#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <ctype.h>

#define XMAP_PI         3.14159265358979323846264338327950288 /* pi */
#define XMAP_PIO2        1.5707963267949   /* pi over 2 */

/* #define EARTHRAD 6378.163 */
#define EARTHRAD 1
#define DEGRAD 0.017453293
#define RADDEG 57.295778667

#define epsDEG .000001
#define epsRAD .00000001745329

#define ABS(a) ((a) < (0) ? -(a) : (a))

#define SIGN(A, B) ((B) < 0 ? -ABS(A) : ABS(A))

#define ASIGN(A) ((A) < 0 ? -1 : 1)



#define deg2rad(D)      ((D) * XMAP_PI / 180.0)
#define rad2deg(R)      ((R) * 180.0 / XMAP_PI)

/********************************************************************************/
/** FUNC DEF **/ double npi2pi(double angin)
{  /* borrowed from MATLAB routines  */
   double angout;
   angout = XMAP_PI*((ABS(angin)/XMAP_PI - 2*ceil(((ABS(angin)/XMAP_PI)-1)/2)) * ASIGN(angin));

   return(angout);

}
/** FUNC DEF **/ double zero22pi(double angin)
{
   double angout;
   angout = npi2pi(angin)+XMAP_PI;
   return(angout);
}
/********************************************************************************/

/** FUNC DEF **/ int In_SphereRect(double  minlat1, double minlon1, double maxlat2, double maxlon2, double pntlat,  double pntlon)
{  

   minlon1 = RADDEG*npi2pi(DEGRAD*minlon1);
   maxlon2 = RADDEG*npi2pi(DEGRAD*maxlon2);
   pntlon = RADDEG*npi2pi(DEGRAD*pntlon);

   /* fprintf(stderr, "%f %f %f %f %f %f\n",  minlat1,  minlon1,  maxlat2,  maxlon2,  pntlat,   pntlon); */


   if( ( (pntlat>=minlat1) && (pntlat<=maxlat2) ) &&  ((pntlon>=minlon1)&&(pntlon<=maxlon2) ) )
   {
      return(1);

   }
   else
   {
      return(0);
   }
}
/********************************************************************************/
/** FUNC DEF **/ void XprodLL(double deglat1, double deglon1, double deglat2, double deglon2,
double ex[3])
{
   /*  get the cross product of two great circles associated with two points */
   double lat1, lat2, lon1, lon2;

   lat1 = deg2rad(deglat1);
   lat2 = deg2rad(deglat2);
          /* this negative is so the correct convention of positive east longitudes */
   lon1 = deg2rad(deglon1);
   lon2 = deg2rad(deglon2);

 ex[0] =  sin(lat1-lat2) *sin((lon1+lon2)/2) *cos((lon1-lon2)/2) -

	    sin(lat1+lat2) *cos((lon1+lon2)/2) *sin((lon1-lon2)/2) ;

 ex[1] = sin(lat1-lat2) *cos((lon1+lon2)/2) *cos((lon1-lon2)/2) +

       sin(lat1+lat2) *sin((lon1+lon2)/2) *sin((lon1-lon2)/2);

 ex[2] =  cos(lat1)*cos(lat2)*sin(lon1-lon2) ;

}
/********************************************************************************/
/** FUNC DEF **/ double NORM3(double e[3])
{
   double a;
   a = sqrt(e[0]*e[0]+e[1]*e[1]+e[2]*e[2]);
   e[0] /= a;
   e[1] /= a;
   e[2] /= a;
   return(a);
} 
/********************************************************************************/
/** FUNC DEF **/ void INVERT_LL(double e[3],double *lat, double *lon)
{
   *lat=atan2(e[2], sqrt(e[0]* e[0]+ e[1]*e[1])); 
   *lon=atan2(-e[1], e[0]);
}
/********************************************************************************/
/** FUNC DEF **/ void GC_intersection(double deglat1, double deglon1, double deglat2, double deglon2,
				 double deglat3, double deglon3, double deglat4, double deglon4,
				      double *elat1, double *elon1, double *elat2, double *elon2)
{
/* get intersection points of 2 great circles, return in degrees  */

   double ea[3], eb[3], e[3];
   double alat1, alon1, alat2, alon2;


   XprodLL( deglat1,  deglon1,  deglat2,  deglon2,
	    ea);

   XprodLL( deglat3,  deglon3,  deglat4,  deglon4,
	    eb);

   NORM3(ea);
   NORM3(eb);


   e[0] =  ea[1] *eb[2] -eb[1] *ea[2];
   e[1] =  ea[2] *eb[0] -eb[2] *ea[0];
   e[2] =  ea[0] *eb[1] -ea[1] *eb[0];


   INVERT_LL(e, &alat1, &alon1);

   alat2 = -(alat1);
   alon2 = (alon1)+XMAP_PI;

   *elat1 = rad2deg(alat1);
   *elon1 = rad2deg(alon1);
   *elat2 = rad2deg(alat2);
   *elon2 = rad2deg(alon2);

}

/********************************************************************************/

/** FUNC DEF **/ double great_dist(double phi1, double lam0, double phi, double lam)
{
  /* calculate the great arc distance (in radians)
     between two points
     given the lat lons in radians */

  double tem, tem2;
  double s1, s2;
  s1 = sin( (phi-phi1 )/2);
  s2 = sin( (lam-lam0 )/2);
  tem = sqrt(s1*s1 + cos(phi1)*cos(phi)*s2*s2);
  tem2 = 2*asin(tem);
  return(tem2);
}
/********************************************************************************/
/** FUNC DEF **/ double greatAz( double  phi1, double lam0, double phi, double lam  )
{
  /* get azimuth from point A to Point B  */
  double tem1, tem2;
  
  /* fprintf(stderr,"greatAz input: %f %f %f %f\n", phi1, lam0, phi, lam); */

  tem2=XMAP_PIO2-epsRAD;
  /* fprintf(stderr,"greatAz rad 90 : %f\n",tem2); */

  if(phi1 > (XMAP_PIO2-epsRAD) )
  {
     return(XMAP_PI);
  }

  tem1 = cos(phi1)*sin(phi) - sin(phi1)*cos(phi)*cos(lam-lam0);
  tem2 = atan2(cos(phi)*sin(lam-lam0), tem1); 

  /* fprintf(stderr,"greatAz output: %f %f\n", tem2, RADDEG*tem2 ); */

    return(tem2);
}
/********************************************************************************/
/** FUNC DEF **/ void along_great(double  phi1, double lam0, double c , double Az, double *phi, double *lam  )
{ 
     /* 
	given a point (lat lon) radians  
	a distance in radians (c) and 
	an azimuthal direction Az
	calculate the point (phi, lam) which lies angle radians away from (lat, lon)
     */
   double  tem ;
 
   *phi =  asin( sin(phi1)*cos(c) + cos(phi1)*sin(c)*cos(Az));
   tem = atan2( sin(c)*sin(Az), (cos(phi1)*cos(c) - sin(phi1)*sin(c)*cos(Az)));
   *lam = lam0 + tem;
}
/********************************************************************************/
/** FUNC DEF **/ void Get_Great(double lat1, double lon1, double lat2, double lon2, int num, double *phi2, double *lam2 )
{
       /*    
	     get an array of points along the great circle between two points  
       */
  int i;
  
  double  dis;
 
 
  double angle, dang, phi, lam, Az;

   dis = RADDEG * (great_dist(  DEGRAD * lat1, DEGRAD * lon1, DEGRAD * lat2, DEGRAD * lon2));
   /* fprintf(stderr," NEW angle between X1 and X2 = %f degrees\n", dis);  */
   Az= greatAz(  DEGRAD * lat1, DEGRAD * lon1,  DEGRAD * lat2, DEGRAD * lon2  );
   dang = dis/(float)num;
   
   for(i=0; i<=num; i++)
     {
       angle = DEGRAD * dang*i;  
       along_great( DEGRAD * lat1, DEGRAD * lon1, angle, Az, &phi, &lam);     
       phi2[i] = RADDEG * phi;
       lam2[i] = RADDEG * lam;
       /* fprintf(stdout,"%d %f %f 0.0 1 4 0 10 1 11 1\n", i, polell.lat, polell.lon); */
       
     }

   
}

/********************************************************************************/
/** FUNC DEF **/ void Get_Pole(double deglat1, double deglon1, double deglat2, double deglon2, double *phi2, double *lam2 )
{
               /* given 2 points in LAT-LON degrees return the LATLON point describing the
                    great circle   */
   double ea[3];
   double alat1, alon1;

   XprodLL( deglat1,  deglon1,  deglat2,  deglon2,
	    ea);
   INVERT_LL(ea, &alat1, &alon1);

   *phi2 = rad2deg(alat1);
   *lam2 = rad2deg(alon1);
}
/********************************************************************************/
/** FUNC DEF **/ int GC_X_LAT(double deglat1, double deglon1, double deglat2, double deglon2, 
			      double LAT, double phi[2], double lam[2] )
{

   double phi0=90, lam0=0;
   double  phi2, lam2;
   double range1, range2, range3;
   double az1, az2, temp1, temp2;
   double apex;

   double rlat1, rlon1, rlat0, rlon0;
   
   double projaz1, projaz2;

   range2 = DEGRAD * (90-LAT);
   range1 = XMAP_PI/2;

   rlat1 =  DEGRAD * deglat1;
   rlon1 =  DEGRAD * deglon1;

   rlat0 =  DEGRAD * phi0;
   rlon0 =  DEGRAD * lam0;



   Get_Pole(deglat1, deglon1, deglat2, deglon2, &phi2, &lam2 );

   /* fprintf(stderr,"POLE: phi2=%f lam2=%f\n",phi2, lam2); */

   range3 = great_dist( rlat0, rlon0, DEGRAD*phi2, DEGRAD*lam2);


  /*  fprintf(stderr,"RANGES: %f %f %f\n" , range1, range2, range3); */

       /*  check if no intersection  */
  
   if( ((range3-range1-range2)>epsRAD) || ((range2-range1-range3)>epsRAD) || ((range1-range3-range2)>epsRAD))
   {
      fprintf(stderr,"No intersection with Small circle\n");
      return(0);

   }
      /*  check if non-unique intersection  */

   temp1 = cos(range3) - cos(range1)*cos(range2);
   temp2 = sin(range2)*sin(range1);

   if(temp2 ==0.0) return(0);

   apex = acos(temp1/temp2);

  /*  fprintf(stderr, "temp1=%f temp2=%f apex=%f\n", temp1, temp2, apex); */
 

   az1 =  greatAz(rlat1,  rlon1 , rlat0, rlon0  );
   az2 =  greatAz( rlat0, rlon0, rlat1,  rlon1  );


   projaz1 = asin( sin(apex)*sin(range2)/sin(range3));
   projaz2 = asin( sin(apex)*sin(range1)/sin(range3));


  /*  fprintf(stderr, "az1=%f az2=%f projaz1=%f projaz2=%f\n",  */
/* 	   az1,  az2, projaz1, projaz2); */


   along_great( DEGRAD*phi2, DEGRAD*lam2, range1, (az1-projaz1) , &phi[0], &lam[0] );

   along_great( DEGRAD*phi2, DEGRAD*lam2, range1, (az1+projaz1) , &phi[1], &lam[1] );

   phi[0]*=RADDEG;
   lam[0] = RADDEG*npi2pi(lam[0]);
   phi[1]*=RADDEG;
   lam[1] = RADDEG*npi2pi(lam[1]);
   

   return(1);
}

/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*
from:

http://williams.best.vwh.net/avform.htm#Intermediate

In previous sections we have found intermediate points on a great circle given either the crossing latitude or longitude. Here we find points (lat,lon) a given fraction of the distance (d) between them. Suppose the starting point is (lat1,lon1) and the final point (lat2,lon2) and we want the point a fraction f along the great circle route. f=0 is point 1. f=1 is point 2. The two points cannot be antipodal ( i.e. lat1+lat2=0 and abs(lon1-lon2)=pi) because then the route is undefined. The intermediate latitude and longitude is then given by:

        A=sin((1-f)*d)/sin(d)
        B=sin(f*d)/sin(d)
        x = A*cos(lat1)*cos(lon1) +  B*cos(lat2)*cos(lon2)
        y = A*cos(lat1)*sin(lon1) +  B*cos(lat2)*sin(lon2)
        z = A*sin(lat1)           +  B*sin(lat2)
        lat=atan2(z,sqrt(x^2+y^2))
        lon=atan2(y,x)



 To find the intersection of two great circles defined by the arcs

from pt1 (lat1, lon1) to pt2 and from pt3 to pt4.

-----------------

Use the "W longitude is positive" convention of the Aviation

Formulary. (For the more conventional convention, change the sign of

all longitudes in the following.)

For each point we can associate a unit vector pointing to it from

the center of the earth whose components are:

e ={ex,ey,ez} = {cos(lat)*cos(lon), -cos(lat)*sin(lon), sin(lat)} (1)

which we can invert with

lat=atan2(ez, sqrt(ex^2 + ey^2)); lon=atan2(-ey, ex) (2)

For any great circle, defined by pts 1 and 2, the point

P(e1,e2) =(e1 X e2)/||e1 X e2||

is perpendicular the the plane of the circle. (Its negative is the opposite

point).

Here e1 X e2 is the vector cross-product whose components are

{e1y *e2z -e2y *e1z, e1z *e2x -e2z *e1x, e1x *e2y -e1y *e2x} (3)

respectively (see later for a numerically robust way to compute this!)

||e|| is the length of a vector defined by

||e|| =sqrt(ex^2 + ey^2 + ez^2) (4)

The intersections of the great circles can be seen to be given by

+- P( P(e1,e2), P(e3,e4) )

Direct computation of the cross-product will fail at small distances

because of rounding error. Application of some trig identities

gives:

e1 X e2 = { sin(lat1-lat2) *sin((lon1+lon2)/2) *cos((lon1-lon2)/2) -

sin(lat1+lat2) *cos((lon1+lon2)/2) *sin((lon1-lon2)/2) ,

sin(lat1-lat2) *cos((lon1+lon2)/2) *cos((lon1-lon2)/2) +

sin(lat1+lat2) *sin((lon1+lon2)/2) *sin((lon1-lon2)/2) ,

cos(lat1)*cos(lat2)*sin(lon1-lon2) } (5)

which avoids this problem.

Algorithm:

compute e1 X e2 and e3 X e4 using (5).

Normalize ea= (e1 X e2)/ ||e1 X e2|| , eb=(e3 x e4)/||e3 X e4|| using (4)

Compute ea X eb using (3)

Invert using (2) (it's unnecessary to normalize first).

The two candidate intersections are (lat,lon) and the antipodal point

(-lat, lon+pi)



*/
