
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "hypo.h"

/* --- function prototypes --- */

Boolean CopyToHypoWindow(HYPO_PARMS *phypoParms);
Boolean CopyFromHypoWindow(HYPO_PARMS *phypoParms);
void init_hypoParms(mpic *mp);
void hypo_new_parms(mpic *mplot);
void SetWidgetInt(Widget w, String attr, int i);
void hypo_selection(mpic *mplot);
char *GetWidgetString(Widget w, String attr);
float GetWidgetStringAsFloat(Widget w, String attr);
void SetWidgetStringToFloat(Widget w, String attr, float fl);
void SetWidgetStringToInt(Widget w,String attr, int i);
int GetWidgetStringAsInt(Widget w, String attr);
int PrintHypoParms(HYPO_PARMS *phypoParms);

/* --- functions --- */

void init_hypoParms(mpic *mp)
  {

  mp->hypoParms.t1 = 0.0;
  mp->hypoParms.t2 = 0.0;

  mp->hypoParms.z1 = 0.0;
  mp->hypoParms.z2 = 0.0;

  mp->hypoParms.m1 = 0.0;
  mp->hypoParms.m2 = 0.0;

  mp->hypoParms.np1 = 0.0;
  mp->hypoParms.np2 = 0.0;
  mp->hypoParms.ns1 = 0.0;
  mp->hypoParms.ns2 = 0.0;
  mp->hypoParms.g1 = 0.0;
  mp->hypoParms.g2 = 0.0;

  mp->hypoParms.del1 = 0.0;
  mp->hypoParms.del2 = 0.0;

  mp->hypoParms.rms1 = 0.0;
  mp->hypoParms.rms2 = 0.0;

  mp->hypoParms.err1 = 0.0;
  mp->hypoParms.err2 = 0.0;

  mp->hypoParms.q1 = 0.0;
  mp->hypoParms.q2 = 0.0;

  mp->hypoParms.intarg = 0;
  }

void hypo_new_parms(mpic *mplot)
  {
  int iokay;

  iokay = CopyFromHypoWindow(&mplot->hypoParms);
  }

void PopupHypo(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* fprintf(stderr, "in PopupHypo\n");
     PrintHypoParms(&mplot->hypoParms); */

  iokay = CopyToHypoWindow(&mplot->hypoParms);
  XtPopup(mplot->hypoParms.wShell, XtGrabNonexclusive);
  }

void HypoDoit(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;
 
  /* fprintf(stderr,"in HypoSet\n"); */
  iokay = CopyFromHypoWindow(&mplot->hypoParms);
  /* PrintHypoParms(&mplot->hypoParms); */
  XtPopdown(mplot->hypoParms.wShell);
  hypo_new_parms(mplot);
  hypo_selection(mplot);
  }

void HypoSet(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* fprintf(stderr,"in HypoSet\n"); */
  iokay = CopyFromHypoWindow(&mplot->hypoParms);
  /* PrintHypoParms(&mplot->hypoParms); */
  XtPopdown(mplot->hypoParms.wShell);
  }

void HypoDone(Widget w, mpic *mplot, char *call_data)
  {
  /* fprintf(stderr,"in HypoDone\n"); */
  /* PrintHypoParms(&mplot->hypoParms); */
  XtPopdown(mplot->hypoParms.wShell);
  }

void make_hypo_pop(Widget box, mpic *mplot)
  {
  Widget xp, view, top, hyposhell;

  /* fprintf(stderr,"begin\n"); */

  top = mplot->shell;
  xp = XtVaCreateManagedWidget("Set Hypo", smeBSBObjectClass, box, NULL);

  mplot->hypoParms.wShell = hyposhell
    = XtVaCreatePopupShell("hypoWin", transientShellWidgetClass, top, NULL);
  
  view = XtVaCreateManagedWidget("hypoForm", formWidgetClass, hyposhell, NULL);
  
  /* -----------NOTE:  these must be created in the correct order   !  */
  
  /* Create the various parameter labels and their text boxes. */

  mplot->hypoParms.hTime = XtVaCreateManagedWidget("Time_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hTime1Edit = XtVaCreateManagedWidget("Time1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hTime2Edit = XtVaCreateManagedWidget("Time2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hDepth = XtVaCreateManagedWidget("Depth_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hDepth1Edit = XtVaCreateManagedWidget("Depth1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hDepth2Edit = XtVaCreateManagedWidget("Depth2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hMag = XtVaCreateManagedWidget("Mag_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hMag1Edit = XtVaCreateManagedWidget("Mag1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hMag2Edit = XtVaCreateManagedWidget("Mag2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hNump = XtVaCreateManagedWidget("Nump_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hNump1Edit = XtVaCreateManagedWidget("Nump1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hNump2Edit = XtVaCreateManagedWidget("Nump2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hNums = XtVaCreateManagedWidget("Nums_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hNums1Edit = XtVaCreateManagedWidget("Nums1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hNums2Edit = XtVaCreateManagedWidget("Nums2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hGap = XtVaCreateManagedWidget("Gap_Label",
    labelWidgetClass, view, NULL);
    
  mplot->hypoParms.hGap1Edit = XtVaCreateManagedWidget("Gap1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hGap2Edit = XtVaCreateManagedWidget("Gap2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hDelta = XtVaCreateManagedWidget("Delta_Label",
     labelWidgetClass, view, NULL);
    
  mplot->hypoParms.hDelta1Edit = XtVaCreateManagedWidget("Delta1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hDelta2Edit = XtVaCreateManagedWidget("Delta2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hRms = XtVaCreateManagedWidget("Rms_Label",
    labelWidgetClass, view, NULL);
    
  mplot->hypoParms.hRms1Edit = XtVaCreateManagedWidget("Rms1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hRms2Edit = XtVaCreateManagedWidget("Rms2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hErr = XtVaCreateManagedWidget("Err_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hErr1Edit = XtVaCreateManagedWidget("Err1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hErr2Edit = XtVaCreateManagedWidget("Err2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hQ = XtVaCreateManagedWidget("Q_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hQ1Edit = XtVaCreateManagedWidget("Q1Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hQ2Edit = XtVaCreateManagedWidget("Q2Edit",
    asciiTextWidgetClass, view, NULL);

  mplot->hypoParms.hTarg = XtVaCreateManagedWidget("Targ_Label",
    labelWidgetClass, view, NULL);

  mplot->hypoParms.hTargEdit = XtVaCreateManagedWidget("TargEdit",
    asciiTextWidgetClass, view, NULL);

  /* Make all of the edit boxes editable. */

  SetWidgetInt(mplot->hypoParms.hTime1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hTime2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hDepth1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hDepth2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hMag1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hMag2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hNump1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hNump2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hNums1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hNums2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hGap1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hGap2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hDelta1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hDelta2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hRms1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hRms2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hErr1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hErr2Edit, XtNeditType, XawtextEdit);
 
  SetWidgetInt(mplot->hypoParms.hQ1Edit, XtNeditType, XawtextEdit);
  SetWidgetInt(mplot->hypoParms.hQ2Edit, XtNeditType, XawtextEdit);

  SetWidgetInt(mplot->hypoParms.hTargEdit, XtNeditType, XawtextEdit);

  /* Create the Set and Cancel command buttons. */

  mplot->hypoParms.wSet = XtVaCreateManagedWidget("set",
    commandWidgetClass, view, NULL);

  mplot->hypoParms.wDoit = XtVaCreateManagedWidget("doit",
    commandWidgetClass, view, NULL);

  mplot->hypoParms.wCancel = XtVaCreateManagedWidget("cancel",
    commandWidgetClass, view, NULL);

  /* InitHypoParms(&mplot->hypoParms); */

  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupHypo, mplot);

  XtAddCallback(mplot->hypoParms.wSet, XtNcallback, (XtCallbackProc)HypoSet,
		mplot);
  XtAddCallback(mplot->hypoParms.wDoit, XtNcallback, (XtCallbackProc)HypoDoit,
		mplot);
  XtAddCallback(mplot->hypoParms.wCancel, XtNcallback,
		(XtCallbackProc)HypoDone, mplot);

  /***************DONE XDIP WINDOW ***********************/
  }

/*
 * Copies the current hypo variables to the hypo window's widgets.
 * Returns FALSE if fails.
 */

Boolean CopyToHypoWindow(HYPO_PARMS *phypoParms)
  {

  SetWidgetStringToFloat(phypoParms->hTime1Edit, XtNstring, phypoParms->t1);
  SetWidgetStringToFloat(phypoParms->hTime2Edit, XtNstring, phypoParms->t2);

  SetWidgetStringToFloat(phypoParms->hDepth1Edit, XtNstring, phypoParms->z1);
  SetWidgetStringToFloat(phypoParms->hDepth2Edit, XtNstring, phypoParms->z2);

  SetWidgetStringToFloat(phypoParms->hMag1Edit, XtNstring, phypoParms->m1);
  SetWidgetStringToFloat(phypoParms->hMag2Edit, XtNstring, phypoParms->m2);

  SetWidgetStringToFloat(phypoParms->hNump1Edit, XtNstring, phypoParms->np1);
  SetWidgetStringToFloat(phypoParms->hNump2Edit, XtNstring, phypoParms->np2);

  SetWidgetStringToFloat(phypoParms->hNums1Edit, XtNstring, phypoParms->ns1);
  SetWidgetStringToFloat(phypoParms->hNums2Edit, XtNstring, phypoParms->ns2);

  SetWidgetStringToFloat(phypoParms->hGap1Edit, XtNstring, phypoParms->g1);
  SetWidgetStringToFloat(phypoParms->hGap2Edit, XtNstring, phypoParms->g2);

  SetWidgetStringToFloat(phypoParms->hDelta1Edit, XtNstring, phypoParms->del1);
  SetWidgetStringToFloat(phypoParms->hDelta2Edit, XtNstring, phypoParms->del2);

  SetWidgetStringToFloat(phypoParms->hRms1Edit, XtNstring, phypoParms->rms1);
  SetWidgetStringToFloat(phypoParms->hRms2Edit, XtNstring, phypoParms->rms2);

  SetWidgetStringToFloat(phypoParms->hErr1Edit, XtNstring, phypoParms->err1);
  SetWidgetStringToFloat(phypoParms->hErr2Edit, XtNstring, phypoParms->err2);

  SetWidgetStringToFloat(phypoParms->hQ1Edit, XtNstring, phypoParms->q1);
  SetWidgetStringToFloat(phypoParms->hQ2Edit, XtNstring, phypoParms->q2);

  SetWidgetStringToInt(phypoParms->hTargEdit, XtNstring, phypoParms->intarg);

  return(TRUE);
  }

/*
 * Copies the hypoents of the hypot window's widgets to be the current hypo
 * parameters.
 * Returns FALSE if fails.
 */

Boolean CopyFromHypoWindow(HYPO_PARMS *phypoParms)
  {
 
  /* Get the values of the hypo parameters specified in the hypo window. */
  /* Get the values from the edit boxes. */

  phypoParms->t1 = GetWidgetStringAsFloat(phypoParms->hTime1Edit, XtNstring);
  phypoParms->t2 = GetWidgetStringAsFloat(phypoParms->hTime2Edit, XtNstring);

  phypoParms->z1 = GetWidgetStringAsFloat(phypoParms->hDepth1Edit, XtNstring);
  phypoParms->z2 = GetWidgetStringAsFloat(phypoParms->hDepth2Edit, XtNstring);

  phypoParms->m1 = GetWidgetStringAsFloat(phypoParms->hMag1Edit, XtNstring);
  phypoParms->m2 = GetWidgetStringAsFloat(phypoParms->hMag2Edit, XtNstring);

  phypoParms->np1 = GetWidgetStringAsFloat(phypoParms->hNump1Edit, XtNstring);
  phypoParms->np2 = GetWidgetStringAsFloat(phypoParms->hNump2Edit, XtNstring);

  phypoParms->ns1 = GetWidgetStringAsFloat(phypoParms->hNums1Edit, XtNstring);
  phypoParms->ns2 = GetWidgetStringAsFloat(phypoParms->hNums2Edit, XtNstring);

  phypoParms->g1 = GetWidgetStringAsFloat(phypoParms->hGap1Edit, XtNstring);
  phypoParms->g2 = GetWidgetStringAsFloat(phypoParms->hGap2Edit, XtNstring);

  phypoParms->del1 = GetWidgetStringAsFloat(phypoParms->hDelta1Edit,
					    XtNstring);
  phypoParms->del2 = GetWidgetStringAsFloat(phypoParms->hDelta2Edit,
					    XtNstring);

  phypoParms->np1 = GetWidgetStringAsFloat(phypoParms->hNump1Edit, XtNstring);
  phypoParms->np2 = GetWidgetStringAsFloat(phypoParms->hNump2Edit, XtNstring);

  phypoParms->ns1 = GetWidgetStringAsFloat(phypoParms->hNums1Edit, XtNstring);
  phypoParms->ns2 = GetWidgetStringAsFloat(phypoParms->hNums2Edit, XtNstring);

  phypoParms->rms1 = GetWidgetStringAsFloat(phypoParms->hRms1Edit, XtNstring);
  phypoParms->rms2 = GetWidgetStringAsFloat(phypoParms->hRms2Edit, XtNstring);

  phypoParms->err1 = GetWidgetStringAsFloat(phypoParms->hErr1Edit, XtNstring);
  phypoParms->err2 = GetWidgetStringAsFloat(phypoParms->hErr2Edit, XtNstring);

  phypoParms->q1 = GetWidgetStringAsFloat(phypoParms->hQ1Edit, XtNstring);
  phypoParms->q2 = GetWidgetStringAsFloat(phypoParms->hQ2Edit, XtNstring);

  phypoParms->intarg = GetWidgetStringAsInt(phypoParms->hTargEdit, XtNstring);

  return(TRUE);
  }

