#include "geotouch.h"
#include "jutil.h"

typedef fxy fpoint;

/*  global variables  */
fpoint *plotkin;
int num;

int inside(fpoint t, fpoint *p, int N);

/**  FUNC DEF **/int set_poly(int m, float **poly)
{

  int i, j, lowy, *indx;
  float *pys;


  num = m;
  pys = alloc_fvec(0, num);
  indx = alloc_ivec(0, num);

  plotkin = XmapNewArray(fpoint, num + 1);
  for(i = 0; i < num; i++) pys[i] = poly[i][1];

  cindex(pys, indx, num);

  lowy = indx[0];
  for(i = lowy, j = 1; i < num; i++)
    {
    plotkin[j].x = poly[i][0];
    plotkin[j].y = poly[i][1];
    j++;
    }

  for(i = 0; i < lowy; i++)
    {
    plotkin[j].x = poly[i][0];
    plotkin[j].y = poly[i][1];
    j++;
    }
  free_fvec(pys, 0, num);
  free_ivec(indx, 0, num);
  return(1);
}

/**  FUNC DEF **/int unset_poly()
{

  XmapFree(plotkin);
  return(1);
}

/* function to determine if a point is inside a
   polygon or not returns 1 = inside     0 = outside
   inpoly */

/**  FUNC DEF **/int Minpoly(float x, float y)
  {
     int j;
     fpoint  po;
     po.x = x;
     po.y = y;
     
     j = inside(po, plotkin, num);
     
     return(j);
  }
