
#ifndef _mpic_h
#define _mpic_h


/*#include <std.h>*/
#include "geotouch.h"
#include "jml.h"
#include "jgraph.h"
#include "surf_grd.h"
#include "pickfile.h"
#include "contour.h"
#include "colorquant.h"
#include "focal_param.h" 

/* #include "Cont.h" */

typedef struct
  {
  float red, green, blue;
  } Jcol;


typedef struct
  {
    char *name;
    int    col; 
  } Legend_Item;

typedef struct
  {
    Legend_Item *leg_in;
    int Num;
   
  } Legend;





typedef struct
  {
  Widget wShell;	/* The top-level transient shell. */
  Widget wDipLabel;	/* The R label. */
  Widget wDipEdit;	/* The R edit box. */
  Widget wMinzLabel;	/* The I label. */
  Widget wMinzEdit;	/* The I edit box. */
  Widget wMaxzLabel;
  Widget wMaxzEdit;
  Widget wFrontLabel;
  Widget wFrontEdit;
  Widget wBackLabel;
  Widget wBackEdit;
  Widget wSet;		/* The "Set" command button. */
  Widget wDoit;		/* The "Doit" command button. */
  Widget wCancel;	/* The "Cancel" command button. */
  float dip, minz, maxz, front, back;
  } XDIP_PARMS;

typedef struct rgbimage_t
  {
  unsigned int *ir;	/* red pixel components		*/
  unsigned int *ig; 	/* green pixel components	*/
  unsigned int *ib;	/* blue pixel components	*/
  unsigned int sx;	/* image width (in pixels)	*/
  unsigned int sy;	/* image height (in pixels)	*/
  float lat, lon, dx, dy;
  char regis[3];
  char *i_format;
  char *i_coord;
  int coordflag, regisflag, formatflag;
  } rgbimage_t;

typedef struct jml_image
  {
  unsigned int sx;	/* image width (in pixels)	*/
  unsigned int sy;	/* image height (in pixels)	*/
  float lat, lon, dx, dy;
  char regis[3];
  char *i_format;
  char *i_coord;
  int coordflag, regisflag, formatflag;
  unsigned int  K;
  unsigned int *pixels;
  qcolor_t  *colors;
  } jml_image;

#include "hypo.h"

typedef struct
  {
  /*** Main origin defining the model and window parameters  ***/

  ORG origin;
  char origin_file[100];
  char src_dump_file[100];
  JGRAPH gr;
  /***** Source Information   *****/
  Source_File sources[20]; 
  int src_flag;
  int time_src_flag;
  int more_src_flag;
  int connect_flag;
  int max_more_src;
  int current_src;
  int src_color;
  int src_in_layer;
  float time_plot_wait;
  int src_depth_color;
  int MinColor, MaxColor;
  float MinDepth, MaxDepth;
  int SourceSize;
  float SourceSlope;

  int fancy_src_flag;
  int mag_src_flag;
  float min_mag, max_mag;
  char hypo_format_str[50];
  int force_source;
  

  /***** Map and Stuff Information   *****/

  Map_File map[20];
  Simple_Map_File xy_map;
  int num_map_files;
  int map_color;  
  int map_flag;
  int map_type, add_poly_lines;
  char Formation_name[200][5];
  int Formation_color[200];
  int Formation_count;
  /*  map_type = 0  for lat-lon segment files Simple_Map
      map_type = 1  for lees format data base  */
  int grid_flag;
  int geotab_flag;
    int map_point_flag;
       int map_sel_flag;
  int plot_cont_flag;  
  int plot_cont_points;  
  int plot_cont_values;  
  int project_type;

  Wells_File wells[20];
  int num_wells_files;
  int wells_color;  
  int wells_flag;
  int wells_project_flag;
  int wells_symbol_flag;
  int wells_name_flag;
  int wells_in_layer;
  int size_well;
    int wells_proj_all;
    int wells_thickness;
    
    Legend  well_leg[20];
    int plot_well_leg;
    int num_well_leg;

    
    
  /****   focal mech Stuff   *************************/
  FocMec_File focm[20];
  int num_focm_files;
  int focm_color;  
  int focm_flag;
  int size_focm;
  int focal_selection;
  int focal_explode;
  int focal_plot_style;
  int focal_mag_scale;
  int focal_current;
  int focal_total_num;
  int foc_in_layer;
  int foc_summary_flag;
  int foc_auto_summary_flag;
    int auto_ternary;
    
  /****   Image Stuff   *************************/
    int  Hi_Lite_flag ;
    int  Integrate_flag ;

    int Draw_spline_flag;
    int Replot_Poly_flag;
    
    int   Replot_target_flag;
    
  /****   Other Stuff   *************************/

  Markup_File markup;
  int stuff_color;
  int stuff_flag;
  Point_File Mpoint[20];
  int point_flag;
  int current_point;
  int point_onoff;
  Zoom_File zoom;
  int zoom_flag, zoom_flag2;
  xyxy Current_Zoom;
  Zoom_File picsource;
  int picsource_flag, picsourcemove_flag, picsource_outflag;
  pix picsource_org, picsource_spot;
  int picsource_color;

  /******   Cross section stuff    *******/
  int num_xsec;
  Xsec_box cross[50];
  int xsec_flag;
  int BW_flag;
  char Overall_title[50];
  int title_color;
  int bord_color; 
                 
  /***** Station Information   *****/

  Station_File stations[20]; 
  int current_sta;
  int num_sta_files;    
  int sta_flag;
  int size_sta;
  int sta_name_flag;
  int sta_color;

  int special_station_color; 
  int special_station_flag;

  int screen_size_flag; 
  int ScreenX, ScreenY;
  int LocX, LocY;

  xyxy xsect; /* The line along which you've taken a cross section */
  float halfwidth;
  /* Other stuff */
  Widget wij;		/* Widget this is attached to */
  Widget shell;	/* Shell this is a part of */
  Widget vport;
  Widget pshell;
  Widget dialog;
     Widget labshell;


  GC zoom_gc;				/* Xor GC used to draw zoom-box */
  pix zoom_org;			/* Place where zooming starts */
  pix zoom_spot;			/* Place where last zoom box drawn */
  GC xsect_gc;			/* Xor GC used to draw xsect-box */
  pix xsect_org;			/* Place where xsecting starts */
  pix xsect_spot;			/* Place where last xsect box drawn */
  GC ggc;			/* General GC to draw with. */
     int num_colors, num_fixed_colors;
     int NumPal;
  int Pal_index[10], Which_Pal;
  int Pal_num[10];
  int Reverse_Pal;

  int special_src_col;
  int special_sta_col;
  int special_perim_col;
  int special_name_col;
  int back_label_col;
  int name_label_col;
  int date_col;
  int fill_arc_col;
  int draw_arc_col;
  int fancy_src_col;
  int fancy_perim_col;
  int magscale_col;
  int special_station_col;
  int exploding_line_col;
  int back_foc_col;
  int ptax_col;
  int faultplane_col;
  int strikeslip_col;
  int rev_oblSS_col;
  int obl_rev_col;
  int reverse_col;
  int norm_oblSS_col;
  int oblq_norm_col;
  int normal_col;
  int xsec_col;
  int box_xsec_col;
  int zoom_box_col;
  int spline_col;
  int spline_points_col;
  int sta_col;
  int bord_col;
  int back_fill_col;
  int stuff_col;
  int map_col;
  int src_col;
  int title_col;
  int picsource_col;
  int text_col;
  int background_col;
  int foreground_col;
  Jcol jmlcol[256];
    Colormap colmap;
  Pixel *colors;	/* Array of colors to draw with */
  Font *fonts;
  xyxy marrow; /* The line along which you've taken arrow */
  GC marrow_gc;		/* Xor GC used to draw arrow */
  pix marrow_org;		/* Place where arrow starts */
  pix marrow_spot;	/* Place end of arrow */
  Label labels[20];
  int num_labels;
  int current_label;
  char  label_file[100];

  char *field_name;
  CONT_PARMS contParms;
  XDIP_PARMS xdipParms;
  HYPO_PARMS hypoParms;
  FOCAL_PARMS focalParms;
  Image_File image;
  int image_flag;
  int image_layer;
  int image_scale_flag;  
  int image_scale_log_flag; /*nps*/

  jml_image satimage;
  int satimage_flag;
  int plotsat_flag;
  int wire_flag;
  int wire_tot;
  int wire_num;
  WireFrame wire[10];
  int lip_flag;
  int lip_tot;
  int lip_num;
  LipSet lip[10];
  int hoz_slab_flag;
  float hoz_slab_top;
  float hoz_slab_bot;

  FILE *pointsFP;
  int  points_store;
  

  int  nargc;
  char **nargv;

  } mpic;



#endif /* _mpic_h */
