/* some of the following code was modified by J. M. Lees from
   the standard GMT distribution software:
   The modifications mainly involved isolating
   the gridding and contouring from the gmt modules
   so they code be incorporated in Xmap
   

   #	Information for installing GMT 2.1.4
   #		@(#)README	2.16 8/16/93 
   Copyright (c) 1991-1993, P. Wessel & W. H. F. Smith
   
*/

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"
#include "contour.h"
#include "my_support.h"

/* --- macros --- */

#define SIZE_MALLOC 10000

/* --- global variables --- */

float *grd;
double *x, *y;

/* --- functions --- */

struct RETURN_VEC *init_cont(void)
  {
  struct RETURN_VEC *cont_return;

  if(!(cont_return = XmapNewArray(struct RETURN_VEC, 1))
     || !(cont_return->cont_level = XmapNewArray(float, SIZE_MALLOC))
     || !(cont_return->number_sections = XmapNewArray(int, SIZE_MALLOC))
     || !(cont_return->vec = XmapNewArray(struct VEC_REC, SIZE_MALLOC)))
    {
    fprintf(stderr, "malloc error\n");
    exit(1);
    }    
  return(cont_return);
  }

void write_level_number(struct RETURN_VEC *C_ret, int flag, double cval,
			int section)
  {
  static int number, chunk;

  if(flag == 1)
    {
    number = 0, chunk = 1;
    return;
    }

  if(number >= (chunk * SIZE_MALLOC - 5))
    {
    fprintf(stderr,"realloc\n");
    realloc((void *)C_ret->cont_level, 
	    (size_t)(SIZE_MALLOC * (++chunk) * sizeof(float)));
    realloc((void *)C_ret->number_sections,
	    (size_t)(SIZE_MALLOC * chunk * sizeof(float)));
    }

  C_ret->cont_level[number]= (float)cval;
  C_ret->number_sections[number]= section;
  number++;
  }

void write_xy_vector(struct RETURN_VEC *C_ret, int flag, double *x,
		     double *y, int length)
  {
  static int number, chunk;
  int i;

  if(flag == 1)
    {
    number = 0, chunk = 1;
    return;
    }

  while(number >= (chunk * SIZE_MALLOC - 5))
    {
    fprintf(stderr, "realloc\n");
    chunk++;
    realloc((void *)C_ret->vec,
	    (size_t)(SIZE_MALLOC * chunk * sizeof(struct VEC_REC)));
    }

  if(!(C_ret->vec[number].x_vec = XmapNewArray(float, (length + 10)))
     || !(C_ret->vec[number].y_vec = XmapNewArray(float, (length + 10))))
    {
    fprintf(stderr,"malloc error\n");
    exit(1);
    }
  C_ret->vec[number].length = length;
  for(i = 0;i < length; i++)
    {
    C_ret->vec[number].x_vec[i] = (float)x[i];
    C_ret->vec[number].y_vec[i] = (float)y[i];
    }
  number++;
  }
  
void read_info(struct SURF_GRD *surf_grd, double *xmin, double *xmax,
	       double *ymin, double *ymax, double *xinc, double *yinc,
	       int *nx, int *ny)
  {
  *xmin = surf_grd->xmin;
  *xmax = surf_grd->xmax;
  *ymin = surf_grd->ymin;
  *ymax = surf_grd->ymax;
  *xinc = surf_grd->xinc;
  *yinc = surf_grd->yinc;
  *nx = surf_grd->nx;
  *ny = surf_grd->ny;
  }

void dump_a_bit_grd(struct SURF_GRD *surf_grd)
  {
  int ii, nx=5, ny=5, jj;

  for(ii = 0; ii < nx; ii++)
    for(jj = 0; jj < ny; jj++)
      {
      fprintf(stderr, "val[%d][%d]=%g     %d\n", ii, jj,
	      surf_grd->val[jj * nx + ii], jj * nx + ii);
      }
  }

struct RETURN_VEC *contour1(struct SURF_GRD *s_grd, char *C, double S,
			    double Z)
  {
  int i, n, nm, c, n_edges, n_alloc, section, n_contours, smooth_factor = 0,
    side, nnx, nny, *edge;
  bool_t first = TRUE, interior, begin, global_grid;  
  char line[512];
  double c_int, take_out, *contour, cval, mult = 1.0, small, small_x, small_y,
    x_min, x_max, y_min, y_max, x_inc, y_inc;
  FILE *fpc = NULL;
  struct RETURN_VEC *C_return;

  C_return = init_cont();

  if(!(fpc = fopen (C, "r")))          /* get cont_file */
    fprintf(stderr, "can't open contour level file: %s\n", C);

  c_int = 1.0;
  smooth_factor = S;                           /* get S, default 0 */
  mult = Z;                                    /* get Z, default 1 */
  if (!fpc || smooth_factor < 0)
    {
    fprintf(stderr,"exit due to error\n");
    exit(1);
    }

  /* fprintf(stderr,"incontour1 1\n"); 
     dump_a_bit_grd(s_grd);
     */
  
  read_info(s_grd, &x_min, &x_max, &y_min, &y_max, &x_inc, &y_inc, &nnx, &nny);
  
  /* First check if global grid needs wrapping */

  global_grid = (fabs(x_max - x_min) == 360.0);
  nm = nnx * nny;

  grd = XmapNewArray(float, (s_grd->nx * s_grd->ny));

  for(i = 0; i < (s_grd->nx * s_grd->ny); i++) grd[i] = s_grd->val[i];

  n_edges = nny * (int)ceil(nnx / 16.0);
  edge = XmapNewArray(int, n_edges);

  /* multiplying grid by mult, if mult!=1.0 */

  if(mult != 1.0) for(i = 1; i < nm; i++) grd[i] *= mult;
  small = c_int * 1.0e-6;
  small_x = 0.01 * x_inc, small_y = 0.01 * y_inc;

  /* fprintf(stderr,"incontour1 2\n");
    dump_a_bit_grd(s_grd); */

  n_alloc = GMT_CHUNK;
  if(!(contour = XmapNewArray(double, n_alloc)))
    {
    fprintf(stderr,"malloc error\n");
    exit(1);
    }

  if(fpc)
    {
    /* read contour info from file */

    n_contours = 0;
    while(fgets (line, 512, fpc))
      {
      sscanf(line, "%lf ", &contour[n_contours]);
      n_contours++;
      if(n_contours == n_alloc)
	{
	fprintf(stderr,"realloc\n");
	n_alloc += GMT_CHUNK;
	contour = (double *)realloc((void *)contour, n_alloc * sizeof(double));
	}
      }
    fclose(fpc);
    }

  /* fprintf(stderr,"incontour1 3\n"); 
     dump_a_bit_grd(s_grd); */

  write_level_number(C_return, 1, 0.0, 0);

  /* fprintf(stderr,"incontour1 4\n"); 
     dump_a_bit_grd(s_grd); */

  /* WARNING! This next call passed 0.0 and 0.0 rather than NULL, NULL */

  write_xy_vector(C_return, 1, NULL, NULL, 0);

  /* fprintf(stderr,"incontour1 4.1\n"); 
     dump_a_bit_grd(s_grd);
     for (c = 0; c < n_contours; c++)
     { fprintf(stderr,"%d %f\n",c,contour[c]); */

  for(c = 0; c < n_contours; c++)
    {
    /* For each contour value cval */
    /* Reset markers and set up new zero-contour*/

    cval = contour[c];
    take_out = (first) ? cval : (contour[c] - contour[c-1]);
    for(i = 0; i < nm; i++)
      {
      grd[i] -= take_out;
      if(grd[i] == 0.0) grd[i] += small;
      }
    section = 0;
    first = FALSE;
    side = 0;
    begin = TRUE;

    /* fprintf(stderr,"incontour1 5: %d\n", side); 
       dump_a_bit_grd(s_grd); */

    while(side < 5)
      {
      while((n = contours(s_grd,grd, smooth_factor, 1, &side, edge, begin,
			  &x, &y)) > 0)
	{
	if((fabs (x[0] - x[n-1]) < small_x) &&
	   (fabs (y[0] - y[n-1]) < small_y))
	  {
	  interior = TRUE;
	  x[n - 1] = x[0], y[n - 1] = y[0];
	  /* close the interior loop */
	  }
	else interior = FALSE;

	write_xy_vector(C_return, 0, x, y, n);
	section++;
	begin = FALSE;
	free((void *)x);
	free((void *)y);
	}
      begin = FALSE;
      }

    if(section > 0) write_level_number(C_return, 0, cval, section);
    }
  write_level_number(C_return, 0, 0.0, 0);

  /* dump_a_bit_grd(s_grd); */

  free((void *)edge);
  free((void *)contour);
  free((void *)grd);

  /* dump_a_bit_grd(s_grd); */

  return(C_return);
  }



