/* some of the following code was modified by J. M. Lees from
   the standard GMT distribution software:
The modifications mainly involved isolating
the gridding and contouring from the gmt modules
so they code be incorporated in Xmap


#	Information for installing GMT 2.1.4
#		@(#)README	2.16 8/16/93 
 	Copyright (c) 1991-1993, P. Wessel & W. H. F. Smith

*/

/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "contour.h"

/* --- functions --- */

char *memory(char *prev_addr, int n, int size, char *progname)
  {
  char *tmp;
  
  if(prev_addr)
    {
    if(!(tmp = (char *)realloc((void *)prev_addr, (size_t)(n * size))))
      {
      fprintf(stderr, "%s: Could not reallocate more memory, n = %d\n",
	      progname, n);
      exit(-1);
      }
    }
  else
    {
    if(!(tmp = (char *)calloc((size_t)n, (size_t)size)))
      {
      fprintf(stderr, "%s: Could not allocate memory, n = %d\n", progname, n);
      exit(-1);
      }
    }
  return(tmp);
  }

int akima(double x[], double y[], int nx, double c[])
  {
  int i, no;
  double t1, t2, b, rm1, rm2, rm3, rm4;
  
  if(nx < 4) return(-1);
  for(i = 1; i < nx; i++)
    if(x[i] <= x[i-1]) return(-2);
  
  rm3 = (y[1] - y[0])/(x[1] - x[0]);
  t1 = rm3 - (y[1] - y[2])/(x[1] - x[2]);
  rm2 = rm3 + t1;
  rm1 = rm2 + t1;

  /* get slopes */

  no = nx - 2;

  for(i = 0; i < nx; i++)
    {
    if(i >= no) rm4 = rm3 - rm2 + rm3;
    else rm4 = (y[i+2] - y[i+1])/(x[i+2] - x[i+1]);
    t1 = fabs(rm4 - rm3);
    t2 = fabs(rm2 - rm1);
    b = t1 + t2;
    c[3*i] = ((b != 0.0) ? ((t1*rm2 + t2*rm3) / b) : (0.5 * (rm2 + rm3)));
    rm1 = rm2;
    rm2 = rm3;
    rm3 = rm4;
    }

  no = nx - 1;

  for(i = 0; i < no; i++)
    {
    t1 = inv(x[i+1] - x[i]);
    t2 = (y[i+1] - y[i]) * t1;
    b = (c[3 * i] + c[3 * i + 3] - t2 - t2) * t1;
    c[3 * i + 2] = b * t1;
    c[3 * i + 1] = -b + (t2 - c[3 * i]) * t1;
    }
  return(0);
  }

int cubspl(double x[], double y[], int nx, double c[])
  {
  int im1, i, jj, j, mm1, mp1, m, nm1, nm2;
  double divdf1, divdf3, dtau, g, cnx[3];

  if(nx < 4) return(-1);
  nm1 = nx - 1;
  for(m = 1; m < nm1; m++)
    {
    mm1 = m - 1;
    c[3 * m + 1] = x[m] - x[mm1];
    if(c[3 * m + 1] <= 0.0) return(-2);
    c[3 * m + 2] = (y[m] - y[mm1]) / c[3 * m + 1];
    }
  cnx[1] = x[nx - 1] - x[nm1 - 1];
  if(cnx[1] <= 0.0) return(-3);
  cnx[2] = (y[nx - 1] - y[nm1 - 1]) / cnx[1];
  nm2 = nx - 2;
  c[2] = c[7];
  c[1] = c[4] + c[7];
  c[0] = ((c[4] + 2.0 * c[1]) * c[5] * c[7] + sqr(c[4]) * c[8]) / c[1];

  for(m = 1; m < nm2; m++)
    {
    mp1 = m + 1;
    mm1 = m - 1;
    g = -c[3 * mp1 + 1] / c[3 * mm1 + 2];
    c[3 * m] = (g * c[3 * mm1] + 3.0 * c[3 * m + 1] * c[3 * mp1 + 2]
		+ 3.0 * c[3 * mp1 + 1] * c[3 * m + 2]);
    c[3 * m + 2] = (g * c[3 * mm1 + 1] + 2.0 * c[3 * m + 1] + 2.0
		    * c[3 * mp1 + 1]);
    }

  g = -cnx[1] / c[3 * nm2 - 1];
  c[3 * nm1 - 3] = (g * c[3 * nm2 - 3] + 3.0 * c[3 * nm1 - 2] * cnx[2]
		    + 3.0 * cnx[1] * c[3 * nm1 - 1]);
  c[3 * nm1 - 1] = (g * c[3 * nm2 - 2] + 2.0 * c[3 * nm1 - 2] + 2.0 * cnx[1]);
  g = c[3 * nm1 - 2] + cnx[1];
  cnx[0] = (((cnx[1] + 2.0 * g) * cnx[2] * c[3 * nm1 - 2] + sqr(cnx[1])
	     * (y[nm1 - 1] - y[nx - 3]) / c[3 * nm1 - 2]) / g);
  g = -g / c[3 * nm1 - 1];
  cnx[2] = c[3 * nm1 - 2] + g * c[3 * nm1 - 2];
  cnx[0] = (g * c[3 * nm1 - 3] + cnx[0]) / cnx[2];
  c[3 * nm1 - 3] = ((c[3 * nm1 - 3] - c[3 * nm1 - 2] * cnx[0])
		    / c[3 * nm1 - 1]);

  for(jj = 0; jj < nm2; jj++)
    {
    j = nm1 - jj - 1;
    c[3 * j] = ((c[3 * j] - c[3 * j + 1] * c[3 * j + 3]) / c[3 * j + 2]);
    }
  for(i = 1; i < nm1; i++)
    {
    im1 = i - 1;
    dtau = c[3 * i + 1];
    divdf1 = (y[i] - y[im1]) / dtau;
    divdf3 = c[3 * im1] + c[3 * i] - 2.0 * divdf1;
    c[3 * im1 + 1] = (divdf1 - c[3 * im1] - divdf3) / dtau;
    c[3 * im1 + 2] = divdf3 / sqr(dtau);
    }

  dtau = cnx[1];
  divdf1 = (y[nx - 1] - y[nm1 - 1]) / dtau;
  divdf3 = c[3 * nm1 - 3] + cnx[0] - 2.0 * divdf1;
  c[3 * nm1 - 2] = (divdf1 - c[3 * nm1 - 3] - divdf3) / dtau;
  c[3 * nm1 - 1] = divdf3 / sqr(dtau);
  return(0);
  }

int intpol(double x[], double y[], int n, int m, double u[],
	   double v[], int mode)
  {
  int i, j, err_flag = 0;
  double dx, *c, mynan;

  if(n < 4) mode = 0;
  if(mode > 0) c = (double *)memory(NULL, 3 * n, sizeof(double), "intpol");

  /* Linear interpolation */
  if(mode == 0)
    {
    for(i = 1; i < n; i++)
      if(x[i] <= x[i - 1]) return(-1);
    }
  else if(mode == 1) 	/* Akimas spline */
    err_flag = akima(x,y,n,c);
  else if(mode == 2)	/* Natural cubic spline */
    err_flag = cubspl(x,y,n,c);
  else err_flag = -4;

  if(err_flag != 0) return(err_flag);

  /* Compute the interpolated values from the coefficients */

  j = 0;
  mknan(mynan);
  for(i = 0; i < m; i++)
    {
    if(u[i] < x[0] || u[i] > x[n-1])
      {	/* Desired point outside data range */
      v[i] = mynan;
      continue;
      } 
    while(x[j] <= u[i] && j < n) j++;
    if(j > 0) j--;
    dx = u[i] - x[j];

    if(mode == 0)
      v[i] = ((y[j + 1] - y[j]) * dx / (x[j + 1] - x[j]) + y[j]);
    else
      v[i] = (((c[3 * j + 2] * dx + c[3 * j + 1]) * dx + c[3 * j]) * dx
	      + y[j]);
    }

  if(mode > 0) free((void *)c);
  return(0);
  }

int start_trace(float first, float second, int edge[], int edge_word,
		int edge_bit, unsigned int bit[])
  {
  if((edge[edge_word] & bit[edge_bit])) return(FALSE);
  if(nan((double)first)) return(FALSE);
  if(nan((double)second)) return(FALSE);
  return((first * second) < 0.0);
  }

int trace_contour(struct SURF_GRD *surf_grd, float grd[], double x0,
		  double y0, int edge[], int smooth_factor,
		  double *x_array[], double *y_array[], int i, int j,
		  int kk, int offset, int i_off[], int j_off[], int k_off[],
		  int p[], unsigned int bit[], int *nan_flag)
  {
  int side = 0, n = 1, k, k0, ij, ij0, n_cuts, k_index[2], kk_opposite, more,
    edge_word, edge_bit, m, n_nan, nx, ny, n_alloc, ij_in;
  double xk[4], yk[4], r, dr[2], west, north, dx, dy, xinc2, yinc2, *xx, *yy;
  
  west = surf_grd->xmin, north = surf_grd->ymax;
  dx = surf_grd->xinc, dy = surf_grd->yinc;
  nx = surf_grd->nx, ny = surf_grd->ny;
  xinc2 = yinc2 = 0.0;
  n_alloc = GMT_CHUNK;
  m = n_alloc - 2;

  if(!(xx = XmapNewArray(double, n_alloc))
     || !(yy = XmapNewArray(double, n_alloc)))
    {
    fprintf(stderr,"malloc error\n");
    exit(1);
    }

  xx[0] = x0, yy[0] = y0;
  ij_in = j * nx + i - 1;

  more = TRUE;
  do
    {
    ij = i + j * nx;
    x0 = west + i * dx + xinc2;
    y0 = north - j * dy - yinc2;
    n_cuts = 0;
    k0 = kk;
    for(k = n_nan = 0; k < 4; k++)
      {
      if(k == k0) continue;
      if(nan((double)grd[ij + p[k + 1]]) || nan((double)grd[ij + p[k]]))
	{
	n_nan++;
	continue;
	}

      ij0 = (i + i_off[k]) + (j + j_off[k]) * nx;
      edge_word = ij0 / 32 + k_off[k] * offset;
      edge_bit = ij0 % 32;

      if(edge[edge_word] & bit[edge_bit]) continue;
      if(grd[ij + p[k + 1]] * grd[ij + p[k]] > 0.0) continue;
      r = grd[ij + p[k + 1]] - grd[ij + p[k]];
      if(k%2)
	{	/* Cutting a S-N line */
	if(k == 1)
	  {
	  xk[1] = x0 + dx;
	  yk[1] = y0 - grd[ij + p[k]] * dy / r;
	  }
	else
	  {
	  xk[3] = x0;
	  yk[3] = y0 + (1.0 + grd[ij + p[k]] / r) * dy;
	  }
	}
      else
	{	/* Cutting a E-W line */
	if(k == 0)
	  {
	  xk[0] = x0 - grd[ij + p[k]] * dx / r;
	  yk[0] = y0;
	  }
	else
	  {
	  xk[2] = x0 + (1.0 + grd[ij + p[k]] / r) * dx;
	  yk[2] = y0 + dy;
	  }
	}
      kk = k;
      n_cuts++;
      }

    if(n > m)
      {		/* Must try to allocate more memory */
      n_alloc += GMT_CHUNK;
      m += GMT_CHUNK;
      fprintf(stderr,"realloc %d to xx and yy\n", n_alloc);

      xx = (double *)realloc((void *)xx, (size_t)(n_alloc*sizeof (double)));
      yy = (double *)realloc((void *)yy, (size_t)(n_alloc*sizeof (double)));
      }

    if(n_cuts == 0)
      {		/* Close interior contour and return */
      if(ij == ij_in)
	{	/* Close iterior contour */
	xx[n] = xx[0];
	yy[n] = yy[0];
	n++;
	}
      more = FALSE;
      *nan_flag = n_nan;
      }
    else if(n_cuts == 1)
      {		/* Draw a line to this point and keep tracing */
      xx[n] = xk[kk];
      yy[n] = yk[kk];
      n++;
      }
    else
      {	
      /* Saddle point, we decide to connect to point nearest previous point */

      kk_opposite = (k0 + 2) % 4;	/* But it cannot be on opposite side */
      for(k = side = 0; k < 4; k++)
	{
	if(k == k0 || k == kk_opposite) continue;
	dr[side] = ((xx[n - 1] - xk[k]) * (xx[n - 1] - xk[k])
		    + (yy[n - 1] - yk[k]) * (yy[n - 1] - yk[k]));
	k_index[side++] = k;
	}
      kk = ((dr[0] < dr[1]) ? k_index[0] : k_index[1]);
      xx[n] = xk[kk];
      yy[n] = yk[kk];
      n++;
      }

    if(more)
      {		/* Mark this edge as used */
      ij0 = (i + i_off[kk]) + (j + j_off[kk]) * nx;
      edge_word = ij0 / 32 + k_off[kk] * offset;
      edge_bit = ij0 % 32;
      edge[edge_word] |= bit[edge_bit];	
      }

    if((kk == 0 && j == ny - 1) || (kk == 1 && i == nx - 2)
       || (kk == 2 && j == 1) || (kk == 3 && i == 0))	/* Going out of grid */
      more = FALSE;

    /* Get next box (i,j,kk) */

    i -= (kk - 2) % 2;
    j -= (kk - 1) % 2;
    kk = (kk + 2) % 4;
    }
  while(more);

  *x_array = xx, *y_array = yy;
  return(n);
  }

int smooth_contour(double *x_in[], double *y_in[], int n, int sfactor,
		   int stype)
  {
  int i, j, k, n_out;
  double ds, t_next, *x, *y, *t_in, *t_out, *x_tmp, *y_tmp, x0, x1, y0, y1;
  char *flag;

#define d_swap(x, y) {double tmp; tmp = x, x = y, y = tmp;}

  /* Interpolation scheme used (0 = linear, 1 = Akima, 2 = Cubic spline */
  
  /* Need at least 4 points to call Akima */
  if(sfactor == 0 || n < 4) return(n);

  x = *x_in, y = *y_in;
  n_out = sfactor * n - 1;	/* Number of new points */
  
  t_in = (double *)memory(NULL, n, sizeof(double), "smooth_contour");
  t_out = (double *)memory(NULL, n_out + n, sizeof(double), "smooth_contour");
  x_tmp = (double *)memory(NULL, n_out + n, sizeof(double), "smooth_contour");
  y_tmp = (double *)memory(NULL, n_out + n, sizeof(double), "smooth_contour");
  flag = (char *)memory(NULL, n_out + n, sizeof(char), "smooth_contour");

  /* Create dummy distance values for input points */

  t_in[0] = 0.0;
  for(i = 1; i < n; i++)
    t_in[i] = (t_in[i-1] + hypot((x[i] - x[i - 1]), (y[i] - y[i - 1])));
  ds = t_in[n-1] / (n_out-1);
  t_next = ds;
  t_out[0] = 0.0;
  flag[0] = TRUE;
  for(i = j = 1; i < n_out; i++)
    {
    if(j < n && t_in[j] < t_next)
      {
      t_out[i] = t_in[j];
      flag[i] = TRUE;
      j++;
      n_out++;
      }
    else
      {
      t_out[i] = t_next;
      t_next += ds;
      }
    }
  t_out[n_out-1] = t_in[n-1];
  if(t_out[n_out-1] == t_out[n_out-2]) n_out--;
  flag[n_out-1] = TRUE;
  
  intpol(t_in, x, n, n_out, t_out, x_tmp, stype);
  intpol(t_in, y, n, n_out, t_out, y_tmp, stype);
  
  /* Make sure interpolated function is bounded on each segment interval */
  
  i = 0;
  while(i < (n_out - 1))
    {
    j = i + 1;
    while(j < n_out && !flag[j]) j++;

    x0 = x_tmp[i], x1 = x_tmp[j];
    if(x0 > x1) d_swap(x0, x1);
    y0 = y_tmp[i], y1 = y_tmp[j];
    if(y0 > y1) d_swap(y0, y1);

    for(k = i + 1; k < j; k++)
      {
      if(x_tmp[k] < x0)	x_tmp[k] = x0 + 1.0e-10;
      else if(x_tmp[k] > x1) x_tmp[k] = x1 - 1.0e-10;

      if(y_tmp[k] < y0) y_tmp[k] = y0 + 1.0e-10;
      else if(y_tmp[k] > y1) y_tmp[k] = y1 - 1.0e-10;
      }
    i = j;
    }

  free((void *)x);
  free((void *)y);

  *x_in = x_tmp;
  *y_in = y_tmp;

  free((void *)t_in);
  free((void *)t_out);
  free((void *)flag);
  return(n_out);
  }

/* Basically does a "tail -r" on the array x,y and append arrays x2/y2 */

int splice_contour(double *x[], double *y[], int n, double *x2[],
		   double *y2[], int n2)
  {
  int i, j, m = (n + n2 - 1);
  double *xtmp, *ytmp, *xa = *x, *ya = *y, *xb = *x2, *yb = *y2;

  xtmp = (double *)memory(NULL, n , sizeof(double), "splice_contour");
  ytmp = (double *)memory(NULL, n, sizeof(double), "splice_contour");

  memcpy((void *)xtmp, (void *)xa, n * sizeof(double));
  memcpy((void *)ytmp, (void *)ya, n * sizeof(double));

  xa = (double *)memory((char *)xa, m, sizeof(double), "splice_contour");
  ya = (double *)memory((char *)ya, m, sizeof(double), "splice_contour");

  for(i = 0; i < n; i++) xa[i] = xtmp[n-i-1];
  for(i = 0; i < n; i++) ya[i] = ytmp[n-i-1];
  for(j = 1, i = n; j < n2; j++, i++) xa[i] = xb[j];
  for(j = 1, i = n; j < n2; j++, i++) ya[i] = yb[j];

  free((void *)xtmp);
  free((void *)ytmp);
  *x = xa, *y = ya;

  return(m);
  }

int contours(struct SURF_GRD *surf_grd, float grd[], int smooth_factor,
	     int int_scheme, int *side, int edge[], int first,
	     double *x_array[], double *y_array[])
  {
  static int i0, j0, odd;
  int i, j, ij, n = 0, n2, n_edges, edge_word, edge_bit, nx, ny, nans = 0,
    p[5], i_off[5], j_off[5], k_off[5], offset;
  unsigned int bit[32];
  bool_t go_on = TRUE;
  double x0, y0, r, west, east, south, north, dx, dy, xinc2, yinc2, *x, *y,
    *x2, *y2;
  
  nx = surf_grd->nx, ny = surf_grd->ny;
  west = surf_grd->xmin, east = surf_grd->xmax;
  south = surf_grd->ymin, north = surf_grd->ymax;
  dx = surf_grd->xinc, dy = surf_grd->yinc;
  xinc2 = yinc2 = 0.0;
  x = *x_array, y = *y_array;

  n_edges = ny * (int)(ceil(nx / 16.0));
  offset = n_edges / 2;

  /* Reset edge-flags to zero, if necessary */

  if(first)
    {
    /* Set i0,j0 for southern boundary */
    memset((void *)edge, 0, n_edges * sizeof(int));
    i0 = 0;
    j0 = ny - 1;
    odd = TRUE;
    }

  p[0] = p[4] = 0, p[1] = 1, p[2] = 1 - nx, p[3] = -nx;
  i_off[0] = i_off[2] = i_off[3] = i_off[4] = 0, i_off[1] =  1;
  j_off[0] = j_off[1] = j_off[3] = j_off[4] = 0, j_off[2] = -1;
  k_off[0] = k_off[2] = k_off[4] = 0, k_off[1] = k_off[3] = 1;
  for(i = 1, bit[0] = 1; i < 32; i++) bit[i] = bit[i - 1] << 1;

  switch(*side)
    {
    case 0:	/* Southern boundary */
      {  
      for(i = i0, j = j0, ij = (ny - 1) * nx + i0;
	  go_on && (i < nx - 1); i++, ij++)
	{
	edge_word = ij / 32;
	edge_bit = ij % 32;
	if(start_trace (grd[ij + 1], grd[ij], edge, edge_word, edge_bit, bit))
	  {
	  /* Start tracing countour */
	  r = grd[ij + 1] - grd[ij];
	  x0 = west + (i - grd[ij] / r) * dx + xinc2;
	  y0 = south + yinc2;
	  edge[edge_word] |= bit[edge_bit];
	  n = trace_contour(surf_grd,grd, x0, y0, edge, smooth_factor, &x, &y,
			    i, j, 0, offset, i_off, j_off, k_off, p, bit,
			    &nans);
	  n = smooth_contour(&x, &y, n, smooth_factor, int_scheme);
	  go_on = FALSE;
	  i0 = i + 1, j0 = j;
	  }
	}
      if(n == 0)
	{
	i0 = nx - 2;
	j0 = ny - 1;
	(*side)++;
	}
      break;
      }

    case 1:		/* Eastern boundary */
      {
      for(j = j0, ij = nx * (j0 + 1) - 1, i = i0; go_on && j > 0;
	  j--, ij -= nx)
	{
	edge_word = ij / 32 + offset;
	edge_bit = ij % 32;
	if(start_trace(grd[ij - nx], grd[ij], edge, edge_word, edge_bit, bit))
	  {
	  /* Start tracing countour */
	  r = grd[ij] - grd[ij - nx];
	  x0 = east - xinc2;
	  y0 = north - (j - grd[ij] / r) * dy - yinc2;
	  edge[edge_word] |= bit[edge_bit];
	  n = trace_contour(surf_grd,grd, x0, y0, edge, smooth_factor, &x, &y,
			    i, j, 1, offset, i_off, j_off, k_off, p, bit,
			    &nans);
	  n = smooth_contour(&x, &y, n, smooth_factor, int_scheme);
	  go_on = FALSE;
	  i0 = i, j0 = j - 1;
	  }
	}
      if(n == 0)
	{
	i0 = nx - 2;
	j0 = 1;
	(*side)++;
	}
      break;
      }

    case 2:		/* Northern boundary */
      {
      for(i = i0, j = j0, ij = i0; go_on && i >= 0; i--, ij--)
	{
	edge_word = ij / 32;
	edge_bit = ij % 32;
	if(start_trace(grd[ij], grd[ij + 1], edge, edge_word, edge_bit, bit))
	  {
	  /* Start tracing countour */
	  r = grd[ij + 1] - grd[ij];
	  x0 = west + (i - grd[ij] / r) * dx + xinc2;
	  y0 = north - yinc2;
	  edge[edge_word] |= bit[edge_bit];
	  n = trace_contour(surf_grd,grd, x0, y0, edge, smooth_factor, &x, &y,
			    i, j, 2, offset, i_off, j_off, k_off, p, bit,
			    &nans);
	  n = smooth_contour(&x, &y, n, smooth_factor, int_scheme);
	  go_on = FALSE, i0 = i - 1, j0 = j;
	  }
	}
      if(n == 0)
	{
	i0 = 0;
	j0 = 1;
	(*side)++;
	}
      break;
      }

    case 3:		/* Western boundary */
      {
      for(j = j0, ij = j * nx, i = i0; go_on && j < ny; j++, ij += nx)
	{
	edge_word = ij / 32 + offset;
	edge_bit = ij % 32;
	if(start_trace(grd[ij], grd[ij-nx], edge, edge_word, edge_bit, bit))
	  {
	  /* Start tracing countour */
	  r = grd[ij] - grd[ij - nx];
	  x0 = west + xinc2;
	  y0 = north - (j - grd[ij] / r) * dy - yinc2;
	  edge[edge_word] |= bit[edge_bit];
	  n = trace_contour(surf_grd,grd, x0, y0, edge, smooth_factor, &x, &y,
			    i, j, 3, offset, i_off, j_off, k_off, p, bit,
			    &nans);
	  n = smooth_contour(&x, &y, n, smooth_factor, int_scheme);
	  go_on = FALSE;
	  i0 = i, j0 = j + 1;
	  }
	}
      if(n == 0)
	{
	i0 = 1;
	j0 = 1;
	(*side)++;
	}
      break;
      }

    case 4:	/* Then loop over interior boxes */
      {
      for(j = j0; go_on && j < ny; j++)
	{
	ij = i0 + j * nx;
	for(i = i0; go_on && (i < nx - 1); i++, ij++)
	  {
	  edge_word = ij / 32 + offset;
	  edge_bit = ij % 32;
	  if(start_trace(grd[ij], grd[ij - nx], edge, edge_word, edge_bit,
			 bit))
	    {
	    /* Start tracing countour */

	    r = grd[ij] - grd[ij - nx];
	    x0 = west + i * dx + xinc2;
	    y0 = north - (j - grd[ij] / r) * dy - yinc2;
	    /* edge[edge_word] |= bit[edge_bit]; */
	    nans = 0;
	    n = trace_contour(surf_grd,grd, x0, y0, edge, smooth_factor, &x,
			      &y, i, j, 3, offset, i_off, j_off, k_off, p,
			      bit, &nans);
	    if(nans)
	      {
	      /* Must trace in other direction, then splice */
	      n2 = trace_contour(surf_grd,grd, x0, y0, edge, smooth_factor,
				 &x2, &y2, i-1, j, 1, offset, i_off, j_off,
				 k_off, p, bit, &nans);
	      n = splice_contour(&x, &y, n, &x2, &y2, n2);
	      free((void *)x2);
	      free((void *)y2);
	      n = smooth_contour(&x, &y, n, smooth_factor, int_scheme);
	      }
	    i0 = i + 1;
	    go_on = FALSE;
	    j0 = j;
	    }
	  }
	if(go_on) i0 = 1;
	}
      if(n == 0) (*side)++;
      break;
      }
    }
  *x_array = x, *y_array = y;
  return(n);
  }
