
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "focproto.h"
#include "jutil.h"
#include "image_stuff.h"



  char projtypes[10][20]={
"jml0",
"jml1",
"albers_equal_area",
"mercator_sphr",
"miller_sphr",
"no_projection",
"utm_sphr",
"utm_ellipsoid",
"cen_utm_sphr",
"cen_utm_ellipsoid"};
  

/* --- function prototypes --- */
void get_tim_str(char *jtim);
void set_xsec(float **amat, float x1, float y1, float x2, float y2,
	      float front, float back, float min_z, float max_z, float dip);


int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);

void citoxyz(int nx, int ny, int nlay, int iway, int *i, int *ix, int *iy,
	     int *iz);
void setup_pat_ps(FILE *inf);
float get_mag_size(float mag, float minsize, float slope,float minmag, float maxmag,
		   int style);
void get_perim(float dir[3], float axis[3], float elip[][2], int *n);
int getline(FILE *input, char s[], int lim);
float refLL(float num, int *ideg, int *imin, int *isec, float *left);

/* --- macros --- */

#define MAXPAT 21
#define MAXCOL 65535

/* --- global variables --- */

int BB_ORG_x, BB_ORG_y;
int BB_LL_x, BB_LL_y, BB_UR_x, BB_UR_y;
float BDX, BDY;



/* --- functions --- */

 float  usr2points(float xkmmax, float ykmmax, float  pagex, float pagey,
		  float bordx, float bordy)
   {
   /*

     input:

      xkmmax = max range for user X units
      ykmmax = max range for user Y units
      pagex  = page x size in inches
      pagey  = page y size in inches
      bordx  = border x in inches
      bordy  = border y in inches

       output:
       plx1 = scaling factor in user units/points

      find  the conversion from km to points on the postscript page 
      the function allows any size paper and
      portrait and landscape are contolled by changing the page shape
      */  
   float plx1;
   float Px, Py, inch=72;
   /* units are in inches  */

     Px = pagex-bordx;
     Py = pagey-bordy;
   
  if(xkmmax > ykmmax) plx1 = Px * inch / xkmmax;
  else plx1 = Py * inch / ykmmax;
  if((plx1 * xkmmax / inch) > Px) plx1 = Px * inch / xkmmax;

  return plx1;
  

  }



int get_f_ind(float val, float *vec, int len)
  {
  int i, j = 0;
  float x, tem;

  x = fabs((val - vec[0]));
  for(i = 0; i < len; i++) 
    {
    tem = fabs((val - vec[i]));
    if(tem < x) j = i, x = tem;
    }

  return(j);
  }

double  ps_kmx(float x, float xorg)
  {
  double  nx = (double)((double) x - (double) xorg);

  return(nx);
  }

double  ps_kmy(float y, float yorg)
  {
  double  ny = (double)((double) y - (double) yorg);

  return(ny);
  }
/************************************************/
void Ps_Xsec(FILE *fp, mpic *mplot, int i)
  {
  float **tmat = alloc_fmat(0, 10, 0, 4);
  float x0, y0;
  
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  set_xsec(tmat, mplot->cross[i].xseckm.x1, mplot->cross[i].xseckm.y1,
	   mplot->cross[i].xseckm.x2, mplot->cross[i].xseckm.y2,
	   mplot->cross[i].max_xsfront, mplot->cross[i].max_xsback,
	   mplot->cross[i].min_xsdepth, mplot->cross[i].max_xsdepth,
	   mplot->cross[i].xs_dip);

  /* fprintf(fp, "1 0 0 setrgbcolor \n"); */
  fprintf(fp, "0 setgray [2] 0 setdash\n");

  if(mplot->cross[i].xs_dip != 90.0)
    {
    /* fprintf(fp, "0 1 0 setrgbcolor \n"); */
    fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[4][0],x0), ps_kmy(tmat[4][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[5][0],x0), ps_kmy(tmat[5][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[6][0],x0), ps_kmy(tmat[6][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[7][0],x0), ps_kmy(tmat[7][1],y0));
    fprintf(fp, "closepath stroke\n");
    /* fprintf(fp, ".5 .5 .5 setrgbcolor \n"); */
    fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[0][0],x0), ps_kmy(tmat[0][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[4][0],x0), ps_kmy(tmat[4][1],y0));
    fprintf(fp, " stroke\n");
    fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[1][0],x0), ps_kmy(tmat[1][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[5][0],x0), ps_kmy(tmat[5][1],y0));
    fprintf(fp, " stroke\n");
    fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[2][0],x0), ps_kmy(tmat[2][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[6][0],x0), ps_kmy(tmat[6][1],y0));
    fprintf(fp, " stroke\n");
    fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[3][0],x0), ps_kmy(tmat[3][1],y0));
    fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[7][0],x0),ps_kmy( tmat[7][1],y0));
    fprintf(fp, " stroke\n");
    }

  fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[0][0],x0), ps_kmy(tmat[0][1],y0));
  fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[1][0],x0), ps_kmy(tmat[1][1],y0));
  fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[2][0],x0), ps_kmy(tmat[2][1],y0));
  fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[3][0],x0), ps_kmy(tmat[3][1],y0));
  fprintf(fp, "closepath stroke\n");
  fprintf(fp, "0 setgray [] 0 setdash\n");
  fprintf(fp, "%lf bx  %lf bz moveto \n", ps_kmx(tmat[8][0],x0), ps_kmy(tmat[8][1],y0));
  fprintf(fp, "%lf bx  %lf bz lineto \n", ps_kmx(tmat[9][0],x0), ps_kmy(tmat[9][1],y0));
  fprintf(fp, " stroke\n");
  fprintf(fp, " %lf bx %lf bz moveto (%d) show\n", ps_kmx(tmat[8][0],x0),ps_kmy(tmat[8][1],y0),
	  mplot->cross[i].xsec_index);

  free_fmat(tmat, 0, 10, 0, 4);
  }

/*************************************************/
void ps_border2( FILE *inf, mpic *mplot)
  {
  float  x0, y0, dif1, dif2, px, py, phi, lam;
  int i, k=0, inc = 10;
  float  phio, lamo, xmax, ymax, xmin, ymin, dum,
    xshift, yshift;
  float pmax, lmax;

  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  xmin =  mplot->origin.minx;
  xmax =  mplot->origin.maxx;
  ymin =  mplot->origin.miny;
  ymax =  mplot->origin.maxy;

  /* fprintf(stderr, " PSBORD %f %f %f %f\n", xmin, xmax, ymin, ymax); */
  

  xy2geo(mplot,  &phio, &lamo, xmin, ymin);
  xy2geo(mplot,  &dum, &lam, xmax, ymin);
  xy2geo(mplot,  &phi, &dum, xmin, ymax);

  pmax = phi;
  lmax = lam;
  
  dif1 = pmax - phio;
  dif1 = fabs(dif1);
  dif2 = lmax - lamo;
  dif2 = fabs(dif2);
   /* fprintf(stderr, " PSBORD %f %f %f %f %f %f   \n", phio, lamo , pmax, lmax, dif1, dif2); */
 
  geo2xy(mplot, phio, lamo, &xshift, &yshift);
 
   fprintf(inf, " %% Plotting border2 and clipping region  \n");
  
     if(mplot->project_type!=1) 
    {
    xshift=0;
    yshift=0;
    }
  
 

  geo2xy(mplot, phio, lamo, &px, &py);
 

      fprintf(inf, " %lf bx %lf bz moveto \n", ps_kmx(px,x0), ps_kmy(py,y0));
  lam = lamo; 

      for(i = 0; i < inc; i++)
	{
	phi = phio + i * dif1 / inc;
	geo2xy(mplot, phi, lam, &px, &py);
	fprintf(inf, " %lf bx %lf bz lineto \n", ps_kmx(px,x0),
		ps_kmy(py,y0));

	 /* fprintf(stderr,"%d %d %f %f %f %f\n", i,k,phi, lam, px, py); */ 

	k++;
	}
      phi = pmax;

      for(i = 0; i < inc; i++)
	{
	lam = lamo + i * dif2 / inc;
	geo2xy(mplot, phi, lam, &px, &py);
	fprintf(inf, " %lf bx %lf bz lineto \n", ps_kmx(px,x0),
		ps_kmy(py,y0));
	 /* fprintf(stderr,"%d %d %f %f %f %f\n", i,k,phi, lam, px, py); */ 
	k++;
	}

      lam = lmax; 
      for(i = 0; i < inc; i++)
	{
	phi = pmax - i * dif1 / inc;
	geo2xy(mplot, phi, lam, &px, &py);
	fprintf(inf, " %lf bx %lf bz lineto \n", ps_kmx(px,x0),
		ps_kmy(py,y0));
	 /* fprintf(stderr,"%d %d %f %f %f %f\n", i,k,phi, lam, px, py); */ 
	k++;
	}

      phi = phio;

      for(i = 0; i < inc; i++)
	{
	lam = lmax -  i * dif2 / inc;
	geo2xy(mplot, phi, lam, &px, &py);
	fprintf(inf, " %lf bx %lf bz lineto \n", ps_kmx(px,x0),
		ps_kmy(py,y0));
	 /* fprintf(stderr,"%d %d %f %f %f %f\n", i,k,phi, lam, px, py); */ 
	k++;
	}
      fprintf(inf, "closepath\n");
fprintf(inf, " %%******************Done Plotting border2 \n");


      k++;
  }

void PS_Border(FILE *inf, mpic *mplot, int bord_style)
  {
  float maxx, maxy, x0, y0;

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  switch(bord_style)
    {
    case 0:
      fprintf(inf, " 0 0  %f bx %f bz bord \n\n\n", maxx, maxy);
      break;

    case 2:
      ps_border2( inf, mplot);
      break;

    case 6:
      ps_border2( inf, mplot);
      break;
    case 7:
      ps_border2( inf, mplot);
      break;
    case 8:
      ps_border2( inf, mplot);
      break;
    case 9:
      ps_border2( inf, mplot);
      break;

    default:
      fprintf(inf, " 0 0  %f bx %f bz bord \n\n\n", maxx, maxy);
      break;
    }
  }

/*****************************************************/

void ps_lips_mapview(FILE *inf, mpic * mplot, float x0, float y0)
   {
   int i, klip, k, kk;
   float x, y, xp, yp, dirin[3], axis[3], dir[3], elip[360][2];
   double a,b;
   

   fprintf(inf, ".5 .5 .5 setcol1 \n\n");

   dirin[0] = 0;
   dirin[1] = 0;
   dirin[2] = 1;
   klip=0;
   k=0;
   
  

   /*     x     y  a    b 
	  newpath 144 400 72 144 0 360 ellipse stroke*/ 

   for (klip = 0; klip < mplot->lip_num; klip++) 
      {

      fprintf(inf, "       %% Ellipse file %d : %s \n", klip,  mplot->lip[klip].file_name);
    
      for (k = 0; k < mplot->lip[klip].n; k++) 
	 {
	 geo2xy(mplot, mplot->lip[klip].lips[k].latlon.phi,
		mplot->lip[klip].lips[k].latlon.lam, &x, &y);

	 if(mplot->lip[klip].lips[k].ind == 1)
	    {
	 
	    a = mplot->lip[klip].lips[k].ebar.x;
	    b = mplot->lip[klip].lips[k].ebar.y;
	    fprintf(inf, "newpath %lf bx %lf bz  %f bx %f bz 0 lip stroke \n",
		    ps_kmx(x, x0), ps_kmy(y, y0), a, b);
	    }
	 else
	    {
	 


	    axis[0] = mplot->lip[klip].lips[k].lambda[0];
	    axis[1] = mplot->lip[klip].lips[k].lambda[1];
	    axis[2] = mplot->lip[klip].lips[k].lambda[2];

	    dir[0] = (mplot->lip[klip].lips[k].vec[0][0] * dirin[0]
		      + mplot->lip[klip].lips[k].vec[0][1] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[0][2] * dirin[2]);
	    dir[1] = (mplot->lip[klip].lips[k].vec[1][0] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[1][1] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[1][2] * dirin[2]);
	    dir[2] = (mplot->lip[klip].lips[k].vec[2][0] * dirin[2]
		      + mplot->lip[klip].lips[k].vec[2][1] * dirin[1]
		      + mplot->lip[klip].lips[k].vec[2][2] * dirin[2]);

	    get_perim(dir, axis, elip, &kk);

	    i = 0;
	    xp = elip[i][0] + x;
	    yp = elip[i][1] + y;
	    fprintf(inf, "       %% Ellipse file: %d number: %d\n", klip, k);
	    fprintf(inf, "%lf bx %lf bz moveto\n", ps_kmx(xp, x0), ps_kmy(yp, y0));
	    for(i = 0; i < kk; i++)
	       {
	       xp = elip[i][0] + x;
	       yp = elip[i][1] + y;
	       fprintf(inf, "%lf bx %lf bz lineto\n", ps_kmx(xp, x0), ps_kmy(yp, y0));
	       }
	    fprintf(inf, "stroke\n");
	    }
      
	 }
      }
   }
/*****************************************************/

void ps_wire_mapview(FILE *inf, mpic *mplot, float x0, float y0)
  {
  int kount, i, j, n;

  fprintf(inf, "%% 3D total files = %d\n", mplot->wire_num);

  for(kount = 0; kount < mplot->wire_num; kount++) 
    {
    for(i = 0; i < mplot->wire[kount].n; i++) 
      {
      fprintf(inf, "%f %f %f setcol1 \n",
	      mplot->jmlcol[mplot->wire[kount].poly[i].col].red,
	      mplot->jmlcol[mplot->wire[kount].poly[i].col].green,
	      mplot->jmlcol[mplot->wire[kount].poly[i].col].blue);
      n = mplot->wire[kount].poly[i].n;
      /* fprintf(stderr, "3D Slab = %d  num=%d\n", i,n); */

      fprintf(inf, " %lf bx %lf bz moveto \n",
	      ps_kmx(mplot->wire[kount].poly[i].kmloc[0].x, x0),
	      ps_kmy(mplot->wire[kount].poly[i].kmloc[0].y, y0));

      for(j = 0; j < n; j++) 
	{
	fprintf(inf, " %lf bx %lf bz lineto \n",
		ps_kmx(mplot->wire[kount].poly[i].kmloc[j].x, x0),
		ps_kmy(mplot->wire[kount].poly[i].kmloc[j].y, y0));

	/* fprintf(stderr, "PLOT %d %f %f %f\n", j,
	   mplot->wire[kount].poly[i].kmloc[j].x,
	   mplot->wire[kount].poly[i].kmloc[j].y,
	   mplot->wire[kount].poly[i].kmloc[j].z); */
	}
      fprintf(inf, "closepath stroke\n");
      }
    }
  }

void ps_mag_scale(FILE *of, mpic *mplot)
  {
  int i, maxm = (int)(mplot->max_mag + 1), minm = (int)(mplot->min_mag);
  float sizmag, x, y, tx, ty, sizmax;

  sizmag = get_mag_size((float)maxm, (float)mplot->SourceSize, (float)mplot->SourceSlope, (float)minm,
			maxm, mplot->mag_src_flag);

  if(sizmag <= 1.0) sizmag = 1;
  sizmax = sizmag;

    {
    fprintf(of, "/mag_scale {\n");
    fprintf(of, "     gsave   translate\n");
    fprintf(of, " /eqpl { eqsiz 0 360 arc stroke } def \n    newpath\n");
    fprintf(of, " %% maxsiz = %f maxm=%d mplot->max_mag=%f\n", sizmag, maxm,
	    mplot->max_mag);
    fprintf(of, "/maxsiz {  %f } def\n", sizmag);

    y = max2(7.367852, sizmag);

    tx = x = 0.0;

  /* first loop through and find the max position  */

    for(i = minm; i <= maxm; i++) 
      {
      sizmag = get_mag_size((float)i, (float) mplot->SourceSize,(float) mplot->SourceSlope,
			    mplot->min_mag, mplot->max_mag,
			    mplot->mag_src_flag);
      if(sizmag <= 1.0) sizmag = 1;
      y = max2(7.367852, sizmag);

      if(i < 5) 
	{
	x = x + 1.1 * y;
	x = x + 1.1 * y;
	tx += y;
	}
      else tx = x + 1.1 * sizmax;
      }

    ty = y;

    fprintf(of, "%f  eqsiz  %f eqsiz -1 mul %f eqsiz 0 270 arc\n", tx, ty, ty);
    fprintf(of, "currentpoint /ny exch def /nx exch def newpath\n");
    fprintf(of, "%f  eqsiz  %f eqsiz -1 mul %f eqsiz 0 360 arc\n", tx, ty, ty);
    fprintf(of, "currentpoint pop /anx exch def newpath\n");
    fprintf(of, "(Magnitude Scale) stringwidth pop /sw exch def\n");
    fprintf(of, "sw  anx gt { /max { sw } def } { /max { anx } def }"
	    " ifelse\n");
    fprintf(of, " 1 setgray \n");
    fprintf(of, "-.05 inch ny 0.05 inch sub max .05 inch add 22 bord fill\n");
    fprintf(of, " 0 setgray \n");
    fprintf(of, "-.05 inch ny 0.05 inch sub max .05 inch add 22 bord"
	    " stroke\n");
    fprintf(of, "0 12 moveto (Magnitude Scale) show\n");
    fprintf(of, " newpath \n");

    x = 0.0;

    for(i = 0; i <= maxm; i++) 
      {
      sizmag = get_mag_size((float)i, (float)mplot->SourceSize,(float)mplot->SourceSlope, mplot->min_mag,
			    mplot->max_mag, mplot->mag_src_flag);
      if(sizmag <= 1.0) sizmag = 1;
      y = max2(7.367852, sizmag);

      if(i < 5) 
	{
	x = x + 1.1 * y;
	fprintf(of, "%f eqsiz %f eqsiz -1 mul %f eqpl \n", x, sizmag, sizmag);
	fprintf(of, "%f  eqsiz  %f eqsiz -1 mul %f eqsiz 0 88 arc (%d)"
		" show newpath\n", x, sizmag, sizmag, i);
	x = x + 1.1 * y;
	}
      else 
	{
	tx = x + 1.1 * sizmax;
	fprintf(of, "%f eqsiz %f eqsiz -1 mul %f eqpl \n", tx, ty, sizmag);
	fprintf(of, "%f  eqsiz  %f eqsiz -1 mul %f eqsiz 0 50 arc (%d) show"
		" newpath\n",tx, ty, sizmag, i);
	}
      }
    fprintf(of, "     grestore } def \n");
    }
  }

/****************************************************/
void Prep_Color_Scales(FILE *of, mpic *mplot)
{
   int j;
     int  color_range = mplot->MaxColor - mplot->MinColor;


  int  k, n = 0, gscr_num;
   int r,g,b;
 
  XColor co;
  
  Colormap gcol;
  Display *gdisp;

  gdisp = XtDisplay(mplot->wij);
  gscr_num = DefaultScreen(gdisp);
  gcol = DefaultColormap(gdisp, gscr_num);


   fprintf(of, "%%   position set to zero for now\n");
   fprintf(of, "\n/pos_sc_x { 0 } def  /pos_sc_y { 0 } def \n\n");

                           /***********  horizontal scale  **********/
   

   fprintf(of, "%%horizontal_scale\n");
   fprintf(of, "/Hoz_Scale {\n");
   fprintf(of, "gsave\n");
   fprintf(of, " pos_sc_x pos_sc_y translate\n");
   fprintf(of, " currentdict  /bsiz known not  { /bsiz { 0.1 inch mul } def  } if \n");
   
   n = mplot->MaxColor - mplot->MinColor ;
   fprintf(of, "gsave\n");
   fprintf(of, "%d bsiz 1 bsiz scale\n",  n);

   fprintf(of, "/picstr %d string def\n", n*3);
   fprintf(of, "%d 1 8 \n", n  );
   fprintf(of, "[%d 0 0 1  0 0  ]\n",n );
  
 
    fprintf(of,"<");

   for(j=mplot->MinColor , k=1; j<mplot->MaxColor  ; j++, k++ )
   {
      
      if(mplot->BW_flag==0)
      {
      co.pixel =   mplot->colors[XmapAppColor(j)];
      XQueryColor(gdisp, gcol, &co);
      
      r = (int)(255*co.red/65535);
      g = (int)(255*co.green/65535);
      b = (int)(255*co.blue/65535);
      
      /* fprintf(of, "%d: R=%d G=%d B=%d\n", i, co.red, co.green, co.blue); */
      fprintf(of, "%02x%02x%02x",r,g,b);
      if((k%10) == 0) fprintf(of,"\n");
      }
      else
      {
	 r = 255*(j-mplot->MinColor)/(mplot->MaxColor - mplot->MinColor);
	 fprintf(of, "%02x",r);
	 if((k%mplot->image.nx) == 0) fprintf(of,"\n");

      }
   }

   fprintf(of,">");
   if(mplot->BW_flag==0)
   {
      fprintf(of, "false 3 colorimage\n");
   }
   else
   {
      fprintf(of, "image\n");
   }
   fprintf(of,"\n");
   fprintf(of,"grestore\n");
      

   fprintf(of, "0 setgray\n");
   fprintf(of, "0 0  %d bsiz 1 bsiz bord stroke\n", color_range);
   if(!mplot->image_scale_log_flag){
      float currMin,currMax;
      int i,num=4;
      if(mplot->image_scale_flag == 0){
	 currMin=mplot->image.Temp_image_min;
	 currMax=mplot->image.Temp_image_max;
      }else{
	 currMin=mplot->image.Layer_min[mplot->image_layer - 1];
	 currMax=mplot->image.Layer_max[mplot->image_layer - 1];
      }
      for(i=0;i<num;i++){
	 fprintf(of, " %d bsiz -1.5 bsiz moveto (%#.3g) show\n", 
		 (color_range - 1)*i/(num-1),
		 (currMin*(num-1-i)+currMax*i)/(num-1));
      }
   }else{
      float currMin,currMax,currVal,diff;
      int i,num=4;
      if(mplot->image_scale_flag == 0){
	 currMin=mplot->image.Temp_image_min;
	 currMax=mplot->image.Temp_image_max;
      }else{
	 currMin=mplot->image.Layer_min[mplot->image_layer - 1];
	 currMax=mplot->image.Layer_max[mplot->image_layer - 1];
      }
      diff=log10(1.0+currMax-currMin);
      for(i=0;i<num;i++){
	 currVal=currMin-1.0+pow(10.0,diff*i/(num-1));
	 fprintf(of, " %d bsiz -1.5 bsiz moveto (%#.3g) show\n", 
		 (color_range - 1)*i/(num-1),
		 currVal);
      }
   }
   
   fprintf(of, "%% %d bsiz 1.1 bsiz moveto (title) censhow\n",
	   (color_range - 1) / 2);
   fprintf(of, "grestore } def \n\n");
   
/***********   vertical scale  **********/

  fprintf(of, "%%vertical\n");
  fprintf(of, "/Vert_Scale {\n");
  fprintf(of, "gsave\n");
  fprintf(of, " pos_sc_x pos_sc_y translate\n");
  fprintf(of, " currentdict  /bsiz known not  { /bsiz { 0.1 inch mul } def  } if \n");
  


   n = mplot->MaxColor - mplot->MinColor ;
   fprintf(of, "gsave\n");
   fprintf(of, "0 1 bsiz  translate\n");
   fprintf(of, "1 bsiz %d  bsiz scale\n",  n);

   fprintf(of, "/picstr %d string def\n", n*3);
   fprintf(of, "1 %d  8 \n", n  );
   fprintf(of, "[1 0 0 %d  0 0  ]\n",-n );
   
  
   fprintf(of, "<");

   for(j=mplot->MinColor , k=1; j<mplot->MaxColor  ; j++, k++ )
   {
     
     if(mplot->BW_flag==0)
      {
      co.pixel = mplot->colors[XmapAppColor(j)];
      XQueryColor(gdisp, gcol, &co);
      
      r = (int)(255*co.red/65535);
      g = (int)(255*co.green/65535);
      b = (int)(255*co.blue/65535);
      
      /* fprintf(of, "%d: R=%d G=%d B=%d\n", i, co.red, co.green, co.blue); */
      fprintf(of, "%02x%02x%02x",r,g,b);
      if((k%10) == 0) fprintf(of,"\n");
      }
     else
     {
	 r = 255*(j-mplot->MinColor)/(mplot->MaxColor - mplot->MinColor);
	 fprintf(of, "%02x",r);
	 if((k%mplot->image.nx) == 0) fprintf(of,"\n");

     }
   }
   fprintf(of, ">");
 

 if(mplot->BW_flag==0)
   {
      fprintf(of, "false 3 colorimage\n");
   }
   else
   {
      fprintf(of, "image\n");
   }


   fprintf(of,"\n");
   fprintf(of,"grestore\n");
      

  fprintf(of, "0 setgray\n");
  fprintf(of, "0 1 bsiz  1 bsiz %d bsiz  bord stroke\n", -(color_range - 1));
 if(!mplot->image_scale_log_flag){
    float currMin,currMax;
    int i,num=4;
    if(mplot->image_scale_flag == 0){
      currMin=mplot->image.Temp_image_min;
      currMax=mplot->image.Temp_image_max;
    }else{
      currMin=mplot->image.Layer_min[mplot->image_layer - 1];
      currMax=mplot->image.Layer_max[mplot->image_layer - 1];
    }
    for(i=0;i<num;i++){
      fprintf(of, " 1.1 bsiz %d bsiz moveto (%#.3g) show\n", 
	      -(color_range - 1)*i/(num-1),
	      (currMin*(num-1-i)+currMax*i)/(num-1));
    }
  }else{
    float currMin,currMax,currVal,diff;
    int i,num=4;
    if(mplot->image_scale_flag == 0){
      currMin=mplot->image.Temp_image_min;
      currMax=mplot->image.Temp_image_max;
    }else{
      currMin=mplot->image.Layer_min[mplot->image_layer - 1];
      currMax=mplot->image.Layer_max[mplot->image_layer - 1];
    }
    diff=log10(1.0+currMax-currMin);
    for(i=0;i<num;i++){
      currVal=currMin-1.0+pow(10.0,diff*i/(num-1));
      fprintf(of, " 1.1 bsiz %d bsiz moveto (%#.3g) show\n", 
	      -(color_range - 1)*i/(num-1),
	      currVal);
    }
  }


  fprintf(of, "%% 0  1.1 bsiz moveto (title) show\n");
  fprintf(of, "grestore } def \n");

}



void Ps_Palette( FILE *of, mpic *mplot)
  {
  int i, color_range = mplot->MaxColor - mplot->MinColor;

  fprintf(stderr, " Ps_Palette: MinColor=%d  MaxColor=%d\n", mplot->MinColor,
	  mplot->MaxColor);
  fprintf(of, "\n  %% Following is a Postscript Color Palette  \n");
  fprintf(of, "    %% You may insert your own different palette here \n");
  fprintf(of, "    %% Just change the RGB values in the 3 following vectors"
	  " \n");
  fprintf(of, "    %% Remember there have to be %d values in each vector  \n",
	  color_range);
  fprintf(of, "\n\n\n");
  fprintf(of, "/reds %d array def\n/blues %d array def\n/greens %d array"
	  " def\n", color_range, color_range, color_range);

  for(i = 0; i < color_range; i++)
    {
    fprintf(of, "%f ", mplot->jmlcol[mplot->MinColor+i].red);
    if((i + 1) % 10 == 0) fprintf(of, "\n");
    }
  fprintf(of, "  reds astore \n");

  for(i = 0; i < color_range; i++)
    {
    fprintf(of, "%f ", mplot->jmlcol[mplot->MinColor+i].green);
    if((i + 1) % 10 == 0) fprintf(of, "\n");
    }
  fprintf(of, "  greens astore \n");

  for(i = 0; i < color_range; i++)
    {
    fprintf(of, "%f ", mplot->jmlcol[mplot->MinColor+i].blue);




  if((i + 1) % 10 == 0) fprintf(of, "\n");
    }
  fprintf(of, "  blues astore \n");

  fprintf(of, "/changecolor { \n");
  fprintf(of, "    /col exch def \n");
  fprintf(of, "    reds col get greens col get blues col get \n");
  fprintf(of, "    setrgbcolor } def \n");
  fprintf(of, "/staurated_hi { 1 0 0 setcol1 } def \n");
  fprintf(of, "/staurated_lo { 0 0 1 setcol1 } def \n");
  fprintf(of, "\n  %%For Black and White figures (grayscale) the following"
	  " line must be active \n\n");





  if(mplot->BW_flag == 1) 
    {

      fprintf(stderr," reverse pal = %d \n", mplot->Reverse_Pal);
      
      if(mplot->Reverse_Pal == 0)
	{
	  
	  fprintf(of, "    /changecolor { %d div setgray  } def \n", color_range);
	}
      
      else
	{
	  
	  fprintf(of, "    /changecolor { %d div -1 mul 1 add setgray  } def \n", color_range);
	}
      
    }
  
  else
    {
      
    fprintf(of, "    %%/changecolor { %d div setgray  } def \n", color_range);
    
    }

/*********** position of scale set to zero, for now  **********/

  fprintf(of, "%%   position set to zero for now\n");
  fprintf(of, "\n/pos_sc_x { 0 } def  /pos_sc_y { 0 } def \n\n");
#if 0

/***********  horizontal scale  **********/


  fprintf(of, "%%horizontal_scale\n");
  fprintf(of, "/Hoz_Scale {\n");
  fprintf(of, "gsave\n");
  fprintf(of, " pos_sc_x pos_sc_y translate\n");
  fprintf(of, " currentdict  /bsiz known not  { /bsiz { 0.1 inch mul } def  } if \n");
  fprintf(of, " 0 1 %d { dup changecolor bsiz  0 box fill } for\n",
	  color_range - 1);
  fprintf(of, "0 setgray\n");
  fprintf(of, "0 0  %d bsiz 1 bsiz bord stroke\n", color_range);
 if(!mplot->image_scale_log_flag){
    float currMin,currMax;
    int i,num=4;
    if(mplot->image_scale_flag == 0){
      currMin=mplot->image.Temp_image_min;
      currMax=mplot->image.Temp_image_max;
    }else{
      currMin=mplot->image.Layer_min[mplot->image_layer - 1];
      currMax=mplot->image.Layer_max[mplot->image_layer - 1];
    }
    for(i=0;i<num;i++){
      fprintf(of, " %d bsiz -1.5 bsiz moveto (%#.3g) show\n", 
	      (color_range - 1)*i/(num-1),
	      (currMin*(num-1-i)+currMax*i)/(num-1));
    }
  }else{
    float currMin,currMax,currVal,diff;
    int i,num=4;
    if(mplot->image_scale_flag == 0){
      currMin=mplot->image.Temp_image_min;
      currMax=mplot->image.Temp_image_max;
    }else{
      currMin=mplot->image.Layer_min[mplot->image_layer - 1];
      currMax=mplot->image.Layer_max[mplot->image_layer - 1];
    }
    diff=log10(1.0+currMax-currMin);
    for(i=0;i<num;i++){
      currVal=currMin-1.0+pow(10.0,diff*i/(num-1));
      fprintf(of, " %d bsiz -1.5 bsiz moveto (%#.3g) show\n", 
	      (color_range - 1)*i/(num-1),
	      currVal);
    }
  }
 
  fprintf(of, "%% %d bsiz 1.1 bsiz moveto (title) censhow\n",
	  (color_range - 1) / 2);
  fprintf(of, "grestore } def \n\n");

/***********   vertical scale  **********/

  fprintf(of, "%%vertical\n");
  fprintf(of, "/Vert_Scale {\n");
  fprintf(of, "gsave\n");
  fprintf(of, " pos_sc_x pos_sc_y translate\n");
  fprintf(of, " currentdict  /bsiz known not  { /bsiz { 0.1 inch mul } def  } if \n");
  fprintf(of, " 0 1 %d { dup changecolor bsiz  -1 mul 0 exch box fill } for\n",
	  color_range - 1);
  fprintf(of, "0 setgray\n");
  fprintf(of, "0 1 bsiz  1 bsiz %d bsiz  bord stroke\n", -(color_range - 1));
 if(!mplot->image_scale_log_flag){
    float currMin,currMax;
    int i,num=4;
    if(mplot->image_scale_flag == 0){
      currMin=mplot->image.Temp_image_min;
      currMax=mplot->image.Temp_image_max;
    }else{
      currMin=mplot->image.Layer_min[mplot->image_layer - 1];
      currMax=mplot->image.Layer_max[mplot->image_layer - 1];
    }
    for(i=0;i<num;i++){
      fprintf(of, " 1.1 bsiz %d bsiz moveto (%#.3g) show\n", 
	      -(color_range - 1)*i/(num-1),
	      (currMin*(num-1-i)+currMax*i)/(num-1));
    }
  }else{
    float currMin,currMax,currVal,diff;
    int i,num=4;
    if(mplot->image_scale_flag == 0){
      currMin=mplot->image.Temp_image_min;
      currMax=mplot->image.Temp_image_max;
    }else{
      currMin=mplot->image.Layer_min[mplot->image_layer - 1];
      currMax=mplot->image.Layer_max[mplot->image_layer - 1];
    }
    diff=log10(1.0+currMax-currMin);
    for(i=0;i<num;i++){
      currVal=currMin-1.0+pow(10.0,diff*i/(num-1));
      fprintf(of, " 1.1 bsiz %d bsiz moveto (%#.3g) show\n", 
	      -(color_range - 1)*i/(num-1),
	      currVal);
    }
  }


  fprintf(of, "%% 0  1.1 bsiz moveto (title) show\n");
  fprintf(of, "grestore } def \n");
#endif
  }






void plot_ps_image(FILE *of, mpic *mplot)
  {
  int j, i, i1, npoints, ix, iy, iz, iway = 1, start, color_range;
  float hsizex, hsizey, xorg, yorg,  phi, lam, maxx, maxy, x0, y0;
  float lam1, lam2, phi1, phi2,x1, x2, y1, y2;
  double x, y, xh, yh;
  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  color_range = mplot->MaxColor - mplot->MinColor;

  if(mplot->image_layer > mplot->image.nz)
    mplot->image_layer = mplot->image.nz;
  if(mplot->image_layer < 1)
    mplot->image_layer = 1;

  /* fprintf(stderr,"color range= %d  plotting %d\n", color_range,
     mplot->image_layer); */

  npoints = mplot->image.nx * mplot->image.ny;
  phi = mplot->image.phi;
  lam = mplot->image.lam;
  geo2xy(mplot, phi, lam, &xorg, &yorg);

  hsizex = mplot->image.dx;
  hsizey = mplot->image.dy;
  start = (mplot->image_layer - 1) * npoints;

  fprintf(of, " gsave \n" );
  PS_Border(of, mplot, mplot->project_type);
  fprintf(of, " clip newpath \n\n\n");
  fprintf(of, " /saturated_lo { 1 setgray } def  \n /saturated_hi { 1"
	  " setgray } def \n\n\n");

  for(i = start; i < start + npoints; i++) 
    {
    j = i;
    if((mplot->image.col[i] != 0) && (mplot->image.col[i] != 1)) 
      {
      i1 = mplot->image.col[i];

      /* fprintf(of, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	 mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue); */

      citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway, &j,
	      &ix, &iy, &iz);

       if(!strcmp(mplot->image.Type, "GMT"))
	{
	 
	  lam1 = mplot->image.lam + (ix - 1) * mplot->image.dx;
	  lam2 = lam1 +  mplot->image.dx;

	  phi1 = mplot->image.phi - (iy - 1) * mplot->image.dy;
	  phi2 = phi1 -  mplot->image.dy;


	  geo2xy(mplot, phi1, lam1, &x2, &y2);
	  geo2xy(mplot, phi2, lam2, &x1, &y1);

	 
	  x = ps_kmx(x1 , x0);
	   y = ps_kmy(y1 , y0);
	   xh =  ps_kmx(x2 , x0);
	   yh = ps_kmy(y2 , y0);
	}
       else
	 {
	   x = ps_kmx(xorg + (ix - 1) * mplot->image.dx, x0);
	   y = ps_kmy(yorg + (iy - 1) * mplot->image.dy, y0);
	   xh = x + hsizex;
	   yh = y + hsizey;
	 }

      /* check to see if the box overlaps the picture area  */

      if(((x >= 0.0 && x <= maxx) && (y >= 0 && y <= maxy))
	 || ((x >= 0.0 && x <= maxx) && (yh >= 0 && yh <= maxy))
	 || ((xh >= 0.0 && xh <= maxx) && (y >= 0 && y <= maxy))
	 || ((xh >= 0.0 && xh <= maxx) && (yh >= 0 && yh <= maxy))) 
	{
	i1 = i1 - mplot->MinColor;
	if((i1 >= 0) && (i1 < color_range)) 
	  {
	  fprintf(of, " %d changecolor\n", i1);
	  fprintf(of, " %f bx  %f bz  %f bx  %f bz bord fill \n", x, y, xh,
		  yh);
	  }
	else 
	  {
	  if(i1 < 0) fprintf(of, " saturated_lo   \n");
	  else fprintf(of, " saturated_hi   \n");
	  fprintf(of, " %f bx  %f bz  %f bx  %f bz bord fill \n", x, y, xh,
		  yh);
	  }
	}
      }
    }

  fprintf(of, "grestore\n\n");
    fprintf(of, "   /bsiz { 0.1 inch mul } def\n");
  fprintf(of, "\n/pos_sc_x { %f bx 0.1 inch add  } def  /pos_sc_y { %f bz } def\n", maxx,
	  maxy);
  fprintf(of, "Vert_Scale\n\n");
  BB_UR_x+=25;
  fprintf(of, "0 setgray\n");
  fprintf(of, "%f bx  %f bz 2 add moveto (Layer %d: %g-%g) show\n",
	  0.60 * maxx, maxy, mplot->image_layer,
	  mplot->image.z_parts[mplot->image_layer - 1],
	  mplot->image.z_parts[mplot->image_layer]);
  }
/***************************************************/
void plot_ps_HEX_image(FILE *of, mpic *mplot)
  {
  int j, i, i1, npoints,  start, color_range;
  float hsizex, hsizey, xorg, yorg,  phi, lam, maxx, maxy, x0, y0;
  
  

  int  k,  gscr_num;
   int r,g,b;
 
  XColor co;
  
  Colormap gcol;
  Display *gdisp;

  gdisp = XtDisplay(mplot->wij);
  gscr_num = DefaultScreen(gdisp);
  gcol = DefaultColormap(gdisp, gscr_num);

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  color_range = mplot->MaxColor - mplot->MinColor;

  if(mplot->image_layer > mplot->image.nz)
    mplot->image_layer = mplot->image.nz;
  if(mplot->image_layer < 1)
    mplot->image_layer = 1;

  /* fprintf(stderr,"color range= %d  plotting %d\n", color_range,
     mplot->image_layer); */

  npoints = mplot->image.nx * mplot->image.ny;
  phi = mplot->image.phi;
  lam = mplot->image.lam;
  geo2xy(mplot, phi, lam, &xorg, &yorg);

  hsizex =mplot->image.nx * mplot->image.dx;
  hsizey = mplot->image.ny*mplot->image.dy;
  start = (mplot->image_layer - 1) * npoints;

  fprintf(of, " gsave \n" );
  PS_Border(of, mplot, mplot->project_type);

    fprintf(of, "/picstr %d string def\n", mplot->image.nx*3);
  fprintf(of, " clip newpath \n\n\n");
  fprintf(of, " /saturated_lo { 1 setgray } def  \n /saturated_hi { 1"
	  " setgray } def \n\n\n");

      fprintf(of, "%f bx %f bz  translate\n",xorg, yorg );

      fprintf(of, "%f bx  %f bz scale\n", hsizex, hsizey );

      fprintf(of, "%d %d 8 \n",mplot->image.nx, mplot->image.ny );
      fprintf(of, "[%d 0 0 %d 0 0  ]\n",mplot->image.nx, mplot->image.ny );

      fprintf(of, "{currentfile picstr readhexstring pop}\n");
      fprintf(of, "false 3 colorimage\n");
      

  for(i = start, k=1; i < start + npoints; i++, k++) 
    {
    j = i;
    
    if((mplot->image.col[i] != 0) && (mplot->image.col[i] != 1)) 
    {
       i1 = mplot->image.col[i];
    }
    else
    {
       i1 = mplot->back_fill_col;
       
    }
    /* fprintf(of, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
       mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue); */
    
    /* citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway, &j, */
          /* 	      &ix, &iy, &iz); */
    
	    co.pixel = mplot->colors[XmapAppColor(i1)];
	    XQueryColor(gdisp, gcol, &co);

	    r = (int)(255*co.red/65535);
	    g = (int)(255*co.green/65535);
	    b = (int)(255*co.blue/65535);

	    /* fprintf(of, "%d: R=%d G=%d B=%d\n", i, co.red, co.green, co.blue); */

	    fprintf(of, "%02x%02x%02x",r,g,b);
	    if((k%10) == 0) fprintf(of,"\n");
   	  
    }
  fprintf(of,"\n");
  fprintf(of, "grestore\n\n");
    fprintf(of, "   /bsiz { 0.1 inch mul } def\n");
  fprintf(of, "\n/pos_sc_x { %f bx 0.1 inch add  } def  /pos_sc_y { %f bz } def\n", maxx,
	  maxy);
  fprintf(of, "Vert_Scale\n\n");
  BB_UR_x+=25;
  fprintf(of, "0 setgray\n");
  fprintf(of, "%f bx  %f bz 2 add moveto (Layer %d: %g-%g) show\n",
	  0.60 * maxx, maxy, mplot->image_layer,
	  mplot->image.z_parts[mplot->image_layer - 1],
	  mplot->image.z_parts[mplot->image_layer]);
  }

/**************************************************/
/***************************************************/
void plot_ps_HEX_BWimage(FILE *of, mpic *mplot)
  {
  int j, i, i1, npoints,   start, color_range;
  float hsizex, hsizey, xorg, yorg,  phi, lam, maxx, maxy, x0, y0;
  
  

  int  k,  gscr_num;
   int r;
 
  
  
  Colormap gcol;
  Display *gdisp;

  gdisp = XtDisplay(mplot->wij);
  gscr_num = DefaultScreen(gdisp);
  gcol = DefaultColormap(gdisp, gscr_num);

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  color_range = mplot->MaxColor - mplot->MinColor;

  if(mplot->image_layer > mplot->image.nz)
    mplot->image_layer = mplot->image.nz;
  if(mplot->image_layer < 1)
    mplot->image_layer = 1;

  /* fprintf(stderr,"color range= %d  plotting %d\n", color_range,
     mplot->image_layer); */

  npoints = mplot->image.nx * mplot->image.ny;
  phi = mplot->image.phi;
  lam = mplot->image.lam;
  geo2xy(mplot, phi, lam, &xorg, &yorg);

  hsizex =mplot->image.nx * mplot->image.dx;
  hsizey = mplot->image.ny*mplot->image.dy;
  start = (mplot->image_layer - 1) * npoints;

  fprintf(of, " gsave \n" );
  PS_Border(of, mplot, mplot->project_type);

    fprintf(of, "/picstr %d string def\n", mplot->image.nx*3);
  fprintf(of, " clip newpath \n\n\n");
  fprintf(of, " /saturated_lo { 1 setgray } def  \n /saturated_hi { 1"
	  " setgray } def \n\n\n");

      fprintf(of, "%f bx %f bz  translate\n",xorg, yorg );

      fprintf(of, "%f bx  %f bz scale\n", hsizex, hsizey );

      fprintf(of, "%d %d 8 \n",mplot->image.nx, mplot->image.ny );
      fprintf(of, "[%d 0 0 %d 0 0  ]\n",mplot->image.nx, mplot->image.ny );

      fprintf(of, "{currentfile picstr readhexstring pop}\n");
      fprintf(of, " image\n");
      

  for(i = start, k=1; i < start + npoints; i++, k++) 
    {
    j = i;
    
    if((mplot->image.col[i] != 0) && (mplot->image.col[i] != 1)) 
    {
       i1 = mplot->image.col[i];
    }
    else
    {
       i1 = mplot->MaxColor;
       
    }
    /* fprintf(of, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
       mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue); */
    
    /* citoxyz(mplot->image.nx, mplot->image.ny, mplot->image.nz, iway, &j, */
          /* 	      &ix, &iy, &iz); */

    r = 255*(i1-mplot->MinColor)/(mplot->MaxColor - mplot->MinColor);
            
    
	    
	    /* fprintf(of, "%d: R=%d G=%d B=%d\n", i, co.red, co.green, co.blue); */

	    fprintf(of, "%02x",r);
	    if((k%mplot->image.nx) == 0) fprintf(of,"\n");
   	  
    }
  fprintf(of,"\n");
  fprintf(of, "grestore\n\n");
    fprintf(of, "   /bsiz { 0.1 inch mul } def\n");
  fprintf(of, "\n/pos_sc_x { %f bx 0.1 inch add  } def  /pos_sc_y { %f bz } def\n", maxx,
	  maxy);
  fprintf(of, "Vert_Scale\n\n");
  BB_UR_x+=25;
  fprintf(of, "0 setgray\n");
  fprintf(of, "%f bx  %f bz 2 add moveto (Layer %d: %g-%g) show\n",
	  0.60 * maxx, maxy, mplot->image_layer,
	  mplot->image.z_parts[mplot->image_layer - 1],
	  mplot->image.z_parts[mplot->image_layer]);
  }

/**************************************************/

void Print_Header(FILE *inf, char fname[])
  {
  FILE *input;
  int c;

  fprintf(stderr, "header file is:  %s \n", fname);
  if((input = fopen(fname, "r")) == NULL)
    {
    fprintf(stderr,"Can't open header file...continuing\n");
    return;
    }

  while((c = fgetc(input)) != EOF)
    fputc(c, inf);

  fclose(input);
  }

/* ---------------------------------------------------------------- */


void plot_a_point_ps(FILE *inf , mpic *m, float px, float py, int kount, int i)
  {
  float size;

  fprintf(inf, "%f %f %f setcol1 \n",
	  m->jmlcol[m->Mpoint[kount].points[i].color].red,
	  m->jmlcol[m->Mpoint[kount].points[i].color].green,
	  m->jmlcol[m->Mpoint[kount].points[i].color].blue);

  size = 0.75 * m->Mpoint[kount].points[i].symsize;
  	fprintf(inf, " %%  (%s) \n",
		 m->Mpoint[kount].points[i].name);

  if(m->Mpoint[kount].points[i].symcode == 1)
    {
    fprintf(inf, "/tsiz { %f mul } def \n", size);
    fprintf(inf, "%f bx %f bz \n", px, py);

    switch(m->Mpoint[kount].points[i].symbol) 
      {
      case 0:
        fprintf(inf, "   1 tsiz xtriangleU \n");
	break;

      case 1:
	fprintf(inf, "  1 tsiz xtriangle  \n");
	break;

      case 2:
	fprintf(inf, "  1  tsiz xsquare  \n");
	break;

      case 3:
	fprintf(inf, "   1  tsiz star_of_david  \n");
	break;

      case 4:
	fprintf(inf, "   1 tsiz xmark \n");
	break;

      case 5:
	fprintf(inf, "   1 tsiz xplus  \n");
	break;

      case 6:
	fprintf(inf, "   1 tsiz xdiamond  \n");
	break;

      case 7:
	fprintf(inf, "   1 tsiz xcirc  \n");
	break;

      case 8:
	fprintf(inf, "   1 tsiz xfillcirc  \n");
	break;

      case 9:
	fprintf(inf, "   1 tsiz xasterix30  \n");
	break;
      case 10:
	fprintf(inf, "   1 tsiz star5  \n");
	break;
      case 11:
	fprintf(inf, "   1 tsiz star5  \n");
	break;

      default:
	fprintf(inf, "  jugsta fill  \n");
	break;
      }
    }

  if(m->Mpoint[kount].points[i].strcode == 1)
    {
    fprintf(inf, "  /Helvetica-Bold findfont %d scalefont setfont\n",
	    m->Mpoint[kount].points[i].fsize);

    if(m->Mpoint[kount].points[i].symcode == 1)
      {
      switch(m->Mpoint[kount].points[i].just)
	{
	case 0:
	  fprintf(inf, " /shifx { %f } def /shify { %f } def \n", size / 2,
		  size / 2 );
	  break;

	case 1:
	  fprintf(inf, " /shifx { %f } def /shify { %f } def \n", 0.0,
		  size / 2);
	  break;

	case 2:
	  fprintf(inf, " /shifx { %f } def /shify { %f } def \n", -size / 2,
		  size / 2);
	  break;
	}
      }
    else fprintf(inf, " /shifx { 0 } def /shify { 0 } def \n");

    switch(m->Mpoint[kount].points[i].just) 
      {
      case 0:
        fprintf(inf, " %f bx %f bz moveto shifx shify rmoveto (%s) show\n",
		px, py, m->Mpoint[kount].points[i].name);
	break;

      case 1:
	fprintf(inf, " %f bx %f bz moveto  shifx shify rmoveto (%s) censhow\n",
		px, py, m->Mpoint[kount].points[i].name);
	break;

      case 2:
	fprintf(inf, " %f bx %f bz moveto  shifx shify rmoveto (%s) "
		"rightshow\n", px, py, m->Mpoint[kount].points[i].name);
      break;
      }
    }
  }

/**********************/
void plot_a_point_M(FILE *inf , mpic *m, double px, double  py, int kount, int i)
  {
  float  x0 = m->origin.minx, y0 = m->origin.miny;
  px = ps_kmx(px, x0);
  py = ps_kmy(py, y0);
 plot_a_point_ps(inf, m, px, py, kount, i);
  }
/**********************/
void Plot_Points_Map(FILE *inf, mpic *m)
  {
  float px, py;
  int i, kount;

#if 0
  name
  color, fsize, symbol, symsize
  symcode;			/* symbol 0 = off 1 = on */
  strcode;			/* string 0 = off 1 = on */
  just;				/* HJ_LEFT=0, HJ_CENTER=1, HJ_RIGHT=2 */
  lat, lon, depth;
#endif

  fprintf(inf, "\n\n %% BEGIN POINTS \n\n");
  for(kount = 0; kount < m->point_flag; kount++) 
    {
    for(i = 0; i < m->Mpoint[kount].numpoints; i++)
      {
      geo2xy(m, m->Mpoint[kount].points[i].lat, m->Mpoint[kount].points[i].lon,
	     &px, &py);
      if((px > m->origin.minx) && (px < m->origin.maxx)
	 && (py > m->origin.miny) && (py < m->origin.maxy))
        plot_a_point_M(inf, m, px, py, kount, i);
      }
    }
  fprintf(inf, " %% END POINTS \n\n");


  }

/*********************/

void plot_ps_connect_sources(FILE *inf, mpic *mplot)
  {
  int j, i;
  float x0 = mplot->origin.minx, y0 = mplot->origin.miny;

  for(j = 0; j < mplot->max_more_src - 1; j++) 
    {
    for(i = 0; i < mplot->sources[j].numpoints; i++) 
      {
      if(mplot->sources[j].loc[i].z <= mplot->MaxDepth)
	{
	fprintf(inf, " %lf bx %lf bz moveto %lf bx %lf bz lineto stroke\n",
		ps_kmx(mplot->sources[j].loc[i].x, x0),
		ps_kmy(mplot->sources[j].loc[i].y, y0),
		ps_kmx(mplot->sources[j + 1].loc[i].x, x0),
		ps_kmy(mplot->sources[j + 1].loc[i].y, y0));
	}
      }
    }
  }

/********************/

void plot_ps_wells(FILE *inf, mpic *mplot)
  {
  int kount, i,i1;
  float  x0 = mplot->origin.minx, apx, apy, y0 = mplot->origin.miny, phi, lam;
  double px, py;
  fprintf(inf, "\n\n %% BEGIN WELLS \n\n");
  fprintf(inf, "\n\n /wsiz  3  def %%  well size \n");
  fprintf(inf, " .2 setlinewidth \n ");

  for(kount = 0; kount < mplot->num_wells_files; kount++) 
    {
    for(i = 0; i < mplot->wells[kount].well_count; i++) 
      {
      phi = mplot->wells[kount].well[i].loc[0].x;
      lam = mplot->wells[kount].well[i].loc[0].y;
      geo2xy(mplot, phi, lam, &apx, &apy);

      i1 = mplot->wells[kount].well[i].color;
      fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);
      px = ps_kmx(apx, x0);
      py = ps_kmy(apy, y0);

      if(mplot->wells_name_flag)
        fprintf(inf, " %lf bx %lf bz plwell %lf bx %lf bz moveto wsiz wsiz "
		"rmoveto (%s) show \n", px, py, px, py,
		mplot->wells[kount].well[i].name);
      if(mplot->wells_symbol_flag)
        fprintf(inf, " %lf bx %lf bz plwell %% %s \n", px, py,
		mplot->wells[kount].well[i].name);
      }
    }
  fprintf(inf, "\n\n %% END WELLS \n\n");
  }

void plot_ps_proj_wells(FILE *inf, mpic *mplot)
  {
  int kount, i,j, i1;
  float  x0 = mplot->origin.minx, apx, apy,  y0 = mplot->origin.miny, phi, lam;
  double  px, py;       
  fprintf(inf, "\n\n %% BEGIN PROJECT WELLS \n\n");
  fprintf(inf, "\n\n %%   projecting wells onto horizontal plane \n");
  if(mplot->hoz_slab_flag == 1)
    fprintf(inf, " %% only projecting wells from %f to %f km depth \n",
	    mplot->hoz_slab_top, mplot->hoz_slab_bot);
  fprintf(inf, "\n");

  for(kount = 0; kount < mplot->num_wells_files; kount++)
    {
    for(i = 0; i < mplot->wells[kount].well_count; i++) 
      {
      if((mplot->hoz_slab_flag == 1)
	 && ((mplot->wells[kount].well[i].loc[0].z < mplot->hoz_slab_top)
	     || (mplot->wells[kount].well[i].loc[0].z > mplot->hoz_slab_bot)))
	{
	/* fprintf(stderr,"  NOT plotting\n"); */
	continue;
	}

      i1 = mplot->wells[kount].well[i].color;
      fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);

      phi = mplot->wells[kount].well[i].loc[0].x;
      lam = mplot->wells[kount].well[i].loc[0].y;
      geo2xy(mplot, phi, lam, &apx, &apy);

      px = ps_kmx(apx, x0);
      py = ps_kmy(apy, y0);
      fprintf(inf, " %lf bx %lf bz moveto \n", px, py);

      for(j = 1; j < mplot->wells[kount].well[i].nump; j++) 
	{
	phi = mplot->wells[kount].well[i].loc[j].x;
	lam = mplot->wells[kount].well[i].loc[j].y;
	geo2xy(mplot, phi, lam, &apx, &apy);
	px = ps_kmx(apx, x0);
	py = ps_kmy(apy, y0);
	fprintf(inf, " %lf bx %lf bz lineto \n", px, py);
	}
      fprintf(inf, "   stroke ");
      }
    }
  fprintf(inf, "\n\n %% END PROJECT WELLS \n\n");
  }

/*******************/

void plot_ps_map(FILE *inf, mpic *mplot)
  {
  int i, j, kk, k, i1, ii, kount, inout, lastcol = 0;
  float x0, y0;
  char *c;

  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  fprintf(inf, "%% BEGIN MAP \n ");
  fprintf(inf, " map_color \n ");
  fprintf(inf, " .2 setlinewidth \n ");
  fprintf(inf, "/polystroke { stroke  } def \n");

  if(mplot->add_poly_lines == 1)
    fprintf(inf, "\n\n /polyfill { gsave fill grestore 0 setgray stroke }"
	    " def \n\n");
  else fprintf(inf, "/polyfill { fill  } def \n");

  if(mplot->map_type == 1) 
    {
    fprintf(inf, "%% Plotting the map with map_type= 1 \n\n\n");
    for(i = 0; i < mplot->xy_map.numpoints; i++) 
      {
      if(((mplot->xy_map.km[i].x1 > mplot->origin.minx)
	  && (mplot->xy_map.km[i].x1 < mplot->origin.maxx)
	  && (mplot->xy_map.km[i].y1 > mplot->origin.miny)
	  && (mplot->xy_map.km[i].y1 < mplot->origin.maxy))
	 || ((mplot->xy_map.km[i].x2 > mplot->origin.minx)
	     && (mplot->xy_map.km[i].x2 < mplot->origin.maxx)
	     && (mplot->xy_map.km[i].y2 > mplot->origin.maxx)
	     && (mplot->xy_map.km[i].y2 < mplot->origin.maxy)))
        fprintf(inf, " %lf bx %lf bz moveto %lf bx %lf bz lineto polystroke \n",
		ps_kmx(mplot->xy_map.km[i].x1, x0),
		ps_kmy(mplot->xy_map.km[i].y1,y0),
		ps_kmx(mplot->xy_map.km[i].x2, x0),
		ps_kmy(mplot->xy_map.km[i].y2,y0));
      }
    }
  if(mplot->map_type > 1) 
    {
    for(kount = 0; kount < mplot->num_map_files; kount++)
      {
      fprintf(inf, " \n\n %%  MAPFILE = %s\n\n", mplot->map[kount].file_name);
      kk = 0;
      for(k = 0; k < mplot->map[kount].stroke_count; k++)
	{
	j = inout = 0;

	/* to reduce the number of strokes in the postscript file we need to
	   eliminate strokes that do not intersect the target */

	for(i = kk; i < kk + mplot->map[kount].stroke[k].num; i++)
	  {
	  if((mplot->map[kount].km[i].x > mplot->origin.minx)
	     && (mplot->map[kount].km[i].x < mplot->origin.maxx)
	     && (mplot->map[kount].km[i].y > mplot->origin.miny)
	     && (mplot->map[kount].km[i].y < mplot->origin.maxy))
	    {
	    inout = 1;
	    break;
	    }
	  }

	/* next check to see if the map code is included */
	c = mplot->map[kount].map_code;

	while(*(c++) != mplot->map[kount].stroke[k].code) 
	  if(*c == '\0') inout = 0;

	if(inout == 1) 
	  {
	  if(mplot->map[kount].stroke[k].style > 1) 
	    {
	    fprintf(inf, " %lf bx %lf bz moveto \n",
		    ps_kmx(mplot->map[kount].km[kk].x,x0),
		    ps_kmy(mplot->map[kount].km[kk].y,y0));

	    for(i = kk + 1; i < kk + mplot->map[kount].stroke[k].num; i++)
	      {
	      fprintf(inf, " %lf bx %lf bz lineto \n",
		      ps_kmx(mplot->map[kount].km[i].x,x0),
		      ps_kmy(mplot->map[kount].km[i].y,y0));
	      j++;
	      }

	    i1 = mplot->map[kount].stroke[k].col;
	    fprintf(inf, "%%  stroke name = %s \n",
		    mplot->map[kount].stroke[k].name);
	    fprintf(inf, "%% change colors here to Color=%d \n", i1);
	    fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
		    mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);

	    switch(mplot->map[kount].stroke[k].style) 
	      {
	      case 2:
	        fprintf(inf, " polystroke \n");
		break;

	      case 3:
		fprintf(inf, " closepath \n");
		if(mplot->map_type>2) fprintf(inf, " polystroke \n");
		else 
		  {
		  if(mplot->BW_flag == 1)
		    {
		    /* loop through formation colors and determine which one
		       to use */

		    /* fprintf(stderr," stroke color= %d\n", i1); */

		    for(ii = 0;ii < mplot->Formation_count; ii++)
		      {
		      /* fprintf(stderr," table entry %d %d\n", ii,
			 mplot->Formation_color[ ii ]); */
		      if(mplot->Formation_color[ii] == i1) break;
		      }
		    ii++;
		    if(ii > MAXPAT) ii = MAXPAT;
		    fprintf(inf, "gsave pat%d 8 1 300 32 div setpattern fill"
			    "  grestore 0 setgray stroke\n", ii);
		    }
		  else fprintf(inf, " polyfill \n");
		  }
		break;
	      } /* end switch   */
	    }

	  if(mplot->map[kount].stroke[k].style == 1) 
	    {
	    fprintf(inf, " %lf bx %lf bz ptsiz 0 360 arc \n",
		    ps_kmx(mplot->map[kount].km[kk].x, x0),
		    ps_kmy(mplot->map[kount].km[kk].y, y0));
	    i1 = mplot->map[kount].stroke[k].col;

	    if(lastcol != mplot->map[kount].stroke[k].col)
	      fprintf(inf, "%f %f %f setcol1  polystroke %% %s\n",
		      mplot->jmlcol[i1].red, mplot->jmlcol[i1].green,
		      mplot->jmlcol[i1].blue,
		      mplot->map[kount].stroke[k].name);
	    else fprintf(inf, "  polystroke %% %s\n",
			 mplot->map[kount].stroke[k].name);

	    lastcol = mplot->map[kount].stroke[k].col;
	    }
	  } /* end inout  */
	kk += mplot->map[kount].stroke[k].num;
	}
      }
    }

  fprintf(inf, "%% END MAP \n ");
  }

/*******************/

void plot_ps_stations(FILE *inf, mpic *mplot)
  { 
  int kount, i;
  float sizsta, x0 = mplot->origin.minx, y0 = mplot->origin.miny;

  fprintf(inf, "\n%% BEGIN STATIONS\n\n");
  fprintf(inf, "\n%%stations flag=%d number files=%d\n\n", mplot->sta_flag,
	  mplot->num_sta_files);
  fprintf(inf, " .2 setlinewidth \n ");
  fprintf(inf, " /Helvetica-Bold findfont 12 scalefont setfont\n");

  for(kount = 0; kount < mplot->num_sta_files; kount++) 
    {
    fprintf(inf, "\n\n\n%% Plotting the Stations : %s\n\n\n",
	    mplot->stations[kount].file_name);


    fprintf(inf, "%f %f %f setcol1 \n",
	    mplot->jmlcol[mplot->stations[kount].color].red,
	    mplot->jmlcol[mplot->stations[kount].color].green,
	    mplot->jmlcol[mplot->stations[kount].color].blue);

    fprintf(inf, "/stacol { %f %f %f setcol1 } def \n",
	    mplot->jmlcol[mplot->stations[kount].color].red,
	    mplot->jmlcol[mplot->stations[kount].color].green,
	    mplot->jmlcol[mplot->stations[kount].color].blue);



    fprintf(inf,"/adjustUR {  .86 tsiz .5 tsiz rmoveto show } def \n");
    fprintf(inf," /adjustUL {  -.86 tsiz  0.5 tsiz rmoveto rightshow } def \n");
    fprintf(inf," /adjustLL {  -.8 tsiz -1.5 tsiz rmoveto rightshow } def \n");
    fprintf(inf,"/adjustLR {  .8 tsiz -1.5 tsiz rmoveto show } def \n");

    switch(mplot->stations[kount].symbol)
      {
      case 0:
         fprintf(inf,"/plot_sta { /y exch def /x exch def \n"); 
         fprintf(inf,"    /tsiz { sta_siz  mul } def  \n");
         fprintf(inf," stacol  \n");
	 fprintf(inf," x y jugsta fill \n");
	 fprintf(inf,"     0 0 0 setcol1 \n");
	 fprintf(inf,"   /tsiz { sta_siz 0.75  mul mul } def \n"); 
	 fprintf(inf,"   x y jugsta fill \n");
	 fprintf(inf,"    /tsiz { sta_siz  mul } def  \n");
	 fprintf(inf," } def  \n");

	break;

      case 1:
	fprintf(inf," /plot_sta { 1 tsiz xtriangle } def \n");
	break;

      case 2:
	fprintf(inf, " /plot_sta { 1  tsiz xsquare } def \n");
	break;

      case 3:
	fprintf(inf," /plot_sta { 1  tsiz star_of_david } def \n");
	break;

      case 4:
	fprintf(inf," /plot_sta { 1 tsiz xmark } def \n");
	break;

      case 5:
	fprintf(inf," /plot_sta { 1 tsiz xplus } def \n");
	break;

      case 6:
	fprintf(inf," /plot_sta {  1 tsiz xdiamond } def \n");
	break;

      default:

	fprintf(inf," /plot_sta { jugsta fill } def \n");
	break;
      }

    sizsta = 1.5 * mplot->size_sta;
    fprintf(inf,"/sta_siz %f  def %%   station size  \n", sizsta );
    fprintf(inf, "newpath  \n/tsiz { %f mul } def %%   station size \n",
	    sizsta);
    for(i = 0; i < mplot->stations[kount].numpoints; i++) 
      {
	if((mplot->stations[kount].sta[i].loc.x > mplot->origin.minx)
	   && (mplot->stations[kount].sta[i].loc.x < mplot->origin.maxx)
	   && (mplot->stations[kount].sta[i].loc.y > mplot->origin.miny)
	   && (mplot->stations[kount].sta[i].loc.y < mplot->origin.maxy))
	  {
	    fprintf(inf, " %lf bx %lf bz plot_sta newpath %% %s\n",
		    ps_kmx(mplot->stations[kount].sta[i].loc.x, x0), 
		    ps_kmy(mplot->stations[kount].sta[i].loc.y, y0), 
		    mplot->stations[kount].sta[i].name);

    
	    if(mplot->sta_name_flag) 
	      {

		fprintf(inf, "  %lf bx %lf bz moveto (%s) adjustUR \n ",
			ps_kmx(mplot->stations[kount].sta[i].loc.x, x0), 
			ps_kmy(mplot->stations[kount].sta[i].loc.y, y0),
			mplot->stations[kount].sta[i].name);

	      }
	  }
      }
    

    fprintf(inf, "\n\n\n 0 setgray ");
    fprintf(inf, "\n%% END STATIONS\n\n");
    }
  }



int plot_ps_sources(FILE *inf, mpic *mplot)
  {
  int j, i, i1, knum = 0;
 float bot=10000.0, top=-10000.0;
 
  static char *eqsyms[] =
    {"xcirc", "xplus", "xdiamond", "xsquare", "xmark", "xtriangle", "xrotsq",
      "star_of_david" };
  float sizmag, x0 = mplot->origin.minx, y0 = mplot->origin.miny;


   if( mplot->src_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }
   

  fprintf(inf, "%% BEGIN SOURCES \n ");
  fprintf(inf, " .2 setlinewidth \n ");
  if(mplot->BW_flag == 1) 
    {
    sizmag = 0.4 * (mplot->SourceSize / 3);
    fprintf(inf, "/eqsiz { %f mul } def  %%   earthquake size   \n", sizmag);
    }
  else  
    {
    sizmag = 0.4 * (mplot->SourceSize / 3);
    fprintf(inf, "/eqsiz { %f mul } def  %%   earthquake size   \n", sizmag);
    }

  fprintf(inf, "/eqpl { eqsiz 0 360 arc stroke } def\n");
  fprintf(inf, " %%  SYMBOLS that all use the same format:  x y size"
	  " <symbol>\n");
  fprintf(inf, "%%  xmark xsquare xtri xtriangle xrotsq xdiamond\n\n");
  fprintf(inf, "%%  Use these to change the symbols for different event"
	  " files\n");
  fprintf(inf, "%%  to change the earthquake plotting to a fancier plot,"
	  " uncomment the following macro\n");
  fprintf(inf, "%%  (to uncomment a line, remove the %% from the beginning)"
	  " \n\n");

  if(mplot->fancy_src_flag == 1)
    fprintf(inf, "  /eqpl { eqsiz 0 360 arc gsave fill grestore gsave 0"
	    " setgray stroke grestore newpath } def  \n");
  else
    fprintf(inf, "%%  /eqpl { eqsiz 0 360 arc gsave fill grestore gsave 0"
	    " setgray stroke grestore newpath } def  \n");

  fprintf(inf, "%%  \n");


  j = 0;
  if(mplot->BW_flag == 1)
    fprintf(inf, "/eqpl { eqsiz %s } def\n", eqsyms[j]);




  fprintf(inf, " \n\n\n %%  source file: %d %s \n", j,
	  mplot->sources[j].file_name);
  i1 = mplot->src_color - j;
  fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	  mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);

  for(i = 0; i < mplot->sources[j].numpoints; i++) 
     {
     if(mplot->sources[j].onoff[i] == 1)
	{
       
	if( mplot->src_in_layer == 0 || 
	   (mplot->src_in_layer == 1 && 
	    mplot->sources[j].loc[i].z < bot  && 
	    mplot->sources[j].loc[i].z >= top) )  
	   {
	 
	   sizmag =mplot->sources[j].size[i];
	   if(sizmag <= 1.0) sizmag = 1;
	   if(mplot->mag_src_flag == 0) sizmag = 1;

	   if((mplot->sources[j].loc[i].x > mplot->origin.minx)
	      && (mplot->sources[j].loc[i].x < mplot->origin.maxx)
	      && (mplot->sources[j].loc[i].y > mplot->origin.miny)
	      && (mplot->sources[j].loc[i].y < mplot->origin.maxy))
	      {
	      if(mplot->src_depth_color) 
		 {
		 i1 = mplot->sources[j].point_color[i];
		 fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
			 mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);
		 }
	      
	      fprintf(inf, " %lf bx %lf bz %f eqpl \n",
		      ps_kmx(mplot->sources[j].loc[i].x, x0),
		      ps_kmy(mplot->sources[j].loc[i].y, y0), sizmag);
	      }
	   
	   knum++;
	   
	   
	   }
	}
     }
  
  fprintf(inf, "\n\n\n 0 setgray newpath\n");

  /* PLOT MORE  SOURCES */

  if(mplot->more_src_flag) 
    {
    fprintf(inf, "\n\n 0 setgray newpath\n");
    for(j = 1; j < mplot->max_more_src; j++) 
      {
      if(mplot->BW_flag == 1) 
	{
	if(j <= 7)
	  fprintf(inf, "/eqpl { eqsiz %s } def\n", eqsyms[j]);
	else
	  fprintf(inf, "/eqpl { eqsiz %s } def\n", eqsyms[7]);
	}
      fprintf(inf, " \n\n\n %%  source file: %d %s \n", j,
	      mplot->sources[j].file_name);

      i1 = mplot->src_color - j;
      fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);

      for(i = 0; i < mplot->sources[j].numpoints; i++) 
	 {
	 if(mplot->sources[j].onoff[i] == 1) 
	    {
	    if( mplot->src_in_layer == 0 || 
	       (mplot->src_in_layer == 1 && 
		mplot->sources[j].loc[i].z < bot  && 
		mplot->sources[j].loc[i].z >= top) )  
	       {
	
	       if(mplot->src_depth_color) 
		  {
		  i1 = mplot->sources[j].point_color[i];
		  fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
			  mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);
		  }
	       sizmag = mplot->sources[j].size[i];
	       if(sizmag <= 1.0) sizmag = 1;
	       if(mplot->mag_src_flag == 0) sizmag = 1;

	       if((mplot->sources[j].loc[i].x > mplot->origin.minx)
		  && (mplot->sources[j].loc[i].x < mplot->origin.maxx)
		  && (mplot->sources[j].loc[i].y > mplot->origin.miny)
		  && (mplot->sources[j].loc[i].y < mplot->origin.maxy))
	       fprintf(inf, " %lf bx %lf bz %f eqpl \n",
		       ps_kmx(mplot->sources[j].loc[i].x, x0),
		       ps_kmy(mplot->sources[j].loc[i].y, y0), sizmag);
	       knum++;
	       }
	    }
	 }
      
      }
    fprintf(inf, "\n\n\n 0 setgray newpath \n ");
    }
  return(knum);
  }

/*******************/

void plot_ps_table_sources(FILE *inf, mpic *mplot)
  {
  int j, i1;
  float maxy, plx1, ply1;
  static char *eqsyms[] =
    { "xcirc","xplus", "xdiamond", "xsquare", "xmark",
      "xtriangle", "xrotsq", "star_of_david" };


  fprintf(inf, " \n%% BEGIN Legend of source symbols \n\n");
  
  fprintf(inf, "gsave\n");
  
  maxy = mplot->origin.maxy - mplot->origin.miny;
      plx1 = 0.0;
      ply1 = maxy;
  fprintf(inf, "%f bx %f bz translate\n", plx1, ply1);
  if(mplot->BW_flag == 1) 
    {
    /* plot out a table of the source files */

    for(j = 0; j < mplot->max_more_src; j++) 
      {
      i1 = mplot->src_color - j;
      fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);

      plx1 = 0.0;
      ply1 = maxy;
      fprintf(inf, " newpath \n");
      fprintf(inf, " 0 0  .25 inch %d mul add .1 inch %s newpath \n",
	       j + 1, eqsyms[j]);
      fprintf(inf, "         external_color\n");
      fprintf(inf, " .25 inch 0 .25 inch %d mul add .05 inch sub moveto"
	      " (%s) show \n",  j + 1, mplot->sources[j].file_name);
      }
    }
  else 
    {

    /* plot out a table of the source files */

    for(j = 0; j < mplot->max_more_src; j++) 
      {
      i1 = mplot->src_color - j;
      fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);
      plx1 = 0.0;
      ply1 = maxy;
      fprintf(inf, " newpath \n");
      fprintf(inf, " 0 0 .25 inch %d mul add .1 inch 0 360 arc fill"
	      " newpath \n",  j + 1);
      fprintf(inf, "         external_color\n");
      fprintf(inf, " .25 inch 0 .25 inch %d mul add .05 inch sub moveto"
	      " (%s) show \n",  j + 1, mplot->sources[j].file_name);
      }
    }

       fprintf(inf, "   %% this adds a border around the legend\n");
        fprintf(inf, " currentpoint ");
      fprintf(inf, " .25 inch add exch .25 inch add exch ");
      fprintf(inf, " -.25 inch  0  bord stroke\n");

 fprintf(inf, "grestore\n");
 
  fprintf(inf, " \n%% END Legend of source symbols \n\n");

  BB_UR_y += (mplot->max_more_src+1)*( .25*72) ;
  

  }

/*************************************************/

void plot_ps_map_focals(FILE *inf, mpic *mplot)
  {
  int i, kount;
 float bot=10000, top=-10000;
    /* itype[7] = { 18, 23, 22, 21, 19, 20, 2 }; */
  float focrad, phi, lam, px, py, dis, plx1, ply1, fx, fy, p1, p2,
    x0 = mplot->origin.minx, y0 = mplot->origin.miny;
  /* char *ctype[7] = 
     { "strikeslip", "rev-oblSS", "obl-rev", "reverse", "norm-oblSS",
     "obl-norm", "normal" }; */

 if( mplot->foc_in_layer == 1 && mplot->image.nz > 1)
       {
       top  = mplot->image.z_parts[mplot->image_layer - 1]; 
       bot  = mplot->image.z_parts[mplot->image_layer];
       }

  fprintf(inf, "\n\n %% BEGIN FOCALS \n\n");
  fprintf(inf, " newpath \n ");
  fprintf(inf, " .2 setlinewidth \n ");

  focrad = mplot->size_focm / 2;

  fprintf(inf, " /scalefocsiz { 1 } def \n");
  fprintf(inf, " /focsiz { 20 mul scalefocsiz mul } def \n");
  fprintf(inf, " /focfilcol { 1 .5 .7 setcol1 } def \n");
  fprintf(inf, " /slip_vec_size { 1.7 } def\n");
  fprintf(inf, " /foclincol { focfilcol } def \n");
  fprintf(inf, " %%     If you want the outlines of the focal mechanism"
	  " to stand out\n");
  fprintf(inf, " %%      may need to switch this to: /foclincol { 0 .4 1"
	  " setcol1 } def\n");

  for(kount = 0; kount < mplot->num_focm_files; kount++)
    {
    for(i = 0; i < mplot->focm[kount].numpoints; i++) 
      {
      if(!mplot->focm[kount].focs[i].on_off)continue;

      if( !(mplot->foc_in_layer == 0 || 
	    (mplot->foc_in_layer == 1 && mplot->focm[kount].focs[i].loc.z < bot  
	     && mplot->focm[kount].focs[i].loc.z >= top)) ) continue; 

      phi = mplot->focm[kount].focs[i].loc.x;
      lam = mplot->focm[kount].focs[i].loc.y;
      geo2xy(mplot, phi, lam, &px, &py);

      /* get rid of focal mechanisms that are not within the target region */

      if((px < mplot->origin.minx) || (px > mplot->origin.maxx)
	  || (py < mplot->origin.miny) || (py > mplot->origin.maxy)) 
	continue;

      /* determine the correct size of the focal sphere */

      focrad = mplot->size_focm / 2;
      if(mplot->focm[kount].scale_by_mag == 1) 
	{
	if(mplot->focm[kount].minMag < mplot->focm[kount].maxMag)
	  focrad += (focrad * (mplot->focm[kount].focs[i].ac.mag
			       - mplot->focm[kount].minMag)
		     / (mplot->focm[kount].maxMag
			- mplot->focm[kount].minMag));
	else focrad = mplot->size_focm / 2;
	}

      fprintf(inf, " /focsiz {  %f mul scalefocsiz mul } def \n", focrad);
      fprintf(inf, " gsave \n");
      fprintf(inf, "/focfilcol { %f %f %f setcol1  } def\n",
	      mplot->jmlcol[mplot->focm[kount].focs[i].type].red,
	      mplot->jmlcol[mplot->focm[kount].focs[i].type].green,
	      mplot->jmlcol[mplot->focm[kount].focs[i].type].blue);

      /* may need to explode the focals  */

      if(mplot->focal_explode >= 1) 
	{
	fprintf(inf, "focfilcol\n");
	fprintf(inf, " %lf bx %lf bz moveto %f bx %lf bz lineto stroke\n",
		ps_kmx(px, x0), ps_kmy(py, y0),
		ps_kmx(mplot->focm[kount].focs[i].explode_x, x0),
		ps_kmy(mplot->focm[kount].focs[i].explode_y, y0));
	fprintf(inf, " %lf bx %lf bz translate\n",
		ps_kmx(mplot->focm[kount].focs[i].explode_x, x0),
		ps_kmy(mplot->focm[kount].focs[i].explode_y, y0));

	}
      else 
	{
	fprintf(inf, " %lf bx %lf bz translate\n", ps_kmx(px, x0),
		ps_kmy(py, y0));
	}

      switch(mplot->focal_plot_style) 
	{
	case 5:
	  /* plot only the fault plane  */
	fprintf(inf, " %f %f %f setcol1 \n",
		mplot->jmlcol[mplot->focm[kount].focs[i].type].red,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].green,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].blue);
	fprintf(inf, " %f %f justplane \n",
		mplot->focm[kount].focs[i].fm.strk1,
		mplot->focm[kount].focs[i].fm.dip1);
	Slip_Point(mplot->focm[kount].focs[i].fm.strk1,
		   mplot->focm[kount].focs[i].fm.dip1,
		   mplot->focm[kount].focs[i].fm.strk2,
		   mplot->focm[kount].focs[i].fm.dip2,
		   mplot->focm[kount].focs[i].fm.trot,
		   mplot->focm[kount].focs[i].fm.tdip,
		   &p1, &p2, &fx, &fy);
	dis = 1.7 / 30.0;
	plx1 = p1 + dis * fx;
	ply1 = p2 + dis * fy;
	fprintf(inf, "newpath %f %f %f %f slip_point \n", p1, p2, fx, fy);
	/* fprintf(inf, "newpath %f focsiz %f  focsiz slip_vec_size 0 360 arc"
	   " fill \n", plx1, ply1); */
	fprintf(inf, "                 %% auxilliary plane= %f %f\n",
		mplot->focm[kount].focs[i].fm.strk2,
		mplot->focm[kount].focs[i].fm.dip2);

	/* this puts a circle on the plane where the slip vector lies
	   I am leaving this out for now */

	/* fprintf(inf,"0 0 0 setrgbcolor  %f focsiz %f focsiz 5 xcirc\n",
	   plx1, ply1); */
	break;

      case 3:
	/* only plot  P and T axis    */
	fprintf(inf, "    setcolP     %%  P-axis\n");
	fprintf(inf, " %f %f plPTax \n", mplot->focm[kount].focs[i].fm.prot,
		mplot->focm[kount].focs[i].fm.pdip);

	/* T-Axis    this is in the dark region so paint it white */

	fprintf(inf, " setcolT     %%  T-axis \n");
	fprintf(inf, " %f %f plPTax \n", mplot->focm[kount].focs[i].fm.trot,
		mplot->focm[kount].focs[i].fm.tdip);
	break;

      case 7:
	/* only plot  P and T axis    */
	fprintf(inf, " %f %f %f setcol1 \n",
		mplot->jmlcol[mplot->focm[kount].focs[i].type].red,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].green,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].blue);
	fprintf(inf, " %f %f plPTax \n", mplot->focm[kount].focs[i].fm.prot,
		mplot->focm[kount].focs[i].fm.pdip);
	break;

      case 8:
	/* only plot  P and T axis    */
	fprintf(inf, " %f %f %f setcol1 \n",
		mplot->jmlcol[mplot->focm[kount].focs[i].type].red,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].green,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].blue);

	/* T-Axis    this is in the dark region so paint it white */

	fprintf(inf, " %f %f plPTax \n", mplot->focm[kount].focs[i].fm.trot,
		mplot->focm[kount].focs[i].fm.tdip);
	break;

      case 6:
	/* Ralph Archuleta method    */

	fprintf(inf, " %f %f %f setcol1 \n",
		mplot->jmlcol[mplot->focm[kount].focs[i].type].red,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].green,
		mplot->jmlcol[mplot->focm[kount].focs[i].type].blue);
	fprintf(inf, " %f %f ralphplane \n",
		mplot->focm[kount].focs[i].fm.strk1,
		mplot->focm[kount].focs[i].fm.dip1);
	break;

      default:
	fprintf(inf, " %f %f %f %f %d focu \n",
		mplot->focm[kount].focs[i].fm.strk1,
		mplot->focm[kount].focs[i].fm.dip1,
		mplot->focm[kount].focs[i].fm.strk2,
		mplot->focm[kount].focs[i].fm.dip2,
		mplot->focm[kount].focs[i].ipol);

	/* add plot  P and T axis    */

	if(mplot->focal_plot_style == 2) 
	  {
	  /* P-Axis   */

	  fprintf(inf, "  setcolP     %%  P-axis\n");
	  fprintf(inf, " %f %f plPax \n", mplot->focm[kount].focs[i].fm.prot,
		  mplot->focm[kount].focs[i].fm.pdip);

	  /* T-Axis    this is in the dark region so paint it white */

	  fprintf(inf, "   setcolT     %%  T-axis \n");
	  fprintf(inf, " %f %f plTax \n", mplot->focm[kount].focs[i].fm.trot,
		  mplot->focm[kount].focs[i].fm.tdip);

	  }

	/* end PT axis  */

	if(mplot->focal_plot_style == 4) 
	  {
	  /* add  plot a black fault plane */

	  fprintf(inf, " 0 0 0 setcol1 \n");
	  fprintf(inf, " %f %f justplane \n",
		  mplot->focm[kount].focs[i].fm.strk1,
		  mplot->focm[kount].focs[i].fm.dip1);

	  }
	break;
	}

      fprintf(inf, " grestore \n");
      } /* end for  */
    }
  
  fprintf(inf, "\n\n %% END FOCALS \n\n");
  }
/***************************************************/

void plot_ps_geotab(FILE *inf, mpic *mplot)
  {
  int i, ii, i1;
  float maxx, maxy /*, x0 = mplot->origin.minx, y0 = mplot->origin.miny*/ ;

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;

  fprintf(inf, "/Geo_Legend { /bsiz { 24 mul } def   \n");
  for(i = 0; i < mplot->Formation_count; i++)
    {
    i1 = mplot->Formation_color[i];
    if(mplot->BW_flag == 1)
      {
      ii = i + 1;
      if(ii > MAXPAT) ii = MAXPAT;
      fprintf(inf, "0 %f bsiz box  pat%d 8 1 300 32 div    \n",
	      -(i + 1) * 1.3, ii);
      fprintf(inf, "gsave setpattern fill grestore 0 setgray stroke \n");
      }
    else 
      fprintf(inf, "0 %f bsiz box gsave %f %f %f setcol1  fill grestore 0"
	      " setgray stroke \n", -(i + 1) * 1.3, mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);

    fprintf(inf, " 1 bsiz %f bsiz  moveto .1 inch .5 bsiz rmoveto (%s) show"
	    " \n", -(i + 1) * 1.3, mplot->Formation_name[i]);
    }

  fprintf(inf, "} def   \n");
  fprintf(inf, "gsave  \n %f bx %f bz translate .1 inch 0 translate\n",
	  maxx, maxy);
  fprintf(inf, "Geo_Legend %%   GEO_LEGEND \n grestore   \n");
  BB_UR_x+=25;
  }

/***************************************************/

void plot_ps_Cont_points(FILE *inf, mpic *mplot)
  {
  int j;
  float size = 3,  pz, x0 = mplot->origin.minx, y0 = mplot->origin.miny;
  double px, py;
  fprintf(inf, "\n\n %% BEGIN CONTOUR POINTS \n\n");
  fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[1].red,
	  mplot->jmlcol[1].green, mplot->jmlcol[1].blue);
  size = 0.75* 3;
  fprintf(inf, "/tsiz { %f mul } def \n", size);

  for(j = 0; j < mplot->contParms.length_data; j++) 
    {
    px = mplot->contParms.datapt[j].x;
    py = mplot->contParms.datapt[j].y;
    pz = mplot->contParms.datapt[j].z;
    px = ps_kmx(px, x0);
    py = ps_kmy(py, y0);
    fprintf(inf, "%f bx %f bz ", px, py);
    fprintf(inf, "  1  tsiz xsquare  \n");
    }
  fprintf(inf, "\n\n %% END CONTOUR POINTS \n\n");
  }

void plot_ps_Cont_values(FILE *inf, mpic *mplot)
  {
  int j;
  char pchar[8];
  float size = 3, pz, x0 = mplot->origin.minx, y0 = mplot->origin.miny;
  double px, py;
  fprintf(inf, "\n\n %% BEGIN CONTOUR VALUES \n\n");
  fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[1].red,
	  mplot->jmlcol[1].green, mplot->jmlcol[1].blue);
  size = 0.75 * 3;
  fprintf(inf, "/tsiz { %f mul } def \n", size);

  for(j = 0; j < mplot->contParms.length_data; j++) 
    {
    px = mplot->contParms.datapt[j].x;
    py = mplot->contParms.datapt[j].y;
    pz = mplot->contParms.datapt[j].z;
    sprintf(pchar, "%g", pz);
    px = ps_kmx(px, x0);
    py = ps_kmy(py, y0);
    fprintf(inf, "%f bx %f bz ", px, py);
    fprintf(inf, "  1  tsiz xsquare  \n");
    fprintf(inf, "    %f bx %f bz 1  tsiz add moveto  (%s) censhow \n",
	    px, py, pchar);
    }
  fprintf(inf, "\n\n %% END CONTOUR VALUES \n\n");
  }

void plot_ps_contours(FILE *inf, mpic *mplot)
  {
  struct RETURN_VEC *C_r;
  double valdiff;
  float px, py, p1, p2, maxx, maxy, x0 = mplot->origin.minx,
    y0 = mplot->origin.miny;
  int kk, k, j, i2, i1, m, Col_Diff;

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;

  fprintf(inf, "\n\n %% BEGIN CONTOURS \n\n");
  fprintf(inf, "\n\n %% define how to plot the labels \n\n");
  fprintf(inf, "/cont_lab { /lab exch def /yt1 exch def\n");
  fprintf(inf, "           /xt1 exch def /y1 exch def  /x1 exch def\n");
  fprintf(inf, " gsave x1 bx y1 bz moveto xt1 yt1 atan \n");
  fprintf(inf, "     dup 90 gt { 180 sub } if \n");
  fprintf(inf, "     dup 90 gt { 180 sub } if \n");
  fprintf(inf, " rotate lab censhow grestore } def   \n");
  fprintf(inf, " \n%% to remove labels uncomment following line:   \n");
  fprintf(inf, " \n%%/cont_lab { pop pop pop pop pop } def   \n");

  Col_Diff = (mplot->contParms.MaxCol - mplot->contParms.MinCol);
  valdiff = (mplot->contParms.minmax.zmax - mplot->contParms.minmax.zmin);

  fprintf(inf, " newpath \n");
  fprintf(inf, " gsave\n");
  PS_Border(inf, mplot, mplot->project_type);
  fprintf(inf, " clip newpath %% BEGIN CLIP2\n\n\n");
  fprintf(inf, "/Helvetica-Bold findfont 8 scalefont setfont 0 setgray\n ");
  fprintf(inf, " .2 setlinewidth \n ");
  C_r = mplot->contParms.cont_struct;
  kk = 0;

  for(k = 0; C_r->number_sections[k] != 0; k++) 
    {
    for(j = 0; j < C_r->number_sections[k]; j++) 
      {
      i2 = C_r->vec[kk].length;

      /* i1 = ((mplot->MaxColor - mplot->MinColor) *
	 (C_r->cont_level[k] - mplot->contParms.minmax.zmin) /
	 (mplot->contParms.minmax.zmax - mplot->contParms.minmax.zmin)) +
	 mplot->MinColor;*/

      i1 = (Col_Diff * (C_r->cont_level[k] - mplot->contParms.minmax.zmin)
	    / valdiff) + mplot->contParms.MinCol;

      fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	      mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);
      fprintf(inf, " %lf bx %lf bz moveto \n", ps_kmx(C_r->vec[kk].x_vec[1], x0),
	      ps_kmy(C_r->vec[kk].y_vec[1], y0));

      for(m = 0; m < i2; m++) 
	fprintf(inf, " %lf bx %lf bz lineto \n",
		ps_kmx(C_r->vec[kk].x_vec[m], x0),
		ps_kmy(C_r->vec[kk].y_vec[m], y0));

      fprintf(inf, " stroke  \n");

      /* need to write in the contour label */
      /* need to rotate the label so it goes in direction of the line: use
	 postscript atan2 for this */
      /* C_r->cont_level[k] */

      if(i2 > 10) 
	{
	m = i2 / 2;

	px = (C_r->vec[kk].x_vec[m] + C_r->vec[kk].x_vec[m - 1]) / 2.0;
	py = (C_r->vec[kk].y_vec[m] + C_r->vec[kk].y_vec[m - 1]) / 2.0;
	p1 = C_r->vec[kk].x_vec[m] - C_r->vec[kk].x_vec[m - 1];
	p2 = C_r->vec[kk].y_vec[m] - C_r->vec[kk].y_vec[m - 1];

	if(p1 > 0 && p2 < 0) p1 *= -1, p2 *= -1;
	if(p1 < 0 && p2 < 0) p1 *= -1, p2 *= -1;

	fprintf(inf, "%lf  %lf   %f %f (%g) cont_lab \n", ps_kmx(px, x0),
		ps_kmy(py,y0), p2, p1, C_r->cont_level[k]);

	/* fprintf(inf, "gsave %f bx %f bz moveto \n", ps_kmx(px,x0),
	   ps_kmy(py,y0));
	   fprintf(inf, " %f %f atan rotate\n", p2, p1);
	   fprintf(inf, "(%g) censhow grestore\n", C_r->cont_level[k]);
	   fprintf(inf, "(%g) 0 pathtext\n",C_r->cont_level[k]); */
	}
      kk++;
      }
    }

  fprintf(inf, "grestore           %% END CLIP2\n\n");
  fprintf(inf, "\n\n %% END CONTOURS \n\n");
  }

/**********************************/

void plot_ps_color_depth(FILE *inf, mpic *mplot)
  {
  float p1, ply1, maxy, plx1, plx2;
  int j, i1;

  maxy = mplot->origin.maxy - mplot->origin.miny;

  p1 = 1.5 / 40.0;
  ply1 = maxy;

  /* plot out a table of color depths */

  fprintf(inf, " %% *********  PLOT out the depth Scale colors  *******\n");
  for(j = 0; j < 40; j++) 
    {
    i1 = mplot->MinColor + j;
    fprintf(inf, "%f %f %f setcol1 \n", mplot->jmlcol[i1].red,
	    mplot->jmlcol[i1].green, mplot->jmlcol[i1].blue);
    plx1 = p1 * (float)j;
    plx2 = plx1 + p1;
    fprintf(inf, " %f inch %f bz .25 inch add %f inch %f bz \n",
	    plx1, ply1, plx2, ply1);
    fprintf(inf, "    .25 inch add .2 inch add  bord fill newpath \n");
    }
  /* end of for loop  */

  fprintf(inf, "  0 setgray  \n");
  plx1 = p1 * 39.0;
  fprintf(inf, " %f inch .1 inch add %f bz .25 inch add moveto  (%g km)"
	  " show\n", plx1, ply1, mplot->MaxDepth);
  fprintf(inf, " 0 inch -.1 inch add %f bz .25 inch add  moveto (0)"
	  " rightshow\n", ply1);
  plx1 = p1 * 19.0;
  fprintf(inf, " %f inch %f bz .25 inch add .25 inch add moveto (Event Depth)"
	  " censhow\n", plx1, ply1);
  }

/*************************************************/

void plot_ps_labels(FILE *inf, mpic *mplot)
  {
  int i; 
  float x0 = mplot->origin.minx, y0 = mplot->origin.miny;

  fprintf(inf, "        %%  BEGIN USER Labels    \n");
  fprintf(inf, "/Helvetica-Bold findfont 12 scalefont setfont 0 setgray\n");
  fprintf(inf, " 2 setlinewidth \n");

  for(i = 0; i <= mplot->num_labels; ++i) 
    {
    fprintf(inf, " newpath \n");

    if( !(mplot->labels[i].kmloc.x1 == mplot->labels[i].kmloc.x2 
  && mplot->labels[i].kmloc.y1 == mplot->labels[i].kmloc.y2 )  )
       {
    fprintf(inf, " %lf bx %lf bz %lf bx %lf bz 2 10 16 arrow fill\n",
	    ps_kmx(mplot->labels[i].kmloc.x1,x0),
	    ps_kmy(mplot->labels[i].kmloc.y1,y0),
	    ps_kmx(mplot->labels[i].kmloc.x2,x0),
	    ps_kmy(mplot->labels[i].kmloc.y2,y0));
    }
    


    fprintf(inf, "       (%s)  %lf bx %lf bz moveto cen_labshow \n",
	    mplot->labels[i].label, ps_kmx(mplot->labels[i].kmloc.x1,x0),
	    ps_kmy(mplot->labels[i].kmloc.y1,y0));
    }
  fprintf(inf, " .2 setlinewidth \n");
  fprintf(inf, "        %%  END USER Labels    \n");
  }

/*************************************************/

void plot_ps_latlon(FILE *inf, mpic *mplot)
  {
  int i;
  float maxx, maxy, x0, y0;
  int ideg, imin, isec;
  float left, ka;
  
  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  fprintf(inf, "%% BEGIN LATLON\n");
  fprintf(inf, "/LATS {\n");
    fprintf(inf, "border_line_width \n");

  for(i = 0; i < mplot->markup.numpoints; i++) 
    {
    if(mplot->markup.stuff[i].code1 == 1) 
      {
      /* its a latitude   */
      /* strcpy( pchar, tics->stuff[j].name); */

      if(mplot->markup.stuff[i].min != 0)
        fprintf(inf, " (%d\\312%d\\251) 8.0 %lf bx %lf bz lticr \n",
		abs(mplot->markup.stuff[i].deg), mplot->markup.stuff[i].min, 
		ps_kmx(mplot->markup.stuff[i].m.x, x0),
		ps_kmy(mplot->markup.stuff[i].m.y, y0));
      else
        fprintf(inf, " (%d\\312) 8.0 %lf bx %lf bz lticr \n",
		abs(mplot->markup.stuff[i].deg),
		ps_kmx(mplot->markup.stuff[i].m.x, x0),
		ps_kmy(mplot->markup.stuff[i].m.y, y0));
      }
    if(mplot->markup.stuff[i].code1 == 3)
      {
  /* its a latitude */
      /* strcpy( pchar, tics->stuff[j].name); */

      fprintf(inf, " (%f\\312) 8.0 %lf bx %lf bz lticr \n",
	      (double)fabs(mplot->markup.stuff[i].ddeg),
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));



      fprintf(inf, " (%f\\312) 8.0 %lf bx %lf bz lticr \n",
	      (double)fabs(mplot->markup.stuff[i].ddeg),
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));

      ka =   refLL( mplot->markup.stuff[i].ddeg  , &ideg, &imin, &isec, &left);
      ka = isec+left;
       fprintf(inf, "%% (%d\\312%d\\251%3f\\042) 8.0 %lf bx %lf bz lticr \n",
	      ideg, imin, ka,
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));


      }
    if(mplot->markup.stuff[i].code1 == 5)
      {
  /* its a latitude */
      /* strcpy( pchar, tics->stuff[j].name); */
      
  ka =   refLL( mplot->markup.stuff[i].ddeg  , &ideg, &imin, &isec, &left);
      

      fprintf(inf, " (%d:%02d:%02d) 8.0 %lf bx %lf bz ltic \n",
	      abs(ideg), imin, isec,
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));
      }



    }
  fprintf(inf, "} def\n");
  fprintf(inf, "/LONS {\n");
  fprintf(inf, "border_line_width \n");
  for(i = 0; i < mplot->markup.numpoints; i++) 
    {
    if(mplot->markup.stuff[i].code1 == 2) 
      {
      /* its a longitude      */

      if(mplot->markup.stuff[i].min != 0)
        fprintf(inf, " (%d\\312%d\\251) 8.0  %lf bx %lf bz btic \n",
		abs(mplot->markup.stuff[i].deg), mplot->markup.stuff[i].min,
		ps_kmx(mplot->markup.stuff[i].m.x, x0),
		ps_kmy(mplot->markup.stuff[i].m.y, y0));
      else
        fprintf(inf, " (%d\\312) 8.0  %lf bx %lf bz btic \n",
		abs(mplot->markup.stuff[i].deg),
		ps_kmx(mplot->markup.stuff[i].m.x, x0),
		ps_kmy(mplot->markup.stuff[i].m.y, y0));
      }
    if(mplot->markup.stuff[i].code1 == 4) 
      {
        /* its a longitude      */

      /* strcpy( pchar, tics->stuff[j].name); */

      fprintf(inf, " (%f\\312) 8.0  %lf bx %lf bz btic \n",
	      (double)fabs(mplot->markup.stuff[i].ddeg),
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));


 ka =   refLL( mplot->markup.stuff[i].ddeg  , &ideg, &imin, &isec, &left);
      ka = isec+left;

       fprintf(inf, "%% (%d\\312%02d\\251%3f\\042)  8.0  %lf bx %lf bz btic  \n",
	      ideg, imin, ka,
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));




      }
    
    if(mplot->markup.stuff[i].code1 == 6)
      {
      /* its a longitude      */

      /* strcpy( pchar, tics->stuff[j].name); */
      
  ka =   refLL( mplot->markup.stuff[i].ddeg  , &ideg, &imin, &isec, &left);
      

      fprintf(inf, " (%d:%02d:%02d) 8.0 %lf bx %lf bz bticr \n",
	      abs(ideg), imin, isec,
	      ps_kmx(mplot->markup.stuff[i].m.x, x0),
	      ps_kmy(mplot->markup.stuff[i].m.y, y0));
      }




    }
  fprintf(inf, "} def\n");
  fprintf(inf, "LATS LONS\n");
  fprintf(inf, "%% END LATLON\n");
  }

/*************************************************/

void Do_Postscript(Display *gdisp, char ps_file[50], mpic *mplot)
  {
  int i, inout, ix, iy, ntype = 7, num_events, itype[7] = 
    { 18, 23, 22, 21, 19, 20, 2 };
  float plx1,  p1, p2, r, maxx, maxy, x0, y0, fx, xkmmax, ykmmax,
    SMALLr[14] = 
      { .02, .05, .1, .2, .4, .5, .6, .8, 1.0, 2.0, 4.0, 6.0, 8.0, 10.0 };
  char jtim[25], *psdir, psfile[200], *ctype[7] = 
    { "strikeslip", "rev-oblSS", "obl-rev", "reverse", "norm-oblSS",
      "obl-norm", "normal" };
  FILE *inf;
 char *pwd = getenv("PWD");
  float phi, lam, phi1, lam1, phi2, lam2;
  
  /* colors =  mplot->colors;
     gcol = DefaultColormap(gdisp, DefaultScreen(gdisp));
     printf(" Number of colors = %d\n", mplot->num_colors);
     printf(" Creating Postscript in file: %s \n", ps_file); */

  printf("Postscripting.....%s\n", ps_file);

  if((inf = fopen(ps_file, "w")) == NULL) 
    {
    printf("Can't open postscript file...continuing\n");
    return;
    }

  /* here we check if the colors have been changed and if so we modify them */

  /* change_ps_colors( mplot); */

  maxx = mplot->origin.maxx - mplot->origin.minx;
  maxy = mplot->origin.maxy - mplot->origin.miny;
  x0 = mplot->origin.minx;
  y0 = mplot->origin.miny;

  /* for ( i = 0; i< mplot->num_colors; i++)
     {
     printf("RGB: %f %f %f\n",
     mplot->jmlcol[i].red, mplot->jmlcol[i].green, mplot->jmlcol[i].blue);
     }
     xc.pixel = colors[i]; XQueryColor(gdisp, gcol, &xc); */

  /* plot a grey border around each layer */

  fprintf(inf, "%%!PS-Adobe-3.0 EPSF-3.0\n");


  fprintf(inf, "%%%%BoundingBox: (atend)\n");
  fprintf(inf, "%%   to modify the bounding box, go to the Trailer section\n");




#if 0
  fprintf(inf, "%%JMLRUNFILE: The Following Code is an Included RUN File \n");
  if((psdir = getenv("PSHEAD")) == NULL) 
    fprintf(inf, "(../Postscript/head.big) run \n");
  else fprintf(inf, "(%s/head.big) run \n", psdir);
#endif

  if((psdir = getenv("PSHEAD")) == NULL)
    {
    fprintf(stderr, "%%%%  Can't find header file. \n");
    fprintf(stderr, "%%%%  Please set env varible: PSHEAD \n");
    fprintf(inf, "%%%%  Please set env varible: PSHEAD \n");
    fprintf(inf, "%%%%  ( need to include the header file here )\n");
    }
  else 
    {
    /* strcpy(psfile, psdir); strcat(psfile,"/head.big"); */

    sprintf(psfile, "%s/head.big", psdir);
    Print_Header(inf,  psfile);
    }

  get_tim_str(jtim);
  fprintf(inf, "%%  Postscript file Created: %s ", jtim);
  fprintf(inf, " %%--------------------------------------------- \n");
  fprintf(inf,"  %%  Using the %s projection : value=%d\n", 
          projtypes[mplot->project_type], mplot->project_type);
  fprintf(inf, " %%--------------------------------------------- \n");
  fprintf(inf, "%% BEGIN ORIGIN \n");
  fprintf(inf, " 1 inch 2 inch translate \n");
  BB_ORG_x= 1*72;
  BB_ORG_y= 2*72;


  /* Scaling :  assume paper is 8.5 by 11'' */

  xkmmax = mplot->origin.maxx - mplot->origin.minx;
  ykmmax = mplot->origin.maxy - mplot->origin.miny;

plx1 = usr2points(xkmmax, ykmmax,  8.5 , 11.0,
		  2.0 , 3.5);
  



  fprintf(inf, " /bx { %f mul } def  /bz { %f mul } def %%JMLSCALING\n", plx1, plx1);
  p1 = plx1 * maxx / 72;
  p2 = plx1 * maxy / 72;



  BDX = plx1;
  BDY = plx1;

  BB_LL_x= BB_ORG_x;
  BB_LL_y= BB_ORG_y;

  BB_UR_x = BB_ORG_x+maxx*BDX;
  BB_UR_y = BB_ORG_y+maxy*BDY; 
  
  fprintf(inf, "%% IMAGE BOX BOUNDS %f %f INCHES %f %f KM %f DOTS\n\n",
	  p1,p2, maxx, maxy, plx1);

  fprintf(inf, "          %%  %f %f  %%JML_KMBOUNDS\n", xkmmax, ykmmax);

  fprintf(inf, "%% END ORIGIN \n");
  fprintf(inf, "/plwell { newpath \n gsave translate 0 0 wsiz 0 360 arc"
	  " stroke \n ");
  fprintf(inf, "  0 45 360 { rotate \n wsiz 0 moveto wsiz 2 div 0 rlineto"
	  " stroke \n ");
  fprintf(inf, " } for \n grestore \n    } def \n\n\n");
  fprintf(inf, "  %% sample change font: /Helvetica-Bold findfont 12"
	  " scalefont setfont\n");
  fprintf(inf, " .2 setlinewidth \n ");
  fprintf(inf, " /ptsiz { .3 } def %% default point size for maps \n\n");
  fprintf(inf, " \n          %% this is the darker-foreground color setting"
	  " \n");
  fprintf(inf, "/setcol1  { setrgbcolor } def \n");
  fprintf(inf, " \n          %% this is the lighter-background color setting"
	  " \n");
  fprintf(inf, "/setcol2  { setrgbcolor } def \n");
  fprintf(inf, "\n   /BW { /setcol1  { pop pop pop 0 setgray } def \n"
	  " /setcol2  { pop pop pop 1 setgray } def \n } def\n");
  fprintf(inf, "           %% for Black and White figures uncomment the"
	  " following line:\n\n");

  if(mplot->BW_flag == 1)
    {
    fprintf(inf, "           BW\n\n"); 
    setup_pat_ps(inf);
    }
  else fprintf(inf, "           %%BW\n\n");

  fprintf(inf, "%%----------------COLOR Stuff  ------------\n\n");
  fprintf(inf, "  /setcolP { 0 1 0 setcol1 } def     %%  P-axis\n");
  fprintf(inf, "  /setcolT { 1 0 0 setcol1 } def     %%  T-axis\n\n");
  fprintf(inf, "  /external_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /map_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /internal_back_color { .8 .8 .8 setcol2 } def\n");

  fprintf(inf, "  /border_line_width { 0.2 setlinewidth } def\n");


  
  fprintf(inf, "%%----------------End General Stuff  ------------\n\n");


  fprintf(inf, "%%----------------Calling Command  ------------\n\n");
 fprintf(inf, " %% PWD: %s\n", pwd);
  fprintf(inf, "%% ");
  for(i=0; i<mplot->nargc; i++) fprintf(inf, " %s ",  mplot->nargv[i]);
  fprintf(inf, "\n");
  fprintf(inf, "%% Origin File: %s\n", mplot->origin_file);
  fprintf(inf, "%% Origin: %f %f %f %f\n", mplot->origin.phimin,
	  mplot->origin.phimax, mplot->origin.lammin, mplot->origin.lammax);
  fprintf(inf, "%% Input KM Box: %f %f %f %f\n", mplot->origin.minx,
	  mplot->origin.miny, mplot->origin.maxx, mplot->origin.maxy);

/* here need to output the box that is the target in
    lat-lon so can plot this as a vector in larger plots 
   this is especially important for zoom cases. */

    fprintf(inf, "%%  lat-lon outline of target region \n");
    fprintf(inf, "%%   this is in map form \n");
  xy2geo(mplot, &phi1, &lam1, mplot->origin.minx,  mplot->origin.miny);
  xy2geo(mplot, &phi2, &lam2, mplot->origin.maxx,  mplot->origin.maxy);
	    fprintf(inf, "%% > TARG_1  5  2 1  o %f %f %f %f\n", phi1, phi2, lam1, lam2);
	    fprintf(inf, "%%  %f %f \n", phi1, lam1);
  xy2geo(mplot, &phi, &lam, mplot->origin.maxx,  mplot->origin.miny);
	    fprintf(inf, "%%  %f %f \n", phi, lam);
	    fprintf(inf, "%%  %f %f \n", phi2, lam2);
  xy2geo(mplot, &phi, &lam, mplot->origin.minx,  mplot->origin.maxy);
	    fprintf(inf, "%%  %f %f \n", phi, lam);
	    fprintf(inf, "%%  %f %f \n", phi1, lam1);


  fprintf(inf, "%% maxx = %f maxy =%f \n", maxx, maxy);
  fprintf(inf, "%% color for inside the map:\n");
  fprintf(inf, "internal_back_color \n");

  PS_Border(inf, mplot, mplot->project_type);

  fprintf(inf, "            fill \n\n\n");
  fprintf(inf, "0 setgray \n");
  fprintf(inf, "border_line_width \n");

  PS_Border(inf, mplot, mplot->project_type);

  fprintf(inf, "              stroke \n\n\n");
  fprintf(inf, "%% BEGIN MARKUP\n");
  fprintf(inf, "         external_color\n\n");
  fprintf(inf, "       %%     Title \n\n");
  fprintf(inf, " 14 TR\n");
  fprintf(inf, " %f bx %f bz .2 inch add moveto (%s) censhow %%  TITLE\n\n\n",
	  maxx / 2.0, maxy, mplot->Overall_title);
  fprintf(inf, " 12 HV\n");

  /* plot the distance scale */

  fx = (int)(maxx) / 4.0;
  if(fx == 0.0) fx = mplot->gr.user_xdif / 4;
  if(fx > 100) fx = 100 * (int)(0.5 + fx / 100);
  if(fx > 1000) fx = 1000 * (int)(0.5 + fx / 1000);
  r = 10.0 * (int)(fx / 10.0);
  /* fprintf(stderr,"fx=%f r=%f ",fx,r); */
  if(fx < 10)
    {
    i = get_f_ind(fx, SMALLr, 14);
    r = SMALLr[i];
    }
  /* fprintf(stderr,"final i=%d r=%f \n",i,r); */

  /* if focal mecahnisms are being plotted move the kmscale down a bit */

  fx = maxx / 2.0;
  if(mplot->focm_flag > 1) 
    {
    fprintf(inf, "%% BEGIN MARKUP\n");

  /* start focal mech scale */

    itype[0] = mplot->strikeslip_col;
    itype[1] = mplot->rev_oblSS_col;
    itype[2] = mplot->obl_rev_col;
    itype[3] = mplot->reverse_col;
    itype[4] = mplot->norm_oblSS_col;
    itype[5] = mplot->oblq_norm_col;
    itype[6] = mplot->normal_col;

    fprintf(inf, "%%----------------------------------------- \n\n");
    fprintf(inf, "\n\n %% focal mechanism color table \n");
    fprintf(inf, " newpath \n");
    fprintf(inf, "gsave \n 1 inch -.5 inch translate\n");
    fprintf(inf, "/finch { 85 mul } def \n");
    inout = 3;
    for(i = 0; i < ntype; i++) 
      {
      fprintf(inf, " %f %f %f setcol1 \n", mplot->jmlcol[itype[i]].red,
	      mplot->jmlcol[itype[i]].green, mplot->jmlcol[itype[i]].blue);
      ix = i % inout;
      iy = floor((float)(i) / (float)inout);
      fprintf(inf, " newpath \n");
      fprintf(inf, " %d finch %d -.4 mul inch .1 inch 0 360 arc fill \n", ix,
	      iy);
      fprintf(inf, " 0 setgray \n");
      fprintf(inf, " %d finch .1 inch add %d -.4 mul inch moveto (%s) show\n",
	      ix, iy, ctype[i]);
      }

    fprintf(inf, "grestore \n\n");
    fprintf(inf, "%% END MARKUP\n");
    fprintf(inf, "%%----------------------------------------- \n\n");

    /* end focal mech scale */

    fprintf(inf, " %f bx -1.3 inch %f kmscale     %% KM_SCALE\n\n", fx, r);
    }
  else
    fprintf(inf, " %f bx -.5 inch %f kmscale      %% KM_SCALE\n\n", fx, r);

  fprintf(inf, "%% END MARKUP\n");
  plot_ps_latlon(inf, mplot);
  fprintf(inf, " newpath \n");

  if(mplot->image_flag > 0)
    {
    fprintf(inf, "%% BEGIN IMAGE\n");
    Ps_Palette(inf, mplot);

    Prep_Color_Scales(inf, mplot);


    /* plot_ps_image(inf, mplot); */

    if(mplot->BW_flag == 1)
    {
       plot_ps_HEX_BWimage(inf, mplot);
    }
    else
    {
       plot_ps_HEX_image(inf, mplot);
    }
    

    fprintf(inf, "%% END IMAGE\n");
    }

  fprintf(inf, " newpath \n");
  fprintf(inf, " gsave \n");

  PS_Border(inf, mplot, mplot->project_type);

  fprintf(inf, "clip newpath %% BEGIN  CLIP\n\n\n");

  /* DO the MAP stuff here   */

  if(mplot->map_flag) plot_ps_map(inf, mplot);

  /* STATIONS */

  /* fprintf(stderr, "outpostM: stations %d %d\n", mplot->sta_flag,
     mplot->num_sta_files); */

  if(mplot->sta_flag == 1) plot_ps_stations(inf, mplot);
  /***********************************************/

  /* PLOT SOURCES */

  fprintf(inf, "\n newpath \n");
  if(mplot->src_flag == 1) num_events = plot_ps_sources(inf, mplot);
  if(mplot->connect_flag) plot_ps_connect_sources(inf, mplot);

  fprintf(inf, "%% END SOURCES \n\n");
  /***********************************************/

  /* PLOT WELLS */

  if(mplot->wells_flag > 1) 
    {
    if((mplot->wells_symbol_flag == 1) || (mplot->wells_name_flag == 1))
      plot_ps_wells(inf, mplot);		
    if(mplot->wells_project_flag == 1) plot_ps_proj_wells( inf,  mplot);
    }
  /***********************************************/

  /* PLOT XSECS */

  if(mplot->xsec_flag) 
    {
    for(i = 0; i <= mplot->num_xsec; i++) 
      {
      fprintf(inf, "%%  BEGIN XSECS \n");
      fprintf(inf, " newpath      %% plotting the cross sections....\n");
      fprintf(inf, "/Helvetica-Bold findfont 12 scalefont setfont 0"
	      " setgray\n");
      Ps_Xsec(inf, mplot, i);
      }
    fprintf(inf, "0 setgray [] 0 setdash\n");
    fprintf(inf, "%%  END XSECS \n");
    }
  /***********************************************/
  /* PLOT Points */

  if(mplot->point_flag > 0) Plot_Points_Map(inf, mplot);
  /***********************************************/

  /* PLOT Contours */

  if(mplot->plot_cont_flag == 1) plot_ps_contours(inf, mplot);	
  if(mplot->plot_cont_points == 1) plot_ps_Cont_points(inf, mplot);
  if(mplot->plot_cont_values == 1) plot_ps_Cont_values(inf, mplot);
  /***********************************************/

  /* PLOT  Focal Mechanisms */

  if(mplot->focm_flag > 1) plot_ps_map_focals(inf, mplot);

  /***********************************************/
  /* PLOT Wire Frames */

  if(mplot->wire_flag) 
    {
    fprintf(inf, "\n\n%% BEGIN WIRE_FRAME \n\n");
    ps_wire_mapview(inf, mplot, x0, y0);
    fprintf(inf, "\n\n%% END WIRE_FRAME \n\n");
    }
  /***********************************************/
  /* PLOT  Ellipses */

  if(mplot->lip_flag) 
    {
    fprintf(inf, "\n\n%% BEGIN ELLIPSES \n\n");
    ps_lips_mapview(inf, mplot, x0, y0);
    fprintf(inf, "\n\n%% END ELLIPSES \n\n");
    }
  /***********************************************/

  fprintf(inf, " %% -------------------------------\n");
  fprintf(inf, "\n\n grestore %% END CLIP\n");
  /***********************************************/
 /* PLOT  Source Legend table */

  /* plot out a table of the source files */

  if((mplot->src_flag == 1) && mplot->more_src_flag
     && (mplot->src_depth_color != 1))
    plot_ps_table_sources( inf,  mplot);

  fprintf(inf, "0 setgray \n");
  fprintf(inf, "border_line_width \n");
  PS_Border(inf, mplot, mplot->project_type);
  fprintf(inf, "           stroke \n\n\n");

  /* PLOT labels*/

  if(mplot->num_labels >= 0) plot_ps_labels(inf, mplot);

  fprintf(inf, " %% -------------------------------\n");
  fprintf(inf, " %% HERE INSERT EXTRA STUFF, LIKE POLYGONS... \n");
  fprintf(inf, " %% -------------------------------\n");

  /* PLOT  Source Color Scale For depths */

  if((mplot->src_flag == 1) && mplot->src_depth_color) plot_ps_color_depth(inf, mplot);

  fprintf(inf, "0 setgray \n");
  fprintf(inf, "border_line_width \n");
  PS_Border(inf, mplot, mplot->project_type);

  fprintf(inf, "         stroke \n\n\n");
  fprintf(inf, "%% BEGIN MARKUP\n");

  /* PLOT SOURCE SCALE */

  /* if(mplot->mag_src_flag == 1 && (mplot->more_src_flag
     || mplot->src_flag)) */

  if((mplot->src_flag == 1) && (mplot->mag_src_flag > 0) && (num_events > 2))
     {

     /*  fprintf(stderr, "magscale stuff: flag=%d num=%d\n", mplot->mag_src_flag, num_events); */
    

     fprintf(inf, " \n\n 10 HV \n");
     ps_mag_scale(inf, mplot);
     fprintf(inf, " %% EARTHQUAKE MAG SCALE \n");
     fprintf(inf, " %% to remove the scale simply comment out the next line\n");
     fprintf(inf, " %% to move the scale change the location point of the next"
	     " line\n");


     /* if focal mecahnisms are beging plotted move the mag scale down a bit */
     if(( mplot->max_mag  - mplot->min_mag)<2)fprintf(inf, "%% commented out %%");
    
     if(mplot->focm_flag > 1)
     fprintf(inf, " 4.5  inch -.8 inch   mag_scale    %% MAG_SCALE\n");
     else 
	{
	fprintf(inf, " .8 inch -.6 inch  mag_scale    %% MAG_SCALE\n");
	BB_LL_y-=36;
	}
     

     
     }

  if( mplot->hoz_slab_flag == 1  )
    {
      BB_UR_x+=25;
      fprintf(inf, "0 setgray\n");
      fprintf(inf, "%f bx  %f bz 2 add moveto (Layer %d: %g-%g) show\n",
	      0.60 * maxx, maxy, mplot->image_layer,
	      mplot->hoz_slab_top,
	      mplot->hoz_slab_bot);
    }
 

  if(mplot->focm_flag > 1)
     {
     BB_LL_y-=72;
     }
  
  /* geologic legend */

  if(mplot->geotab_flag) plot_ps_geotab(inf, mplot);

  fprintf(inf, "%% END MARKUP\n");

  fprintf(inf, "\nJML_END \n");
  fprintf(inf, "\n\n%%END PAGE\n");
  fprintf(inf, "%%%%Trailer\n");
  
/* add a border around the plot 0.5inch = 36 */
  BB_LL_x-=36;
  BB_LL_y-=48;
  BB_UR_x+=36;
  BB_UR_y+=36;
  fprintf(stderr,"BBOX: %d %d %d %d\n", BB_LL_x, BB_LL_y, BB_UR_x, BB_UR_y);
  
fprintf(inf, "%%%%BoundingBox: %d %d %d %d\n",  BB_LL_x, BB_LL_y, BB_UR_x, BB_UR_y  );
  fprintf(inf, "            %%       full page  BBox: 0 0 612 792\n");
  fprintf(inf, "%%%%EOF \n");

  fprintf(stderr," \n DONE CREATING POST-SCRIPT: \n  Submit job by typing> lpr %s\n\n",
	 ps_file);

  fclose(inf);
  }

