/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "jutil.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "focproto.h"

/* --- function prototypes --- */
void Prep_Color_Scales(FILE *of, mpic *mplot);
void Ps_Palette(FILE *of, mpic *mplot);
int In_Rect_Vol(float RMAT[3][3], float dx, float dy, float dz, float mindep,
		float maxdep, float mindist, float maxdist, float d1, float d2, float *range,
		float *dep, float *aproj);
void PSsec_plot_well(xsec * xs, FILE *inf);
void Print_Header(FILE *inf, char fname[]);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);
float get_mag_size(float mag, float minsize, float slope, float minmag, float maxmag,
		   int style);
void get_perim(float dir[3], float axis[3], float elip[][2], int *n);
int Get_polarity(float strka, float dip1, float strkb, float dip2, float prot,
		 float pdip, float trot, float tdip);
void plot_a_point_ps(FILE *inf, mpic *m, float px, float py, int kount,
		     int i);

int pretty_tics(float left, float right, float *first, float *last, float *inc);
void slide_point(float x1, float y1, float x2, float y2, float dis, float *nx, float *ny);
double dis2points(float x1, float y1, float x2, float y2);


/* POSTSCRIPT X-SECT */

void slice_surf(struct SURF_GRD * grd, float x1, float x2, float y1, float y2,
		float *r, float *f, int SLICE_pts);
int simpX(int lx, int ly, float dx, float dy, float xq, float yq, float xsta,
	  float ysta, int *ivec, float *bvec);
int line_in_rect(float x1, float y1, float x2, float y2, float **poly1,
		 float newx[2], float newy[2]);
int change_ps_colors(mpic *mplot);

 float  usr2points(float xkmmax, float ykmmax, float  pagex, float pagey,
		   float bordx, float bordy);

void slice_surf_Image(mpic *xm, float x1, float y1, float x2, float y2,
		      float *r, float *f, int SLICE_pts);

double PrettyNum(double number, double distnext)
{
  double precision, temp;  

  precision = floor(log10(distnext) + .5);             /* # must have sig */
  (distnext > 0) ? precision-- : precision++;          /* figs            */
  temp = floor((number / pow(10, precision)) + .5);    /* Round to that   */ 
  return (temp * pow(10, precision));                  /* decimal place   */
}



void dirlab( float angle, char *dir)
   {				/* return the direction given an angle in degrees  */
   float inc, a, f;
   int i;
   
   char *dirs2[] = 
      {"N",  "NE", "NE", "E", "E",  "SE", "SE", "S", "S", 
       "SW","SW",  "W", "W", "NW", "NW", "N" };
   
   inc = 360.0/16.0;
   f = fmod(angle, 360.0);
   /* fprintf(stderr," b=%f and fmod=%f\n", b, first); */
   
   a = f/inc;
   
   i = (int)a;
   
   strcpy(dir , dirs2[i]);

   }


float Xshiftps_x(xsec *xs, float x)
   {
   return(x - xs->x_left);
   }
float Xshiftps_z(xsec *xs, float z)
   {
   return((xs->y_top-z) );
   }


void putpsXpoint(FILE *inf, xsec *xs, float x, float y)
   {
   /* shift to accomodate the zoom  */
   fprintf(inf, " %f bx  %f bz ", Xshiftps_x(xs,x) , Xshiftps_z(xs, y) );
   }

void m2psXpoint(FILE *inf, xsec *xs, float x, float y)
   {
   /* shift to accomodate the zoom  */
      putpsXpoint(inf, xs, x, y); 
      fprintf(inf, "  moveto " );
   }
void line2psXpoint(FILE *inf, xsec *xs, float x, float y)
   {
   /* shift to accomodate the zoom  */
      putpsXpoint(inf, xs, x, y); 
      fprintf(inf, "  lineto " );
   }

/*
putpsXpoint(inf, xs, 

m2psXpoint(inf, xs, xp, yp); 
line2psXpoint(inf, xs, xp, yp); 

      putpsXpoint(inf, xs, xp, yp); 
	fprintf(inf, " moveto\n");

      putpsXpoint(inf, xs, xp, yp); 
	fprintf(inf, " lineto\n");
*/


/* --- macros --- */


#define MAXCOL 65535

/* --- global variables --- */

int BB_ORG_x, BB_ORG_y;
int BB_LL_x, BB_LL_y, BB_UR_x, BB_UR_y;
float BDX, BDY;

  float PageOrgx=1.0, PageOrgy=6.8;
  float PageSizex=8.5, PageSizey=11.0;
  float Inch2Points=72.0;
  
/* --- functions --- */

void plot_X_ps_image(FILE *inf, xsec *xs)
  {
  mpic           *xm = xs->m;
  int color_range, i, j, k, i1;
  float y1, y2, x1, x2;

  color_range = xm->MaxColor - xm->MinColor;
  Ps_Palette(inf, xm);
    Prep_Color_Scales(inf, xm);

  fprintf(inf, " /saturated_lo { 1 setgray } def  \n /saturated_hi { 1"
	  " setgray } def \n\n\n");



  for(i = 0; i < xm->image.nz; i++)
    {
    y1 = xm->image.z_parts[i];
    if(y1 >= xs->min_xsdepth && y1 <= xs->max_xsdepth)
      {
      x2 = xs->image_are;
      y2 = xm->image.z_parts[i + 1];
      if(y2>xs->max_xsdepth) y2 = xs->max_xsdepth;
      for(j = 0; j < xs->image_nbloc; j++)
	{
	x2 += xs->image_bvec[j];
	x1 = x2 - xs->image_bvec[j];
	k = xs->image_ivec[j] + i * (xm->image.nx * xm->image.ny);
	if(xm->image.col[k] != 0)
	  {
	  i1 = xm->image.col[k];
	  i1 = i1 - xm->MinColor;
	  if((i1 >= 0) && (i1 < color_range))
	    fprintf(inf, " %d changecolor\n", i1);
	  else
	    {
	    if(i1 < 0) fprintf(inf, " saturated_lo   \n");
	    else fprintf(inf, " saturated_hi   \n");
	    }
           
	
	  putpsXpoint( inf, xs, x1, y1);
	  putpsXpoint( inf, xs, x2, y2);
	  fprintf(inf, " bord fill \n");
	  
		 
	  }
	}
      }
    }


  }

void ps_wire_xview(FILE *inf, xsec *xs)
  {
  int i;
  mpic *xm = xs->m;

  for(i = 0; i < xs->num_threeD; i++)
    {
    /* fprintf(stderr, "X3D: %d %f %f %f %f\n", i, xs->threeD[i].x1,
       xs->threeD[i].y1, xs->threeD[i].x2, xs->threeD[i].y2); */

    fprintf(inf, "%f %f %f setcol1 \n", xm->jmlcol[xs->col3D[i]].red,
	    xm->jmlcol[xs->col3D[i]].green, xm->jmlcol[xs->col3D[i]].blue);
    
    putpsXpoint( inf, xs, xs->threeD[i].x1, xs->threeD[i].y1);
    fprintf(inf, "  moveto ");
    putpsXpoint( inf, xs, xs->threeD[i].x2, xs->threeD[i].y2);
    fprintf(inf, " lineto stroke\n");

    }
  }

void ps_lips_xview(FILE *inf, xsec *xs)
   {
   mpic *mplot = xs->m;
   int i, k, klip, kin, kk;
   float px, py, xp, yp, garb, dep, r, off, ang, degrad, fi,
   dirin[3], dir[3], axis[3], elip[360][2];
   double dis;
   double phir, a, b, theta;
   
   degrad = 0.0174532;
   ang = 0.0;
  
   fprintf(inf, ".5 .5 .5 setcol1 \n\n");
   klip=0;
   k=0;
   
   
   dis = sqrt((xs->line.x2 - xs->line.x1) * (xs->line.x2 - xs->line.x1)
	      + (xs->line.y2 - xs->line.y1) * (xs->line.y2 - xs->line.y1));
   dirin[0] = -(xs->line.y2 - xs->line.y1) / dis;
   dirin[1] = (xs->line.x2 - xs->line.x1) / dis;

   dirin[2] = sin(degrad * (xs->dip - 90));

   fi = 0;
   for(klip = 0; klip < mplot->lip_num; klip++)
      {
      for(k = 0; k < mplot->lip[klip].n; k++)
	 {
	 geo2xy(mplot, mplot->lip[klip].lips[k].latlon.phi,
		mplot->lip[klip].lips[k].latlon.lam, &px, &py);
	 garb = mplot->lip[klip].lips[k].latlon.z;
	 kin = In_Rect_Vol(xs->RM, px - xs->line.x1, py - xs->line.y1, garb,
			   xs->min_xsdepth, xs->max_xsdepth, xs->x_left, xs->x_right,
			   xs->max_xsfront, xs->max_xsback, &r, &dep, &off);
	 if(kin == 1)
	    {

	    if(mplot->lip[klip].lips[k].ind == 1)
	       {
	       fi = 0;
	       phir = degrad * fi;
	       a = mplot->lip[klip].lips[k].ebar.x;

	       /*  to get the a axis need to make a calculation  */

	       theta = atan((mplot->lip[klip].lips[k].ebar.x
			     / mplot->lip[klip].lips[k].ebar.y)
			    * ((xs->line.x2-xs->line.x1)
			       / (xs->line.y2-xs->line.y1)));
	       a = sqrt(sqr(mplot->lip[klip].lips[k].ebar.x * sin(theta))
			+ sqr(mplot->lip[klip].lips[k].ebar.y * cos(theta)));
	       b = mplot->lip[klip].lips[k].ebar.z;
	       fprintf(inf, "newpath ");
	       putpsXpoint(inf, xs, r, dep);
	       putpsXpoint(inf, xs, a, b);
	       fprintf(inf, "0 lip stroke \n");
	       }
	    else
	       {
	   

	       axis[0] = mplot->lip[klip].lips[k].lambda[0];
	       axis[1] = mplot->lip[klip].lips[k].lambda[1];
	       axis[2] = mplot->lip[klip].lips[k].lambda[2];
	       dir[0] = (mplot->lip[klip].lips[k].vec[0][0] * dirin[0]
			 + mplot->lip[klip].lips[k].vec[0][1] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[0][2] * dirin[2]);
	       dir[1] = (mplot->lip[klip].lips[k].vec[1][0] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[1][1] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[1][2] * dirin[2]);
	       dir[2] = (mplot->lip[klip].lips[k].vec[2][0] * dirin[2]
			 + mplot->lip[klip].lips[k].vec[2][1] * dirin[1]
			 + mplot->lip[klip].lips[k].vec[2][2] * dirin[2]);

	       get_perim(dir, axis, elip, &kk);
	       i = 0;
	       xp = elip[i][0] + r;
	       yp = (elip[i][1] + dep);
	       fprintf(inf, "       %% Ellipse file: %d number: %d\n", klip, k);
	
	       putpsXpoint(inf, xs, xp, yp); 
	       fprintf(inf, " moveto\n");
	       for(i = 0; i < kk; i++)
		  {
		  xp = elip[i][0] + r;
		  yp = (elip[i][1] + dep);
		  putpsXpoint(inf, xs, xp, yp); 
		  fprintf(inf, " lineto\n");
	 
		  }
	       fprintf(inf, "stroke\n");
	       }
	
	    }
	 }
      }
   }

void Do_Postscript_Xsect(Display *gdisp, char ps_file[50], xsec *xs)
  {
  float p1, p2, fx, fy, f1, f2, f3, f4, garb1, r1[10], dep1[10], off1[10],
    xkmmin, xkmmax, xkmdiff, ykmmax, ykmmin, ykmdiff, sizmag, r, off, dep,  phi[3],
    lam[3], px, py, urot, udip, vrot, vdip, prot, pdip, trot, tdip, az1, d1,
    az2, d2, phirot, yshift, maxy, miny, *rdis, *fval, focrad, qx, qy;
  char *psdir, psfile[200];
  float nx1, ny1, nx2, ny2;
 
  mpic *xm = xs->m;
  int i, j, k, i1, kount, a, ipol, nx, ny, SLICE_pts;
 char *pwd = getenv("PWD");

  int ntic;
  float first_tic, last_tic, inc_tic;
  
  char dirtic[4];
  
     

  static char *eqsyms[] =
    {"xcirc", "xplus", "xdiamond", "xsquare", "xmark", "xtriangle", "xrotsq",
      "star_of_david" };


  FILE *inf;

  if((inf = fopen(ps_file, "w")) == NULL)
    {
    printf("Can't open postscript file...continuing\n");
    return;
    }

  change_ps_colors(xm);

  /* plot a grey border around each layer */

  fprintf(inf, "%%!PS-Adobe-3.0 EPSF-3.0\n%%%%BoundingBox: (atend)\n");

#if 0
  fprintf(inf, "%%JMLRUNFILE: The Following Code is an Included RUN File \n");
  if((psdir = getenv("PSHEAD")) == NULL)
    fprintf(inf, "(../Postscript/head.big) run \n");
  else fprintf(inf, "(%s/head.big) run \n", psdir);
#endif

  if((psdir = getenv("PSHEAD")) == NULL)
    fprintf(inf, "%%%%  need to include the header file here \n");
  else
    {
    sprintf(psfile,"%s/head.big", psdir);
    Print_Header(inf, psfile);
    }



  fprintf(inf, "%%----------------Calling Command  ------------\n\n");
 fprintf(inf, " %% PWD: %s\n", pwd);
  fprintf(inf, "%% ");
  for(i=0; i<xm->nargc; i++) fprintf(inf, " %s ",  xm->nargv[i]);
  fprintf(inf, "\n");


  fprintf(inf, " gsave \n");

  fprintf(inf, " %%  To get landscape mode need to fiddle with these\n ");
  fprintf(inf, " %%   also need to change the bounding box on the bottom\n");
  fprintf(inf, " %%   landscape 1.6 inch 6.8 inch translate \n\n");
  fprintf(inf, " %% Main Page Translation \n");
  fprintf(inf, " %f inch %f inch translate \n", PageOrgx, PageOrgy);
  fprintf(inf, "  /border_line_width { 0.2 setlinewidth } def\n");


  

  BB_ORG_x = PageOrgx*Inch2Points;
  BB_ORG_y = PageOrgy*Inch2Points;

  BB_LL_x = BB_ORG_x;
  BB_UR_y = BB_ORG_y;

  BB_LL_y = BB_ORG_y-BB_ORG_y;
  BB_UR_x = BB_ORG_x+PageSizex*Inch2Points;


  i = xs->index - 1;
  fprintf(inf, "%% Origin File: %s\n" , xm->origin_file);


  fprintf(inf, "%% Old input params: %f %f %f %f %f %f %f %f %f %f %f\n",
	  xm->cross[i].xsecphilam.x1, xm->cross[i].xsecphilam.y1,
	  xm->cross[i].xsecphilam.x2, xm->cross[i].xsecphilam.y2,
	  xm->cross[i].xsecwidth, xm->cross[i].xsecdepth,
	  90 - xm->cross[i].xs_dip, xm->cross[i].min_xsdepth,
	  xm->cross[i].max_xsdepth, xm->cross[i].max_xsfront,
	  xm->cross[i].max_xsback);

  fprintf(inf, "%% Xsec input params: x1 y1 x2 y2 dip top bot front back\n");
  fprintf(inf, "%% %f %f %f %f %f %f %f %f %f \n",
	  xm->cross[i].xsecphilam.x1, xm->cross[i].xsecphilam.y1,
	  xm->cross[i].xsecphilam.x2, xm->cross[i].xsecphilam.y2,
	  90 - xm->cross[i].xs_dip, xm->cross[i].min_xsdepth,
	  xm->cross[i].max_xsdepth, xm->cross[i].max_xsfront,
	  xm->cross[i].max_xsback);



  f2 = dis2points(xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2);
  
  if( (xs->x_left!=0.0) || (xs->x_right!=f2) || (xs->y_top!=xm->cross[i].min_xsdepth) || (xs->y_bot!=xm->cross[i].max_xsdepth) )
     {
   
     fprintf(inf, "%% ZOOM BOX: %f %f %f %f \n",   xs->x_left,  xs->x_right,  xs->y_top,  xs->y_bot);
     fprintf(inf, "%% to get a box in the unzoomed figure of the zoomed box \n");
     fprintf(inf, "%% insert the following code in the unzoomed  postscript file\n");
     fprintf(inf, "%% ");
     
     putpsXpoint(inf, xs, xs->x_left,  xs->y_top);
     putpsXpoint(inf, xs, xs->x_right,  xs->y_bot);
     fprintf(inf, "   bord stroke \n");
     fprintf(inf, "%% \n");


     }
  
  /* Scaling :  assume paper is 8.5 by 11'' */

  xkmmin = xs->x_left;
  xkmmax = xs->x_right;
  xkmdiff = xkmmax - xkmmin;
  

  ykmmin = xs->y_top;
  ykmmax = xs->y_bot;
  ykmdiff = ykmmax - ykmmin;

/*  this is defunct
  f1 = 7.5 * 72.0 / xkmmax;
  f2 = 6.2 * 72.0 / ykmdiff;
  if(xkmmax >= ykmdiff) f3 = f1;
  if(ykmdiff > xkmmax) f3 = f2;
  if(f3 * ykmdiff / 72.0 > 6.2) f3 = 6.2 * 72.0 / ykmdiff;
*/

/* for landscape mode */

f3 = usr2points(xkmdiff, ykmdiff, 8.5, 11 ,  2.0 , 3.5 );
  fprintf(inf, "%%PORTRAITMODE /bx { %f mul } def  /bz { %f mul } def \n", f3, f3);

f3 = usr2points(xkmdiff, ykmdiff, 11.0 , 8.5 ,  3.5 , 2.3);
  fprintf(inf, "%%LANDSCAPEMODE /bx { %f mul } def  /bz { %f mul } def \n", f3, f3);


/* for matching 1-1 aspect with map view do this */

  f1 = usr2points(xm->origin.maxx - xm->origin.minx, 
		  xm->origin.maxy - xm->origin.miny, 
		  8.5 , 11 , 2.0 , 3.5);

 
  BDX = f1;
  BDY = f1;


  BB_LL_x = BB_ORG_x;
  BB_UR_y = BB_ORG_y;

  BB_LL_y = BB_ORG_y-ykmdiff*BDY;

/* this is here to prevent the plot from going off the page.
   if the plot does go off the bottom the ps scaling
    is adjusted in the Y dimension to account for this
    and the aspect ratio of the plot is modified.  */


     fprintf(inf, " \n");
     fprintf(inf, " %% The following lines set up the postscript scaling in X and Z:\n");
     fprintf(inf, " %% the x scaling is set so that it matches the scaling of the\n");
     fprintf(inf, " %% Map view plots.\n");    
 
  if(BB_LL_y<0.0)  
     {
     BB_LL_y = 72;
     BDY = (BB_ORG_y - BB_LL_y)/ykmdiff;
     fprintf(inf, " %% Because the plot will not fit on the page with 1-1 scaling\n");
     fprintf(inf, " %% the scaling has been modified so the Z axis is compressed.\n");
     fprintf(inf, " %%  To get 1-1 aspect ratio, set the bx and bz parameters are equal.\n");
     }
  
      fprintf(inf, " \n");

  BB_UR_x = BB_ORG_x+xkmdiff*BDX;

   fprintf(inf, " /bx { %f mul } def  /bz { %f mul } def %%JMLSCALING\n", BDX, BDY);

  fprintf(inf, "          %%  %f %f  %%JML_KMBOUNDS\n", xkmdiff, ykmdiff);


  fprintf(inf, " \n          %% this is the darker-foreground color setting"
	  " \n");
  fprintf(inf, "/setcol1  { setrgbcolor } def \n");
  fprintf(inf, " \n          %% this is the lighter-background color setting"
	  " \n");
  fprintf(inf, "/setcol2  { setrgbcolor } def \n");
  fprintf(inf, "\n   /BW { /setcol1  { pop pop pop 0 setgray } def \n"
	  " /setcol2  { pop pop pop 1 setgray } def \n } def\n");
  fprintf(inf, "           %% for Black and White figures uncomment the"
	  " following line:\n\n");

  if(xm->BW_flag == 1) fprintf(inf, "           BW\n\n");
  else fprintf(inf, "           %%BW\n\n");

  fprintf(inf, "%%----------------COLOR Stuff  ------------\n\n");
  fprintf(inf, "  /setcolP { 0 1 0 setcol1 } def     %%  P-axis\n");
  fprintf(inf, "  /setcolT { 1 0 0 setcol1 } def     %%  T-axis\n\n");
  fprintf(inf, "  /external_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /map_color { 0 0 0  setcol1 } def\n");
  fprintf(inf, "  /internal_back_color { .8 .8 .8 setcol2 } def\n");
  fprintf(inf, " /slip_vec_size { 1.7 } def\n");
  fprintf(inf, "%%----------------End General Stuff  ------------\n\n");
  fprintf(inf, "  %% sample change font: /Helvetica-Bold findfont 12"
	  " scalefont setfont\n");
  fprintf(inf, " .2 setlinewidth \n ");
  fprintf(inf, "internal_back_color\n");

/*
  putpsXpoint(inf, xs, 0, -ykmdiff); 
  fprintf(inf, "  translate\n");  */

  putpsXpoint(inf, xs, xs->x_left, xs->y_top ); 
  putpsXpoint(inf, xs,  xs->x_right ,  xs->y_bot); 
  fprintf(inf, "  bord fill \n\n\n");


  fprintf(inf, "0 setgray \n");
  fprintf(inf, "border_line_width \n");
  putpsXpoint(inf, xs, xs->x_left, xs->y_top ); 
  putpsXpoint(inf, xs,  xs->x_right ,  xs->y_bot); 
  fprintf(inf, " bord stroke \n\n\n");


 fprintf(inf, " %%%% X-distance  TIC MARKS  %%%%%%%%%%\n");

  fprintf(inf, "12 HV \n\n");

  fprintf(inf, "   external_color \n\n");

  fprintf(inf, "border_line_width \n");
  
/*   TIC MARKS   */
                   /*   upper left X  */

  m2psXpoint(inf, xs, xkmmin,  ykmmin);
  fprintf(inf, "  0 .1 inch rlineto stroke \n\n");
  m2psXpoint(inf, xs, xkmmin, ykmmin);
  /* fprintf(inf, "  0 .15 inch  rmoveto (0) censhow newpath\n\n"); */

   /* dirtic  */

      f1 = atan2( xs->line.y1 -xs->line.y2,  xs->line.x1-xs->line.x2);
      f1 = 57.29578*f1;
      f1 = 90-f1;
     if(f1<0.0) f1 = 360+f1;
       dirlab(f1, dirtic);

  fprintf(inf, "  0 .15 inch  rmoveto (0 %s) censhow newpath\n\n", dirtic);

                   /*   upper right X  */

      f1 = atan2( xs->line.y2 -xs->line.y1,  xs->line.x2-xs->line.x1);
      f1 = 57.29578*f1;
      f1 = 90-f1;
     if(f1<0.0) f1 = 360+f1;
       dirlab(f1, dirtic);
  
  m2psXpoint(inf, xs, xkmmax, ykmmin);
  fprintf(inf, "  0 bx .1 inch  rlineto stroke \n");
  m2psXpoint(inf, xs, xkmmax, ykmmin);
  f1 = PrettyNum((double)xkmdiff , (double)xkmdiff/100.0 );
  
  fprintf(inf, "  0 bx .15 inch  rmoveto (%g km %s) censhow"
	  " newpath\n",  f1, dirtic);
  fprintf(inf, "           %% for label rounded %f to %g\n", xkmdiff , f1);
  fprintf(inf, "\n");


                   /*   upper right Z  tic only */

  m2psXpoint(inf, xs, xs->x_right, xs->y_top);
  fprintf(inf, "  .1 inch 0 rlineto stroke\n");
  fprintf(inf, " %f bx %f bz  moveto .1 inch 0 rlineto stroke\n", Xshiftps_x(xs, xs->x_right),
	  Xshiftps_z(xs, xs->y_bot) );

                  /*   lower right Z  */
  f1 = PrettyNum((double)xs->y_bot , (double) (xs->y_bot-xs->y_top)/100.0 );
  fprintf(inf, " %f bx .1 inch add %f bz  .05 inch sub moveto (%g km) show"
	  " \n",
	  Xshiftps_x(xs, xs->x_right),  Xshiftps_z(xs, xs->y_bot), 
	   f1);
  fprintf(inf, "           %% for label rounded %f to %g\n", xs->y_bot , f1);
    fprintf(inf, "\n");

                   /*   upper right Z  Label */

  if(ykmmin!=0.0)
    {
  f1 = PrettyNum((double)xs->y_top , (double) (xs->y_bot-xs->y_top)/100.0 );
    fprintf(inf, " %f bx .1 inch add %f bz  .05 inch sub moveto (%g km) show"
	  " \n", Xshiftps_x(xs, xs->x_right),   Xshiftps_z(xs, xs->y_top) ,  f1);
  fprintf(inf, "           %% for label rounded %f to %g\n", xs->y_top , f1);
 fprintf(inf, "\n");
    }
  else
     {
         fprintf(inf, " %f bx .1 inch add %f bz  .05 inch sub moveto (0) show"
	  " \n\n\n", Xshiftps_x(xs, xs->x_right),   Xshiftps_z(xs, xs->y_top) );

     }
  
                  /*   Depth  Label */

  fprintf(inf, " %f bx .15 inch add %f bz  moveto gsave -90 rotate (Depth"
	  " km) censhow grestore \n\n\n", xkmdiff,   Xshiftps_z(xs, (ykmmax+ykmmin)/2)   ) ;


                 /*  tic marks   */
  fprintf(inf, " %%  ********* DEPTH  TIC MARKS *********** \n");
  

 ntic = pretty_tics(xs->y_top, xs->y_bot, &first_tic, &last_tic, &inc_tic);

  for(j = 0; j < ntic; j++)
    {
    garb1=first_tic+j*inc_tic;
    m2psXpoint(inf, xs, xs->x_right, garb1); 
    fprintf(inf, "  .08 inch  0 rlineto stroke\n");
    }
  fprintf(inf, "\n");
  

  /**  the following tickmarks are commented out temporarily  **/
  for(j = 0; j < ntic; j++)
    {
    garb1=first_tic+j*inc_tic;
    fprintf(inf, "%%");
    m2psXpoint(inf, xs, xs->x_right, garb1); 
    fprintf(inf, " .1 inch  -.05 inch rmoveto (%g) show  \n", garb1 );
    }




  fprintf(inf, " %% ******** Horizontal  TIC MARKS ********* \n");

 ntic = pretty_tics(xs->x_left, xs->x_right, &first_tic, &last_tic, &inc_tic);

  for(j = 0; j < ntic; j++)
    {
    garb1=first_tic+j*inc_tic;
    m2psXpoint(inf, xs, garb1, xs->y_bot ); 
    fprintf(inf, " 0  -.06 inch rlineto stroke\n");
    }




#if 1
  fprintf(inf, " /hticlabs  {   %% horizontal tic labels: %d\n", ntic);
    
  for(j = 0; j < ntic; j+=max2((ntic-1), 1) ) 
    {
    garb1=first_tic+j*inc_tic;
    m2psXpoint(inf, xs, garb1, xs->y_bot ); 
    fprintf(inf, " 0  -.06 inch .1 inch sub rmoveto (%g) censhow\n", garb1);
    }


  fprintf(inf, " }  def \n\n  hticlabs\n\n");
#endif
/******    Title on top *****/

  fprintf(inf, "/Helvetica findfont 18 scalefont setfont 0 setgray\n");
  yshift = 0.4;

  if(xm->plot_cont_flag == 1)
  if(xs->field_style_flag == 0)
  yshift = 1.05;
  
  if(xs->X_Image_Above == 1)
     {
     
     if(xm->image_flag == 1)
	{   
	yshift = 1.05;
	}
     }
  



  m2psXpoint(inf, xs, (xs->x_left+xs->x_right)/2 , xs->y_top ); 

  fprintf(inf, "  0 %f inch rmoveto (%s Cross"
	  " Section %d) censhow  newpath\n\n\n",  yshift,
	  xm->Overall_title, xs->index);
  fprintf(inf, "12 TR 0 setgray\n");

  BB_UR_y+=25;
  

/*  from here to the next grestore we create a clipping region
    and only plot things inside  */

  fprintf(inf, " %%     START plotting only inner stuff\n");

  fprintf(inf, "  gsave \n");
        putpsXpoint(inf, xs, xs->x_left, xs->y_top); 
        putpsXpoint(inf, xs, xs->x_right, xs->y_bot); 

  fprintf(inf, "  bord \n clip newpath    %% BEGIN  CLIP\n\n\n");

  if(xm->image_flag > 0)
    {
    plot_X_ps_image(inf, xs);
    fprintf(inf, "0 setgray \n");
    fprintf(inf, "border_line_width \n");
  putpsXpoint(inf, xs, xs->x_left, xs->y_top ); 
  putpsXpoint(inf, xs,  xs->x_right ,  xs->y_bot); 
  fprintf(inf, " bord stroke \n\n\n");
  BB_LL_y -= 36;
    }


  /*  PLOT SOURCES */

 if(xm->src_flag)
   {
     
  fprintf(inf, " .2 setlinewidth \n ");
  /* fprintf(stderr, "xs->xwidth = %f\n", xs->xwidth); */

  if(xm->BW_flag == 1) 
    {
    sizmag = 0.4 * (xm->SourceSize);
    fprintf(inf, "/eqsiz { %f mul } def  %%   earthquake size   \n", sizmag);
    }
  else
    {
    sizmag = 0.4 * (xm->SourceSize / 3);
    fprintf(inf, "/eqsiz { %f mul } def  %%   earthquake size   \n", sizmag);
    }

  fprintf(inf, "/eqpl { eqsiz 0 360 arc stroke } def\n");
  fprintf(inf, " %%  SYMBOLS that all use the same format:  x y size"
	  " <symbol>\n");
  fprintf(inf, "%%  xmark xsquare xtri xtriangle xrotsq xdiamond\n\n");
  fprintf(inf, "%%  Use these to change the symbols for different event"
	  " files\n");
  fprintf(inf, "%%  to change the earthquake plotting to a fancier plot,"
	  " uncomment the following macro\n");
  fprintf(inf, "%%  (to uncomment a line, remove the %% from the beginning)"
	  " \n\n");

  if(xm->fancy_src_flag == 1)
    fprintf(inf, "  /eqpl { eqsiz 0 360 arc gsave fill grestore gsave 0"
	    " setgray stroke grestore newpath } def  \n");
  else
    fprintf(inf, "%%  /eqpl { eqsiz 0 360 arc gsave fill grestore gsave 0"
	    " setgray stroke grestore newpath } def  \n");

  fprintf(inf, "\n newpath \n");
  fprintf(inf, "%f %f %f setcol1 \n", xm->jmlcol[xm->src_color].red,
	  xm->jmlcol[xm->src_color].green, xm->jmlcol[xm->src_color].blue);

  for(a = 0; a <= xm->max_more_src - 1; a++)
    {
    if(xm->BW_flag == 1)
      fprintf(inf, "/eqpl { eqsiz %s } def\n", eqsyms[a]);

    fprintf(inf, " \n\n\n %%  source file: %d %s \n", a,
	    xm->sources[a].file_name);
    i1 = xm->src_color - a;
    fprintf(inf, "%f %f %f setcol1 \n", xm->jmlcol[i1].red,
	    xm->jmlcol[i1].green, xm->jmlcol[i1].blue);

    for(i = 0; i < xm->sources[a].numpoints; i++)
      {
      if(xm->sources[a].onoff[i] == 1)
	{
	k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
			xm->sources[a].loc[i].y - xs->line.y1,
			xm->sources[a].loc[i].z, xs->min_xsdepth,
			xs->max_xsdepth, xs->x_left,  xs->x_right, xs->max_xsfront,
			xs->max_xsback, &r, &dep, &off);

	if(k == 1)
	  {
	  sizmag = xm->sources[a].size[i];
	  if(sizmag <= 1.0) sizmag = 1;
	  if(xm->mag_src_flag == 0) sizmag = 1; 
             putpsXpoint(inf, xs, r, dep); 
	  fprintf(inf, "  %f eqpl \n",  sizmag);
	  }
	}
      }
    }
  
   }
 
  fprintf(inf, "\n\n\n 0 setgray ");

  /* CONNECT SOURCES */

  if(xm->connect_flag)
    {
    for(i = 0; i < xm->sources[0].numpoints; i++)
      {
      k = In_Rect_Vol(xs->RM, xm->sources[0].loc[i].x - xs->line.x1,
		      xm->sources[0].loc[i].y - xs->line.y1,
		      xm->sources[0].loc[i].z, xs->min_xsdepth,
		      xs->max_xsdepth, xs->x_left,  xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r1[0], &dep1[0], &off1[0]);

      if(k == 1)
	{
	for(a = 1; a <= xm->max_more_src - 1; a++)
	  {
	  k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
			  xm->sources[a].loc[i].y - xs->line.y1,
			  xm->sources[a].loc[i].z, xs->min_xsdepth,
			  xs->max_xsdepth, xs->x_left,  xs->x_right, xs->max_xsfront,
			  xs->max_xsback, &r1[a], &dep1[a], &off1[a]);

	  if(k == 1)
	    {
       m2psXpoint(inf, xs,r1[a - 1], dep1[a - 1] ); 
       line2psXpoint(inf, xs,r1[a ], dep1[a ] ); 
	    fprintf(inf, "  stroke\n" );
	    }
	  }
	}
      }
    }

  /* PLOT the POINTS */

  if(xm->point_flag > 0)
    {
  fprintf(inf, " %% Plotting POINTS\n");
    for(kount = 0; kount < xm->point_flag; kount++)
      {
      for(i = 0; i < xm->Mpoint[kount].numpoints; i++)
	{
	geo2xy(xm, xm->Mpoint[kount].points[i].lat,
	       xm->Mpoint[kount].points[i].lon, &px, &py);
	garb1 = xm->Mpoint[kount].points[i].depth;
	k = In_Rect_Vol(xs->RM, px - xs->line.x1, py - xs->line.y1, garb1,
			xs->min_xsdepth, xs->max_xsdepth, xs->x_left,  xs->x_right,
			xs->max_xsfront, xs->max_xsback, &r, &dep, &off);
	/* fprintf(stderr, "point %f %f ", r, dep); */

	dep = Xshiftps_z(xs, dep);
	r   = Xshiftps_x(xs, r);
	/* fprintf(stderr, "point %f %f \n", r, dep); */
	
	if(k==1) plot_a_point_ps(inf, xm, r, dep, kount, i);
	}
      }
    }

  if(xm->lip_flag) ps_lips_xview(inf,  xs);
  if(xm->wire_flag) ps_wire_xview(inf,  xs);




  fprintf(inf, " grestore\n");
  fprintf(inf, " %% END of inner plotting stuff\n");
 

  /*  Image Scale */

  if(xm->image_flag > 0)
     {

     /* there will be 40 boxes painted the scale factor is BDX pix/km in the hoz dir
 so, have BDX*(xs->x_right - xs->x_left) total pixels
         if we want the scale to be about 0.75 of the fig
         
*/

     f3 = 0.75*BDX*(xs->x_right - xs->x_left);
     
     f4 = f3/40;
     
     fprintf(inf, " /bsiz { %f mul } def \n", f4);
     f1 = Xshiftps_x(xs, (xs->x_left + xs->x_right)*0.5 - (f3*0.5)/BDX );
     f2 = Xshiftps_z(xs, xs->y_bot);
     fprintf(inf, "\n/pos_sc_x { %f bx  } def  /pos_sc_y { %f bz 32 sub } def\n",
	     f1 ,  f2 );
     fprintf(inf, "Hoz_Scale\n\n");
     BB_UR_x+=1*Inch2Points;
     }
  


  /* WELLS */

  if(xm->wells_flag > 1) PSsec_plot_well(xs, inf);

  /* STATIONS*/

  if(xm->sta_flag)
    {
    phi[1] = 0.0;
    phi[2] = 0.0;
    lam[1] = 0.0;
    lam[2] = 0.0;

    for(kount = 0; kount < xm->num_sta_files; kount++)
      {
      fprintf(inf, "%f %f %f setcol1 \n",
	      xm->jmlcol[xm->stations[kount].color].red,
	      xm->jmlcol[xm->stations[kount].color].green,
	      xm->jmlcol[xm->stations[kount].color].blue);
      fprintf(inf, "   /tsiz { 5 mul } def \n");

      switch(xm->stations[kount].symbol)
	{
	case 0:
	  fprintf(inf, " /plot_sta { jugsta fill } def \n");
	  break;

	case 1:
	  fprintf(inf, " /plot_sta { 1 tsiz xtriangle } def \n");
	  break;

	case 2:
	  fprintf(inf, " /plot_sta { 1  tsiz xsquare } def \n");
	  break;

	case 3:
	  fprintf(inf, " /plot_sta { 1  tsiz star_of_david } def \n");
	  break;

	case 4:
	  fprintf(inf, " /plot_sta { 1 tsiz xmark } def \n");
	  break;

	case 5:
	  fprintf(inf, " /plot_sta { 1 tsiz xplus } def \n");
	  break;

	  case 6:
	  fprintf(inf, " /plot_sta {  1 tsiz xdiamond } def \n");
	  break;

	  case 7:
	  fprintf(inf, "  /plot_sta {  1 tsiz xcirc } def \n");
	  break;
	  
	  case 8:
	  fprintf(inf, "  /plot_sta {  1 tsiz xfillcirc } def \n");
	  break;
	  
	  case 9:
	  fprintf(inf, "  /plot_sta {  1 tsiz xasterix30 } def \n");
	  break;
	  case 10:
	  fprintf(inf, "  /plot_sta {  1 tsiz star5 } def \n");
	  break;
	  case 11:
	  fprintf(inf, "  /plot_sta {  1 tsiz star5 } def \n");
	  break;





	default:
	  fprintf(inf, " /plot_sta { jugsta fill } def \n");
	  break;
	}

      for(a = 0; a < xm->stations[kount].numpoints; a++)
	{
	switch(xs->sta_elevation_flag)
	  {
	  case 0:
	    garb1 = 0.0;
	    break;

	  case 1:
	    garb1 = (xm->stations[kount].sta[a].loc.z);
	    break;

	  case 2:
	    garb1 = (xm->stations[kount].sta[a].loc.z
		     - xm->stations[kount].mean_elev);
	    break;

	  default:
	    garb1 = 0.0;
	    break;
	  }

	garb1 *= -1;

	k = In_Rect_Vol(xs->RM, xm->stations[kount].sta[a].loc.x - xs->line.x1,
			xm->stations[kount].sta[a].loc.y - xs->line.y1, garb1,
			xs->min_xsdepth, xs->max_xsdepth, xs->x_left,  xs->x_right,
			xs->max_xsfront, xs->max_xsback, &r, &dep, &off);

	if(k == 1)
	  {
	  if(xm->sta_name_flag)
	    {
      putpsXpoint(inf, xs, r, -dep); 
	    fprintf(inf, "   plot_sta  newpath \n ");
      putpsXpoint(inf, xs, r, -dep); 
	    fprintf(inf, " moveto 0 2 tsiz rmoveto (%s) censhow \n",
		     xm->stations[kount].sta[a].name);
	    }
	  else
	     {
	     putpsXpoint(inf, xs, r, -dep); 
	    fprintf(inf, "  plot_sta %% %s\n", 
		    xm->stations[kount].sta[a].name);
	    }
	  

	  }
	}

      fprintf(inf, "  1 setgray /tsiz { 3.5 mul } def \n");

      for(a = 0; a < xm->stations[kount].numpoints; a++)
	{
	switch(xs->sta_elevation_flag)
	  {
	  case 0:
	    garb1 = 0.0;
	    break;

	  case 1:
	    garb1 = (xm->stations[kount].sta[a].loc.z);
	    break;

	  case 2:
	    garb1 = (xm->stations[kount].sta[a].loc.z
		     - xm->stations[kount].mean_elev);
	    break;

	  default:
	    garb1 = 0.0;
	    break;
	  }

	garb1 *= -1;

	k = In_Rect_Vol(xs->RM, xm->stations[kount].sta[a].loc.x - xs->line.x1,
			xm->stations[kount].sta[a].loc.y - xs->line.y1, garb1,
			xs->min_xsdepth, xs->max_xsdepth, xs->x_left,  xs->x_right,
			xs->max_xsfront, xs->max_xsback, &r, &dep, &off);

	if(k == 1)
	  {
	  putpsXpoint(inf, xs, r, -dep); 
	  fprintf(inf, "  plot_sta %% %s\n", 
		  xm->stations[kount].sta[a].name);
	  }
	}
      }
    }



  /* PLOT the field cross section */

  if(xm->plot_cont_flag == 1)
    {
    nx = xm->contParms.surf_grd->nx;
    ny = xm->contParms.surf_grd->ny;
    SLICE_pts = 2 * (nx + ny);
    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);

    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);
    
    
    slice_surf(xm->contParms.surf_grd, nx1, ny1,
	       nx2, ny2, rdis, fval, SLICE_pts);



    if(xs->field_style_flag == 0)
      {
      fprintf(inf, " %% plotting the field data above the main xsec plot  \n");
      miny = fval[0];
      maxy = fval[0];

      for(i = 0; i < SLICE_pts; i++)
	{

	/* fprintf(stderr,"xsec: %f %f \n", rdis[i],fval[i]); */
	miny = min2(fval[i], miny);
	maxy = max2(fval[i], maxy);
	}

      fprintf(inf, " /nbz { %f sub %f div inch } def\n", miny, maxy - miny);
      fprintf(inf, " 0 setgray newpath\n");
      fprintf(inf, " %f bx %f nbz moveto \n", rdis[0], fval[0]);

      for(i = 1; i < SLICE_pts; i++)
	fprintf(inf, " %f bx %f nbz lineto \n", rdis[i], fval[i]);

      fprintf(inf, " stroke  \n");
      fprintf(inf, "newpath %f bx %f nbz %f bx %f nbz bord stroke \n",
	      rdis[0], miny, rdis[SLICE_pts-1], maxy);
      fprintf(inf, "newpath %f bx %f nbz moveto (%g) rightshow    %%"
	      " max=%f\n", rdis[0], maxy, maxy, maxy);
      fprintf(inf, "newpath %f bx %f nbz moveto (%g) rightshow   %%"
	      " min=%f\n", rdis[0], miny, miny, miny);

      BB_LL_x-=.4*Inch2Points;
      BB_UR_y+=1.1*Inch2Points;
      

      }




    if(xs->field_style_flag == 1)
      {
      fprintf(inf, " %% plotting the field data in the main xsec plot  \n");
      fprintf(inf, " 0 setgray newpath\n");
      m2psXpoint(inf, xs,  rdis[0], fval[0]);

    

      for(i = 1; i < SLICE_pts; i++)
	 {
	 line2psXpoint(inf, xs,  rdis[i], fval[i]);
	}
      
      fprintf(inf, " stroke  \n");
      }

    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }

/***************************************************/
/***************************************************/

  /* PLOT the image cross section */
  if(xs->X_Image_Above == 1)
     {
     
  if(xm->image_flag == 1)
    {

    nx = xm->image.nx;
    ny = xm->image.ny;



    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);
    
     
    SLICE_pts =  (  fabs(nx2-nx1)/xm->image.dx +  fabs(ny2-ny1)/xm->image.dy );

    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);


    slice_surf_Image(xm, nx1, ny1,
	       nx2, ny2, rdis, fval, SLICE_pts);

      fprintf(inf, " %% plotting the field data above the main xsec plot  \n");
      miny = fval[0];
      maxy = fval[0];

      for(i = 0; i < SLICE_pts; i++)
	{

	/* fprintf(stderr,"xsec: %f %f \n", rdis[i],fval[i]); */
	miny = min2(fval[i], miny);
	maxy = max2(fval[i], maxy);
	}

      fprintf(inf, " /nbz { %f sub %f div inch } def\n", miny, maxy - miny);
      fprintf(inf, " 0 setgray newpath\n");
      fprintf(inf, " %f bx %f nbz moveto \n", rdis[0], fval[0]);

      for(i = 1; i < SLICE_pts; i++)
	fprintf(inf, " %f bx %f nbz lineto \n", rdis[i], fval[i]);

      fprintf(inf, " stroke  \n");
      fprintf(inf, "newpath %f bx %f nbz %f bx %f nbz bord stroke \n",
	      rdis[0], miny, rdis[SLICE_pts-1], maxy);
      fprintf(inf, "newpath %f bx %f nbz moveto (%g) rightshow    %%"
	      " max=%f\n", rdis[0], maxy, maxy, maxy);
      fprintf(inf, "newpath %f bx %f nbz moveto (%g) rightshow   %%"
	      " min=%f\n", rdis[0], miny, miny, miny);

      BB_LL_x-=.4*Inch2Points;
      BB_UR_y+=1.1*Inch2Points;
      

      

    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }
  }
  



  /* PLOT  Focal Mechanisms */

  if(xm->focm_flag > 1)
    {
    fprintf(inf, " /scalefocsiz { 1 } def \n");
    fprintf(inf, " /focsiz { 20 mul scalefocsiz mul } def \n");
    fprintf(inf, " /slip_vec_size { 1.7 } def\n");
    for(j = 0; j < xs->jselect; j++)
      {
      i = xs->focind[j];
      kount = xs->focind_file[j];

      if(!xm->focm[kount].focs[i].on_off)continue;

      px = xs->focpos[j].x1;
      py = xs->focpos[j].y1;

      /* get rid of focs outside of target */

      if(py < -xs->xdepth) continue;

      /* determine the correct size of the focal sphere   */

      focrad = xs->focrad[j];

      fprintf(inf, " /focsiz { %f mul scalefocsiz mul } def \n", focrad);
      fprintf(inf, " gsave \n");
      fprintf(inf, "/focfilcol { %f %f %f setcol1  } def\n",
	      xm->jmlcol[xm->focm[kount].focs[i].type].red,
	      xm->jmlcol[xm->focm[kount].focs[i].type].green,
	      xm->jmlcol[xm->focm[kount].focs[i].type].blue);

      if(xm->focal_explode >= 1)
	{
	px = xs->focpos[j].x2;
	py = xs->focpos[j].y2;
	qx = xs->focpos[j].x1;
	qy = xs->focpos[j].y1;

	fprintf(inf, " %f %f %f setcol1\n",
		xm->jmlcol[xm->focm[kount].focs[i].type].red,
		xm->jmlcol[xm->focm[kount].focs[i].type].green,
		xm->jmlcol[xm->focm[kount].focs[i].type].blue);
	
	m2psXpoint(inf, xs, px, py); 
	line2psXpoint(inf, xs, qx, qy); 
	fprintf(inf, "  stroke\n");

	}

      phirot = -xs->XSEC_angle;
      urot = xm->focm[kount].focs[i].fm.urot;
      udip = xm->focm[kount].focs[i].fm.udip;
      vrot = xm->focm[kount].focs[i].fm.vrot;
      vdip = xm->focm[kount].focs[i].fm.vdip;
      prot = xm->focm[kount].focs[i].fm.prot;
      pdip = xm->focm[kount].focs[i].fm.pdip;
      trot = xm->focm[kount].focs[i].fm.trot;
      tdip = xm->focm[kount].focs[i].fm.tdip;

      Rot_foc_phi(&phirot, &urot, &udip, &vrot, &vdip, &az1, &d1, &az2, &d2,
		  &prot, &pdip, &trot, &tdip);

      /* fprintf(inf, " %f %f %f %f %f %f %f %f \n",az1, d1,az2, d2, prot,
	 pdip, trot,tdip); */

      ipol = Get_polarity(az1, d1, az2, d2, prot, pdip, trot, tdip);
      putpsXpoint(inf, xs, px, py); 
      fprintf(inf, "  translate\n");

      switch(xm->focal_plot_style)
	{
	case 5:
	  /* plot only the fault plane */

	  fprintf(inf, " %f %f %f setcol1 \n",
		  xm->jmlcol[xm->focm[kount].focs[i].type].red,
		  xm->jmlcol[xm->focm[kount].focs[i].type].green,
		  xm->jmlcol[xm->focm[kount].focs[i].type].blue);

	  fprintf(inf, " %f %f justplane \n", az1, d1);

	  /* getfpshift_(&az1, &d1, &az2, &d2, &trot, &tdip, &p1, &p2, &fx,
	     &fy); */

	  Slip_Point(az2, d2, az1, d1, trot, tdip, &p1, &p2, &fx, &fy);

	  fprintf(inf, "newpath %f %f %f %f slip_point \n", p1, p2, fx, fy);
	  break;

	case 3:
	  /* P-Axis   */
	  fprintf(inf, "  setcolP     %%  P-axis\n");
	  fprintf(inf, " %f %f plPTax \n", prot, pdip);

	  /* T-Axis    this is in the dark region so paint it white */

	  fprintf(inf, "   setcolT     %%  T-axis \n");
	  fprintf(inf, " %f %f plPTax \n", trot, tdip);
	  break;			/* end PT axis  */

	case 7:
	  /* P-Axis   */
	  fprintf(inf, " %f %f %f setcol1 \n",
		  xm->jmlcol[xm->focm[kount].focs[i].type].red,
		  xm->jmlcol[xm->focm[kount].focs[i].type].green,
		  xm->jmlcol[xm->focm[kount].focs[i].type].blue);
	  fprintf(inf, " %f %f plPTax \n", prot, pdip);
	  break;			/* end PT axis  */

	case 8:
	  /* T-Axis    this is in the dark region so paint it white */

	  fprintf(inf, " %f %f %f setcol1 \n",
		  xm->jmlcol[xm->focm[kount].focs[i].type].red,
		  xm->jmlcol[xm->focm[kount].focs[i].type].green,
		  xm->jmlcol[xm->focm[kount].focs[i].type].blue);
	  fprintf(inf, " %f %f plPTax \n", trot, tdip);
	  break;			/* end PT axis  */

	default:
	  /*  insert this protection for the postscript code */
	    if(fabs(d1-90)<0.001) d1 = 90;
	    if(fabs(d2-90)<0.001) d2 = 90;
	    
	  fprintf(inf, " %f %f %f %f %d focu \n", az1, d1, az2, d2, ipol);

	  
	  if(xm->focal_plot_style == 2)
	    {
	    /* P-Axis   */

	    fprintf(inf, "  setcolP     %%  P-axis\n");
	    fprintf(inf, " %f %f plPax \n", prot, pdip);

	    /* T-Axis    this is in the dark region so paint it white */

	    fprintf(inf, "   setcolT     %%  T-axis \n");
	    fprintf(inf, " %f %f plTax \n", trot, tdip);
	    }

	  if(xm->focal_plot_style == 4)
	    {
	    /* plot only the fault plane  */

	    fprintf(inf, " 0 0 0 setcol1 \n");
	    fprintf(inf, " %f %f justplane \n", az1, d1);
	    }
	  break;
	}

      fprintf(inf, " grestore \n");
      }
    }

  /************* PLOT  Labels  LABELS labels*********************/

  /* PS ARROW: xtail ytail xhead yhead thickness_of_tail thickness_wide
     length_head */

  if(xs->num_labels >= 0)
    {
    fprintf(inf, "        %%  USER Labels    \n");
    fprintf(inf, "/Helvetica-Bold findfont 12 scalefont setfont 0 setgray\n");
    fprintf(inf, " 2 setlinewidth \n");
    for(i = 0; i <= xs->num_labels; ++i)
      {
      fprintf(inf, " newpath \n");
     putpsXpoint(inf, xs, xs->labels[i].kmloc.x1, xs->labels[i].kmloc.y1); 
     putpsXpoint(inf, xs, xs->labels[i].kmloc.x2, xs->labels[i].kmloc.y2); 
      fprintf(inf, "  2 10 16 arrow fill\n");

      fprintf(inf, "  (%s) " , xs->labels[i].label);
      m2psXpoint(inf, xs,xs->labels[i].kmloc.x1,
		 xs->labels[i].kmloc.y1); 
      fprintf(inf, "  cen_labshow \n" );

      /* if (xs->labels[i].kmloc.y1 < xs->labels[i].kmloc.y2)
	 fprintf(inf, " (%s) 12  %f bx %f bz utic \n", xs->labels[i].label,
	 xs->labels[i].kmloc.x1, -xs->labels[i].kmloc.y1);
	 else	fprintf(inf, " (%s) 12  %f bx %f bz btic \n",
	 xs->labels[i].label,	xs->labels[i].kmloc.x1,
	 -xs->labels[i].kmloc.y1); */
      }

    fprintf(inf, " .2 setlinewidth \n");
    }

  fprintf(inf, "\n\n grestore \n");

  fprintf(inf, "\nJML_END \n");
  fprintf(inf, "\n\n%%END PAGE\n");
  fprintf(inf, "%%%%Trailer\n");

/* add a border around the plot 0.5inch = 36points */

  BB_LL_x-=0.4*Inch2Points;
  BB_LL_y-=0.5*Inch2Points;
  BB_UR_x+=0.8*Inch2Points;   /* this is to get the labels */
  BB_UR_y+=0.4*Inch2Points;


/* landscape mode is on may need to do this stuff:  */

 /* here we need to rotate the bbox because of landscape mode  */
/* first subtract 8.5 inch from x */


/*
  BB_LL_y-=612;
  BB_UR_y-=612;
  

  a=BB_LL_x;
  BB_LL_x=-BB_LL_y;
  BB_LL_y=a;
  
  a=BB_UR_x;
  BB_UR_x=-BB_UR_y;
  BB_UR_y=a;
fprintf(stderr,"BBOX: %d %d %d %d\n", BB_UR_x , BB_LL_y,BB_LL_x, BB_UR_y);

 */




  fprintf(stderr,"BBOX: %d %d %d %d\n", BB_LL_x , BB_LL_y, BB_UR_x, BB_UR_y);


  
  fprintf(inf, "%%%%BoundingBox: %d %d %d %d\n",  BB_LL_x , BB_LL_y, BB_UR_x, BB_UR_y );

  fprintf(inf, "            %%       full page  BBox: 0 0 612 792\n");
  fprintf(inf, "%%%%EOF \n");
 
  fclose(inf);

  fprintf(stderr," \n DONE CREATING POST-SCRIPT: \n  Submit job by typing> lpr %s\n\n",
	 ps_file);
  }
