#ifndef _pickfile_h
#define _pickfile_h

#define NPHASES 200
#define NCOMMENTS 50
#define TOT_NUM_STA 1000

/* One record in a ".ac" (Acards) files */

typedef struct
  {
  char type[2];
  char id[13];	/* Date/Time it happened */
  float sec;		/* Second it happened */
  float phi, lam;
  int lat1, lat2, lon1,lon2; 
  float depth;
  float mag;
  int nump;
  int nums;
  int gap;
  int delta;
  float rms;
  float err;
  char q1[2], q2[2], Fix[2];
  char modid[3];
  char NS[2], EW[2], JU[2];
  char unique_id[100];
  
  } ac_rec;

/* ---------------------------------------------------------------- */

typedef struct
  {
  char type[2];
  char Vel[3];
  float rms, MeanRMS, SDabout0, SDaboutMean, SSWRES, SDx, SDy, SDz, SDt, Mag,
    StErrMag, MeanUncert;
  int NDFR;
  char FIX[5];
  } UW_ac_err;

/* ---------------------------------------------------------------- */

typedef struct
  {     
  float strk1, dip1, strk2, dip2;
  float urot, udip, vrot, vdip;
  float prot, pdip, trot, tdip;
  float rake;
  } Mech;

typedef struct
  {
  char type;
  char name[5];
  int dur, weight;
  char phs1[2], phs2[2];
  char pol[3];
  float sec1, sec2;
  char used1[2], used2[2];
  float prec1, prec2;
  float res1, res2;
  } UWphase_card;


typedef struct
  {
  char *com;
  } Comment;

typedef struct 
  {
  ac_rec ac;
  UW_ac_err err;
  Mech  mech;
  UWphase_card phs[NPHASES];
  Comment cmt[NCOMMENTS];
  int Num_phase, Num_com;
  } UWPICKFILE;
     
/*********************************************************/

/* One record in UW station file files */

typedef struct
  {
  char name[5];  
  float lat1, lat2, lon1, lon2;
  float elevation;
  char NS, EW;
  } station_rec;

typedef struct
  {
  station_rec sta[TOT_NUM_STA];
  } Station_file;

typedef struct
{
  int type, proj;
  float phi, lam;
  float dx,dy;
  float phimin, phimax, lammin, lammax;
  float phi0, lam0, phi1, lam1,  phi2, lam2;
  int nxblk, nyblk, nzblk;
  float *tops;
  float minx, maxx, miny, maxy;
} ORG;

/*****************************************************/

typedef struct
  {
  char name[5];
  char prmk[3],srmk[3];
  char ppol[2];
  int pwgt, yy,mo,dd,hr,mn;
  float psec;
  float pres, pwgt_used;
  float ssec;
  int swgt;
  float sres, ppamp, swgt_used, pdel, sdel;
  float dist, incang, clock;
  char starmk[2];
  float dur, az,mag_dur,mag_amp, pimp, simp;
  } HINVphas_card;

/***************/

typedef struct
  {
  char type;
  int  yy, mo, dd, hr, mn;   /* date */
  float sec;		/* Second it happened */
  float phi, lam;
  float latdeg, latmin, londeg,lonmin; 
  float depth;
  float ampmag;
  int nump;
  int nums;
  float gap;
  float delta;
  float rms;
  float az_serr, dip_serr, mag_serr;
  float az_ierr, dip_ierr, mag_ierr;
  float mag_dur;
  char remark[4];
  float large_err;
  float hoz_err, vert_err;
  int numpmotion;
  char NS[2], EW[2];
  } HINVsum_card;

typedef struct
  {
  HINVsum_card sum;
  int Num_phase;
  HINVphas_card phas[NPHASES];
  } HINV_REC;

/*   example UW format record 
A 8005190021 63.19 46N1346 122W1150 17.39  2.1 14/016  86 12 0.08  0.6AA S3
E S3  0.08 0.151 0.089 0.167    4.11  12      0.24 0.24 0.63 0.05 2.13     0.14
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7.$..|....8
 SFT    0 P-  66.77 0 0.03-0.02 S   69.78 2 0.11 0.18
 APE    0 P   66.93 2 0.07 0.02
 CDF    0 PCn 67.17 0 0.02-0.00 S   70.21X4 0.31-0.07
 MTM   45 PDn 67.88 0 0.01 0.01 S   71.41X4 0.18-0.10
 LVP    0 P   68.06 1 0.04-0.06
 RAN    0 P   69.26 0 0.02 0.00
 COW    0 PCn 69.25 0 0.01-0.03
 CMM    0 PDn 69.42 0 0.02-0.00 S   74.22 2 0.15-0.06
*/

#endif /* _pickfile_h */
