/* --- feature switches --- */
 
#define _POSIX_SOURCE 1
 
#include "geotouch.h"

#include "jutil.h"



/* --- system headers ---*/
#define sgn(N)          (((N) >= 0) ? (((N) > 0) ? 1 : 0) : -1)
/******************************************/
int gintersect(fxyxy a, fxyxy b, fxy *c)
  {
  double ma, mb, ba, bb;

  if(a.x1 != a.x2 && b.x1 != b.x2)
    {
    ma = (a.y2 - a.y1) / (a.x2 - a.x1);
    ba = a.y1 - ma * a.x1;
    mb = (b.y2 - b.y1) / (b.x2 - b.x1);
    bb = b.y1 - mb * b.x1;
    if(ma == mb && ba != bb) return(5);
    if(ma == mb && ba == bb)
      {
      c->x = a.x1;
      c->y = a.y1;
      return(3);
      }

    c->x = (ba - bb) / (mb - ma);
    c->y = (ba * mb - bb * ma) / (mb - ma);
    if(((c->x < a.x1) && (c->x < a.x2)) ||
       ((c->x > a.x1) && (c->x > a.x2))) return(-1);
    return(0);
    }

  if((a.x1 == a.x2) && (b.x1 == b.x2) && (a.x1 != b.x1))
    return(6);	/* both slopes are infinite  */

  if((a.x1 == a.x2) && (b.x1 == b.x2) && (a.x1 == b.x1))
    {
    c->x = a.x1;
    c->y = a.y1;
    return(4);
    }

  if(a.x1 == a.x2 && b.x1 != b.x2)
    {
    mb = (b.y2 - b.y1) / (b.x2 - b.x1);
    bb = b.y1 - mb * b.x1;
    c->x = a.x1;
    c->y = mb * a.x1 + bb;

    if(((c->y < a.y1) && (c->y < a.y2))
       || ((c->y > a.y1) && (c->y > a.y2))) return(-1);
    return(1);
    }

  if(a.x1 != a.x2 && b.x1 == b.x2)
    {
    ma = (a.y2 - a.y1) / (a.x2 - a.x1);
    ba = a.y1 - ma * a.x1;
    c->x = b.x1;
    c->y = ma * b.x1 + ba;

    if(((c->x < a.x1) && (c->x < a.x2))
       || ((c->x > a.x1) && (c->x > a.x2))) return(-1);
    return(2);
    }
  return(-1);
  }
/******************************************/
int poly_line(float **poly, int n2, fxyxy linb, float *ctempx, float *ctempy)
  {
  int i, m, flag;
  float minx, miny, maxx, maxy;
  fxyxy lina;
  fxy pointc;

  minx = min2(linb.x1, linb.x2);
  maxx = max2(linb.x1, linb.x2);
  miny = min2(linb.y1, linb.y2);
  maxy = max2(linb.y1, linb.y2);

  for(i = 0, m = 0; i < n2; i++)
    {
    lina.x1 = poly[i][0];
    lina.y1 = poly[i][1];
    lina.x2 = poly[i + 1][0];
    lina.y2 = poly[i + 1][1];

    /* lina is the polygon    linb is the directional vector */

    flag = gintersect(lina, linb, &pointc);
    if((flag >= 5) || (flag < 0))
      {
      /* fprintf(stderr, "No intersection\n"); */
      continue;
      }

    /* fprintf(stderr, "flag=%d a: %f %f %f %f b: %f %f %f %f\n", flag,
       lina.x1,	lina.y1, lina.x2, lina.y2, linb.x1, linb.y1, linb.x2,
       linb.y2); */                  

    if((pointc.x >= minx) && (pointc.x <= maxx) && (pointc.y >= miny)
       && (pointc.y <= maxy))
      {
      /* fprintf(stderr, "intersection 2: %f %f \n", pointc.x, pointc.y); */

      ctempx[m] = pointc.x;
      ctempy[m] = pointc.y;
      m++;
      }
    }
  return(m);
  }

/******************************************/
void xprod(float u[3], float v[3], float ans[3])
   {
   ans[0]=u[1]*v[2]-u[2]*v[1];
   ans[1]=u[2]*v[0]-u[0]*v[2];
   ans[2]=u[0]*v[1]-u[1]*v[0];
   }

 float normalize(float *perp, int len)
  {
  int i;
  double sum = 0.0;
 
  for(i = 0; i < len; i++) sum += (perp[i] * perp[i]);
  if(sum <= 0.0) return(0.0);
 
  sum = sqrt(sum);
  for(i = 0; i < len; i++) perp[i] /= sum;
  return(sum);
  }

 float rms(float *perp, int len)
  {
  int i;
  double sum = 0.0;
 
  for(i = 0; i < len; i++) sum += (perp[i] * perp[i]);
  if(sum <= 0.0) return(0.0);
 
  sum = sqrt(sum);
 
  return(sum);
  }

void Matrix_4Mult(float **a, float **b, float **ans)
   {  /* matrix multiplication of 4 by 4 matricies a*b=ans  */
   
   int i, j, k;
   double sum;

   for(i = 0; i < 4; i++)
      {
      for(k=0; k<4; k++)
	 {
	 sum = 0;
	 for(j = 0; j < 4; j++)
	    {			
	    sum += a[i][j] * b[j][k];
	    }
	 ans[i][k] = (float)sum;
	 }

      }
  


   }

void Proj_Points(float **a, int n, float **M, float **ans)
   {
   
   int i, j, k;
   double sum;

   for(i = 0; i < n; i++)
      {
      for(k=0; k<4; k++)
	 {
	 sum = 0;
	 for(j = 0; j < 4; j++)
	    {
	    sum += a[i][j] * M[j][k];
	    }
       
	 ans[i][k] = (float)sum;
	 }
    
      }


   }

void dumpmat( char *name, float **M1)
   {
   int i;
   
   fprintf(stderr, "%s\n", name); 
  
  for(i=0; i<4; i++) fprintf(stderr, "%d %f %f %f %f\n",i, M1[i][0],M1[i][1], M1[i][2],M1[i][3]);
   }


/* --- local headers --- */
int goget_intersex(float **p1 , int n1, float **p2, int n2, fxyxy *finline)
  {

  int i,  j;
  
  float **T1, **Rx, **Ry, **tem, **M1;
  float u[3], v[3], dir[3];
  float dlen;
  float **augp1, **augp2;
   float **P1, **P2;
  float d, a;
  
  
  
  /* first get the new Z vector direction.  
     use the first point as an origin for the projection  
   */

  augp1 = alloc_fmat(0, n1+1, 0, 3);
 tem = alloc_fmat(0, 3, 0, 3);
 M1 = alloc_fmat(0, 3, 0, 3);
 T1 = alloc_fmat(0, 3, 0, 3);
 Rx = alloc_fmat(0, 3, 0, 3);
 Ry = alloc_fmat(0, 3, 0, 3);


  for(i=0; i<n1; i++)
     {
     augp1[i][0] = p1[i][0];
     augp1[i][1] = p1[i][1];
     augp1[i][2] = p1[i][2];
     augp1[i][3] = 1.0;
     }
     augp1[i][0] = p1[0][0];
     augp1[i][1] = p1[0][1];
     augp1[i][2] = p1[0][2];
     augp1[i][3] = 1.0;  
  

  augp2 = alloc_fmat(0, n2+1, 0, 3);

  for(i=0; i<n2; i++)
     {
     augp2[i][0] = p2[i][0];
     augp2[i][1] = p2[i][1];
     augp2[i][2] = p2[i][2];
     augp2[i][3] = 1.0;
     }
     augp2[i][0] = p2[0][0];
     augp2[i][1] = p2[0][1];
     augp2[i][2] = p2[0][2];
     augp2[i][3] = 1.0;  
  

  v[0]= p1[1][0]-p1[0][0];
  v[1]= p1[1][1]-p1[0][1];
  v[2]= p1[1][2]-p1[0][2];
  
  u[0]= p1[n1-1][0]-p1[0][0];
  u[1]= p1[n1-1][1]-p1[0][1];
  u[2]= p1[n1-1][2]-p1[0][2];
  
  xprod(v,u,dir);
  dlen=normalize(dir, 3);
 
  
  /* fprintf(stderr, "dir: %f %f %f\n", dir[0] , dir[1], dir[2]); */
  
/********Translation Matrix to top left corner of section*******/

/* this is set up to assume the cross section is vertical and
   is taken at the surface = this can be changed later.... */

  T1[0][0]=1;
  T1[0][1]=0;
  T1[0][2]=0;
  T1[0][3]=0;

  T1[1][0]=0;
  T1[1][1]=1;
  T1[1][2]=0;
  T1[1][3]=0;

  T1[2][0]=0;
  T1[2][1]=0;
  T1[2][2]=1;
  T1[2][3]=0;

  T1[3][0]=-p1[0][0];
  T1[3][1]=-p1[0][1];
  T1[3][2]=0;
  T1[3][3]=1;
/* the zero in T1[3,2]=0 is the surface option  */
/***************/

/*******Rotation about X axis Rx********/

  d = sqrt(dir[1]*dir[1] +dir[2]*dir[2]);


  Rx[0][0]=1;
  Rx[0][1]=0;
  Rx[0][2]=0;
  Rx[0][3]=0;

  Rx[1][0]=0;
  Rx[1][1]=dir[2]/d;
  Rx[1][2]=dir[1]/d;
  Rx[1][3]=0;

  Rx[2][0]=0;
  Rx[2][1]=-dir[1]/d;
  Rx[2][2]=dir[2]/d;
  Rx[2][3]=0;

  Rx[3][0]=0;
  Rx[3][1]=0;
  Rx[3][2]=0;
  Rx[3][3]=1;

/*******Rotation about Y axis Ry********/

  Ry[0][0]=d;
  Ry[0][1]=0;
  Ry[0][2]=dir[0];
  Ry[0][3]=0;

  Ry[1][0]=0;
  Ry[1][1]=1;
  Ry[1][2]=0;
  Ry[1][3]=0;

  Ry[2][0]=-dir[0];
  Ry[2][1]=0;
  Ry[2][2]=d;
  Ry[2][3]=0;

  Ry[3][0]=0;
  Ry[3][1]=0;
  Ry[3][2]=0;
  Ry[3][3]=1;

/***************/

/*  form the projection matrix M1_T1 %*% Rx %*% Ry
*/
 
/*
 
dumpmat("T1" , T1);
  dumpmat("Rx" , Rx);
  dumpmat("Ry" , Ry);
  */

  Matrix_4Mult(Rx , Ry, tem);

 /*  dumpmat("tem" , tem); */
 
  Matrix_4Mult( T1 , tem, M1);

 /*  dumpmat("Projection Matrix" , M1); */
  
 

  P1 = alloc_fmat(0, n1+1, 0, 3);
  P2 = alloc_fmat(0, n1+1, 0, 3);

  Proj_Points(augp1, n1+1, M1, P1);

/*
  fprintf(stderr,"*******    Projected augp1  ****\n");
  for(i=0; i<(n1+1); i++)
     {
     fprintf(stderr,"%d %f %f %f %f\n", i, augp1[i][0],augp1[i][1], augp1[i][2],augp1[i][3]);
     }
  
  fprintf(stderr,"*******    Projected P1  ****\n");
  for(i=0; i<(n1+1); i++)
     {
     fprintf(stderr,"%d %f %f %f %f\n", i, P1[i][0],P1[i][1], P1[i][2],P1[i][3]);
     }
*/
  
  Proj_Points(augp2, n2+1, M1, P2);
 
/*
  fprintf(stderr,"*******    Projected P2  ****\n");
  for(i=0; i<(n2+1); i++)
     {
     fprintf(stderr,"%d %f %f %f %f\n", i, P2[i][0],P2[i][1], P2[i][2],P2[i][3]);
     }
 */

#if 0

/* better do the cross product thing here to see 
   if the line is correct  */

  v[0]= P2[0][0]-P2[1][0];
  v[1]= P2[0][1]-P2[1][1];
  v[2]= P2[0][2]-P2[1][2];
  
  u[0]= P2[2][0]-P2[1][0];
  u[1]= P2[2][1]-P2[1][1];
  u[2]= P2[2][2]-P2[1][2];
  
  xprod(v,u,w);

  u[0]= 0;
  u[1]= 0;
  u[2]= 1;
  
  xprod(w,u,v);
/* v now is parallel to the line of intersection  */

  /*  first check to make sure the new plane does intersect plane */
 for(i=0, j=0; i<(n2); i++)
#endif




  for(i=0, j=0; i<(n2); i++)
     {
     if(sgn(P2[i][2]) == sgn(P2[i+1][2])) continue;
     dir[0] = P2[i+1][0]-P2[i][0];
     dir[1] = P2[i+1][1]-P2[i][1];
     dir[2] = P2[i+1][2]-P2[i][2];
     /* fprintf(stderr,"dir: %f %f %f\n", dir[0],dir[1],dir[2]); */ 
     if(dir[2]==0) continue;
     
     a = rms(dir, 3);
     /* d=a*fabs(P2[i][2])/fabs(dir[2]); */

    d=a*fabs(P2[i][2])/fabs(dir[2]);


    /*  fprintf(stderr,"%d %d %f %f\n", i, j, a, d); */
     
  u[0]= P2[i][0]+d*dir[0]/a;
  u[1]= P2[i][1]+d*dir[1]/a;
  u[2]= P2[i][2]+d*dir[2]/a;
     j++;
     if(j==1)
	{
	finline->x1= u[0];
	finline->y1= u[1];
	}
      if(j==2)
	{
	finline->x2= u[0];
	finline->y2= u[1];
	}
         
    
     }

 /* change the sign of all the coords if
the cross section is taken right to left  - i don't know why we need this, but we do*/
 if( p1[0][0] > p1[1][0] )

     {
     finline->x1=-finline->x1;
     finline->y1=-finline->y1;
     finline->x2=-finline->x2;
     finline->y2=-finline->y2;
     }
  
#if 0
/* test to see if this is parallel to v  */

if(j>1)
   {
   
  u[0]= finline->x2-finline->x1;
  u[1]= finline->y2-finline->y1;
  u[2]= 0;
  xprod(v,u,w);

  fprintf(stderr, "test (should all be zero): %f %f %f\n", w[0], w[1], w[2]);
  }
  
#endif

  
/*   fprintf(stderr,"Done\n"); */
/*  fprintf(stderr,"answer: %d %f %f %f %f\n", j, finline->x1, finline->y1, finline->x2, finline->y2); */
  
  
  free_fmat(P1,(long)0,(long)(n1+1),(long)0,(long)3);
  free_fmat(P2,(long)0,(long)(n2+1),(long)0,(long)3);
  free_fmat(augp1,(long)0,(long)(n1+1),(long)0,(long)3);
  free_fmat(augp2,(long)0,(long)(n2+1),(long)0,(long)3);
 free_fmat(tem,(long)0,(long)(3),(long)0,(long)3);
 free_fmat(M1,(long)0,(long)(3),(long)0,(long)3);
 free_fmat(T1,(long)0,(long)(3),(long)0,(long)3);
 free_fmat(Rx,(long)0,(long)(3),(long)0,(long)3);
 free_fmat(Ry,(long)0,(long)(3),(long)0,(long)3);

  return(j);
  
  }

