
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"

/* --- functions --- */

/* take a double number and make a char string for labeling on graphs */

void prep_d2lab(double dg, char *output)
  {
  double df, rl, mant, intpart;
  char form1[100];
  int j, k;

  df = fabs(dg);
  if(df == 0.0)
    {
    sprintf(output, "0");
    return;
    }
  rl = log10(df);
  mant = modf(rl, &intpart);

  sprintf(output, "%.6f", df);
  k = strlen(output);
  for(j = k - 1; j > 0; j--)
    {
    /* fprintf(stderr, "|%c| ",output[j]); */
    if(output[j] != '0' && output[j] != ' ')
      {
      if(output[j] == '.')
	{
	j++;
	break;
	}
      break;
      }
    }

  if(df > 1.0 && j <= 2) j++;

  /* fprintf(stderr,"\nprep_label: %s k=%d j=%d\n",output,k,j); */

  if(intpart > -2 && intpart < 5)
    {
    if(dg < 0.0) ++j;
    sprintf(form1, "%%.%dG", j);
    sprintf(output, form1, dg);
    }
  else
    {
    if(j < 4) sprintf(form1, "%%.%de", j);
    else sprintf(form1, "%%.4e");
    sprintf(output, form1, dg);
    }

  /* fprintf(stderr,"final label: %s intpart=%5.0f\n",output, intpart); */
  }
