/*
 * ---------------------------------------------------------------------------
 * rotwidgetP.h - Private definitions for RotateWidget
 *
 * Mark Lindner - 2/10/96
 * ---------------------------------------------------------------------------
 */

#ifndef _rotwidgetP_h
#define _rotwidgetP_h

#include <X11/CoreP.h>

#include "rotwidget.h"

/* New fields for the LinePlot widget class record */

typedef struct
  {
  int dummy;
  } RotateClassPart;

/* Full class record declaration */

typedef struct _RotateClassRec
  {
  CoreClassPart core_class;
  RotateClassPart rotate_class;
  } RotateClassRec;

/* New fields for RotateWidget instance record */

typedef struct
  {
  /* resources */
  Pixel	foreground;
  Pixel background;
  XtCallbackList callback; /* probably don't need this */
  String font_name;
  float xr;
  float yr;
  float zr;
  float x0;
  float y0;
  float z0;
  float radius; /* this is no longer supported */
  ptset_t *pointset;
  ptset_t *lineset;
  ptset_t *ctr;
  axes_t *axes;
  float minx, maxx, miny, maxy, minz, maxz;
    /* maximums and minimums for autoscaling */
  float xaa, yaa, zaa; /* axis angles */
  int flags; /* special action flags */

  /* private state */
  XFontStruct *font_info;
  ptset_t ppointset; /* saved pointer to pointset (get it out of reclist) */
  ptset_t plineset; /* saved pointer to lineset (get it out of reclist) */
  ptset_t lpointset; /* contains cumulatively-rotated points */ 
  ptset_t llineset; /* contains cumulatively-rotated wireframe points */
  ptset_t container; /* container */
  float x_scl, y_scl; /* pixel to cartesian scaling */
  float matrix[3][3]; /* rotation matrix */
  float xrr, yrr, zrr; /* rotation angles in radians */
  Boolean pointsetf, linesetf; /* flags */
  GC draw_gc, undraw_gc;
  XPoint *points; /* cached points for redraw */
  XPoint *lines; /* cached points for lines for redraw */
  Colormap colors;
  Visual visual;
  unsigned long pixelvals[32];
  } RotatePart;

/*
 * Full instance record declaration
 */

typedef struct _RotateRec
  {
  CorePart core;
  RotatePart rotate;
  } RotateRec;

/* declare external class record */

extern RotateClassRec rotateClassRec;

#endif /* _rotwidgetP_h */
