
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

/*
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h> */

#include <ctype.h>

/* --- local headers --- */

#include "geotouch.h"
#include "xlext.h"
#include "mpic.h"
#include "Gen.h"
#include "xsec.h"
#include "jutil.h"
#include "focproto.h"
#include "colorquant.h"
#include "user2pix.h"

/* --- macros --- */

#define MAXCOLORS 256

/* --- global variables --- */

extern XtAppContext apcon;
/*
static int gscr_num;
int default_depth;
static float xs_dip, min_xsdepth, max_xsdepth, max_xsfront, max_xsback;
*/

/* --- typedefs --- */

typedef fxy fpoint;

/* --- function prototypes --- */

float ps_kmx(float x, float xorg);
float ps_kmy(float y, float yorg);
void Hypos_2_File(mpic *mplot, char *source_file, int append);
void Hypo_Stats(Widget wij, mpic *mplot, char *call_data);
bool_t readac(FILE *f, ac_rec *a);


void citoxyz(int nx, int ny, int nlay, int iway, int *i, int *ix, int *iy,
	     int *iz);
void Scale_Image_Layer(mpic *m);
void Scale_Image_Global(mpic *m, float max, float min);
void flip_color_palette(mpic *m);
void change_palette_colors(mpic *m);
void cut_image(xsec *xs);
void break_line(char *line, int *fake_argc, char **fake_argv);
void  dump_color_scheme(mpic *oneplot);
int inside(fpoint t, fpoint *p, int N);

/* --- functions --- */

Boolean rgbplot_read_rawA(const char *file, rgbimage_t *plot)
  {
  FILE *fp;
  unsigned int *rp, *gp, *bp, size;
  int r, g, b, i;
  char text[80], dumc[2], reg[3];
  float x1, y1;
  enum { UL, LL, UR, LR, CE };

  if(!(fp = fopen(file, "r"))) return(FALSE);
  fgets(text, 79, fp);

  sscanf(text, "%c %i %i %f %f %f %f %f %f %s\n", dumc,  &(plot->sx),
	 &(plot->sy), &(plot->lat), &(plot->lon), &x1, &y1, &(plot->dx),
	 &(plot->dy), reg);

  strcpy(plot->regis, reg);

  if(strstr(reg, "UL")) plot->regisflag = UL; 
  else if(strstr(reg, "LL")) plot->regisflag = LL;
  else if(strstr(reg, "UR")) plot->regisflag = UR;
  else if(strstr(reg, "LR")) plot->regisflag = LR;
  else if(strstr(reg, "CE")) plot->regisflag = CE;

  size = plot->sx * plot->sy;
  fprintf(stderr, "%d %d %d\n", size ,plot->sx, plot->sy);
  fprintf(stderr, "%f %f %f %f\n", plot->lat, plot->lon, plot->dx, plot->dy);

  plot->ir = (unsigned int *)XtCalloc(size, sizeof(unsigned int));
  plot->ig = (unsigned int *)XtCalloc(size, sizeof(unsigned int));
  plot->ib = (unsigned int *)XtCalloc(size, sizeof(unsigned int));

  for(rp = plot->ir, gp = plot->ig, bp = plot->ib, i = 0;
      i< size;  i++, rp++, gp++, bp++)
    {
    fscanf(fp,"%d %d %d", &r, &g, &b);

    *rp = (unsigned int)r;
    *gp = (unsigned int)g;
    *bp = (unsigned int)b;
    /* if(i<10) fprintf(stderr,"%d %d %d\n", r, g, b); */
    }

  fclose(fp);

#if 0
  if(i >= 0)
    {
    XtFree((char *)plot->ir);
    XtFree((char *)plot->ig);
    XtFree((char *)plot->ib);
    return(FALSE);
    }
  
#endif

  return(TRUE);
  }
/***************************************************/
void sat_image(mpic *mplot)
  {
  qcolor_t  *colors;
  char inputfile[500];
  rgbimage_t IMAGE;
  unsigned int K = 110, *pixels, e, i, j, n, size;
  int x, y, c, cpix, gscr_num;
  XColor xcol, co;
  Colormap gcol, oldcmap;
  Display *gdisp;
  XVisualInfo vis;
  unsigned long *pix;
  static unsigned long subpix[MAXCOLORS-140];
  static Boolean init = TRUE;

  if(init == TRUE)
    {
    init = FALSE;
    for(i = 0; i < MAXCOLORS - 140; i++)
      subpix[i] = i + 140;
    }

  gdisp = XtDisplay(mplot->wij);
  gscr_num = DefaultScreen(gdisp);
  oldcmap = DefaultColormap(gdisp, gscr_num); 

  if(!XMatchVisualInfo(gdisp, gscr_num, DefaultDepth(gdisp, gscr_num),
		       PseudoColor, &vis))
    {
    printf("visual info match failed.\n");
    exit(-1);
    }

  gcol = XCreateColormap(gdisp, XtWindow(mplot->wij), vis.visual, AllocNone);
  pix = XmapNewArray(unsigned long, MAXCOLORS);

  if(!XAllocColorCells(gdisp, gcol, False, NULL, 0, pix, MAXCOLORS))
    {
    printf("colorcell allocation failed.\n");
    exit(-1);
    }

  XtVaSetValues(mplot->wij, XtNcolormap, gcol, NULL);

  fprintf(stderr, "Type in the input file:\n");
  fscanf(stdin, "%s", inputfile);

  if(rgbplot_read_rawA(inputfile, &IMAGE))
    {
    /* XtVaSetValues(rgb, XtNimage, &IMAGE, NULL); */
    size = IMAGE.sx * IMAGE.sy;

    if(!(e = CQ_Quantize(IMAGE.sx, IMAGE.sy, &K, &colors, IMAGE.ir, IMAGE.ig,
			 IMAGE.ib, &pixels)))
      fprintf(stderr, "error occurred\n");
    else
      {
      fprintf(stderr, "image quantized....K=%d\n", K);

      for(j = 0; j < 255; j++)
	{
	co.pixel = mplot->colors[j];
	pix[j] = mplot->colors[j];
	XQueryColor(gdisp, oldcmap, &co);
	XStoreColor(XtDisplay(mplot->wij), gcol , &co);

	/* fprintf(stderr, "old %d pix=%ld R=%d G=%d B=%d\n", j, mplot->colors[j], */
/* 		co.red, co.green, co.blue); */
	}

      /* XFreeColors(gdisp, oldcmap, subpix, MAXCOLORS - 140, 0); */

      xcol.flags = (DoRed | DoGreen | DoBlue);

      for(j = 0, n = 140; j < K; j++, n++)
	{
	xcol.pixel = n;

	xcol.red = (short)(colors[j].r * 256);
	xcol.green = (short)(colors[j].g * 256);
	xcol.blue = (short)(colors[j].b * 256);  
        pix[n] = xcol.pixel;
	/*
	fprintf(stderr,"%d %d = %d %d %d : %d %d %d", j, n, colors[j].r,
		colors[j].g, colors[j].b, xcol.red, xcol.green,xcol.blue);
	fprintf(stderr,"\n");
	*/

	/* XStoreColor(XtDisplay(mplot->wij), oldcmap, &xcol);
	   XAllocColor(XtDisplay(mplot->wij), oldcmap, &xcol); */
	}

      mplot->colors = pix;

      /* gcol = DefaultColormap(gdisp, gscr_num); */

      for(j = 0; j < 255; j++)
	{
	co.pixel = mplot->colors[j];
	XQueryColor(gdisp, oldcmap, &co);
	/*
	fprintf(stderr, "new %d pix=%ld R=%d G=%d B=%d\n", j, mplot->colors[j],
		co.red, co.green, co.blue);
		*/
	}

      /* XtVaSetValues(mplot->wij, XtNcolormap, gcol, NULL); */
         
      for(c = 0, y = 0; y < IMAGE.sy; y++)
        for(x = 0; x < IMAGE.sx; x++, c++)
	  {
	  cpix = (int)(pixels[c] + 139);
	  if(c < 50)
	    fprintf(stderr, "%d pix=%d colmappix=%ld\n", c, pixels[c], pix[cpix]);
	  XSetForeground(XtDisplay(mplot->wij), mplot->ggc,
			 XmapQuantColor(pixels[c]));
	  /* XSetForeground(XtDisplay(mplot->wij), mplot->ggc, pixels[c]); */
	  XDrawPoint(XtDisplay(mplot->wij), XtWindow(mplot->wij), mplot->ggc, x,
		     y);
	  }
      }
    }
  else puts("\a\aCan't read file.");
  }
/***************************************************/
/***************************************************/
void get_sat_image(char *inputfile, jml_image *jml)
  {
  qcolor_t *colors;
  rgbimage_t IMAGE;
  unsigned int K, *pixels, e, size;

  K = COLORS_MAX - (COLORS_WM + COLORS_APP);
  
  
  if(rgbplot_read_rawA(inputfile, &IMAGE))
    {
    size = IMAGE.sx * IMAGE.sy;

    if(!(e = CQ_Quantize(IMAGE.sx, IMAGE.sy, &K, &colors, IMAGE.ir, IMAGE.ig,
			 IMAGE.ib, &pixels)))
      fprintf(stderr, "error occurred\n");
    else
      {
      fprintf(stderr, "get_sat_image image quantized....K=%d\n", K);
      fprintf(stderr, "get_sat_image Sat Image Params: %d %d %d %f %f %f %f\n", IMAGE.sx,
	      IMAGE.sy, K, IMAGE.lat, IMAGE.lon, IMAGE.dx, IMAGE.dy); 
      jml->colors = colors;
      jml->K = K;
      jml->pixels = pixels;
      jml->sx = IMAGE.sx;
      jml->sy = IMAGE.sy;
      jml->dy = IMAGE.dy;
      jml->dx = IMAGE.dx;
      jml->lat = IMAGE.lat;
      jml->lon = IMAGE.lon;
      jml->regisflag = IMAGE.regisflag;
      strcpy(jml->regis, IMAGE.regis);
      fprintf(stderr, "Sat Image Params: regis = %s   regisflag=%d\n",
	      jml->regis, jml->regisflag);
      }
    }
  else puts("\a\aCan't read file.");
  }








