
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

/* --- local headers --- */

#include "geotouch.h"
#include "jutil.h"


void Get_Great(double lat1, double lon1, double lat2, double lon2, int num, double *phi2, double *lam2 );
double great_dist(double phi1, double lam0, double phi, double lam);
int Inpoly(float x, float y, int num, float **poly);

void GC_intersection(double deglat1, double deglon1, double deglat2, double deglon2,
				 double deglat3, double deglon3, double deglat4, double deglon4,
		     double *elat1, double *elon1, double *elat2, double *elon2);

int GC_X_LAT(double deglat1, double deglon1, double deglat2, double deglon2, 
	     double LAT, double phi[2], double lam[2] );

int In_SphereRect(double  minlat1, double minlon1, double maxlat2, double maxlon2, double pntlat,  double pntlon);


void jindexD(unsigned long n, double  arr[], int  indx[]);


/* --- macros --- */

#define MAX_SLICEWIDTH 300

/* --- functions --- */

int xasc(const void *x, const void *y)
  {
  int i;
  float *a = (float *)x, *b = (float *)y;

  if(*a > *b) i = 1;
  else if(*a == *b) i = 0;
  else i = -1;

  return(i);
  }

int xdsc(const void *x, const void *y)
  {
  int i;
  float *a = (float *)x, *b = (float *)y;

  if(*a > *b) i = -1;
  else if(*a == *b) i = 0;
  else i = 1;

  return(i);
  }

void revarr(float *x, int num)
  {
  int i;
  float *f;

  f = alloc_fvec(0, num);
  for(i = 0; i < num; i++) f[i] = x[i];
  for(i = 0; i < num; i++) x[i] = f[num - i - 1];
  free_fvec(f, 0, num);
  }

void revard(double *x, int num)
  {
  int i;
  double  *f;

  f = alloc_dvec(0, num);
  for(i = 0; i < num; i++) f[i] = x[i];
  for(i = 0; i < num; i++) x[i] = f[num - i - 1];
  free_dvec(f, 0, num);
  }

void revari(int *x, int num)
  {
  int i;
  int *f;

  f = alloc_ivec(0, num);
  for(i = 0; i < num; i++) f[i] = x[i];
  for(i = 0; i < num; i++) x[i] = f[num - i - 1];
  free_ivec(f, 0, num);
  }

void xline(float x1, float y1, float x2, float y2, float *slope, float *b)
  {

  if(fabs(x1 - x2) < 1e-5)
    {
    *slope = 999999.9;
    *b = -999999.9;
    return;
    }

  *slope = (y2 - y1) / (x2 - x1);
  *b = y1 - *slope * x1;
  return;
  }


/*
 * program for 'simple' straight-line ray tracing and tomography
 *
 * lx = number of nodes in the x direction
 * ly = number of nodes in the y direction
 * spacx = number of km per block in the y direction
 * spacy = number of km per block in the x direction
 * xq, yq  =  coordinates of earthquake in km
 * xsta, ysta  = coordinates of station in km
 *
 * OUTPUT
 * nbloc = final number of blocks
 * ivec = integer vector with the block numbers in sequence
 * bvec = lengths of the ray in each block of ivec
 *
 */

int simpX(int lx, int ly, float spacx, float spacy, float xq, float yq,
	  float xsta, float ysta, int *ivec, float *bvec)
  {
  float *nodex, *nodey, xmax, ymax, nod1, rinf, dist,  sinc, xstart, ystart,
    slope, b, xend, yend, dis;
  double x1,y1;
  int ixq, iyq, istax, istay, len, nx, ny, k, i, ix, iy;

  rinf = 999999.9;
  k = 1;
  dist = 0.0;
  xmax = lx * spacx;
  ymax = ly * spacy;
  sinc = 1.0; 

  ixq = floor(xq / spacx) + 1;
  iyq = floor(yq / spacy) + 1;
  istax = floor(xsta / spacx) + 1;
  istay = floor(ysta / spacy) + 1;
  nx = abs((ixq - istax));
  ny = abs((iyq - istay));

  xend = max2(xq, xsta);
  yend = max2(yq, ysta);

  if((nx > 0) && (fmod(xend, spacx) == 0)) nx--;
  if((ny > 0) && (fmod(yend, spacy) == 0)) ny--;

  xstart = min2(xq, xsta);
  ystart = min2(yq, ysta);
  xline(xq, yq, xsta, ysta, &slope, &b);
  len = nx + ny + 2;

  nodex = alloc_fvec(0, len);
  nodey = alloc_fvec(0, len);

  if(slope < rinf)
    {
    nod1 = (floor(xstart / spacx) + 1) * spacx;
    for(i = 0; i < nx; i++)
      {
      nodex[i] = nod1 + i * spacx;
      nodey[i] = slope * nodex[i] + b;
      }
    }

  /* second loop; Loop on Y nodes and find their X-partners */

  if((slope != 0.0) || (yq != ysta)) 
    {
    nod1 = (floor(ystart / spacy) + 1) * spacy;
    for(i = nx; i < len - 2; i++)
      {
      nodey[i] = nod1 + (i - nx) * spacx;
      if(slope >= rinf) nodex[i] = xq;
      else nodex[i] = (nodey[i] - b) / slope;
      } 
    }
 
  /* add in the two end points */

  nodex[nx + ny] = xq;
  nodex[nx + ny + 1] = xsta;
  nodey[nx + ny] = yq;
  nodey[nx + ny + 1] = ysta;

  /* Now sort all the nodes:  Since the nodes
   * must be monotonically increasing the pairs will match up
   * correctly by even if you sort each of the X-Y node
   * arrays separately.
   */

  qsort((void *)nodex, (size_t)len, sizeof(float), xasc);
  if(slope < 0.0) qsort((void *)nodey, (size_t)len, sizeof(float), xdsc);
  else qsort((void *)nodey, (size_t)len, sizeof(float), xasc);

  /* Now calculate the block number and length of ray in each block to
     return to the main program */

  for(i = 0; i < len - 1; i++)
    {
    x1 = (nodex[i] + nodex[i + 1]) / 2.0;
    y1 = (nodey[i] + nodey[i + 1]) / 2.0;
    dis = sqrt((nodex[i] - nodex[i + 1]) * (nodex[i] - nodex[i + 1])
	       + (nodey[i] - nodey[i + 1]) * (nodey[i] - nodey[i + 1]));

    ix = floor(x1 / spacx) + 1;
    iy = floor(y1 / spacy) + 1;

    if(ix > lx || iy > ly || ix < 1 || iy < 1) continue;

    ivec[i] = (iy - 1) * lx + ix - 1;
    bvec[i] = dis;
    dist += dis;
    }

  if((xq >= xsta && yq >= ysta) || (xq >= xsta && yq < ysta))
    {
    revarr(bvec, len - 1);
    revari(ivec, len - 1);
    }

  free_fvec(nodex, 0, len);
  free_fvec(nodey, 0, len);
  return(len - 1);
  }
/**************************************************************/

/**************************************************************/
/** FUNC DEF **/  int simp_greatX(int nx, int ny, 
				  float dx, float dy, 
				  double  phi , double  lam ,
				  double phi1, double  lam1,
				  double  phi2, double lam2, 
				  int *ivec, float *rvec, double  *PHIvec,  double  *LAMvec)
{
/*  function to determine the intersection
    of a great cicle with a grid of lat lons */
   int i, KOUNT=0;
   int   *index;

   double dlat1,  dlon1, dlat2, dlon2 ;
   double alat1,  alon1, alat2, alon2 ;

   double elat1, elon1, elat2, elon2;
   double tlat1, tlat2;
   double thelat, thelon;
   float x, y, x1, y1, x2, y2; 
     

   double *phis, *lams;
   
   int  num=10,  pode, io1, io2;
   
   
   double darc1, darc2, darc_tot;
   double  arctol;
   double phisc[2], lamsc[2];
   int itest;

   if(nx <= 0) return(0);
  arctol = 2*XMAP_PI/10000.0;

 darc_tot = great_dist((double)deg2rad(phi1), (double)deg2rad(lam1),
		  (double)deg2rad(phi2), (double) deg2rad(lam2));

   num = nx + ny + 2;
 

   phis = alloc_dvec(0, num+2);
   lams = alloc_dvec(0, num+2);
   index = alloc_ivec(0, num+2);

   alat1 =  (double)phi; 
   alat2 =  (double)phi+ny*dy; 
 
   alon1 = (double)lam;
   alon2 = (double)lam+nx*dx;

            /*    work on the latitudes  */
   /* fprintf(stderr, "work on the latitudes \n"); */
   /*   need to work on the small circles here*/

   dlon1 = alon1;
   dlon2 = alon2;


   if(phi1>phi2)
   {
      tlat1 = phi2;
      tlat2 = phi1;
   }
   else
   {
      tlat1 = phi1;
      tlat2 = phi2;
   }

   for(i=0; i<ny; i++)
   {
      dlat1 = alat1 + (float)i*dy;
      dlat2 = dlat1;

      if(dlat1<tlat1 ||  dlat1>tlat2)
      {
	 continue;
      }
      itest = GC_X_LAT(phi1, lam1, phi2, lam2, 
	     dlat1, phisc, lamsc );

      if(itest)
      {
      elat1 = phisc[0];
      elon1 = lamsc[0];

      elat2 = phisc[1];
      elon2 = lamsc[1];
      }
      else
      {
	 continue;	 
      }

      /* fprintf(stderr, "%f %f %f %f\n", elat1, elon1, elat2, elon2); */
      /* fprintf(stderr, "%f %f %f %f\n", dlat1, dlon1, dlat2, dlon2); */

       io1 = In_SphereRect(alat1, alon1, alat2, alon2, elat1,  elon1);
       io2 = In_SphereRect(alat1, alon1, alat2, alon2, elat2,  elon2);

      if(io1==0 && io2 == 0)
      {

	    /* fprintf(stderr, "%f %f OUT  1:%f %f 2:%f %f\n",x1, y1, elat1, elon1, elat2, elon2); */
	    continue;
      }

      if(io1==1)  
      {
	 thelat = elat1;
	 thelon = elon1;
	 x = x1; y = y1;
	 /* fprintf(stderr, "%f %f IN\n",thelat, thelon); */

      }
      if(io2==1)  
      {
	 thelat = elat2;
	 thelon = elon2;
	 x = x2; y = y2;
	 /* fprintf(stderr, "%f %f IN\n",thelat, thelon); */
      }
      darc1 = great_dist((double)deg2rad(phi1), (double)deg2rad(lam1),
			 (double)deg2rad(thelat), (double) deg2rad(thelon));
      
      darc2 = great_dist((double)deg2rad(thelat), (double)deg2rad(thelon),
			 (double)deg2rad(phi2), (double) deg2rad(lam2));


      elat2 = ((darc2+darc1)-darc_tot);
      /* fprintf(stderr,"darc_tot=%f darc1=%f darc2=%f diff=%f\n", darc_tot, darc1, darc2, elat2); */

      
      if( ((darc2+darc1)-darc_tot) > arctol )
      {
	 /* fprintf(stderr, "%f %f OUT_of_Arc  1:%f %f\n",x, y, thelat, thelon); */
	 continue;
	 
      }
      
      phis[KOUNT] = thelat;
      lams[KOUNT] = thelon;
      KOUNT++;

   }
/*   work on the longitudes   */
   /* fprintf(stderr, "work on the longitudes \n"); */

 
   dlat1 =  alat1; 
   dlat2 =  alat2; 
 
   

   
   for(i=0; i<nx; i++)
   {
     dlon1 =   alon1 + (float)i*dx;
      dlon2 = dlon1;


      GC_intersection(phi1 , lam1, phi2 ,lam2,
		      dlat1, dlon1, dlat2, dlon2,
		      &elat1, &elon1, &elat2, &elon2);
      
      /* fprintf(stderr, "%f %f %f %f\n", elat1, elon1, elat2, elon2); */
      /* fprintf(stderr, "%f %f %f %f\n", dlat1, dlon1, dlat2, dlon2); */



      io1 = In_SphereRect(alat1, alon1, alat2, alon2, elat1,  elon1);
      io2 = In_SphereRect(alat1, alon1, alat2, alon2, elat2,  elon2);

     /*  fprintf(stderr, "IOFLAG: %d %d\n",io1, io2); */

      if(io1==0 && io2 == 0)
      {

	    /* fprintf(stderr, "%f %f OUT  1:%f %f 2:%f %f\n",x1, y1, elat1, elon1, elat2, elon2); */
	    continue;
      }

      if(io1==1)  
      {
	 thelat = elat1;
	 thelon = elon1;
	 x = x1; y = y1;
	 /* fprintf(stderr, "%f %f IN\n",thelat, thelon); */

      }
      if(io2==1)  
      {
	 thelat = elat2;
	 thelon = elon2;
	 x = x2; y = y2;
	 /* fprintf(stderr, "%f %f IN\n",thelat, thelon); */
      }

      darc1 = great_dist((double)deg2rad(phi1), (double)deg2rad(lam1),
			 (double)deg2rad(thelat), (double) deg2rad(thelon));
      
      darc2 = great_dist((double)deg2rad(thelat), (double)deg2rad(thelon),
			 (double)deg2rad(phi2), (double) deg2rad(lam2));


      elat2 = ((darc2+darc1)-darc_tot);
      /* fprintf(stderr,"darc_tot=%f darc1=%f darc2=%f diff=%f\n", darc_tot, darc1, darc2, elat2); */

      
      if( ((darc2+darc1)-darc_tot) > arctol )
      {
	 /* fprintf(stderr, "%f %f OUT_of_Arc  1:%f %f\n",x, y, thelat, thelon); */
	 continue;
	 
      }

      phis[KOUNT] = thelat;
      lams[KOUNT] = thelon;
      KOUNT++;


   }

 /*   for(i=0; i< KOUNT; i++) */
/*    { */
/*       elat1=phis[i]; */
/*       elon1=lams[i]; */
/*       fprintf(stderr, "%d %f %f\n", i, elat1, elon1); */
/*    } */


   jindexD(KOUNT, lams-1, index-1);

   io1 = io2 = pode = 0;

   for(i=0; i< KOUNT; i++)
   {
      elat1=phis[index[i]-1];
      elon1=lams[index[i]-1];
      PHIvec[i] = elat1;
      LAMvec[i] = elon1;
      if(i>=1)
      {
      elat2=phis[index[i-1]-1];
      elon2=lams[index[i-1]-1];
      darc1=great_dist(deg2rad(elat1), deg2rad(elon1), deg2rad(elat2), deg2rad(elon2));
      thelat = (elat1+elat2)/2;
      thelon = (elon1+elon2)/2;
      io1 = floor( (thelat-alat1 ) / dy) + 1;
      io2 = floor( (thelon-alon1 )/  dx) + 1;
      pode = (io1-1)*nx + io2 - 1 ;

      ivec[i] = pode;
      rvec[i] = 6371*darc1;
      }

 /*      fprintf(stderr, "%d %d %f %f   %d %d %d\n",  */
/* 	      i, index[i]-1, elat1, elon1, io2, io1, pode); */
 

   }


 /*   fprintf(stderr, "GREAT CUT %f %f %f %f\n", alat1, alon1, alat2, alon2); */

   if(lam1>lam2)
   {
      fprintf(stderr,"GREAT CUT reverse the order of the nodes\n");
      revarr(rvec, KOUNT );
      revari(ivec, KOUNT );
      revard(PHIvec, KOUNT );
      revard(LAMvec, KOUNT );

   }


   free(index);
   free(phis);
   free(lams);

   return(KOUNT);



}


