
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"

/* --- functions --- */

double bilin_interp_Image(mpic *xm, float xkm, float ykm)
  {
  double t, u, ans, y1, y2, y3, y4;
  int i,j, k;  /* for now i = 1:nx  */
  int ix, iy, lay;
  


  ix = i = floor((xkm - xm->image.org_minx) / xm->image.dx) + 1;
  iy = j = floor((ykm - xm->image.org_miny) / xm->image.dy) + 1;
  lay = 0;
  

  if(ix < 1 || ix > xm->image.nx || iy < 1 || iy > xm->image.ny)
    return(xm->image.image_skip);

 /*  iv = ( ((iy - 1) * xm->image.nx + ix) + lay * (xm->image.nx * xm->image.ny)- 1); */


 
  k = ( ((iy ) * xm->image.nx + ix) + lay * (xm->image.nx * xm->image.ny)- 1);
  y1 = xm->image.val[k];

  k = ( ((iy ) * xm->image.nx + ix+1) + lay * (xm->image.nx * xm->image.ny)- 1);
  y2 = xm->image.val[k];

  k = ( ((iy-1 ) * xm->image.nx + ix+1) + lay * (xm->image.nx * xm->image.ny)- 1);
  y3 = xm->image.val[k];

  k = ( ((iy-1 ) * xm->image.nx + ix) + lay * (xm->image.nx * xm->image.ny)- 1);
  y4 = xm->image.val[k];

  t = (xkm - xm->image.dx * i) / (xm->image.dx);
  u = (ykm - xm->image.dy * (xm->image.ny - (j + 2))) / (xm->image.dy);

  ans = ((1 - t) * (1 - u) * y1 + t * (1 - u) * y2 + t * u * y3 + (1 - t) * u
	 * y4);

  return(ans);
  }


double get_slice_Image_val(mpic *xm, float xkm, float ykm)
  {
  double  ans;
  int i,j, k;  /* for now i = 1:nx  */
  int ix, iy, lay;
  


  ix = i = floor((xkm - xm->image.org_minx) / xm->image.dx) + 1;
  iy = j = floor((ykm - xm->image.org_miny) / xm->image.dy) + 1;
 
  lay = xm->image_layer-1;
    /* fprintf(stderr," Layer = %d\n", lay); */


  if(ix < 1 || ix > xm->image.nx || iy < 1 || iy > xm->image.ny)
    return(xm->image.image_skip);

 
 k =  ( ((iy - 1) * xm->image.nx + ix) + lay * (xm->image.nx * xm->image.ny)- 1);
 
  ans = xm->image.val[k];

  return(ans);
  }



void slice_surf_Image(mpic *xm, float x1, float y1, float x2, float y2,
		float *r, float *f, int SLICE_pts)
  {
  float x, y, hoz_dist, delta, co, si, new, small, big;
  int i;

  /* dump_a_bit_grd(grd); */

  hoz_dist = sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
  delta = hoz_dist / (SLICE_pts-1);
  co = (x2 - x1) / hoz_dist;
  si = (y2 - y1) / hoz_dist;

 
  big = xm->image.Layer_max[xm->image_layer-1];
  small = big;
   
  for(i = 0; i < SLICE_pts; i++)
    {
    r[i] = delta * i;
    x = x1 + r[i] * co;
    y = y1 + r[i] * si;

    /* polin2(xsurf, ysurf, val, (long)grd->nx,(long)grd->ny, x,y, &new,
       &dnew);
       fprintf(stderr,"%f %f %f %f\n",x,y, new , dnew);*/

    new = get_slice_Image_val(xm, x,y);
    if(!(new == xm->image.image_skip) && new<small ) small = new;
   /*  new = bilin_interp_Image(xm, x,y); */
    f[i] = new;
    }

/*  fprintf(stderr,"minimum = %f\n",small); */

  for(i = 0; i < SLICE_pts; i++)
    {
    if((f[i] == xm->image.image_skip))  f[i] = small;
    }
  
  }
