/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <string.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"
#include "xsec.h"
#include "jml.h"
#include "rotate.h"

/* --- global variables --- */

extern int screenx, screeny;

/* --- function prototypes --- */

int In_Rectarg(float x, float y, float minx, float maxx, float miny,
	       float maxy);
double pix_to_user_x(JGRAPH *gr, int pix_x);
double pix_to_user_y(JGRAPH *gr, int pix_y);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);

/* --- functions --- */

void Spin_Targ(Widget wij, mpic *mplot, char *call_data)
  {
  int i, j, k, kount, inrect1, inrect2, nevent, nwire, nwell, kwell;
  float minx, maxx, miny, maxy, meanx, meany, meanz, p1x, p1y, p2x, p2y,
    phi, lam;
  /*  max_box_x, max_box_y, max_box_z, min_box_x, min_box_y, min_box_z; */
  Widget rotation;
  ptset_t x, wire;

  if(mplot->picsource_org.x > mplot->picsource_spot.x)
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    maxx =pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&mplot->gr, (int)mplot->picsource_org.x);
    maxx =pix_to_user_x(&mplot->gr, (int)mplot->picsource_spot.x);
    }

  if(mplot->picsource_org.y < mplot->picsource_spot.y)
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    maxy =pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&mplot->gr, (int)mplot->picsource_org.y);
    maxy =pix_to_user_y(&mplot->gr, (int)mplot->picsource_spot.y);
    }

  meanx = meany = meanz = k = 0;
  nevent = 0;
  
  if(mplot->src_flag)
    {
    for(j = 0; j <= mplot->max_more_src - 1; j++)
      {
      for(i = 0; i < mplot->sources[j].numpoints; i++)
	{
	if((inrect1 = In_Rectarg(mplot->sources[j].loc[i].x,
				 mplot->sources[j].loc[i].y, minx, maxx, miny,
				 maxy)) == 1)
	  {
	    meanx += mplot->sources[j].loc[i].x;
	    meany += mplot->sources[j].loc[i].y;
	    meanz += mplot->sources[j].loc[i].z;
	    k++; 
	  }
	} 
      }
    nevent = k;
    }

  nwell = 0;

  if((mplot->num_wells_files > 0) && (mplot->wells_flag > 1))
    {
    nwell = 0;
    for(kwell = 0; kwell < mplot->num_wells_files; kwell++)
      {
      for(i = 0; i < mplot->wells[kwell].well_count; i++)
	{
	for(j = 0; j < mplot->wells[kwell].well[i].nump - 1; j++)
	  {
	  phi = mplot->wells[kwell].well[i].loc[j].x;
	  lam = mplot->wells[kwell].well[i].loc[j].y;
	  geo2xy(mplot, phi, lam, &p1x, &p1y);
	  inrect1 = In_Rectarg(p1x, p1y, minx, maxx, miny, maxy);

	  phi = mplot->wells[kwell].well[i].loc[j + 1].x;
	  lam = mplot->wells[kwell].well[i].loc[j + 1].y;
	  geo2xy(mplot, phi, lam, &p2x, &p2y);
	  inrect2 = In_Rectarg(p2x, p2y, minx, maxx, miny, maxy);

	  if((inrect1 == 1) && (inrect2 == 1))
	    {
	    meanx += p1x;
	    meany += p1y;
	    meanz += mplot->wells[kwell].well[i].loc[j].z;
	    k++;
	    meanx += p2x;
	    meany += p2y;
	    meanz += mplot->wells[kwell].well[i].loc[j+1].z;
	    k++;
	    nwell++;
	    nwell++;
	    }
	  }
	}
      }
    }

  /**********  Wire Frame stuff   *************/

  nwire = 0;
  if((mplot->wire_flag == 1) && (mplot->wire_num > 0))
    {
    nwire = 0;
    for(kount = 0; kount < mplot->wire_num; kount++)
      {
      for(i = 0; i < mplot->wire[kount].n; i++)
	{
	for(j = 0; j < mplot->wire[kount].poly[i].n - 1; j++)
	  {
	  inrect1 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[j].x,
			       mplot->wire[kount].poly[i].kmloc[j].y,
			       minx, maxx, miny, maxy);
	  inrect2 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[j+1].x,
			       mplot->wire[kount].poly[i].kmloc[j+1].y,
			       minx, maxx, miny, maxy);

	  if((inrect1 == 1) && (inrect2 == 1))
	    {
	    meanx += mplot->wire[kount].poly[i].kmloc[j].x;
	    meany += mplot->wire[kount].poly[i].kmloc[j].y;
	    meanz += mplot->wire[kount].poly[i].kmloc[j].z;
	    k++;
	    meanx += mplot->wire[kount].poly[i].kmloc[j+1].x;
	    meany += mplot->wire[kount].poly[i].kmloc[j+1].y;
	    meanz += mplot->wire[kount].poly[i].kmloc[j+1].z;
	    k++;
	    nwire++;
	    nwire++;
	    }
	  }


	inrect1 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[j].x,
			     mplot->wire[kount].poly[i].kmloc[j].y,
			     minx, maxx, miny, maxy);
	inrect2 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[0].x,
			     mplot->wire[kount].poly[i].kmloc[0].y,
			     minx, maxx, miny, maxy);

	if((inrect1 == 1) && (inrect2 == 1))
	  {
	  meanx += mplot->wire[kount].poly[i].kmloc[j].x;
	  meany += mplot->wire[kount].poly[i].kmloc[j].y;
	  meanz += mplot->wire[kount].poly[i].kmloc[j].z;
	  k++;
	  meanx += mplot->wire[kount].poly[i].kmloc[0].x;
	  meany += mplot->wire[kount].poly[i].kmloc[0].y;
	  meanz += mplot->wire[kount].poly[i].kmloc[0].z;
	  k++;

	  nwire++;
	  nwire++;
	  }

	}

      }
    /* wire.n = nwire; */
    }

  fprintf(stderr," nevent = 	%d\n", nevent);
  fprintf(stderr," nwell = 	%d\n", nwell);
  fprintf(stderr," nwire = 	%d\n", nwire);
  fprintf(stderr," total = 	%d\n", k);

  meanx /= (float)k;
  meany /= (float)k;
  meanz /= (float)k;

  /*  fprintf(stderr," meanx=%f meany=%f  meanz=%f\n", meanx, meany, meanz); */

  /*   max_box_x = max_box_y = max_box_z = 0; */
  /*   min_box_x = min_box_y = min_box_z = 0; */

  k = 0;
  x.n = nevent;

  if(nevent > 0)
    {
    x.x = XmapNewArray(float, nevent);
    x.y = XmapNewArray(float, nevent);
    x.z = XmapNewArray(float, nevent);

    for(j = 0; j <= mplot->max_more_src - 1; j++ )
      {
      for(i = 0; i < mplot->sources[j].numpoints; i++)
	{
	if((inrect1 = In_Rectarg(mplot->sources[j].loc[i].x,
				 mplot->sources[j].loc[i].y, 
				 minx, maxx, miny, maxy)) == 1)
	  {
	  x.x[k] = (mplot->sources[j].loc[i].x - meanx);
	  x.y[k] = (mplot->sources[j].loc[i].y - meany);
	  x.z[k] = (mplot->sources[j].loc[i].z - meanz);

	  /* max_box_x = max2(max_box_x, x.x[k]); */
	  /* min_box_x = min2(min_box_x, x.x[k]); */
	  /* max_box_y = max2(max_box_y, x.y[k]); */
	  /* min_box_y = min2(min_box_y, x.y[k]); */
	  /* max_box_z = max2(max_box_z, x.z[k]); */
	  /* min_box_z = min2(min_box_z, x.z[k]); */
	  k++; 
	  }
	} 
      }
    }
  
  if((nwire > 1) || (nwell > 1))
    {
    /* loop through and set the wire frames  */
    /* get total possible number of points  */
    fprintf(stderr, " nwire=%d  nwell=%d\n", nwire, nwell);
    fprintf(stderr, "  wells_flag=%d num_wells_files=%d\n",mplot->wells_flag,
	    mplot->num_wells_files);
    fprintf(stderr, "  wire_flag=%d wire_num=%d\n", mplot->wire_flag,
	    mplot->wire_num);
  
    k = (nwire + nwell);

    fprintf(stderr, " nwire + nwell = %d\n", k);

    wire.x = XmapNewArray(float, k);
    wire.y = XmapNewArray(float, k);
    wire.z = XmapNewArray(float, k);

    k = 0;

    /**********  first do wells   **/

    if((mplot->wells_flag > 1) && (mplot->num_wells_files > 0))
      {
      for(kwell = 0; kwell < mplot->num_wells_files; kwell++)
	{
	for(i = 0; i < mplot->wells[kwell].well_count; i++)
	  {
	  for(j = 0; j < mplot->wells[kwell].well[i].nump - 1; j++)
	    {
	      phi = mplot->wells[kwell].well[i].loc[j].x;
	      lam = mplot->wells[kwell].well[i].loc[j].y;
	      geo2xy(mplot, phi, lam, &p1x, &p1y);
	      inrect1 = In_Rectarg(p1x, p1y, minx, maxx, miny, maxy);

	      phi = mplot->wells[kwell].well[i].loc[j + 1].x;
	      lam = mplot->wells[kwell].well[i].loc[j + 1].y;
	      geo2xy(mplot, phi, lam, &p2x, &p2y);
	      inrect2 = In_Rectarg(p2x, p2y, minx, maxx, miny, maxy);

	      if((inrect1 == 1) && (inrect2 == 1))
		{
		  wire.x[k] = p1x - meanx;
		  wire.y[k] = p1y - meany;
		  wire.z[k] = mplot->wells[kwell].well[i].loc[j].z - meanz;

		  /* max_box_x = max2(max_box_x, wire.x[k]); */
		  /* min_box_x = min2(min_box_x, wire.x[k]); */
		  /* max_box_y = max2(max_box_y, wire.y[k]); */
		  /* min_box_y = min2(min_box_y, wire.y[k]); */
		  /* max_box_z = max2(max_box_z, wire.z[k]); */
		  /* min_box_z = min2(min_box_z, wire.z[k]); */

		  k++;
		  wire.x[k] = p2x - meanx;
		  wire.y[k] = p2y - meany;
		  wire.z[k] = mplot->wells[kwell].well[i].loc[j + 1].z - meanz;

		  /* max_box_x = max2(max_box_x, wire.x[k]); */
		  /* min_box_x = min2(min_box_x, wire.x[k]); */
		  /* max_box_y = max2(max_box_y, wire.y[k]); */
		  /* min_box_y = min2(min_box_y, wire.y[k]); */
		  /* max_box_z = max2(max_box_z, wire.z[k]); */
		  /* min_box_z = min2(min_box_z, wire.z[k]); */
			  
		  k++;
		}
	    }
	  }
	}
      }

      /************/

      if((mplot->wire_flag == 1) && (mplot->wire_num > 0))
	{
	for(kount = 0; kount < mplot->wire_num; kount++)
	  {
	  for(i = 0; i < mplot->wire[kount].n; i++)
	    {
	    for(j = 0; j < mplot->wire[kount].poly[i].n - 1; j++)
	      {
	      inrect1 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[j].x,
				   mplot->wire[kount].poly[i].kmloc[j].y,
				   minx, maxx, miny, maxy);
	      inrect2 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[j + 1].x,
				   mplot->wire[kount].poly[i].kmloc[j + 1].y,
				   minx, maxx, miny, maxy);

	      if((inrect1 == 1) && (inrect2 == 1))
		{
		  wire.x[k] = mplot->wire[kount].poly[i].kmloc[j].x - meanx;
		  wire.y[k] = mplot->wire[kount].poly[i].kmloc[j].y - meany;
		  wire.z[k] = mplot->wire[kount].poly[i].kmloc[j].z - meanz;

		  /* max_box_x = max2(max_box_x, wire.x[k]); */
		  /* min_box_x = min2(min_box_x, wire.x[k]); */
		  /* max_box_y = max2(max_box_y, wire.y[k]); */
		  /* min_box_y = min2(min_box_y, wire.y[k]); */
		  /* max_box_z = max2(max_box_z, wire.z[k]); */
		  /* min_box_z = min2(min_box_z, wire.z[k]); */
		  k++;
			  
		  wire.x[k] = mplot->wire[kount].poly[i].kmloc[j+1].x - meanx;
		  wire.y[k] = mplot->wire[kount].poly[i].kmloc[j+1].y - meany;
		  wire.z[k] = mplot->wire[kount].poly[i].kmloc[j+1].z - meanz;

		  /* max_box_x = max2(max_box_x, wire.x[k]); */
		  /* min_box_x = min2(min_box_x, wire.x[k]); */
		  /* max_box_y = max2(max_box_y, wire.y[k]); */
		  /* min_box_y = min2(min_box_y, wire.y[k]); */
		  /* max_box_z = max2(max_box_z, wire.z[k]); */
		  /* min_box_z = min2(min_box_z, wire.z[k]); */
		  k++;
		}
	      }

	    inrect1 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[j].x,
				 mplot->wire[kount].poly[i].kmloc[j].y,
				 minx, maxx, miny, maxy);
	    inrect2 = In_Rectarg(mplot->wire[kount].poly[i].kmloc[0].x,
				 mplot->wire[kount].poly[i].kmloc[0].y,
				 minx, maxx, miny, maxy);

	    if((inrect1 == 1) && (inrect2 == 1))
	      {
	      wire.x[k] = mplot->wire[kount].poly[i].kmloc[j].x - meanx;
	      wire.y[k] = mplot->wire[kount].poly[i].kmloc[j].y - meany;
	      wire.z[k] = mplot->wire[kount].poly[i].kmloc[j].z - meanz;

	      /* max_box_x = max2(max_box_x, wire.x[k]); */
	      /* min_box_x = min2(min_box_x, wire.x[k]); */
	      /* max_box_y = max2(max_box_y, wire.y[k]); */
	      /* min_box_y = min2(min_box_y, wire.y[k]); */
	      /* max_box_z = max2(max_box_z, wire.z[k]); */
	      /* min_box_z = min2(min_box_z, wire.z[k]); */
	      k++;

	      wire.x[k] = mplot->wire[kount].poly[i].kmloc[0].x - meanx;
	      wire.y[k] = mplot->wire[kount].poly[i].kmloc[0].y - meany;
	      wire.z[k] = mplot->wire[kount].poly[i].kmloc[0].z - meanz;

	      /* max_box_x = max2(max_box_x, wire.x[k]); */
	      /* min_box_x = min2(min_box_x, wire.x[k]); */
	      /* max_box_y = max2(max_box_y, wire.y[k]); */
	      /* min_box_y = min2(min_box_y, wire.y[k]); */
	      /* max_box_z = max2(max_box_z, wire.z[k]); */
	      /* min_box_z = min2(min_box_z, wire.z[k]); */
	      k++;
	      }
	    }
	  }
	}

      wire.n = k;
    }
  else
    {
    wire.n = k = 0;
    }



  fprintf(stderr," x spin: %d \n", x.n);
  fprintf(stderr," wire frame spin: %d \n", wire.n);

  if(wire.n == 0 && x.n == 0) return;

  rotation = rot_main(((x.n > 0) ? &x : NULL),
		      ((wire.n > 0) ? &wire : NULL), mplot->shell);

  XtPopup(rotation, XtGrabNone);
  }




