#include <math.h>


#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))

/* Subroutine */ int tql2_(int *nm, int *n, float *d, float *e, float *z, int *ierr)
{
    /* System generated locals */
    int z_dim1, z_offset, i__1, i__2, i__3;
    double  r__1, r__2;

    /* Builtin functions */
    /*double sqrt(), SIGN();*/

    /* Local variables */
    static double b, c, f, g, h;
    static int i, j, k, l, m;
    static double p, r, s;
    static int l1, ii;
    static float machep;
    static int mml;


/*     float sqrt,abs,sign */

/*     this subroutine is a translation of the algol procedure tql2, */
/*     num. math. 11, 293-306(1968) by bowdler, martin, reinsch, and */
/*     wilkinson. */
/*     handbook for auto. comp., vol.ii-linear algebra, 227-240(1971). */

/*     this subroutine finds the eigenvalues and eigenvectors */
/*     of a symmetric tridiagonal matrix by the ql method. */
/*     the eigenvectors of a full symmetric matrix can also */
/*     be found if  tred2  has been used to reduce this */
/*     full matrix to tridiagonal form. */

/*     on input- */

/*        nm must be set to the row dimension of two-dimensional */
/*          array parameters as declared in the calling program */
/*          dimension statement, */

/*        n is the order of the matrix, */

/*        d contains the diagonal elements of the input matrix, */

/*        e contains the subdiagonal elements of the input matrix */
/*          in its last n-1 positions.  e(1) is arbitrary, */

/*        z contains the transformation matrix produced in the */
/*          reduction by  tred2, if performed.  if the eigenvectors */
/*          of the tridiagonal matrix are desired, z must contain */
/*          the identity matrix. */

/*      on output- */

/*        d contains the eigenvalues in ascending order.  if an */
/*          error exit is made, the eigenvalues are correct but */
/*          unordered for indices 1,2,...,ierr-1, */

/*        e has been destroyed, */

/*        z contains orthonormal eigenvectors of the symmetric */
/*          tridiagonal (or full) matrix.  if an error exit is made, */
/*          z contains the eigenvectors associated with the stored */
/*          eigenvalues, */

/*        ierr is set to */
/*          zero       for normal return, */
/*          j          if the j-th eigenvalue has not been */
/*                     determined after 30 iterations. */

/*     questions and comments should be directed to b. s. garbow, */
/*     applied mathematics division, argonne national laboratory */

/*     ------------------------------------------------------------------ 
*/

/*     ********** machep is a machine dependent parameter specifying */
/*                the relative precision of floating point arithmetic. */

/*                ********** */
    /* Parameter adjustments */
    z_dim1 = *nm;
    z_offset = z_dim1 + 1;
    z -= z_offset;
    --e;
    --d;

    /* Function Body */
    machep = (float)5.96e-8;

    *ierr = 0;
    if (*n == 1) {
	goto L1001;
    }

    i__1 = *n;
    for (i = 2; i <= i__1; ++i) {
/* L100: */
	e[i - 1] = e[i];
    }

    f = (float)0.;
    b = (float)0.;
    e[*n] = (float)0.;

    i__1 = *n;
    for (l = 1; l <= i__1; ++l) {
	j = 0;
	h = machep * ((r__1 = d[l], fabs(r__1)) + (r__2 = e[l], fabs(r__2)));
	if (b < h) {
	    b = h;
	}
/*     ********** look for small sub-diagonal element ********** */
	i__2 = *n;
	for (m = l; m <= i__2; ++m) {
	    if ((r__1 = e[m], fabs(r__1)) <= b) {
		goto L120;
	    }
/*     ********** e(n) is always zero, so there is no exit */
/*                through the bottom of the loop ********** */
/* L110: */
	}

L120:
	if (m == l) {
	    goto L220;
	}
L130:
	if (j == 30) {
	    goto L1000;
	}
	++j;
/*     ********** form shift ********** */
	l1 = l + 1;
	g = d[l];
	p = (d[l1] - g) / (e[l] * (float)2.);
	r = sqrt(p * p + (float)1.);
	d[l] = e[l] / (p + SIGN(r, p));
	h = g - d[l];

	i__2 = *n;
	for (i = l1; i <= i__2; ++i) {
/* L140: */
	    d[i] -= h;
	}

	f += h;
/*     ********** ql transformation ********** */
	p = d[m];
	c = (float)1.;
	s = (float)0.;
	mml = m - l;
/*     ********** for i=m-1 step -1 until l do -- ********** */
	i__2 = mml;
	for (ii = 1; ii <= i__2; ++ii) {
	    i = m - ii;
	    g = c * e[i];
	    h = c * p;
	    if (fabs(p) < (r__1 = e[i], fabs(r__1))) {
		goto L150;
	    }
	    c = e[i] / p;
	    r = sqrt(c * c + (float)1.);
	    e[i + 1] = s * p * r;
	    s = c / r;
	    c = (float)1. / r;
	    goto L160;
L150:
	    c = p / e[i];
	    r = sqrt(c * c + (float)1.);
	    e[i + 1] = s * e[i] * r;
	    s = (float)1. / r;
	    c *= s;
L160:
	    p = c * d[i] - s * g;
	    d[i + 1] = h + s * (c * g + s * d[i]);
/*     ********** form vector ********** */
	    i__3 = *n;
	    for (k = 1; k <= i__3; ++k) {
		h = z[k + (i + 1) * z_dim1];
		z[k + (i + 1) * z_dim1] = s * z[k + i * z_dim1] + c * h;
		z[k + i * z_dim1] = c * z[k + i * z_dim1] - s * h;
/* L180: */
	    }

/* L200: */
	}

	e[l] = s * p;
	d[l] = c * p;
	if ((r__1 = e[l], fabs(r__1)) > b) {
	    goto L130;
	}
L220:
	d[l] += f;
/* L240: */
    }
/*     ********** order eigenvalues and eigenvectors ********** */
    i__1 = *n;
    for (ii = 2; ii <= i__1; ++ii) {
	i = ii - 1;
	k = i;
	p = d[i];

	i__2 = *n;
	for (j = ii; j <= i__2; ++j) {
	    if (d[j] >= p) {
		goto L260;
	    }
	    k = j;
	    p = d[j];
L260:
	    ;
	}

	if (k == i) {
	    goto L300;
	}
	d[k] = d[i];
	d[i] = p;

	i__2 = *n;
	for (j = 1; j <= i__2; ++j) {
	    p = z[j + i * z_dim1];
	    z[j + i * z_dim1] = z[j + k * z_dim1];
	    z[j + k * z_dim1] = p;
/* L280: */
	}

L300:
	;
    }

    goto L1001;
/*     ********** set error -- no convergence to an */
/*                eigenvalue after 30 iterations ********** */
L1000:
    *ierr = l;
L1001:
    return 0;
/*     ********** last card of tql2 ********** */
} /* tql2_ */

