#include <math.h>


/*     ------------------------------------------------------------------ */

#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))

/* Subroutine */ int tred2_(int *nm, int *n, float *a, float *d, float *e, float *z)
{
    /* System generated locals */
    int a_dim1, a_offset, z_dim1, z_offset, i__1, i__2, i__3;
    double r__1;

    /* Builtin functions */
   /* double sqrt(), r_sign();*/

    /* Local variables */
    static double f, g, h;
    static int i, j, k, l;
    static double scale, hh;
    static int ii, jp1;


/*     REAL SQRT,ABS,SIGN */

/* 
C
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TRED2,
C     NUM. MATH. 11, 181-195(1968) BY MARTIN, REINSCH, AND WILKINSON.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 212-226(1971).
C
C     THIS SUBROUTINE REDUCES A DOUBLE PRECISION SYMMETRIC MATRIX TO A
C     SYMMETRIC TRIDIAGONAL MATRIX USING AND ACCUMULATING
C     ORTHOGONAL SIMILARITY TRANSFORMATIONS.
C
C     ON INPUT-
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT,
C
C        N IS THE ORDER OF THE MATRIX,
C
C        A CONTAINS THE DOUBLE PRECISION SYMMETRIC INPUT MATRIX.  ONLY THE
C          LOWER TRIANGLE OF THE MATRIX NEED BE SUPPLIED.
C
C     ON OUTPUT-
C
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE TRIDIAGONAL MATRIX,
C
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE TRIDIAGONAL
C          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS SET TO ZERO,
C
C        Z CONTAINS THE ORTHOGONAL TRANSFORMATION MATRIX
C          PRODUCED IN THE REDUCTION,
C
C        A AND Z MAY COINCIDE.  IF DISTINCT, A IS UNALTERED.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
 
*/

    /* Parameter adjustments */
    z_dim1 = *nm;
    z_offset = z_dim1 + 1;
    z -= z_offset;
    --e;
    --d;
    a_dim1 = *nm;
    a_offset = a_dim1 + 1;
    a -= a_offset;

    /* Function Body */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {

	i__2 = i;
	for (j = 1; j <= i__2; ++j) {
	    z[i + j * z_dim1] = a[i + j * a_dim1];
/* L100: */
	}
    }

    if (*n == 1) {
	goto L320;
    }
/*     ********** FOR I=N STEP -1 UNTIL 2 DO -- ********** */
    i__2 = *n;
    for (ii = 2; ii <= i__2; ++ii) {
	i = *n + 2 - ii;
	l = i - 1;
	h = (float)0.;
	scale = (float)0.;
	if (l < 2) {
	    goto L130;
	}
/*     ********** SCALE ROW (ALGOL TOL THEN NOT NEEDED) ********** */
	i__1 = l;
	for (k = 1; k <= i__1; ++k) {
/* L120: */
	    scale += (r__1 = z[i + k * z_dim1], fabs(r__1));
	}

	if (scale != (float)0.) {
	    goto L140;
	}
L130:
	e[i] = z[i + l * z_dim1];
	goto L290;

L140:
	i__1 = l;
	for (k = 1; k <= i__1; ++k) {
	    z[i + k * z_dim1] /= scale;
	    h += z[i + k * z_dim1] * z[i + k * z_dim1];
/* L150: */
	}

	f = z[i + l * z_dim1];
	r__1 = sqrt(h);
	g = -(double)SIGN(r__1, f);
	e[i] = scale * g;
	h -= f * g;
	z[i + l * z_dim1] = f - g;
	f = (float)0.;

	i__1 = l;
	for (j = 1; j <= i__1; ++j) {
	    z[j + i * z_dim1] = z[i + j * z_dim1] / h;
	    g = (float)0.;
/*     ********** FORM ELEMENT OF A*U ********** */
	    i__3 = j;
	    for (k = 1; k <= i__3; ++k) {
/* L180: */
		g += z[j + k * z_dim1] * z[i + k * z_dim1];
	    }

	    jp1 = j + 1;
	    if (l < jp1) {
		goto L220;
	    }

	    i__3 = l;
	    for (k = jp1; k <= i__3; ++k) {
/* L200: */
		g += z[k + j * z_dim1] * z[i + k * z_dim1];
	    }
/*     ********** FORM ELEMENT OF P ********** */
L220:
	    e[j] = g / h;
	    f += e[j] * z[i + j * z_dim1];
/* L240: */
	}

	hh = f / (h + h);
/*     ********** FORM REDUCED A ********** */
	i__1 = l;
	for (j = 1; j <= i__1; ++j) {
	    f = z[i + j * z_dim1];
	    g = e[j] - hh * f;
	    e[j] = g;

	    i__3 = j;
	    for (k = 1; k <= i__3; ++k) {
		z[j + k * z_dim1] = z[j + k * z_dim1] - f * e[k] - g * z[i + 
			k * z_dim1];
/* L260: */
	    }
	}

L290:
	d[i] = h;
/* L300: */
    }

L320:
    d[1] = (float)0.;
    e[1] = (float)0.;
/*     ********** ACCUMULATION OF TRANSFORMATION MATRICES ********** */
    i__2 = *n;
    for (i = 1; i <= i__2; ++i) {
	l = i - 1;
	if (d[i] == (float)0.) {
	    goto L380;
	}

	i__3 = l;
	for (j = 1; j <= i__3; ++j) {
	    g = (float)0.;

	    i__1 = l;
	    for (k = 1; k <= i__1; ++k) {
/* L340: */
		g += z[i + k * z_dim1] * z[k + j * z_dim1];
	    }

	    i__1 = l;
	    for (k = 1; k <= i__1; ++k) {
		z[k + j * z_dim1] -= g * z[k + i * z_dim1];
/* L360: */
	    }
	}

L380:
	d[i] = z[i + i * z_dim1];
	z[i + i * z_dim1] = (float)1.;
	if (l < 1) {
	    goto L500;
	}

	i__1 = l;
	for (j = 1; j <= i__1; ++j) {
	    z[i + j * z_dim1] = (float)0.;
	    z[j + i * z_dim1] = (float)0.;
/* L400: */
	}

L500:
	;
    }

    return 0;
/*     ********** LAST CARD OF TRED2 ********** */
} /* tred2_ */

