#include<math.h>


/* #define earth_rad	6378206.4*/
#define earth_rad	6378.2064


#define E2	0.00676866
#define E	0.0822719
#define E1	0.993231340
#define TwoE	0.164543800
/* #define R	1.0 */

#define R	6378.2064 

#define DEG2RAD	0.017453293
#define RAD2DEG	57.295778667

#define e2	0.00676866

/* --- global variables --- */

/* static double EN, C, B, RHO0, PHI0, LAM0, k0, Eprime2, M0; */
static double   PHI0, LAM0, k0, Eprime2, M0;

/******  Universal Transverse Mercator (UTM)   SPHERICAL    **************/
static double e1;


void set_UTM_sphere(float phi0, float lam0)
  {
  LAM0 = lam0;
  PHI0 = phi0;
  k0 = 1.0;}

void utm_sphr_xy(float phi, float lam, float *x, float *y)
  {
  double theta = (lam - LAM0), B;

B = cos(DEG2RAD *phi) * sin(DEG2RAD *theta);
  *x = 0.5*R*k0*log( (1+B)/(1-B));
  *y = R * k0* (  atan( tan(DEG2RAD *phi)/cos(DEG2RAD *theta)) - DEG2RAD*PHI0 );
  }

void utm_sphr_ll(float *phi, float *lam, float x, float y)
  {
double D;
double a1, a2;

D = y/(R*k0) + DEG2RAD *PHI0;
  a1 = RAD2DEG *asin( sin(D)/cosh(x/(R*k0)) );
  a2 = RAD2DEG * atan( sinh(x/(R*k0))/cos(D)) + LAM0;
 
*phi = a1;
*lam = a2;

/* fprintf(stderr,"%.10f %.10f\n", a1, a2); */




  }


void set_UTM_ellipsoid(float phi0, float lam0)
  {
  double p;
  
  LAM0 = lam0;
  PHI0 = phi0;
  k0 = 0.9996;
  Eprime2 = e2/(1-e2);
 /*  fprintf(stderr,"eprime2=%f\n",Eprime2); */
    
  e1 = ( 1 - sqrt(1-e2) ) / (1+ sqrt(1-e2));

 /* fprintf(stderr,"e1=%f\n",e1); */
    p = DEG2RAD *phi0;
    M0 = 111132.0894*phi0 - 16216.94*sin(2*p) + 17.21*sin(4*p) - 0.02*sin(6*p);
  M0 /= 1000.0;
  
  /* fprintf(stderr,"M0=%f\n",M0); */
  

}

#if 0
static double getM(double phi)
  {
  double A, B, C, D;
  double Ap,Bp, Cp, Dp;
  double s2p;
  
  s2p = sin(2* DEG2RAD *phi);
  



  }
#endif



void utm_ellipsoid_xy(float phi, float lam, float *x, float *y)
  {  /* page 61 in Snyder  */
  double theta = (lam - LAM0);
   double p, N, T, C, A, M, cp, sp;

  if (theta < 180) theta += 360;
  if (theta > 180) theta -= 360;
    p = DEG2RAD *phi;
  cp = cos(p);
  
    sp = sin(p);
    N = earth_rad/sqrt(1-e2*sp*sp);
    T = tan(p)*tan(p);
    C = Eprime2*cp*cp;
    A =  DEG2RAD *theta *cp;
    M = 111132.0894*phi - 16216.94*sin(2*p) + 17.21*sin(4*p) - 0.02*sin(6*p);
  M /=1000.0;
  
    *x = k0*N*(A+(1-T+C)*A*A*A/6 +(5-18*T + T*T +72*C - 58*Eprime2)*
          A*A*A*A*A/120);
    *y = k0*(M - M0 + N*tan(p)*(A*A/2 +
         (5 - T +9*C + 4*C*C)*A*A*A*A/24 +
         (61 - 58*T +T*T + 600*C - 330*Eprime2) *A*A*A*A*A*A/720  ) )  ;
  }

void utm_ellipsoid_ll(float *phi, float *lam, float x, float y)
  {   /* page 63-64 in Snyder  */

  double C1, T1, N1, R1, D, s2, M, mu;
  double phi1;
  double a1, a2;
  

  M = M0 + y/k0;
 
  /* fprintf(stderr,"M=%f\n", M); */
  
  mu = M/( earth_rad*(1-e2/4-3*e2*e2/64 - 5*e2*e2*e2/256));
  /* fprintf(stderr,"mu=%f\n", mu); */
 
  phi1 = mu + ( (3*e1/2)-27.*e1*e1*e1/32)*sin(2*mu)
  +(21*e1*e1/16 - 55*e1*e1*e1*e1/32) *sin(4*mu)+
  (151*e1*e1*e1/96)*sin(6*mu)+(1097*e1*e1*e1*e1/512.0)*sin(8*mu);

  s2 = sin(phi1)*sin(phi1);
  
 /* fprintf(stderr,"phi1=%f\n", phi1); */
 
  C1 = Eprime2*cos(phi1)*cos(phi1);
  T1 = tan(phi1)*tan(phi1);
  N1 = earth_rad/sqrt(1-e2*sin(phi1)*sin(phi1));
  R1 = earth_rad*(1-e2)/pow( (1-e2*s2), 1.5);
  D = x/(N1*k0);


  /* fprintf(stderr,"C1=%f\nT1=%f\nN1=%f\nR1=%f\nD=%f\n", C1, T1, N1, R1, D); */
  

  a1 =  phi1 - (N1*tan(phi1)/R1)*(D*D/2 - (5+3*T1 + 10*C1 - 4*C1*C1 - 9*Eprime2)* D*D*D*D/24 +

				    (61 + 90*T1 + 298*C1 + 45*T1*T1 - 252*Eprime2 - 3*C1*C1)*
				    D*D*D*D*D*D/720)   ;
  *phi = RAD2DEG *a1 ;
  
  a2 =
   (D - (1+2*T1+ C1)*D*D*D/6 +
		 (5 - 2*C1 + 28*T1 - 3*C1*C1 + 8*Eprime2 + 24*T1*T1) *D*D*D*D*D/120 )/cos(phi1)   ;


*lam = LAM0 + RAD2DEG *a2 ;
  }


