
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "mpic.h"

/* --- function prototypes --- */

void make_xsect(mpic *mplot, xyxy *l);
extern Boolean CopyToXDipWindow(XDIP_PARMS *pxdipParms);
extern Boolean CopyFromXDipWindow(XDIP_PARMS *pxdipParms);
extern void SetWidgetFloat(Widget w, String attr, float i);

/* --- functions --- */

void init_xdipParms(mpic *mp)
  {
  mp->xdipParms.dip = 0.0;
  mp->xdipParms.minz = 0.0;
  mp->xdipParms.maxz = mp->MaxDepth;
  mp->xdipParms.front = mp->halfwidth;
  mp->xdipParms.back = mp->halfwidth;
  }

void xdip_new_parms(mpic *mplot)
  {
  static xyxy xs_line;
  int iokay;

  xs_line.x1 = mplot->xsect_org.x;
  xs_line.y1 = mplot->xsect_org.y;
  xs_line.x2 = mplot->xsect_spot.x;
  xs_line.y2 = mplot->xsect_spot.y;

  iokay = CopyFromXDipWindow(&mplot->xdipParms);

  make_xsect(mplot, &xs_line);
  }

int PrintXdipParms(XDIP_PARMS *pxdipParms);
/*int InitXdipParms(XDIP_PARMS *pxdipParms);*/

/********************************************************************/

void PopupXdip(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;

  /* PrintXdipParms(&mplot->xdipParms); */

  iokay = CopyToXDipWindow(&mplot->xdipParms);
  XtPopup(mplot->xdipParms.wShell, XtGrabNone);
  }

void XdipSet(Widget w, mpic *mplot, char *call_data)
  {
  int iokay;
  
  iokay = CopyFromXDipWindow(&mplot->xdipParms);
  /* PrintXdipParms(&mplot->xdipParms); */
  XtPopdown(mplot->xdipParms.wShell);
  xdip_new_parms(mplot);
  }

void XdipDone(Widget w, mpic *mplot, char *call_data)
  {

  /* PrintXdipParms(&mplot->xdipParms); */
  XtPopdown(mplot->xdipParms.wShell);
  }

void make_xdip_menu(Widget box, mpic *mplot)
  {
  Widget xp, view, top, xdipshell;

  top = mplot->shell;
  xp = XtVaCreateManagedWidget("Set Xdip", smeBSBObjectClass, box, NULL);
  
  mplot->xdipParms.wShell = xdipshell =
    XtVaCreatePopupShell("xdipWin", transientShellWidgetClass, top, NULL);
  
  view = XtVaCreateManagedWidget("xdipForm", formWidgetClass, xdipshell, NULL);
  
  /* -----------NOTE:  these must be created in the correct order   !  */
  
  /* Create the various parameter labels and their text boxes. */

  mplot->xdipParms.wDipLabel = XtVaCreateManagedWidget("DipLabel",
    labelWidgetClass, view, NULL);

  mplot->xdipParms.wDipEdit = XtVaCreateManagedWidget("DipEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->xdipParms.wMinzLabel = XtVaCreateManagedWidget("MinzLabel",
    labelWidgetClass, view, NULL);

  mplot->xdipParms.wMinzEdit = XtVaCreateManagedWidget("MinzEdit",
    asciiTextWidgetClass, view, NULL);
 
  mplot->xdipParms.wMaxzLabel = XtVaCreateManagedWidget("MaxzLabel",
    labelWidgetClass, view, NULL);

  mplot->xdipParms.wMaxzEdit = XtVaCreateManagedWidget("MaxzEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->xdipParms.wFrontLabel = XtVaCreateManagedWidget("FrontLabel",
    labelWidgetClass, view, NULL);

  mplot->xdipParms.wFrontEdit = XtVaCreateManagedWidget("FrontEdit",
    asciiTextWidgetClass, view, NULL);

  mplot->xdipParms.wBackLabel = XtVaCreateManagedWidget("BackLabel",
    labelWidgetClass, view, NULL);

  mplot->xdipParms.wBackEdit = XtVaCreateManagedWidget("BackEdit",
    asciiTextWidgetClass, view, NULL);

  /* Make all of the edit boxes editable. */

  SetWidgetFloat(mplot->xdipParms.wDipEdit, XtNeditType, XawtextEdit);
  SetWidgetFloat(mplot->xdipParms.wMinzEdit, XtNeditType, XawtextEdit);

  SetWidgetFloat(mplot->xdipParms.wMaxzEdit, XtNeditType, XawtextEdit);
  SetWidgetFloat(mplot->xdipParms.wFrontEdit, XtNeditType, XawtextEdit);

  SetWidgetFloat(mplot->xdipParms.wBackEdit, XtNeditType, XawtextEdit);

  /* Create the Set and Cancel command buttons. */

  mplot->xdipParms.wSet = XtVaCreateManagedWidget("set",
    commandWidgetClass, view, NULL);

  mplot->xdipParms.wCancel = XtVaCreateManagedWidget("cancel",
    commandWidgetClass, view, NULL);

  /* InitXdipParms(&mplot->xdipParms); */

  XtAddCallback(xp, XtNcallback, (XtCallbackProc)PopupXdip, mplot);

  XtAddCallback(mplot->xdipParms.wSet, XtNcallback, (XtCallbackProc)XdipSet,
		mplot);
  XtAddCallback(mplot->xdipParms.wCancel, XtNcallback,
		(XtCallbackProc)XdipDone, mplot);
  }

