
/* --- feature switches --- */

#define _POSIX_SOURCE 1

/* --- system headers --- */

#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

/* void usleep(unsigned int useconds); */

/* --- local headers --- */

#include "geotouch.h"
#include "Gen.h"
#include "xlext.h"
#include "user2pix.h"
#include "mpic.h"
#include "xsec.h"
#include "jutil.h"
#include "focproto.h"

/* --- typedefs --- */

typedef fxy fpoint;
typedef struct
  {
  char dat[15];
  } stamp;

/* --- function prototypes --- */

int inside(fpoint t, fpoint *p, int N);
int xy2geo(mpic *mplot, float *phi, float *lam, float x, float y);
void csorta(float *bufin, int *ibufdx, float *bufout, int n);
void clean_file_name(char **sfile);
void create_Acard(ac_rec *ac, char *acrd);
void create_Mcard(mech *mc, char *mcrd);
void tojul(int year, int month, int day, int *jul);
void xaxis(Display *d, Window w, GC grc, JGRAPH *grph, double  x0, double y0,
	   double xn, int tside, int nside, int ndivs, double offset);
void yaxis(Display *d, Window w, GC grc, JGRAPH *grph, double x0, double y0,
	   double yn, int tside, int nside, int ndivs, double offset);
void  plot_X_image(Display *d, Window w, GC ggc, xsec *xs);
void switch_foc(mpic *m, int kfoc);
int select_X_focs(xsec *xs);
void plot_X_focs(Display *d, Window w, GC ggc, xsec *xs);
void plot_X_focs_BW( Display *d, Window w, GC ggc, xsec *xs);
void Xsec_plot_well(xsec *xs, Display * d, Window w, GC ggc);
void Xsec_plot_points(xsec *xs, Display *d, Window w, GC ggc);
void Xsec_plot_lips(xsec *xs, Display *dpy, Window xwin, GC gc);
void draw_Arrow(Display *dpy, Window xwin, GC gc, int x1, int y1, int x2,
		int y2);
void  Do_Postscript_Xsect(Display *gdisp, char ps_file[50], xsec *xs);
void getbox(int g1, int h1, int g2, int h2, XPoint v[5]);
void slice_surf(struct SURF_GRD *grd, float x1, float x2, float y1, float y2,
		float *r, float *f, int SLICE_pts);
void slice_surf_Image(mpic *xm, float x1, float y1, float x2, float y2,
		      float *r, float *f, int SLICE_pts);


void xs_Key_s_lees(Widget wij, XKeyEvent *ev, String *params,
		   Cardinal *num_params);
void slide_point(float x1, float y1, float x2, float y2, float dis, float *nx, float *ny);

void XDump_Point_Info(xsec *xs);

void SAVE_selXsource(Widget wij, xsec *xs, char *call_data);
void APPEND_selXsource(Widget wij, xsec *xs, char *call_data);
void Dump_selXsource(xsec *xs, char *source_file, int append);
void PLOT_selXsource(Widget wij, xsec *xs, char *call_data);
void draw_triang(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_triang_2(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_square(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_star_david(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_ex(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_Plus(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void draw_Diamond(Display *dpy, Window xwin, GC gc, int x, int y, int siz);
void make_xsec_window(Widget top, xsec *xs, Pixel *colors, Font *fonts);
int Inpoly(float x, float y, int num, float **poly);
int poly_line(float **poly, int n2, fxyxy linb, float *ctempx, float *ctempy);
int In_Rect_Vol(float RMAT[3][3], float dx, float dy, float dz, float mindep,
		float maxdep, float mindist, float maxdist, float d1, float d2, float *range,
		float *dep, float *aproj);
int geo2xy(mpic *mplot, float phi, float lam, float *x, float *y);

static void xs_Key_Q_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_u_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_l_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_e_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_p_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_o_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_c_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_c_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_m_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_n_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_f_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_g_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_v_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_a_lees(Widget wij, XKeyEvent *ev, String *params,
			  Cardinal *num_params);
static void xs_Key_F1_lees(Widget wij, XKeyEvent *ev, String *params,
			   Cardinal *num_params);
static void close_xsec(Widget wij, void *client_data, void *server_data);
static void destroy_xsec(Widget wij, void *client_data, void *server_data);

void Start_selXfoc(Widget wij, XButtonEvent *event, String *params,
		   Cardinal *num_params);
void Resize_selXfoc(Widget wij, XButtonEvent *event, String *params,
		    Cardinal *num_params);
void Do_selXfoc(Widget wij, XButtonEvent *ev, String *params,
		Cardinal *num_params);
void Switch_selXfoc(Widget wij, XButtonEvent *ev, String *params,
		    Cardinal *num_params);
void X_Poly_Points(Widget wij, XButtonEvent *ev, String *params,
		   Cardinal *num_params);
void Start_selXsource(Widget wij, XButtonEvent *event, String *params,
		      Cardinal *num_params);
void Do_selXsource(Widget wij, XButtonEvent *ev, String *params,
		   Cardinal *num_params);
void Resize_selXsource(Widget wij, XButtonEvent *event, String *params,
		       Cardinal *num_params);
void Do_xzoom(Widget wij, XButtonEvent *ev, String *params,
	      Cardinal *num_params);

int Plot_Topo_Field( xsec * xs);

 int Plot_X_Field(xsec *xs);
 int Plot_X_Field2(xsec *xs);

/* --- global variables --- */

static int gscr_num, gpolx[200], gpoly[200], global_poly, num_poly = 0;
static int current_poly;

int default_depth, Xoffset = 50, Yoffset = 60;
static float polyx[200], polyy[200];
xsec *DialogDone_xsec;
Widget XdialogDone;

static double xkmORG, zkmORG;


static char defaultTranslations[] =
  "#override\n"
  "<Key>p: xs_key_p_lees()\n"
  "<Key>space: xs_key_p_lees()\n"
  "<Key>o: xs_key_o_lees()\n"
  "<Key>e: xs_key_e_lees()\n"
  "None<Key>q: xs_key_q_lees()\n"
  "s<Key>q: xs_key_Q_lees()\n"
  "<Key>u: xs_key_u_lees()\n"
  "<Key>l: xs_key_l_lees()\n"
  "<Key>f: xs_key_f_lees()\n"
  "<Key>g: xs_key_g_lees()\n"
  "<Key>m: xs_key_m_lees()\n"
  "<Key>n: xs_key_n_lees()\n"
  "<Key>c: xs_key_c_lees()\n"
  "<Key>v: xs_key_v_lees()\n"
  "<Key>a: xs_key_a_lees()\n"
  "<Key>s: xs_key_s_lees()\n"
  "<Key>F1: xs_key_F1_lees()\n"
  "None<Btn1Down>: start_selXsource()\n"
  "None<Btn1Motion>: resize_selXsource()\n"
  "None<Btn1Up>: do_selXsource()\n"
  "s<Btn1Down>: start_selXfoc()\n"
  "s<Btn1Motion>: resize_selXfoc()\n"
  "s<Btn1Up>: do_selXfoc()\n"
  "Ctrl<Btn1Down>: x_poly_points()\n"
  "Meta<Btn1Down>: x_poly_points()\n"
  "None<Btn2Down>: start_selXsource()\n"
  "None<Btn2Motion>: resize_selXsource()\n"
  "None<Btn2Up>: do_xzoom()\n"
  "Meta<Btn2Down>: start_selXfoc()\n"
  "Meta<Btn2Motion>: resize_selXfoc()\n"
  "Meta<Btn2Up>: switch_selXfoc()\n";

static XtActionsRec actions[] =
  {
  /* {"key_xok",(XtActionProc)XDialogDoneAction}, */
    { "xs_key_p_lees", (XtActionProc)xs_Key_p_lees },
    { "xs_key_o_lees", (XtActionProc)xs_Key_o_lees },
    { "xs_key_e_lees", (XtActionProc)xs_Key_e_lees },
    { "xs_key_q_lees", (XtActionProc)close_xsec },
    { "xs_key_Q_lees", (XtActionProc)xs_Key_Q_lees },
    { "xs_key_u_lees", (XtActionProc)xs_Key_u_lees },
    { "xs_key_l_lees", (XtActionProc)xs_Key_l_lees },
    { "xs_key_f_lees", (XtActionProc)xs_Key_f_lees },
    { "xs_key_g_lees", (XtActionProc)xs_Key_g_lees },
    { "xs_key_m_lees", (XtActionProc)xs_Key_m_lees },
    { "xs_key_n_lees", (XtActionProc)xs_Key_n_lees },
    { "xs_key_c_lees", (XtActionProc)xs_Key_c_lees },
    { "xs_key_v_lees", (XtActionProc)xs_Key_v_lees },
    { "xs_key_a_lees", (XtActionProc)xs_Key_a_lees },
    { "xs_key_s_lees", (XtActionProc)xs_Key_s_lees },
    { "xs_key_F1_lees", (XtActionProc)xs_Key_F1_lees },
    { "start_selXsource", (XtActionProc)Start_selXsource },
    { "resize_selXsource", (XtActionProc)Resize_selXsource },
    { "do_selXsource", (XtActionProc)Do_selXsource },
    { "start_selXfoc", (XtActionProc)Start_selXfoc },
    { "resize_selXfoc", (XtActionProc)Resize_selXfoc },
    { "do_selXfoc", (XtActionProc)Do_selXfoc },
    { "x_poly_points", (XtActionProc)X_Poly_Points },
    { "switch_selXfoc", (XtActionProc)Switch_selXfoc },
    { "do_xzoom", (XtActionProc)Do_xzoom }
  };

/* --- functions --- */


/** FUNC DEF **/unsigned long indepth(float xx[], unsigned long n, float x)
{
	unsigned long ju,jm,jl;
	int ascnd;

	jl=-1;
	ju=n;
	ascnd=(xx[n-1] > xx[0]);
	while (ju-jl > 1) {
		jm=(ju+jl) >> 1;
		if (x >= xx[jm] &&  xx[jm] == ascnd)
			jl=jm;
		else
			ju=jm;
	}
	return(jl);
}





static void redraw_xsec(Widget wij, void *client_data, Region exposed)
  {
  /* ======= These variables must be here ======= */
  xsec *xs;		/* The data to redraw */
  Display *d;		/* The display we're using */
  Window w;		/* The window we're drawing in */
  GC ggc;		/* The gc to use */
  Pixel *colors;	/* Color map */
  mpic *xm;
  int circle = 23040, lx, ly, a, i, k, jj, kount, astart, aend, lx2, ly2,
    hsize;
  float hoz_dist, dep, r, off, r1[10], dep1[10], off1[10], garb1;
  char pchar[12];
  Dimension win_hite, win_width;
  Position ex, why;

 

  XtVaGetValues(wij, XtNdata, &xs, NULL);

  xm = xs->m;
  w = XtWindow(wij);
  d = XtDisplay(wij);
  ggc = xs->ggc;
  colors = xs->colors;

  /* XSetRegion(d, ggc, exposed); */
  XClearWindow(d, w);

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

XSetForeground(d, ggc, colors[XmapAppColor(xm->background_col)]);
 


XFillRectangle(d, w, ggc, 0, 0, win_width , win_hite );

  /* Now get around to drawing */

  hoz_dist = sqrt(sqr(xs->line.x1 - xs->line.x2)
		  + sqr(xs->line.y1 - xs->line.y2));

  window(&xs->GR, (double)xs->x_left, (double)xs->x_right,
	 (double)(xs->y_bot), (double)xs->y_top);
  viewport(&xs->GR, xs->Xmargin, win_width - xs->Xmargin, xs->Ymargin / 2,
	   win_hite - 1.5 * xs->Ymargin);

  xs->xdim = hoz_dist;

  /* printf(" Half width = %f Dip = %f\n", xs->xwidth, xs->dip); 
     printf("xsec: maxmoresource = %d %d\n", xm->max_more_src,xm->src_color);
     */

  lx = user_to_pix_x(&xs->GR, (double)hoz_dist);
  ly = user_to_pix_y(&xs->GR, (double)xs->xdepth);



  /* fprintf(stderr,"%d %d %d %d\n", */
/* 	  xs->GR.pix_xmin, xs->GR.pix_ymin,xs->GR.pix_xdif, xs->GR.pix_ydif); */
  

  XSetForeground(d, ggc, colors[XmapAppColor(xm->back_fill_col)]);

  XFillRectangle(d, w, ggc, xs->GR.pix_xmin, xs->GR.pix_ymin, 
		 xs->GR.pix_xdif, xs->GR.pix_ydif); 


  /* Image Stuff */

  if(xm->image_flag) plot_X_image(d, w, ggc, xs);
 
  /* Focal Mechanisms */

  if(xm->focm_flag > 1)
    {
    XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->back_foc_col)]);

    if(xs->do_select == 0)	/*  need to do selection */
      {
      select_X_focs(xs);
      xs->do_select = 1;
      }

    /* ready to plot focals */

    if(default_depth < 2) plot_X_focs_BW(d, w, ggc, xs);
    else plot_X_focs(d, w, ggc, xs);
    } 

  /* Sources */

  if(xm->src_flag == 1) astart = 0;
  else astart = 1;

  if(xm->more_src_flag == 1) aend = xm->max_more_src;
  else aend = 1;

  /* fprintf(stderr,"x1=%f y1=%f  x2=%f  y2=%f  dip(deg)=%f\n",xs->line.x1,
     xs->line.y1, xs->line.x2, xs->line.y2, xs->xs_dip);
     Dump_3Mat(xs->RM) ;
     fprintf(stderr,"mindepth=%f maxdepth=%f  dist=%f max_xsfront=%f"
     " max_xsback=%f\n",xs->min_xsdepth,
     xs->max_xsdepth, xs->x_right, xs->max_xsfront, xs->max_xsback); */

  hsize = xm->SourceSize;
  for(a = astart; a <= aend - 1; a++)
    {
    XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->src_col-a)]);
    /* printf( " numsrc = %d %d\n",a, xm->sources[a].numpoints); */
    for(i = 0; i < xm->sources[a].numpoints; i++) 
      {
      if(xm->sources[a].onoff[i])
	{
	k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
			xm->sources[a].loc[i].y-xs->line.y1,
			xm->sources[a].loc[i].z,xs->min_xsdepth,
			xs->max_xsdepth,  xs->x_left, xs->x_right, xs->max_xsfront,
			xs->max_xsback, &r, &dep, &off);
	if(k == 1)
	  {
	  ly = user_to_pix_y(&xs->GR, (double)dep);  
	  lx = user_to_pix_x(&xs->GR, (double)r);
	  hsize = xm->sources[a].size[i]; 

	  if(xm->fancy_src_flag == 1)
	    {
	    XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->src_col-a)]);
	    XFillArc(d, w, ggc, lx - hsize / 2,	ly - hsize / 2,	hsize, hsize,
		     0, circle);

	    XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->draw_arc_col)]);
	    XDrawArc(d, w, ggc, lx - hsize / 2,	ly - hsize / 2,	hsize, hsize,
		     0, circle);
	    }
	  else
	    XDrawArc(d, w, ggc,	lx - hsize / 2, ly - hsize / 2,	hsize, hsize,
		     0, circle);
	  }
        }
      }
    }

  /* connect sources */

  if(xm->connect_flag)
    {
    for(i = 0; i < xm->sources[0].numpoints; i++)
      {
      /* k = gproj(xs->line.x1, xs->line.y1, xs->line.x2, xs->line.y2, xs->dip,
	 xm->sources[0].loc[i].x, xm->sources[0].loc[i].y,
	 xm->sources[0].loc[i].z, &r1[0], &off1[0], &dep1[0]);*/

      k = In_Rect_Vol(xs->RM, xm->sources[0].loc[i].x - xs->line.x1,
		      xm->sources[0].loc[i].y - xs->line.y1,
		      xm->sources[0].loc[i].z, xs->min_xsdepth,
		      xs->max_xsdepth, xs->x_left,  xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r1[0], &dep1[0], &off1[0]);

      if(k == 1)
	{
	  {
	  for(a = 1; a <= xm->max_more_src - 1; a++)
	    {
	    jj = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
			     xm->sources[a].loc[i].y - xs->line.y1,
			     xm->sources[a].loc[i].z, xs->min_xsdepth,
			     xs->max_xsdepth,  xs->x_left, xs->x_right, xs->max_xsfront,
			     xs->max_xsback, &r1[a], &dep1[a], &off1[a]);

	    if(jj == 1)
	      {
		{
		XSetForeground(d, ggc,
		  xm->colors[XmapAppColor(xm->src_col - (a - 1))]);
		ly = user_to_pix_y(&xs->GR, (double)dep1[a - 1]);
		lx = user_to_pix_x(&xs->GR, (double)r1[a - 1]);
		ly2 = user_to_pix_y(&xs->GR, (double)dep1[a]);
		lx2 = user_to_pix_x(&xs->GR, (double)r1[a]);
		XDrawLine(d, w, ggc, lx, ly, lx2, ly2);
		}
	      }
	    }
	  }
	}
      }
    }

  /* wells */

  XSetFont(d, ggc, xm->fonts[3]);
  if(xm->wells_flag > 1) Xsec_plot_well(xs, d, w, ggc);

  /* points projection */

  if(xm->point_flag > 0) Xsec_plot_points(xs, d, w, ggc);
  if(xm->lip_flag > 0) Xsec_plot_lips(xs, d, w, ggc);

  /* station projection */

  XSetFont(d, ggc, xm->fonts[3]);
  if(xm->sta_flag)
    {
    XSetForeground(d, ggc, xm->colors[XmapAppColor(xm->sta_col)]);
    for(kount = 0; kount < xm->num_sta_files; kount++)
      {
      XSetForeground(d, ggc,
		     xm->colors[XmapAppColor(xm->stations[kount].color)]);
      for(a = 0; a < xm->stations[kount].numpoints; a++)
	{
	switch(xs->sta_elevation_flag)
	  {
	  case 0:
	    garb1 = 0.0;
	    break;

	  case 1:
	    garb1 = (xm->stations[kount].sta[a].loc.z );
	    break;

	  case 2:
	    garb1 = (xm->stations[kount].sta[a].loc.z
		     - xm->stations[kount].mean_elev);
	    break;

          default:
	    garb1 = 0.0;
	    break;
	  }

	/* garb1 = (xm->stations[kount].sta[a].loc.z
	   - xm->stations[kount].mean_elev);*/

	k = In_Rect_Vol(xs->RM, xm->stations[kount].sta[a].loc.x - xs->line.x1,
			xm->stations[kount].sta[a].loc.y - xs->line.y1, garb1,
			xs->min_xsdepth, xs->max_xsdepth,  xs->x_left, xs->x_right,
			xs->max_xsfront, xs->max_xsback, &r, &dep, &off);

	if(k == 1)
	  {
	  ly = user_to_pix_y(&xs->GR, (double)garb1) - xm->size_sta;
	  lx = user_to_pix_x(&xs->GR, (double)r);

	  switch(xm->stations[kount].symbol)
	    {
	    case 0:
	      draw_triang(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    case 1:
	      draw_triang_2(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    case 2:
	      draw_square(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    case 3:
	      draw_star_david(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    case 4:
	      draw_ex(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    case 5:
	      draw_Plus(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    case 6:
	      draw_Diamond(d, w, ggc, lx, ly, xm->size_sta);
	      break;

	    default:
	      draw_triang(d, w, ggc, lx, ly, xm->size_sta);
	      break;
	    }

	  if(xm->sta_name_flag)
	    draw_just_text(d, w, ggc, lx, ly - xm->size_sta,
			   xm->stations[kount].sta[a].name,
			   HJ_CENTER, VJ_BASELINE);
	  }
	}			/* end kount station loop */
      }
    }

  /* Wire Frame */

  if(xm->wire_flag)
    {
    for(i = 0; i < xs->num_threeD; i++)
      {
      /* fprintf(stderr, "X3D: %d %f %f %f %f\n", i, xs->threeD[i].x1,
	 xs->threeD[i].y1, xs->threeD[i].x2, xs->threeD[i].y2); */

      lx = user_to_pix_x(&xs->GR, (double)xs->threeD[i].x1);
      ly = user_to_pix_y(&xs->GR, (double)xs->threeD[i].y1);
      lx2 = user_to_pix_x(&xs->GR, (double)xs->threeD[i].x2);
      ly2 = user_to_pix_y(&xs->GR, (double)xs->threeD[i].y2);
      XSetForeground(d, ggc, colors[XmapAppColor(xs->col3D[i])]);
      XDrawLine(d, w, ggc, lx, ly, lx2, ly2);
      }
    }

  /* other stuff */

  XSetForeground(d, ggc, colors[XmapAppColor(xm->stuff_col)]);
  /* lx = user_to_pix_x(&xs->GR, (double)xs->x_right); */
  lx = xs->GR.pix_xmax;
  ly = user_to_pix_y(&xs->GR, (double)xs->y_bot);
  XDrawRectangle(d, w, ggc, xs->GR.pix_xmin, xs->GR.pix_ymin, xs->GR.pix_xdif,
		 xs->GR.pix_ydif);

  /* put the xsect number in left hand corner  */

  XSetFont(d, ggc, xm->fonts[1]);
  sprintf(pchar, "%d", xs->index);
  draw_just_text(d, w, ggc, user_to_pix_x(&xs->GR, (double)xs->x_left),
		 user_to_pix_y(&xs->GR, (double)xs->y_top) - 5, pchar,
		 HJ_RIGHT, VJ_BASELINE);
  XSetFont(d, ggc, xm->fonts[3]);


  /* draw in scales */

  xaxis(d, w, ggc, &xs->GR, xs->x_left, xs->y_bot, xs->x_right, -1, -1, 10, 
	0.0);
  xaxis(d, w, ggc, &xs->GR, xs->x_left, xs->y_top, xs->x_right, -1, 0, 10, 
	0.0);
  yaxis(d, w, ggc, &xs->GR, (double)xs->x_left, (double)xs->y_top,
	(double)xs->y_bot, -1, 0, 10, 0.0);
  yaxis(d, w, ggc, &xs->GR, (double)xs->x_right, (double)xs->y_top,
	(double)xs->y_bot, 1, 1, 10, 0.0);

  for(i = 0; i <= xs->num_labels; i++) 
    {
    draw_Arrow(d, w, ggc, xs->labels[i].p.x1, xs->labels[i].p.y1,
	       xs->labels[i].p.x2, xs->labels[i].p.y2);

    draw_just_text(d, w, ggc, xs->labels[i].p.x1, xs->labels[i].p.y1,
		   xs->labels[i].label, HJ_CENTER, VJ_BASELINE);
    }

  /* field stuff */

  if(xs->X_Above == 1) Plot_X_Field(xs);
  if(xs->X_InMod == 1) Plot_X_Field2(xs);


  if(xs->X_Image_Above == 1) Plot_Topo_Field(xs);

  /* printf(" THE X-SEC DIMS: %d %f\n", xs->xdepth, xs->x_right); */
  }

/* ----------------------------------------------------- */

/* Tells a widget to repaint one rectangle */

static void send_repaint_X(Widget wij, int x, int y, int w, int h)
  {
  Region exposed;
  XRectangle r = {x, y, w, h};

  /* printf("send_repaint_x rectangle: %d %d %d %d \n",x,y,w,h); */ 

  exposed = XCreateRegion();
  XUnionRectWithRegion(&r, exposed, exposed);
  redraw_xsec(wij, NULL, exposed);  
  XDestroyRegion(exposed);
  }

/* ===================================================== */

void switch_sta_el(Widget wij, xsec *xs, char *call_data)
  {
  Dimension win_hite, win_width;

  XtVaGetValues(xs->shell, XtNwidth, &win_width, XtNheight, &win_hite, NULL);
  xs->sta_elevation_flag++;
  if(xs->sta_elevation_flag > 2) xs->sta_elevation_flag = 0;
  send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
  }

/* ===================================================== */

void switch_dip(Widget wij, xsec *xs, char *call_data)
  {
  Dimension win_hite, win_width;

  XtVaGetValues(xs->shell, XtNwidth, &win_width, XtNheight, &win_hite, NULL);
  xs->dip_meter_flag = !xs->dip_meter_flag;

  if(xs->dip_meter_flag == 0)
    XtVaSetValues(wij,XtNlabel, "Apparent Dip",	NULL);
  else
    XtVaSetValues(wij, XtNlabel, "True Dip", NULL);

  send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
  }

/* --------------------------------------------------------- */

static void quit(void)
  {
  exit(0);
  }

/* --------------------------------------------------------- */

void XDialogDoneAction(Widget wij, XButtonEvent *event, String *params,
		       Cardinal *num_params)
  {

  XtCallCallbacks(XdialogDone, XtNcallback, DialogDone_xsec);
  }

/* dialog box to change dip of earthquake plotting */

static void DialogDone_Dip(Widget wij, xsec *xs, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(xs->xs_shell);

  sfile = XawDialogGetValueString(xs->dialog);
  sscanf(sfile, "%f", &xs->dip);
  printf(" Dialog value: %f ", xs->dip); 
  XtVaGetValues(xs->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }

/* dialog box to change dip of earthquake plotting */

static void DialogDone_Depth(Widget wij, xsec *xs, char *call_data) 
  {
  String sfile;
  Position x, y;
  Dimension w, h;
  float d1, d2;
  
  XtPopdown(xs->xs_shell);

  sfile = XawDialogGetValueString(xs->dialog);  

  sscanf(sfile, "%f %f", &d1, &d2);
  /* printf(" Dialog value: %f %f", xs->y_top, xs->y_bot); */ 
  XtVaGetValues(xs->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  xs->xdepth = d2;
  
  xs->max_xsdepth = d2;
  xs->min_xsdepth = d1;

  xs->y_top = d1; 
  xs->y_bot = d2;
  send_repaint_X(xs->wij, 0, 0, w, h);
  }

/* --------------------------------------------------------- */

/* dialog box to change dip of earthquake plotting */
#if 0
static void DialogDone_Scale(Widget wij, xsec *xs, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(xs->xs_shell);

  sfile = XawDialogGetValueString(xs->dialog);  
  sscanf(sfile, "%f", &xs->xscale );
  XtVaGetValues(xs->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }
#endif
/* --------------------------------------------------------- */

/* dialog box to change dip of earthquake plotting */

static void DialogDone_xchange_save_file(Widget wij, xsec *xs,
					 char *call_data) 
  {
  String sfile;

  XtPopdown(xs->xs_shell);

  sfile = XawDialogGetValueString(xs->dialog);
  sscanf(sfile, "%f", &xs->xscale);
  clean_file_name(&sfile);
  strcpy(xs->m->src_dump_file, sfile);
  /* Hypos_2_File(xs->xm, sfile, 0); */
  Dump_selXsource(xs, sfile, 0);
  }

/* --------------------------------------------------------- */

/* dialog box to change dip of earthquake plotting */

static void DialogDone_Label(Widget wij, xsec *xs, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(xs->xs_shell);

  sfile = XawDialogGetValueString(xs->dialog);
  ++xs->num_labels;
  strcpy(xs->labels[xs->num_labels].label, sfile);
  /* printf(" Dialog value: %f ", xs->xscale); */
  XtVaGetValues(xs->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  /* send_repaint_X(xs->wij, 0, 0, w, h); */
  }

/* --------------------------------------------------------- */

/* dialog box to for postscript plotting */

static void DialogDone_PS(Widget wij, xsec *xs, char *call_data) 
  {
  String sfile;
  int x, y, w, h;

  XtPopdown(xs->xs_shell);

  sfile = XawDialogGetValueString(xs->dialog);
  Do_Postscript_Xsect(XtDisplay(wij), sfile, xs);
  XtVaGetValues(xs->wij, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }

static void XDialogQuit(Widget wij, XButtonEvent *event, String *params,
			Cardinal *num_params)
  {

  /* xsec *xs;

     XtVaGetValues(wij, XtNdata, &xs, NULL);
     XtPopdown(xs->xs_shell); */

  XtPopdown(DialogDone_xsec->xs_shell);
  }

/* ------------------------------------------------------------------ */

static void PopupDialogXS(Widget w, xsec *pf, XtCallbackProc  xsecdiagdone)
  {
  Position x, y;
  Dimension width, height;
  Arg arg[5];
  int i;

  /* HERE is the NEW LINE to remove the input LINE!  */

  XtVaSetValues(pf->dialog, XtNvalue, "", NULL);

  /* get the coordinates of the middle of topLevel widget */

  XtVaGetValues(pf->shell, XtNwidth, &width, XtNheight, &height, NULL);
  XtRemoveAllCallbacks(pf->dialogdone, XtNcallback);
  XtAddCallback(pf->dialogdone, XtNcallback, (XtCallbackProc)xsecdiagdone, pf);

  /* translate coordinates in application top-level window into coordinates
     from root window origin */

  XtTranslateCoords(pf->shell, (Position)(width / 2), (Position)(height / 2),
		    &x, &y);

  /* move popup shell to this position (it's not visible yet) */

  i = 0;
  XtSetArg(arg[i], XtNx, x); i++;
  XtSetArg(arg[i], XtNy, y); i++;
  XtSetArg(arg[i], XtNwidth, 300); i++;
  XtSetArg(arg[i], XtNheight, 200); i++;
  XtSetValues(pf->xs_shell, arg, i);

  /* Indicate to user that no other application functions are valid while
     dialog is popped up... */
  /* Move the mouse here, too */

  XtPopup(pf->xs_shell, XtGrabNonexclusive);
  XWarpPointer(XtDisplay(pf->xs_shell), None, XtWindow(pf->xs_shell),
	       0, 0, 0, 0, x - 100, y + 100);

  /* printf("done with PopupDialogXS\n"); */ 
  }

/* --------------------------------------------------------- */

static void Popup_dip(Widget w, xsec *xs, char *call_data)
  {
  char lab[30];

  sprintf(lab, "DIP: current=%f", xs->dip);
  XtVaSetValues(xs->dialog, XtNlabel, lab, NULL);
  PopupDialogXS(w, xs, (XtCallbackProc)DialogDone_Dip);
  }

/* --------------------------------------------------------- */

static void Popup_depth(Widget w, xsec *xs, char *call_data)
  {
  char lab[100];

  sprintf(lab, "Depth Range: current=%f %f", xs->y_top,xs->y_bot );
  XtVaSetValues(xs->dialog, XtNlabel, lab, NULL);
  PopupDialogXS(w, xs, (XtCallbackProc)DialogDone_Depth);
  }

#if 0
static void Popup_scale(Widget w, xsec *xs, char *call_data)
  {
  char lab[30];

  sprintf(lab, "Scale: current=%f", xs->xscale);
  XtVaSetValues(xs->dialog, XtNlabel, lab, NULL);
  PopupDialogXS(w, xs,(XtCallbackProc) DialogDone_Scale);
  }
#endif

/* --------------------------------------------------------- */

static void Popup_src_dump(Widget w, xsec *xs, char *call_data)
  {
  char lab[30];

  sprintf(lab, "File for Saving Sources: last=%s", xs->m->src_dump_file);
  XtVaSetValues(xs->dialog, XtNlabel, lab, NULL);
  PopupDialogXS(w, xs, (XtCallbackProc)DialogDone_xchange_save_file);
  }

static void Popup_Label(Widget w, xsec *xs, char *call_data)
  {
  char lab[30];

  sprintf(lab, "Insert Label:");
  XtVaSetValues(xs->dialog, XtNlabel, lab, NULL);
  PopupDialogXS(w, xs, (XtCallbackProc)DialogDone_Label);
  }

static void Popup_PS(Widget w, xsec *xs, char *call_data)
  {

  XtVaSetValues(xs->dialog, XtNlabel, "Postscript:", NULL);
  PopupDialogXS(w, xs, (XtCallbackProc)DialogDone_PS);
  }

/* --------------------------------------------------------- */



static void xs_Key_Q_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  printf(" Bye! Quitting geotouch from XSEC %d %d \n", ev->x, ev->y);
  quit();
  }

/* --------------------------------------------------------- */

  /* fix the plot so the aspect ratio is 1:1
     i.e.  1 km in x = 1 km in y */

static void xs_Key_u_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec *xs;
  float dx, dy;

  int wix, wiy;
  Position x, y;
  Dimension wi, h;

  XtVaGetValues(w, XtNdata, &xs, NULL);
  XtVaGetValues(xs->shell, XtNx, &x, XtNy, &y, XtNwidth, &wi, XtNheight, &h,
                NULL);

  /* fprintf(stderr,"start xsec wi h: %d %d \n",wi,h); */

  dx = wi - 2 * xs->Xmargin;
  dy = h - 1.5 * xs->Ymargin;

  if(dy > dx)
    {
    wiy = dy;
    wix = (int)((float)wiy * xs->GR.user_xdif / fabs(xs->GR.user_ydif));
    }
  else
    {
    wix = dx;
    wiy = (int)((float)fabs(wix * xs->GR.user_ydif) / xs->GR.user_xdif);
    }

  wix += 2 * xs->Xmargin;
  wiy += 1.5 * xs->Ymargin;

  /* window(&xs->GR, (double)xs->x_left, (double)xs->x_right,
     (double)(xs->y_bot), (double)xs->y_top);
     viewport(&xs->GR, xs->Xmargin, win_width-xs->Xmargin, xs->Ymargin / 2,
     win_hite - 1.0 * xs->Ymargin);
     print_graph(xs->GR);
     fprintf(stderr, "xsec wix wiy: %d %d \n", wix, wiy); */

  XtVaSetValues(xs->shell, XtNx, x, XtNy, y, XtNwidth, wix, XtNheight, wiy,
		NULL);
  }
static void xs_Key_l_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec *xs;
  
  XtVaGetValues(w, XtNdata, &xs, NULL);


   XtVaSetValues(xs->shell, XtNx, 100, XtNy, 100, XtNwidth, 400,
		XtNheight, 500, NULL);

  send_repaint_X(xs->wij, 0, 0, 400, 500);                     
  }
/* --------------------------------------------------------- */

static void xs_Key_e_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec *xs;
  mpic *xm;

  XtVaGetValues(w, XtNdata, &xs, NULL);
  xm = xs->m;

  xm->focal_explode = !xm->focal_explode;
  send_repaint_X(xs->wij, 0, 0, xm->ScreenX, xm->ScreenY);                     
  }

/* --------------------------------------------------------- */
int Get_i_value(mpic *xm, float xkm, float ykm, float zkm)
  {
  int lay, iv,  ix, iy;
  float phi, lam;
  
/*
 for(i = 0; i < xm->image.nz; i++)
    {
      if(zkm >= xm->image.z_parts[i] && zkm < xm->image.z_parts[i + 1])
	{
	  lay = i;
	  break;
	}
    }
*/
 lay = indepth(xm->image.z_parts,xm->image.nz,zkm);
  
  if(!strcmp(xm->image.Type, "GMT"))
    {
      xy2geo(xm, &phi, &lam, xkm, ykm); 
      
      ix = (int)((lam - xm->image.lam+xm->image.dx)/xm->image.dx) ;
      iy = (int)((xm->image.phi - phi +xm->image.dy)/xm->image.dy); 
    }
  else
    {
      ix = floor((xkm - xm->image.org_minx) / xm->image.dx) + 1;
      iy = floor((ykm - xm->image.org_miny) / xm->image.dy) + 1;

    }
  
       
  if(ix < 1 || ix > xm->image.nx || iy < 1 || iy > xm->image.ny)
    return(-1);
  
   iv = (((iy - 1) * xm->image.nx + ix) + lay * (xm->image.nx * xm->image.ny)
	    - 1);
	
  return(iv);
  }


/* --------------------------------------------------------- */
float Get_image_value(mpic *xm, float xkm, float ykm, float zkm)
  {
  float  val;
  int  iv,  n;

  n = xm->image.nx * xm->image.ny * xm->image.nz;
  
  iv = Get_i_value(xm,  xkm,  ykm,  zkm);
  
   if(iv == -1) return(xm->image.image_skip);
   
  if(iv < 0 || iv >= n)
    {
    fprintf(stderr, "Point Not in Image\n");
    return(xm->image.image_skip);
    }

  val = xm->image.val[iv];
  return(val);
  }

/* --------------------------------------------------------- */


void print_xpoint(xsec *xs, int ex, int ey)
  {
  mpic *xm = xs->m;
  float xkm, zkm, phi, lam, px, py, temspac;

  xkm =  pix_to_user_x(&xs->GR, (int)ex);
  zkm =  pix_to_user_y(&xs->GR, (int)ey);

  fprintf(stdout,"\nCross Section POINT: distance = %f depth = %f \n", xkm, zkm);
  px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
  py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 
  xy2geo(xm, &phi, &lam, px, py);


  fprintf(stdout,"DEG LAT-LON: %f %f \n", phi, lam);

  xkm = pix_to_user_x(&xs->GR, (int)ex);
  zkm = pix_to_user_y(&xs->GR, (int)ey);

  fprintf(stdout,"\nNEW: distance = %f depth = %f \n", xkm, zkm);

  if(xm->image_flag)
    {
    temspac = Get_image_value(xm, px, py, zkm);
    fprintf(stderr, " Image Value = %f\n", temspac);
    }
if(xm->points_store==1)
  {
  fprintf(xm->pointsFP, "%f %f %f\n", phi, lam, zkm);
  }
  


  }

static void xs_Key_p_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec  *xs;

  XtVaGetValues(w, XtNdata, &xs, NULL);
  print_xpoint(xs, (int) ev->x,(int)  ev->y);
  }

/* --------------------------------------------------------- */

static void xs_Key_o_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec  *xs;
  mpic *xm;
  float xkm, zkm, phi, lam, px, py;

  XtVaGetValues(w, XtNdata, &xs, NULL);
  xm = xs->m;
  xkm =  pix_to_user_x(&xs->GR, (int)ev->x);
  zkm =  pix_to_user_y(&xs->GR, (int)ev->y);

  /* calculate the latitude and longitude of point  */

  px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
  py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 

  xy2geo(xm, &phi, &lam, px, py);
  printf("DEG LAT-LON: %f %f %f\n", phi, lam, zkm);
  }

static void xs_Key_c_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec *X;
  mpic *m;
  int i;

  XtVaGetValues(w, XtNdata, &X, NULL);
  m = X->m;
  i = m->focal_plot_style;
  if(i == 1) m->focal_plot_style = 2;
  else if(i == 2) m->focal_plot_style = 4;
  else if(i == 4) m->focal_plot_style = 5;
  else if(i == 5) m->focal_plot_style = 4;

  send_repaint_X(X->wij, 0, 0, m->ScreenX, m->ScreenY);
  }

static void xs_Key_m_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec *X;

  XtVaGetValues(w, XtNdata, &X, NULL);
  X->marrow_org.x = ev->x;
  X->marrow_org.y = ev->y;
  X->marrow_spot = X->marrow_org;
  }

static void xs_Key_n_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  GC ggc;
  xsec *X;
  mpic *m;
  float rx, ry;

  XtVaGetValues(w, XtNdata, &X, NULL);
  ggc = X->ggc; 
  m = X->m;
  X->marrow_spot.x = ev->x;
  X->marrow_spot.y = ev->y;

  /* Draw Line... */

  XDrawLine(XtDisplay(w), XtWindow(w), ggc, X->marrow_org.x, X->marrow_org.y, 
	    X->marrow_spot.x, X->marrow_spot.y);
  X->labels[X->num_labels].p.x1 = X->marrow_org.x;
  X->labels[X->num_labels].p.x2 = X->marrow_spot.x;
  X->labels[X->num_labels].p.y1 = X->marrow_org.y;
  X->labels[X->num_labels].p.y2 = X->marrow_spot.y;

  rx =  pix_to_user_x(&X->GR, (int)X->marrow_org.x);
  ry =  pix_to_user_y(&X->GR, (int)X->marrow_org.y);

  X->labels[X->num_labels].kmloc.x1 = rx;
  X->labels[X->num_labels].kmloc.y1 = ry;

  X->labels[X->num_labels].latlon.x1 = rx;
  X->labels[X->num_labels].latlon.y1 = ry;

  rx = pix_to_user_x(&X->GR, (int) X->marrow_spot.x);
  ry = pix_to_user_y(&X->GR, (int) X->marrow_spot.y);

  X->labels[X->num_labels].kmloc.x2 = rx;
  X->labels[X->num_labels].kmloc.y2 = ry;

  X->labels[X->num_labels].latlon.x2 = rx;
  X->labels[X->num_labels].latlon.y2 = ry;

  printf("LABEL: %d %d %d %d %d %s\n", X->num_labels,
	 X->labels[X->num_labels].p.x1, X->labels[X->num_labels].p.y1,
	 X->labels[X->num_labels].p.x2, X->labels[X->num_labels].p.y2,
	 X->labels[X->num_labels].label);

  fprintf(stderr, " %%-----------------------------X-sec PostScript Label\n");
  fprintf(stderr, " newpath \n");

  fprintf(stderr, " %f bx %f bz %f bx %f bz 2 10 16 arrow fill\n",
	  X->labels[X->num_labels].kmloc.x1,
	  -X->labels[X->num_labels].kmloc.y1,
	  X->labels[X->num_labels].kmloc.x2,
	  -X->labels[X->num_labels].kmloc.y2);
  fprintf(stderr, "     (%s)  %f bx %f bz moveto cen_labshow \n",
	  X->labels[X->num_labels].label,
	  X->labels[X->num_labels].kmloc.x1,
	  -X->labels[X->num_labels].kmloc.y1);
  fprintf(stderr," %%----------------------------------------------\n");

  send_repaint_X(X->wij, 0, 0, m->ScreenX, m->ScreenY);
  }

static void xs_Key_f_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  mpic *m;
  xsec *X;
  float dis, rx, ry, focrad, kmscale;
  int i, found;

  XtVaGetValues(w, XtNdata, &X, NULL);
  m = X->m;

  if(m->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal FIles available\n");
    return;
    }

  kmscale = X->GR.user_xdif / X->GR.pix_xdif;
  X->marrow_org.x = ev->x;
  X->marrow_org.y = ev->y;
  X->marrow_spot = X->marrow_org;

  rx =  pix_to_user_x(&X->GR, (int)X->marrow_org.x);
  ry =  pix_to_user_y(&X->GR, (int)X->marrow_org.y);

  found = 0;
  for(i = 0; i < X->jselect; i++)
    {
    focrad = X->focrad[i] * kmscale;
    dis = sqrt(sqr(rx - X->focpos[i].x2) + sqr(ry - X->focpos[i].y2));
    if(dis < focrad)
      {
      X->focal_selection = i;
      found = 1;
      break;
      }
    }

#if 0
  if(found)
    printf(" GET-FOC %d at %f %f found at %f %f \n",
	   X->focal_selection, rx, ry, X->focpos[i].x2, X->focpos[i].y2);
  else
    {
    X->focal_selection = -1;
    printf(" NO FOC NEAR  %f %f \n", rx, ry);
    }
#endif
  }

static void xs_Key_g_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  xsec *X;
  mpic *m;
  int i, j, kount;

  XtVaGetValues(w, XtNdata, &X, NULL);
  m = X->m;

  if(m->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal FIles available\n");
    return;
    }

  X->marrow_org.x = ev->x;
  X->marrow_org.y = ev->y;
  X->marrow_spot = X->marrow_org;
  i = X->focal_selection;
  j = X->focind[i];
  kount = X->focind_file[i];

  if(i >= 0)
    {
    X->focpos[i].x2 = pix_to_user_x(&X->GR, (int)X->marrow_org.x);
    X->focpos[i].y2 = pix_to_user_y(&X->GR, (int)X->marrow_org.y);

    /* printf("Mec %d moving to: %d %d\n", X->focal_selection, ev->x,
       ev->y); */

    printf("Focal Mec: %s mag = %3.1f \n", m->focm[kount].focs[j].ac.id,
	   m->focm[kount].focs[j].ac.mag);
    }

  send_repaint_X(X->wij, 0, 0, m->ScreenX, m->ScreenY);
  }

static void xs_Key_v_lees(Widget w, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  mpic *m;
  xsec *X;
  float dis, rx, ry, dx, dy, focrad, kmscale;
  int i, found, kount;

  XtVaGetValues(w, XtNdata, &X, NULL);
  m = X->m;

  if(m->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal FIles available\n");
    return;
    }

  kmscale = X->GR.user_xdif / X->GR.pix_xdif;
  rx =  pix_to_user_x(&X->GR, (int)ev->x);
  ry =  pix_to_user_y(&X->GR, (int)ev->y);

  /* fprintf(stderr, " search-FOC start: rx=%f ry=%f\n", rx, ry); */

  found = 0;
  for(i = 0; i < X->jselect; i++)
    {
    focrad = X->focrad[i] * kmscale;
    if(m->focal_explode == 1)
      dx = X->focpos[i].x2, dy = X->focpos[i].y2;
    else
      dx = X->focpos[i].x1, dy = X->focpos[i].y1;

    dis = sqrt(sqr(rx - dx) + sqr(ry - dy));

    /* fprintf(stderr," search-FOC %d at %f %f %f \n",i, dis,dx,dy); */

    if(dis < focrad)
      {
      X->focal_selection = i;
      found = 1;
      break;
      }
    }
   
  if(found == 1)
    {
    i = X->focal_selection;

    /* printf(" GET-FOC %d at %f %f found at %f %f \n",
       X->focal_selection, rx,ry, X->focpos[i].x2, X->focpos[i].y2); */

    m->focal_selection = X->focind[X->focal_selection];
    kount = X->focind_file[X->focal_selection];
    switch_foc(m, kount); 
    }
  else
    {
    X->focal_selection = -1;
    printf(" NO FOC NEAR  %f %f \n", rx, ry);
    }

  /* printf(" switch-FOC %d at %f %f found at %f %f %f %f\n",
     X->focal_selection, rx,ry,X->focpos[i].x1, X->focpos[i].y1,
     X->focpos[i].x2, X->focpos[i].y2); */

  send_repaint_X(X->wij, 0, 0, m->ScreenX, m->ScreenY);
  }

static void xs_Key_a_lees(Widget wij, XKeyEvent *ev, String *params,
			  Cardinal *num_params)
  {
  mpic *m;
  xsec *X;
  int i, k, n, kk, hsize, circle = 23040, indtim[10000], pixx[10000],
    pixy[10000], inine, num, yy, freq_print = 100, iy, im, id, ih, mm,
    dd, lx, ly, a, astart, aend;
  float siz[10000], tims[10000], dt, wa, secs_to_wait, dep, r, off;

  unsigned int iwait;
  
  Display *disp;
  Window wind;
  GC ggc;
  stamp date_stamp[10000];

  XtVaGetValues(wij, XtNdata, &X, NULL);
  m = X->m;
  wind = XtWindow(wij);
  disp = XtDisplay(wij);
  ggc = X->ggc;
  m->src_flag = m->more_src_flag = 0;

  send_repaint_X(X->wij, 0, 0, m->ScreenX, m->ScreenY);

  XSetFont(disp, ggc, m->fonts[2]);
  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->background_col)]);
  XFillRectangle(disp, wind, ggc, 200, 0, 200, 20);
  XFlush(disp);

  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->date_col)]);
  draw_just_text(disp, wind, ggc, 200, 20, "Please Wait...", HJ_LEFT,
		 VJ_BASELINE);
  XFlush(disp);

  yy = 1980;
  iy = 1;
  tojul(yy, iy, iy, &inine);

  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->date_col)]);
  hsize = m->SourceSize / 2;

  astart = n = k = 0;
  aend = m->max_more_src; 

  printf("start and end: %d %d \n", astart, aend);

  for(a = astart; a < aend; a++)
    {
    for(i = 0; i < m->sources[a].numpoints; i++)
      {
      kk = In_Rect_Vol(X->RM, m->sources[a].loc[i].x - X->line.x1,
		       m->sources[a].loc[i].y - X->line.y1,
		       m->sources[a].loc[i].z, X->min_xsdepth,
		       X->max_xsdepth, X->x_left,  X->x_right, X->max_xsfront,
		       X->max_xsback, &r, &dep, &off);

      if(kk == 1)
	{
	ly = user_to_pix_y(&X->GR, (double)dep);
	lx = user_to_pix_x(&X->GR, (double)r);

	sscanf(m->sources[a].acard[i].id, "%2d%2d%2d%2d%2d", &iy, &im, &id,
	       &ih, &mm);
	yy = 1900 + iy;
	tojul(yy, im, id, &dd);
	dd -= inine;
	dt = (dd + (float)ih / (24.0) + (float)mm / (24.0 * 60.0)
	      + m->sources[a].acard[i].sec / (24.0 * 60.0 * 60.0));
	siz[k] = m->sources[a].size[i];

	/* printf("%d %f %f\n",k,siz[k],m->sources[a].acard[i].mag); */

	pixx[k] = lx - siz[k] / 2;
	pixy[k] = ly - siz[k] / 2;
	sprintf(date_stamp[k].dat, "%2d %2d %2d %2d %2d", iy, im, id, ih, mm);
	tims[k] = dt;
	k++;
	}
      }
    }

  num = k;
  freq_print = 100;
  if(num < 100) freq_print = 1;
  printf("Please wait......\n .......there are %d events to sort\n", num);
  csorta(tims, indtim, tims, num);
  dt = tims[num-1] - tims[0];
  wa = m->time_plot_wait / dt;

  for(i = 0; i < num - 1; i++)
    {
    hsize = siz[indtim[i]];

    /* printf("%d %d \n", pixx[indtim[i]], pixy[indtim[i]]); */

    XSetForeground(disp, ggc, m->colors[XmapAppColor(m->fancy_src_col)]);
    XFillArc(disp, wind, ggc, pixx[indtim[i]], pixy[indtim[i]],	hsize, hsize,
	     0, circle);

    XSetForeground(disp, ggc, m->colors[XmapAppColor(m->fancy_perim_col)]);
    XDrawArc(disp, wind, ggc, pixx[indtim[i]], pixy[indtim[i]],	hsize, hsize,
	     0, circle);
    XFlush(disp);

    if((i % freq_print ) == 0)
      {
      /* printf("%d  %s\n",i, date_stamp[indtim[i]].dat); */

      XSetForeground(disp, ggc, m->colors[XmapAppColor(m->background_col)]);
      XFillRectangle(disp, wind, ggc, 200, 0, 200, 20);
      XFlush(disp);

      XSetForeground(disp, ggc, m->colors[XmapAppColor(m->date_col)]);
      draw_just_text(disp, wind, ggc, 200, 20, date_stamp[indtim[i]].dat,
		     HJ_LEFT, VJ_BASELINE);
      XFlush(disp);
      }

    secs_to_wait = (tims[i + 1] - tims[i]) * wa;

    /* printf("%f seconds to wait\n", secs_to_wait);*/

    iwait = 1000000 * secs_to_wait; usleep(iwait); 
    /* sleep(secs_to_wait); */

    }

#if 1	
  hsize = siz[indtim[num - 1]];

  /* printf("%d %d \n",pixx[indtim[num]-1], pixy[indtim[num]]); */

  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->date_col)]);
  XFillArc(disp, wind, ggc, pixx[indtim[num - 1]], pixy[indtim[num - 1]],
	   hsize, hsize, 0, circle);
  XFlush(disp);

  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->fill_arc_col)]);
  XFillArc(disp, wind, ggc, pixx[indtim[num - 1]], pixy[indtim[num - 1]],
	   hsize, hsize, 0, circle);

  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->fancy_perim_col)]);
  XDrawArc(disp,wind, ggc, pixx[indtim[num - 1]], pixy[indtim[num - 1]],
	   hsize, hsize,0, circle);
  XFlush(disp);

#endif

  m->src_flag = m->more_src_flag = 1;

  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->background_col)]);
  XFillRectangle(disp, wind, ggc, 200, 0, 200, 20);
  XFlush(disp);

  printf("DONE: %d \n", num);
  XSetForeground(disp, ggc, m->colors[XmapAppColor(m->text_col)]);
  draw_just_text(disp, wind, ggc, 200, 20, "Done!      ", HJ_LEFT,
		 VJ_BASELINE);
  XFlush(disp);
  }

/* --------------------------------------------------------- */

void Start_selXsource(Widget wij, XButtonEvent *event, String *params,
		      Cardinal *num_params)
  {
  xsec *xs;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xs->selXsource_flag = 1;
  xs->selXsourcemove_flag = 0;
  xs->selXsource_org.x = event->x;
  xs->selXsource_org.y = event->y;
  xs->selXsource_spot = xs->selXsource_org;
  gscr_num = DefaultScreen(XtDisplay(wij));

  xkmORG =  pix_to_user_x(&xs->GR, (int) xs->selXsource_org.x );
  zkmORG =  pix_to_user_y(&xs->GR, (int) xs->selXsource_org.y );


  XSetForeground(XtDisplay(wij), xs->ggc,
		 BlackPixel(XtDisplay(wij), gscr_num));
  XSetBackground(XtDisplay(wij), xs->ggc,
		 WhitePixel(XtDisplay(wij), gscr_num));
  }

/* --------------------------------------------------------- */

void Resize_selXsource(Widget wij, XButtonEvent *event, String *params,
		       Cardinal *num_params)
  {
  GC ggc;
  xsec *xs;
  XPoint p[5];
  mpic *xm;
 char plot_lab[50];
  float  xkm, zkm, phi, lam, px, py;
  double dis;


  XtVaGetValues(wij, XtNdata, &xs, NULL);
  ggc = xs->ggc;
  xm = xs->m;
  XSetClipMask(XtDisplay(wij), ggc, None);
  XSetFunction(XtDisplay(wij), ggc, GXnor);

  getbox(xs->selXsource_org.x, xs->selXsource_org.y,
	 xs->selXsource_spot.x, xs->selXsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);
  xs->selXsource_spot.x = event->x;
  xs->selXsource_spot.y = event->y;

  getbox(xs->selXsource_org.x, xs->selXsource_org.y,
	 xs->selXsource_spot.x, xs->selXsource_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  xs->selXsourcemove_flag = 1;



  xkm =  pix_to_user_x(&xs->GR, (int) xs->selXsource_spot.x );
  zkm =  pix_to_user_y(&xs->GR, (int) xs->selXsource_spot.y );

  px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
  py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 
  xy2geo(xm, &phi, &lam, px, py);

  dis = sqrt((double)(sqr(xkm-xkmORG) + sqr(zkm-zkmORG)));

 sprintf(plot_lab , "X=%f Z=%f Dis: %f  Map: %f %f LL: %f %f\n", 
	  xkm,  zkm, dis, px, py, phi, lam);
 XtVaSetValues(xs->labshell, XtNlabel, plot_lab, NULL);


  XSetFunction(XtDisplay(wij), ggc, GXcopy);


  }

/* ------------------------------------------------------------------ */

void Do_selXsource(Widget wij, XButtonEvent *ev, String *params,
		   Cardinal *num_params)
  {
  xsec *xs;
  mpic *xm;
  float dep, r, off, minx, maxx, miny, maxy;
  int i, k, a, astart, aend;
  char acrd[76];

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xm = xs->m;

  if(xs->selXsourcemove_flag)
    {
    if(xs->selXsource_org.x > xs->selXsource_spot.x)
      {
      minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
      maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
      }
    else
      {
      minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
      maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
      }

    if(xs->selXsource_org.y > xs->selXsource_spot.y)
      {
      miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
      maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
      }
    else
      {
      miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
      maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
      }


    /* select sources */

    if(xm->picsource_outflag != 0)
      {
    printf("\n\n");

      if( xm->src_flag == 1) astart = 0;
      else astart = 1;

      if(xm->more_src_flag == 1) aend = xm->max_more_src;
      else aend = 1;

      for(a = astart; a <= aend - 1; a++)
	{
	printf("\n-------------From Source File %s ---------------\n",
	       xm->sources[a].file_name);
	for(i = 0; i < xm->sources[a].numpoints; i++)
	  {
	  k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
			  xm->sources[a].loc[i].y - xs->line.y1,
			  xm->sources[a].loc[i].z, xs->min_xsdepth,
			  xs->max_xsdepth, xs->x_left,  xs->x_right, xs->max_xsfront,
			  xs->max_xsback, &r, &dep, &off);

	  if(k == 1)
	    {
	      {
	      if((r >=  minx) && (r <= maxx) && (dep >= miny) && (dep <= maxy))
		{
		create_Acard(&xm->sources[a].acard[i], acrd);
		printf("%s", acrd);
		}
	      }
	    }
	  }
	}
      }
    printf("\n");
    }
  else
    {
    print_xpoint(xs, (int)xs->selXsource_org.x, (int)xs->selXsource_org.y);
    }
  }


/* --------------------------------------------------------- */

void Start_selXfoc(Widget wij, XButtonEvent *event, String *params,
		   Cardinal *num_params)
  {
  xsec *xs;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xs->selXfoc_flag = 1;
  xs->selXfocmove_flag = 0;
  xs->selXfoc_org.x = event->x;
  xs->selXfoc_org.y = event->y;
  xs->selXfoc_spot = xs->selXfoc_org;
  gscr_num = DefaultScreen(XtDisplay(wij));
  XSetForeground(XtDisplay(wij), xs->ggc,
		 BlackPixel(XtDisplay(wij), gscr_num));
  XSetBackground(XtDisplay(wij), xs->ggc,
		 WhitePixel(XtDisplay(wij), gscr_num));
  }

/* --------------------------------------------------------- */

void Resize_selXfoc(Widget wij, XButtonEvent *event, String *params,
		    Cardinal *num_params)
  {
  GC ggc;
  xsec *xs;
  mpic *xm;
  XPoint p[5];

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  ggc = xs->ggc;
  xm = xs->m;
  XSetClipMask(XtDisplay(wij), ggc, None);
  XSetFunction(XtDisplay(wij), ggc, GXnor);

  getbox(xs->selXfoc_org.x, xs->selXfoc_org.y, xs->selXfoc_spot.x,
	 xs->selXfoc_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  xs->selXfoc_spot.x = event->x;
  xs->selXfoc_spot.y = event->y;

  getbox(xs->selXfoc_org.x,xs->selXfoc_org.y, xs->selXfoc_spot.x,
	 xs->selXfoc_spot.y, p);
  XDrawLines(XtDisplay(wij), XtWindow(wij), ggc, p, 5, CoordModeOrigin);

  xs->selXfocmove_flag = 1;
  XSetFunction(XtDisplay(wij), ggc, GXcopy);
  }
/* ------------------------------------------------------------------ */

void Do_selXfoc(Widget wij, XButtonEvent *ev, String *params,
		Cardinal *num_params)
  {
  xsec *xs;
  mpic *xm;
  int i, j, kount;
  char acard[76], mcard[76];
  float minx, maxx, miny, maxy;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xm = xs->m;

  if(xm->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal Files available\n");
    return;
    }

  if(xs->selXfoc_org.x > xs->selXfoc_spot.x)
    {
    minx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_spot.x);
    maxx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_org.x);
    }
  else
    {
    minx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_org.x);
    maxx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_spot.x);
    }

  if(xs->selXfoc_org.y > xs->selXfoc_spot.y)
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXfoc_spot.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXfoc_org.y);
    }
  else
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXfoc_org.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXfoc_spot.y);
    }

 /*  printf("minx=%f maxx=%f miny=%f maxy=%f\n\n", minx, maxx, miny, maxy); */

  /* SELECT Foc */

  for(j = 0; j < xs->jselect; j++)
    {
    i = xs->focind[j];
    kount = xs->focind_file[j];

    if((xs->focpos[j].x1 >= minx) && (xs->focpos[j].x1 <= maxx)
       && (xs->focpos[j].y1 >= miny) && (xs->focpos[j].y1 <= maxy))
      {
      create_Acard(&xm->focm[kount].focs[i].ac, acard);
      fprintf(stdout, "%s", acard);
      create_Mcard(&xm->focm[kount].focs[i].fm, mcard);
      fprintf(stdout, "%s", mcard);
      }              
    }
  printf("\n");
  }
/* ------------------------------------------------------------------ */
void X_SDR(Widget wij, xsec * xs, char *call_data)
  {

  mpic *xm;
  int i, j, kount;
  char acard[76], mcard[76];
  float minx, maxx, miny, maxy;
  float ang, dipaz1,rake1, dipaz2, rake2;

  
  xm = xs->m;

  if(xm->num_focm_files < 1)
    {
    fprintf(stderr, "No Focal Files available\n");
    return;
    }

  if(xs->selXfoc_org.x > xs->selXfoc_spot.x)
    {
    minx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_spot.x);
    maxx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_org.x);
    }
  else
    {
    minx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_org.x);
    maxx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_spot.x);
    }

  if(xs->selXfoc_org.y > xs->selXfoc_spot.y)
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXfoc_spot.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXfoc_org.y);
    }
  else
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXfoc_org.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXfoc_spot.y);
    }

  /* printf("minx=%f maxx=%f miny=%f maxy=%f\n\n", minx, maxx, miny, maxy); */

  /* SELECT Foc */

  for(j = 0; j < xs->jselect; j++)
    {
    i = xs->focind[j];
    kount = xs->focind_file[j];

    if((xs->focpos[j].x1 >= minx) && (xs->focpos[j].x1 <= maxx)
       && (xs->focpos[j].y1 >= miny) && (xs->focpos[j].y1 <= maxy))
      {
      create_Acard(&xm->focm[kount].focs[i].ac, acard);
      fprintf(stdout, "%s", acard);
      create_Mcard(&xm->focm[kount].focs[i].fm, mcard);
      fprintf(stdout, "%s", mcard);

  if(xm->focm[kount].focs[i].ipol == 0) ang = 1.0;
  else ang = -1.0;

  Rake_Cal(xm->focm[kount].focs[i].fm.strk1, xm->focm[kount].focs[i].fm.dip1,
	   xm->focm[kount].focs[i].fm.strk2, xm->focm[kount].focs[i].fm.dip2,
	   ang, &dipaz1, &rake1, &dipaz2, &rake2);

     fprintf(stdout,"SDR: %f %f %f %f\n", xm->focm[kount].focs[i].fm.strk1, dipaz1, xm->focm[kount].focs[i].fm.dip1,  rake1);


      }              
    }
  printf("\n");
  }
/************************************/
void Switch_selXfoc(Widget wij, XButtonEvent *ev, String *params,
		    Cardinal *num_params)
  {
  xsec *xs;
  mpic *xm;
  int i, j, k, kount;
  float minx, maxx, miny, maxy;
 
  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xm = xs->m;

  if(xs->selXfoc_org.x > xs->selXfoc_spot.x)
    {
    minx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_spot.x);
    maxx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_org.x);
    }
  else
    {
    minx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_org.x);
    maxx = pix_to_user_x(&xs->GR, (double)xs->selXfoc_spot.x);
    }

  if(xs->selXfoc_org.y > xs->selXfoc_spot.y)
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXfoc_spot.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXfoc_org.y);
    }
  else
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXfoc_org.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXfoc_spot.y);
    }

  printf("minx=%f maxx=%f miny=%f maxy=%f\n\n", minx, maxx, miny, maxy);

  /* SELECT Foc */

  k = 0;
  for(j = 0; j < xs->jselect; j++)
    {
    i = xs->focind[j];
    kount = xs->focind_file[j];

    if((xs->focpos[j].x1 >= minx) && (xs->focpos[j].x1 <= maxx)
       && (xs->focpos[j].y1 >= miny) && (xs->focpos[j].y1 <= maxy))
      {
      xm->focal_selection = xs->focind[j];
      switch_foc(xm, kount);
      k++;
      }
    }

  fprintf(stderr, "switched %d focal mechanisms\n", k);
  send_repaint_X(xs->wij, 0, 0, xm->ScreenX, xm->ScreenY);
  }


/********************   Select a set of points from the target box  ********/
void Xsel_Points(Widget wij, xsec * xs, char *call_data)
   {
   mpic *xm;
   float dep, r, off, minx, maxx, miny, maxy;
   int  k;
   
   char staname[200];
   int j, kount, icount;
   float x, y, z, phi, lam;

   xm = xs->m;


   if(xs->selXsource_org.x > xs->selXsource_spot.x)
      {
      minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
      maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
      }
   else
      {
      minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
      maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
      }

   if(xs->selXsource_org.y > xs->selXsource_spot.y)
      {
      miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
      maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
      }
   else
      {
      miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
      maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
      }

   fprintf(stderr, "dumping out points....\n\n");

   /* select points */


   for(kount = 0; kount < xm->point_flag; kount++)
      {
      fprintf(stderr, "------checking Point file ---%d %s : %d\n", kount,
	      xm->Mpoint[kount].file_name,xm->Mpoint[kount].numpoints );
      for(j = 0; j < xm->Mpoint[kount].numpoints; j++)
	 {
	 phi = xm->Mpoint[kount].points[j].lat;
	 lam = xm->Mpoint[kount].points[j].lon;
         z = xm->Mpoint[kount].points[j].depth;
	 
	 geo2xy(xm, phi, lam, &x, &y);

	 /* fprintf(stderr, "%f %f %f %f %f\n", phi, lam , z, x, y); */
	 
	 k = In_Rect_Vol(xs->RM,
			 x - xs->line.x1,
			 y - xs->line.y1,
			 z , xs->min_xsdepth,
			 xs->max_xsdepth, xs->x_left,  xs->x_right, xs->max_xsfront,
			 xs->max_xsback, &r, &dep, &off);

	 if(k == 1)
	    {

	    if((r >=  minx) && (r <= maxx) && (dep >= miny) && (dep <= maxy))
	       {
    
     
	       strcpy(staname, xm->Mpoint[kount].points[j].name);
	       for(icount = 0; icount < strlen(staname); icount++)
	       if(staname[icount]==' ') staname[icount]='_';

	       fprintf(stderr, "%s %f %f %f %d %d %d %d %d %d %d\n", staname,
		       xm->Mpoint[kount].points[j].lat,
		       xm->Mpoint[kount].points[j].lon,
		       xm->Mpoint[kount].points[j].depth,
		       xm->Mpoint[kount].points[j].color,
		       xm->Mpoint[kount].points[j].symbol,
		       xm->Mpoint[kount].points[j].symcode,
		       xm->Mpoint[kount].points[j].symsize,
		       xm->Mpoint[kount].points[j].strcode,
		       xm->Mpoint[kount].points[j].fsize,
		       xm->Mpoint[kount].points[j].just);
	       }
 
	    }
	 }
      }
    





   }




/********************   Select a set of points from the target box  ********/
  void XGet_Dist(Widget wij, xsec * xs, char *call_data)
     {
     float  r,  minx, maxx, miny, maxy, Dx, Dy;
     if(xs->selXsource_org.x > xs->selXsource_spot.x)
	{
	minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
	maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
	}
     else
	{
	minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
	maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
	}

     if(xs->selXsource_org.y > xs->selXsource_spot.y)
	{
	miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
	maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
	}
     else
	{
	miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
	maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
	}

     Dx = (maxx-minx);
     Dy = (maxy-miny);
     
     r = sqrt( ( Dx*Dx ) +  (Dy*Dy) );
    
     fprintf(stderr, "Distance= %f  Dx= %f   Dy= %f  km\n", r, Dx, Dy  );


     }
  
/* ------------------------------------------------------------------ */

void Do_xzoom(Widget wij, XButtonEvent *ev, String *params,
	      Cardinal *num_params)
  {
  xsec *xs;
  mpic *xm;
  Dimension w,h;
  Position x,y;
  int idx, idy;
  float minx, maxx, miny, maxy;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  idx = xs->selXsource_org.x - xs->selXsource_spot.x;
  idy = xs->selXsource_org.y - xs->selXsource_spot.y;
  idx = abs(idx);
  idy = abs(idy);

  /* fprintf(stderr,"idx=%d  idy=%d\n", idx, idy); */

  if(idx < 10 || idy < 10)
    {
    fprintf(stderr, "No zooming done, Box is too small\n");
    return;
    }

  xm = xs->m;
  if(xs->selXsource_org.x > xs->selXsource_spot.x)
    {
    minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
    maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
    }
  else
    {
    minx = pix_to_user_x(&xs->GR, (int)xs->selXsource_org.x);
    maxx = pix_to_user_x(&xs->GR, (int)xs->selXsource_spot.x);
    }

  if(xs->selXsource_org.y > xs->selXsource_spot.y)
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
    }
  else
    {
    miny = pix_to_user_y(&xs->GR, (int)xs->selXsource_org.y);
    maxy = pix_to_user_y(&xs->GR, (int)xs->selXsource_spot.y);
    }

  xs->x_left = minx;
  xs->x_right = maxx;
  xs->y_top = miny; 
  xs->y_bot = maxy;

  XtVaGetValues(xs->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }
/******************************************************************/
void X_Field_Above(Widget wij, xsec *xs, char *call_data)
  {
  Dimension win_hite, win_width;
  Position ex, why;

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  if(xs->X_Above == 0)
    {
    xs->X_Above = 1;
    xs->Ymargin = Yoffset * 2;
    }
  else
    {
    xs->X_Above = 0;
    xs->Ymargin = Yoffset;
    }

  send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
  }
/******************************************************************/
void X_Field_InMod(Widget wij, xsec *xs, char *call_data)
  {
  Dimension win_hite, win_width;
  Position ex, why;

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  if(xs->X_InMod == 0)
    {
    xs->X_InMod = 1;
    xs->Ymargin = Yoffset * 2;
    }
  else
    {
    xs->X_InMod = 0;
    xs->Ymargin = Yoffset;
    }

  send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
  }/******************************************************************/
void X_Topo_Above(Widget wij, xsec *xs, char *call_data)
  {
  Dimension win_hite, win_width;
  Position ex, why;

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  if(xs->X_Image_Above == 0)
    {
    xs->X_Image_Above = 1;
    xs->Ymargin = Yoffset * 2;
    }
  else
    {
    xs->X_Image_Above = 0;
    xs->Ymargin = Yoffset;
    }

  send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
  }

/***********************************************************************/
void Plot_Topo_Field2(Widget wij, xsec * xs, char *call_data)
  {
  mpic *xm;
    JGRAPH temp_gr;
 
  float miny = -1.0, maxy = 1.0, *rdis, *fval;
  int lx, ly, lx2, ly2, i,  nx, ny, SLICE_pts;
  Dimension win_hite, win_width;
  Position ex, why;
  float nx1, ny1, nx2, ny2;

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);


  xm = xs->m;

  if(xs->X_Image_Above == 1)
    {
    xs->X_Image_Above = 0;
    xs->Ymargin = Yoffset;
    send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
    return;
    }



  if(xm->image_flag == 1) 
    {
    xs->X_Image_Above = 1;
    nx = xm->image.nx;
    ny = xm->image.ny;

#if 0
    for(i = 0; i < nx; i++)
      for(j = 0; j < ny; j++)
	{
	fprintf(stderr, "Pval[%d][%d]=%g     %d\n", i, j,
		xs->m->contParms.surf_grd->val[j * nx + i], j * nx + i);
	}
#endif



    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);
    



    SLICE_pts =  (  fabs(nx2-nx1)/xm->image.dx +  fabs(ny2-ny1)/xm->image.dy );

    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);



    slice_surf_Image(xm , nx1, ny1,  nx2, ny2, rdis, fval, SLICE_pts);

 

    maxy = miny = fval[0];

    for(i = 0; i < SLICE_pts; i++)
      {
      /*  fprintf(stderr,"xsec: %f %f \n", rdis[i],fval[i]);  */
      miny = min2(fval[i], miny);
      maxy = max2(fval[i], maxy);
      }
    for(i = 0; i < SLICE_pts; i++)
      {
      if(fval[i]== xm->image.image_skip) fval[i]= miny;
      
      }

    xs->Ymargin = Yoffset * 2;
    send_repaint_X(xs->wij, 0, 0, win_width, win_hite);
    XSetForeground(XtDisplay(xs->wij), xs->ggc,
		   xs->colors[XmapAppColor(xs->m->map_col)]);


    window(&temp_gr, (double)rdis[0], (double)rdis[SLICE_pts - 1],
	   (double)miny, (double)maxy);
    viewport(&temp_gr, xs->Xmargin, win_width - xs->Xmargin, 0,
	     xs->Ymargin / 2);


    lx = user_to_pix_x(&temp_gr, (double)rdis[0]);
    ly = user_to_pix_y(&temp_gr, (double)fval[0]);

    for(i = 0; i < SLICE_pts; i++)
      {
      lx2 = user_to_pix_x(&temp_gr, (double)rdis[i]);
      ly2 = user_to_pix_y(&temp_gr, (double)fval[i]);

      /* fprintf(stderr, "%f %f %d %d\n", x, y, lx2, ly2); */

      XDrawLine(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, lx, ly, lx2,
		ly2);
      XFlush(XtDisplay(xs->wij));
      lx = lx2;
      ly = ly2;
      }
    yaxis(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, &temp_gr, 
	  (double)0.0, (double)miny, (double)maxy, 1, 1, 10, 0.0);
    XFlush(XtDisplay(xs->wij));

    xs->field_style_flag = 1;

    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }
  else
    {
    fprintf(stderr, "No grid has been read in....try the menu button from"
	    " the main figure\n");
    }
  }

/**********************************************************************/
int Plot_Topo_Field( xsec * xs)
  {
  mpic *xm;
  
  JGRAPH temp_gr;
  Dimension win_hite, win_width;
  Position ex, why;
  int lx, ly, lx2, ly2, i,  nx, ny, SLICE_pts;
  float maxy, miny = -1.0, *rdis, *fval;
  float nx1, ny1, nx2, ny2;

    xm = xs->m;


  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  /*
   * fprintf(stderr,"hello, this is a temporary test using a
   * sinusoid....\n"); fprintf(stderr, "xsec: x1=%f y1=%f x2=%f
   * y2=%f\n", xs->line.x1,xs->line.y1,xs->line.x2, xs->line.y2);
   */

  if(xm->image_flag == 1)
    {
    nx = xm->image.nx;
    ny = xm->image.ny;

    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);


    SLICE_pts =  (  fabs(nx2-nx1)/xm->image.dx +  fabs(ny2-ny1)/xm->image.dy );
    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);

    
     /* fprintf(stderr,"xsec Topo: %f %f %f %f \n", nx1, ny1, */
/* 	       nx2, ny2 ); */
    slice_surf_Image(xm, nx1, ny1,
	       nx2, ny2, rdis, fval, SLICE_pts);

    maxy = miny = fval[0];

    for(i = 0; i < SLICE_pts; i++)
      {
      /* fprintf(stderr,"xsec: %f %f \n", rdis[i],fval[i]); */ 
      miny = min2(fval[i], miny);
      maxy = max2(fval[i], maxy);
      }

     xs->Ymargin = Yoffset * 2;
     

    XSetForeground(XtDisplay(xs->wij), xs->ggc,
		   xs->colors[XmapAppColor(xs->m->map_col)]);

    window(&temp_gr, (double)rdis[0], (double)rdis[SLICE_pts - 1],
	   (double)miny, (double)maxy);
    viewport(&temp_gr, xs->Xmargin, win_width - xs->Xmargin, 0,
	     xs->Ymargin / 2);

    lx = user_to_pix_x(&temp_gr, (double)rdis[0]);
    ly = user_to_pix_y(&temp_gr, (double)fval[0]);

    for(i = 0; i < SLICE_pts; i++)
      {
      lx2 = user_to_pix_x(&temp_gr, (double)rdis[i]);
      ly2 = user_to_pix_y(&temp_gr, (double)fval[i]);

      /* fprintf(stderr,"%f %f %d %d\n",x,y, lx2,ly2); */

      XDrawLine(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, lx, ly, lx2,
		ly2);
      XFlush(XtDisplay(xs->wij));
      lx = lx2;
      ly = ly2;
      }

    yaxis(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, &temp_gr, 
	  (double)0.0, (double)miny, (double)maxy, 1, 1, 10, 0.0);
    XFlush(XtDisplay(xs->wij));

    /* fprintf(stderr, "min ext2=%f loc2 = %d\n", miny,ly2); */

    xs->field_style_flag = 0;

    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }
  else
    {
    fprintf(stderr, "No grid has been read in....try the menu button from"
	    " the main figure\n");
    }
  return(0);
  }
/*****************************************************************/
int Plot_X_Field(xsec *xs)
  {
  JGRAPH temp_gr;
  Dimension win_hite, win_width;
  Position ex, why;
  int lx, ly, lx2, ly2, i,  nx, ny, SLICE_pts;
  float maxy, miny = -1.0, *rdis, *fval;
  float nx1, ny1, nx2, ny2;
  

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  /*
   * fprintf(stderr,"hello, this is a temporary test using a
   * sinusoid....\n"); fprintf(stderr, "xsec: x1=%f y1=%f x2=%f
   * y2=%f\n", xs->line.x1,xs->line.y1,xs->line.x2, xs->line.y2);
   */

  if(xs->m->plot_cont_flag == 1)
    {
    nx = xs->m->contParms.surf_grd->nx;
    ny = xs->m->contParms.surf_grd->ny;

#if 0
    for(i = 0; i < nx; i++)
      for(j = 0; j < ny; j++)
	{
	fprintf(stderr, "Pval[%d][%d]=%g     %d\n", i, j,
		xs->m->contParms.surf_grd->val[j * nx + i], j * nx + i);
	}
#endif

    SLICE_pts = 2 * (nx + ny);

    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);


    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);
    
    
    slice_surf(xs->m->contParms.surf_grd, nx1, ny1,
	       nx2, ny2, rdis, fval, SLICE_pts);

    maxy = miny = fval[0];

    for(i = 0; i < SLICE_pts; i++)
      {
      /* fprintf(stderr,"xsec: %f %f \n", rdis[i],fval[i]); */
      miny = min2(fval[i], miny);
      maxy = max2(fval[i], maxy);
      }

    /* xs->Ymargin = Yoffset * 2;
       send_repaint_X(xs->wij, 0, 0, win_width, win_hite); */

    XSetForeground(XtDisplay(xs->wij), xs->ggc,
		   xs->colors[XmapAppColor(xs->m->map_col)]);

    window(&temp_gr, (double)rdis[0], (double)rdis[SLICE_pts - 1],
	   (double)miny, (double)maxy);
    viewport(&temp_gr, xs->Xmargin, win_width - xs->Xmargin, 0,
	     xs->Ymargin / 2);

    lx = user_to_pix_x(&temp_gr, (double)rdis[0]);
    ly = user_to_pix_y(&temp_gr, (double)fval[0]);

    for(i = 0; i < SLICE_pts; i++)
      {
      lx2 = user_to_pix_x(&temp_gr, (double)rdis[i]);
      ly2 = user_to_pix_y(&temp_gr, (double)fval[i]);

      /* fprintf(stderr,"%f %f %d %d\n",x,y, lx2,ly2); */

      XDrawLine(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, lx, ly, lx2,
		ly2);
      XFlush(XtDisplay(xs->wij));
      lx = lx2;
      ly = ly2;
      }

    yaxis(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, &temp_gr, 
	  (double)0.0, (double)miny, (double)maxy, 1, 1, 10, 0.0);
    XFlush(XtDisplay(xs->wij));

    /* fprintf(stderr, "min ext2=%f loc2 = %d\n", miny,ly2); */

    xs->field_style_flag = 0;

    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }
  else
    {
    fprintf(stderr, "No grid has been read in....try the menu button from"
	    " the main figure\n");
    }
  return(0);
  }
/***********************************************************************/
int Plot_X_Field2(xsec * xs)
  {
  float miny = -1.0, maxy = 1.0, *rdis, *fval;
  int lx, ly, lx2, ly2, i,  nx, ny, SLICE_pts;
  Dimension win_hite, win_width;
  Position ex, why;
  float nx1, ny1, nx2, ny2;

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);



  if(xs->m->plot_cont_flag == 1)
    {
    nx = xs->m->contParms.surf_grd->nx;
    ny = xs->m->contParms.surf_grd->ny;

#if 0
    for(i = 0; i < nx; i++)
      for(j = 0; j < ny; j++)
	{
	fprintf(stderr, "Pval[%d][%d]=%g     %d\n", i, j,
		xs->m->contParms.surf_grd->val[j * nx + i], j * nx + i);
	}
#endif

    SLICE_pts = 2 * (nx + ny);

    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);


    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);
    
    slice_surf(xs->m->contParms.surf_grd, nx1, ny1,
	       nx2, ny2, rdis, fval, SLICE_pts);

 

    maxy = miny = fval[0];

    for(i = 0; i < SLICE_pts; i++)
      {
      /* fprintf(stderr,"xsec: %f %f \n", rdis[i],fval[i]); */
      miny = min2(fval[i], miny);
      maxy = max2(fval[i], maxy);
      }

    /* xs->Ymargin = Yoffset * 2; */
/*     send_repaint_X(xs->wij, 0, 0, win_width, win_hite); */
    XSetForeground(XtDisplay(xs->wij), xs->ggc,
		   xs->colors[XmapAppColor(xs->m->map_col)]);

    /* window(&temp_gr, (double) rdis[0], (double) rdis[SLICE_pts - 1],
       (double) xs->gr.minx , (double) xs->gr.maxy);
       viewport(&temp_gr, xs->Xmargin, win_width - xs->Xmargin, 0,
       xs->Ymargin / 2); */



    lx = user_to_pix_x(&xs->GR, (double)rdis[0]);
    ly = user_to_pix_y(&xs->GR, (double)fval[0]);

    for(i = 0; i < SLICE_pts; i++)
      {
      lx2 = user_to_pix_x(&xs->GR, (double)rdis[i]);
      ly2 = user_to_pix_y(&xs->GR, (double)fval[i]);

      fprintf(stderr, "%d %d  %d %d\n", lx, ly, lx2, ly2);

      XDrawLine(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, lx, ly, lx2,
		ly2);
      /* XFlush(XtDisplay(xs->wij)); */
      lx = lx2;
      ly = ly2;
      }
/* XFlush(XtDisplay(xs->wij)); */
    xs->field_style_flag = 1;

    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }
  else
    {
    fprintf(stderr, "No grid has been read in....try the menu button from"
	    " the main figure\n");
    }

  return(1);
  }

void X_Geology(Widget wij, xsec * xs, char *call_data)
  {
  int lx, ly, lx2, ly2, kmap, k, i, m, n, io, *ind;
  Dimension win_hite, win_width;
  Position ex, why;
  float r1, r2, *ctempx, *ctempy, *rdis, **poly, p1x, p1y, hoz_dist;
  mpic           *mplot = xs->m;

  hoz_dist = sqrt((xs->line.x1 - xs->line.x2) * (xs->line.x1 - xs->line.x2)
		  + (xs->line.y1 - xs->line.y2) * (xs->line.y1 - xs->line.y2));

  XtVaGetValues(xs->shell, XtNx, &ex, XtNy, &why, XtNwidth, &win_width,
		XtNheight, &win_hite, NULL);

  for(kmap = 0; kmap < mplot->num_map_files; kmap++)
    {
    for(k = 0; k < mplot->map[kmap].stroke_count; k++)
      {
      if(mplot->map[kmap].stroke[k].style == 3)
	{
	poly = alloc_fmat((long)0, (long)(mplot->map[kmap].stroke[k].num + 1),
			  (long)0 ,(long)1);
	ctempx = alloc_fvec((long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	ctempy = alloc_fvec((long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	ind = alloc_ivec((long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	rdis = alloc_fvec((long)0, (long)mplot->map[kmap].stroke[k].num + 1);

	m = 0;
	for(i = mplot->map[kmap].stroke[k].index1;
	    i < (mplot->map[kmap].stroke[k].index1
		 + mplot->map[kmap].stroke[k].num); i++)
	  {
	  poly[m][0] = mplot->map[kmap].km[i].x;
	  poly[m][1] = mplot->map[kmap].km[i].y;
	  m++;
	  }

	i = mplot->map[kmap].stroke[k].index1;
	poly[m][0] = mplot->map[kmap].km[i].x;
	poly[m][1] = mplot->map[kmap].km[i].y;
	m = poly_line(poly, mplot->map[kmap].stroke[k].num, xs->line, ctempx,
		      ctempy);

	if(m > 0)
	  {
	  /* fprintf(stderr, " Geology Poly: kmap=%d k=%d %s  num=%d m=%d\n",
	     kmap, k, mplot->map[kmap].stroke[k].name,
	     mplot->map[kmap].stroke[k].num, m); */

	  io = Inpoly(xs->line.x1, xs->line.y1,
		      mplot->map[kmap].stroke[k].num, poly);
	  n = 0;

	  if(io == 1)
	    { 
	    rdis[n]= 0.0;
	    n++;   
	    }

	  for(i = 0; i < m; i++)
	    {
	    p1x = ctempx[i];
	    p1y = ctempy[i];
	    rdis[n] = sqrt((p1x - xs->line.x1) * (p1x - xs->line.x1)
			   + (p1y - xs->line.y1) * (p1y - xs->line.y1));
	    n++;
	    /* fprintf(stderr, "%f %f r1=%f\n", p1x, p1y, rdis[i]); */
	    }

	  io = Inpoly(xs->line.x2, xs->line.y2,
		      mplot->map[kmap].stroke[k].num, poly);
	  if(io == 1)
	    {
	    rdis[n] = hoz_dist;
	    n++;
	    }

	  csorta(rdis, ind, rdis, n);
	  /* fprintf(stderr,"n=%d m=%d\n", n, m); */

	  for(i = 0; i < n - 1; i = i + 2)
	    {
	    r1 = rdis[i];
	    r2 = rdis[i + 1];
	    if(r1 > hoz_dist) break;
	    if(r2 > hoz_dist) r2 = hoz_dist;
	    lx = user_to_pix_x(&xs->GR, (double)r1);
	    ly = user_to_pix_y(&xs->GR, (double)0) - 4;
	    lx2 = (user_to_pix_x(&xs->GR, (double)r2) - lx);
	    ly2 = 5;

	    /* fprintf(stderr,"%f %f %d * %d\n",x,y, lx2,ly2); */

	    XSetForeground(XtDisplay(xs->wij), xs->ggc,
	      mplot->colors[XmapAppColor(mplot->map[kmap].stroke[k].col)]);
	    XFillRectangle(XtDisplay(xs->wij), XtWindow(xs->wij), xs->ggc, lx,
			   ly, lx2, ly2);
	    XFlush(XtDisplay(xs->wij));
	    }
	  }

	free_fvec(rdis, (long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	free_fvec(ctempx, (long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	free_fvec(ctempy, (long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	free_ivec(ind, (long)0, (long)mplot->map[kmap].stroke[k].num + 1);
	free_fmat(poly, (long)0, (long)(mplot->map[kmap].stroke[k].num + 1),
		  (long)0, (long)1);
	}
      }
    }
  }

/***********************************************/
void XDump_Ascii_image(Widget wij, xsec *xs, char *call_data)
   {

  mpic *xm = xs->m;
  int i, j, k,  imdepth;
  float y = 0.0, x1, x2, x;

    FILE *inf;

 

  if((inf = fopen("Xsec_ascii_dump", "w")) == NULL)
  {
    printf("Can't open output Xsec_ascii_dump ....try again\n");
    return;
    }

  imdepth = xm->image.nz;

/*
  for(i = 0; i < xm->image.nz; i++)
    {
    if((xs->xdepth > xm->image.z_parts[i])
       && (xs->xdepth < xm->image.z_parts[i + 1]))
      imdepth = i;
    }
*/

 imdepth  = indepth(xm->image.z_parts,xm->image.nz,xs->xdepth);

  for(i = 0; i < imdepth; i++)
    {
    y = (xm->image.z_parts[i]+xm->image.z_parts[i+1])/2;
    x2 = 0;

    /* the following line is inefficient because abs() evalutes arguments
       more than once */

  

    for(j = 0; j < xs->image_nbloc; j++)
      {
      x2 += xs->image_bvec[j];
      x1 = x2 - xs->image_bvec[j];
      x = (x2+x1)/2;  
      k = xs->image_ivec[j] + i * (xm->image.nx * xm->image.ny);
      if(xm->image.val[k] != xm->image.image_skip) fprintf(inf,"%f %f %f\n", x,  y,  xm->image.val[k]);
      
      }
    }
  
  fprintf(stderr,"ascii Xsec Image file is in: Xsec_ascii_dump\n");
  
  fclose(inf);

   }

void Dump_Field(Widget wij, xsec *xs, char *call_data)
  {
  int i, nx, ny, SLICE_pts;
  float *rdis, *fval, xkm, phi, lam, px, py;
  float nx1, ny1, nx2, ny2;

  if(xs->m->plot_cont_flag == 1)
    {
    nx = xs->m->contParms.surf_grd->nx;
    ny = xs->m->contParms.surf_grd->ny;

#if 0
    for(i = 0; i < nx; i++)
      for(j = 0; j < ny; j++)
	{
	fprintf(stderr, "Pval[%d][%d]=%g     %d\n", i, j,
		xs->m->contParms.surf_grd->val[j * nx + i], j * nx + i);
	}
#endif

    SLICE_pts = 2 * (nx + ny);
    rdis = alloc_fvec((long)0, (long)SLICE_pts);
    fval = alloc_fvec((long)0, (long)SLICE_pts);


    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_left,  &nx1,  &ny1);
    
    slide_point( xs->line.x1,  xs->line.y1,  xs->line.x2,  xs->line.y2,  
		xs->x_right,  &nx2,  &ny2);
    
    
    slice_surf(xs->m->contParms.surf_grd, nx1, ny1,
	       nx2, ny2, rdis, fval, SLICE_pts);

    fprintf(stdout, "CONTOUR SLICE %d\n", xs->index);

    for(i = 0; i < SLICE_pts; i++)
      {
      xkm = rdis[i];
      px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
      py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 
      xy2geo(xs->m, &phi, &lam, px, py);
      
      fprintf(stdout," %f %f ", phi, lam);
      fprintf(stdout, "%f %f\n", rdis[i], fval[i]);
      }
    free_fvec(rdis, 0, SLICE_pts);
    free_fvec(fval, 0, SLICE_pts);
    }
  else
    {
    fprintf(stderr, "No grid has been read in....try the menu button from"
	    " the main figure\n");
    }
  }

/***************************************************/

void XDump_Image_Field(Widget wij, xsec *xs, char *call_data)
  {
  mpic *xm;
  int i, j, k, imdepth, sym, symsiz, col;
  float y, x1, x2, px, py, xkm, val, phi, lam, reglam, regphi,
    minx = 0, maxx, miny = 0, maxy, stepx, stepy;
  FILE *inf, *cinf;

  xm = xs->m;

  if((inf = fopen("Xsec_Points", "w")) == NULL)
     {
     printf("Can't open output Xsec_Points ....try again\n");
     return;
     }

  if((cinf = fopen("Xsec_Cont", "w")) == NULL)
    {
    printf("Can't open output Xsec_Cont ....try again\n");
    return;
    }

  miny = minx = 1e50;
  maxy = maxx = -minx;
  y = 0.0;

  /* fprintf(stderr,"final image xsec: %f %f %f %f\n",xq,yq,xsta,ysta); */ 
  /* fprintf(stderr,"nbloc = %d\n", nbloc);
     for(i=0; i< nbloc; i++)fprintf(stderr,"ivec=%d  bvec=%f\n", ivec[i],
     bvec[i]); */

  imdepth = xm->image.nz;

/*
  for(i = 0; i < xm->image.nz; i++)
    {
    if((xs->xdepth > xm->image.z_parts[i])
       && (xs->xdepth < xm->image.z_parts[i + 1]))
      imdepth = i;
    }
*/
 imdepth  = indepth(xm->image.z_parts,xm->image.nz,xs->xdepth);

  for(i = 0; i < imdepth; i++)
    {
    y = (xm->image.z_parts[i + 1] + xm->image.z_parts[i]) / 2.0;
    x2 = 0;

    for(j = 0; j < xs->image_nbloc; j++)
      {
      x2 += xs->image_bvec[j];
      x1 = x2 - xs->image_bvec[j];
      xkm = (x1 + x2) / 2.0;
      k = xs->image_ivec[j] + i * (xm->image.nx * xm->image.ny);
      px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
      py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 
      val = xm->image.val[k];
      xy2geo(xs->m, &phi, &lam, px, py);
      
      col = xm->image.col[k];
      symsiz = col - xm->MinColor;
      if(symsiz > 20) sym = 6;
      else sym = 5;

      symsiz = 3 + abs(symsiz - 20);
      col = 1;

      if(val != xm->image.image_skip)
	{
	fprintf(inf, "%5f %f %f %f %d %d 1 %d 0 9 2 \n", val, phi, lam, y,
		col, sym, symsiz);
	fprintf(cinf, "%f %f %f\n", xkm, y, val);
	minx = min2(minx, xkm);
	maxx = max2(maxx, xkm);
	miny = min2(miny, y);
	maxy = max2(maxy, y);
	}

      /* name lat lon depth color symbol symcode symsize strcode font_size just
	 Test2            46.689793 -123.019196 7.0 1 5 1 4 1 11 2 */
      }
    }

  fprintf(stderr, "The image slice is being dumped as points file:"
	  " Xsec_Points\n");
  fprintf(stderr, "The image slice is being dumped as km values in file:"
	  " Xsec_Cont\n");
  fprintf(stderr, "Registration points and contour program:\n");
  fprintf(stderr, "lcont Xsec_Cont %f %f %f %f\n", minx, maxx, miny, maxy);
  stepx = (maxx - minx) / 20;
  stepy = (maxy - miny) / 20;
  fprintf(stderr, "lcont Xsec_Cont %f %f\n", stepx, stepy);
  px = xs->line.x1; 
  py = xs->line.y1; 
  xy2geo(xs->m, &regphi, &reglam, px, py);
  fprintf(stderr, "lcont Xsec_Cont 20 20 %f %f %f\n", xs->XSEC_angle, regphi,
	  reglam);
  fclose(inf);
  fclose(cinf);
  }

/**********************************************/
static void SaveXparams(Widget wij, xsec *xs, char *call_data)
{
  
  
  FILE *outf;
  mpic *xm = xs->m;
  float xkm, zkm, phi1, lam1, phi2, lam2, px, py;
  
  int i;
  

  i = xs->index - 1;


  xkm =  xs->x_left;
  zkm =  xs->y_top;

  fprintf(stdout,"\nLeft distance from edge= %f depth = %f \n", xkm, zkm);
  px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
  py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 
  xy2geo(xm, &phi1, &lam1, px, py);


  fprintf(stdout,"DEG LAT-LON: %f %f \n", phi1, lam1);

  xkm = xs->x_right;
  zkm = xs->y_bot;

  fprintf(stdout,"\nRight distance from edge %f depth = %f \n", xkm, zkm);
  px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle); 
  py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle); 
  xy2geo(xm, &phi2, &lam2, px, py);

  fprintf(stdout,"DEG LAT-LON: %f %f \n", phi2, lam2);


 fprintf(stderr, "%% ZOOM BOX %d: %f %f %f %f \n",  xs->index, xs->x_left,  xs->x_right,  xs->y_top,  xs->y_bot);
 
  if((outf = fopen("SAVE_one_xsec", "w")) == NULL)
    {
    printf("Can't open file SAVE_one_xsec ....try again\n");
    return;
    }

 
    fprintf(outf, "%f %f %f %f %f %f %f %f %f\n",
	    phi1, lam1,
	    phi2, lam2,
	    90 - xm->cross[i].xs_dip, xs->y_top,
	    xs->y_bot, xm->cross[i].max_xsfront,
	    xm->cross[i].max_xsback);

  fprintf(stderr,"\n\n X-secs are saved in file: SAVE_one_xsec\n\n");
  fclose(outf);


 }

static void XRestore(Widget wij, xsec *xs, char *call_data)
{
  Dimension w, h;
  Position x, y;

  xs->x_left = 0.0;
  xs->x_right = sqrt(sqr(xs->line.x1 - xs->line.x2)
		     + sqr( xs->line.y1 - xs->line.y2));
  xs->y_top = xs->min_xsdepth; 
  xs->y_bot = xs->xdepth;
  xs->Ymargin = Yoffset;
  xs->X_Above = 0;
  xs->X_InMod = 0;

  xs->X_Image_Above = 0;

  XtVaGetValues(xs->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }

static void XRefresh(Widget wij, xsec *xs, char *call_data)
{
  Dimension w, h;
  Position x, y;

  XtVaGetValues(xs->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }

static void xs_Key_F1_lees(Widget wij, XKeyEvent *ev, String *params,
			   Cardinal *num_params)
  {
  xsec *xs;
  Dimension w, h;
  Position x, y;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  xs->x_left = 0.0;
  xs->x_right = sqrt(sqr(xs->line.x1 - xs->line.x2)
		     + sqr(xs->line.y1 - xs->line.y2));
  xs->y_top = 0.0;
  xs->y_bot = xs->xdepth;
  xs->Ymargin = Yoffset;

  XtVaGetValues(xs->shell, XtNx, &x, XtNy, &y, XtNwidth, &w, XtNheight, &h,
                NULL);
  send_repaint_X(xs->wij, 0, 0, w, h);
  }

/* ------------------------------------------------------------------ */

static void quit_window(Widget wij, xsec *pf, char *call_data)
  {

  XtDestroyWidget(pf->shell);
  }

/* ------------------------------------------------------------------ */

/* Do what you need to here to de-allocate memory */

static void destroy_xsec(Widget wij, void *client_data, void *server_data)
  {
  xsec *x;
  mpic *xm;

  XtVaGetValues(wij, XtNdata, &x, NULL);
  xm = x->m;

  fprintf(stderr, "xind = %d mind = %d\n", x->index,
	  xm->cross[x->index - 1].xsec_index);
  xm->cross[x->index - 1].xsec_index = -(xm->cross[x->index - 1].xsec_index);

  XmapFree(x->focpos);
  XmapFree(x->focrad);
  XmapFree(x->focind);
  XmapFree(x->focind_file);
  XmapFree(x->FOC_IN);

  XmapFree(x);
  printf("Destroying xsec!\n");
  }

/* Do what you need to here to de-allocate memory */

static void close_xsec(Widget wij, void *client_data, void *server_data)
  {
  xsec *x;
  mpic *xm;

  XtVaGetValues(wij, XtNdata, &x, NULL);
  xm =  x->m;
  fprintf(stderr, "xind = %d mind = %d\n", x->index,
	  xm->cross[x->index - 1].xsec_index);
  xm->cross[x->index - 1].xsec_index = -(xm->cross[x->index - 1].xsec_index);
  XtDestroyWidget(x->shell);

/*   XmapFree(x->focpos); */
/*   XmapFree(x->focrad); */
/*   XmapFree(x->focind); */
/*   XmapFree(x->focind_file); */
/*   XmapFree(x->FOC_IN); */

/*   XmapFree(x); */
  printf("Closing and Destroying xsec!\n");
  }

/* --------------------------------------------------------- */

void X_Poly_Start(Widget wij, xsec *xs, char *call_data)
  {

  fprintf(stderr, "starting new polygon...\n");
  if(global_poly > 0)
    fprintf(stderr, "old global=%d\n", global_poly);

  num_poly++;
  global_poly = 0;
  current_poly = xs->index;
  
  }

/* ------------------------------------------------------------------ */

void X_Poly_Points(Widget wij, XButtonEvent *ev, String *params,
		   Cardinal *num_params)
  {
  xsec *xs;
  mpic *m;
  float px, py, xkm, ykm, phi, lam;

  XtVaGetValues(wij, XtNdata, &xs, NULL);
  m = xs->m;
  xkm = pix_to_user_x(&xs->GR, (int)ev->x);
  ykm = pix_to_user_y(&xs->GR, (int)ev->y);

  px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle);
  py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle);
  xy2geo(m, &phi, &lam, px, py);

  /* xy2geo(m,  &phi,  &lam,xkm, ykm);
     lat= phi;
     lon= lam;
     fprintf(stderr,"%f %f \n", lat, lon); */
       
  gpolx[global_poly] = ev->x;
  gpoly[global_poly] = ev->y;
  polyx[global_poly] = xkm;
  polyy[global_poly] = ykm;
  fprintf(stderr, "%f %f LATLON= %f %f : %d\n", xkm, ykm, phi, lam, current_poly);
  if(global_poly > 0)
    {
    XSetForeground(XtDisplay(wij), m->ggc,
		   m->colors[XmapAppColor(m->spline_points_col)]);
    XDrawLine(XtDisplay(wij),XtWindow(wij), xs->ggc, gpolx[global_poly - 1],
	      gpoly[global_poly - 1], gpolx[global_poly], gpoly[global_poly]);
    }
  global_poly++;
  XFlush(XtDisplay(wij));
  }

/* ------------------------------------------------------------------ */

void X_Replot_Poly_Points(Widget wij, xsec *xs, char *call_data)
  {
  mpic *m;
  int i, lx1, ly1, lx2, ly2;

  /* XVaGetValues(wij, XtNdata, &xs, NULL); */

  m = xs->m;
  XSetForeground(XtDisplay(xs->wij), xs->ggc,
		 m->colors[XmapAppColor(m->spline_points_col)]);
  if(global_poly > 0)
    {
    fprintf(stderr, "\n\n%% following code can be put in Xsect postscript"
	    " file for plotting, poly=%d\n", current_poly);
    fprintf(stderr, "%f bx %f -1 mul bz moveto\n", polyx[0], polyy[0]);
    for(i = 1; i < global_poly; i++)
      {
      fprintf(stderr, "%f bx %f -1 mul bz lineto\n", polyx[i], polyy[i]);
      lx1 = user_to_pix_x(&xs->GR, (double)polyx[i - 1]);
      ly1 = user_to_pix_y(&xs->GR, (double)polyy[i - 1]);
      lx2 = user_to_pix_x(&xs->GR, (double)polyx[i]);
      ly2 = user_to_pix_y(&xs->GR, (double)polyy[i]);
      XDrawLine(XtDisplay(xs->wij),XtWindow(xs->wij), xs->ggc, lx1, ly1, lx2,
		ly2);
      }

    fprintf(stderr, "closepath  stroke\n");

    lx1 = user_to_pix_x(&xs->GR, (double) polyx[global_poly - 1]);
    ly1 = user_to_pix_y(&xs->GR, (double) polyy[global_poly - 1]);
    lx2 = user_to_pix_x(&xs->GR, (double) polyx[0]);
    ly2 = user_to_pix_y(&xs->GR, (double) polyy[0]);
    XDrawLine(XtDisplay(xs->wij),XtWindow(xs->wij), xs->ggc, lx1, ly1, lx2,
	      ly2);
    }
  XFlush(XtDisplay(xs->wij));
  }
/* ------------------------------------------------------------------ */

void DUMP_X_POLY(Widget wij, xsec *xs, char *call_data)
  {
  mpic *m;
  int i, lx1, ly1, lx2, ly2;
float px, py, xkm, ykm, phi, lam;

  /* XVaGetValues(wij, XtNdata, &xs, NULL); */

  m = xs->m;
  XSetForeground(XtDisplay(xs->wij), xs->ggc,
		 m->colors[XmapAppColor(m->spline_points_col)]);


  if(global_poly > 0)
    {
    fprintf(stdout, "XSEC LINE INDEX: %d\n", xs->index);
    if(current_poly!=xs->index) return;
    
    i = 0;
  

   xkm = polyx[i];
      ykm = polyy[i];
      
    px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle);
    py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle);
    xy2geo(m, &phi, &lam, px, py);

     fprintf(stdout, "LATLONZ: %f %f %f\n", phi, lam, ykm);

    for(i = 1; i < global_poly; i++)
      {
     
      xkm = polyx[i];
      ykm = polyy[i];
      
    px = xs->line.x1 + xkm * cos(0.0174532 * xs->XSEC_angle);
    py = xs->line.y1 + xkm * sin(0.0174532 * xs->XSEC_angle);
    xy2geo(m, &phi, &lam, px, py);

     fprintf(stdout, "LATLONZ: %f %f %f\n", phi, lam, ykm);


      lx1 = user_to_pix_x(&xs->GR, (double)polyx[i - 1]);
      ly1 = user_to_pix_y(&xs->GR, (double)polyy[i - 1]);
      lx2 = user_to_pix_x(&xs->GR, (double)polyx[i]);
      ly2 = user_to_pix_y(&xs->GR, (double)polyy[i]);
      XDrawLine(XtDisplay(xs->wij),XtWindow(xs->wij), xs->ggc, lx1, ly1, lx2,
		ly2);
      }

    fprintf(stdout, "\n");
    
  
    }
  XFlush(XtDisplay(xs->wij));
  }

/* ------------------------------------------------------------------ */

void Do_selXpoly(Widget wij, xsec *xs, char *call_data)
  {
  mpic *xm = xs->m;
  char acrd[76];
  int a, astart, aend, i, k = 0, j, lowy, num, *indx;
  float dep, r, off, *pys;
  fpoint *plotkin, po;
  FILE *inf;

  fprintf(stderr, "source file = %s\n", xm->src_dump_file);
  if((inf = fopen(xm->src_dump_file, "w")) == NULL)
    {
    printf("Can't open special source %s ....try again\n", xm->src_dump_file);
    return;
    }

  num = global_poly;
  if(num == 0)
    {
    fprintf(stderr,
	    "\nFIRST: Please select a poly gon using the meta-1 mouse!\n");
    return;
    }

  pys = alloc_fvec(0, num);
  indx = alloc_ivec(0, num);
  plotkin = XmapNewArray(fpoint, num + 1);
  fprintf(stdout, " -------------------------------- \n\n");

  for(i = 1; i < num; i++) pys[i] = polyy[i];

  /* indexx((unsigned long) num, pys - 1, indx - 1); */

  cindex(pys, indx, num);
  lowy = indx[0];
  for(i = lowy, j = 1; i < num; i++)
    {
    plotkin[j].x = polyx[i];
    plotkin[j].y = polyy[i];
    j++;
    }
  for(i = 0; i < lowy; i++)
    {
    plotkin[j].x = polyx[i];
    plotkin[j].y = polyy[i];
    j++;
    }

  /* SELECT SOURCES */

  if(xm->src_flag == 1) astart = 0;
  else astart = 1;
  if(xm->more_src_flag == 1) aend = xm->max_more_src;
  else aend = 1;

  for(a = astart; a <= aend - 1; a++)
    {
    printf("\n-------------From Source File %s ---------------\n",
	   xm->sources[a].file_name);
    for(i = 0; i < xm->sources[a].numpoints; i++)
      {
      k = In_Rect_Vol(xs->RM, xm->sources[a].loc[i].x - xs->line.x1,
		      xm->sources[a].loc[i].y - xs->line.y1, 
		      xm->sources[a].loc[i].z, xs->min_xsdepth,
		      xs->max_xsdepth,  xs->x_left, xs->x_right, xs->max_xsfront,
		      xs->max_xsback, &r, &dep, &off);

      if(k == 1)
	{
	po.x = r;
	po.y = dep;

	if(inside(po, plotkin, num) == 1)
	  {
	  create_Acard(&xm->sources[a].acard[i], acrd);
	  if(xm->picsource_outflag != 0) fprintf(stdout, "%s", acrd);
	  fprintf(inf, "%s", acrd);
	  }
	}
      }
    }

  printf("\n");
  free_fvec(pys, 0, num);
  free_ivec(indx, 0, num);
  XmapFree(plotkin); 
  fclose(inf);
  }

/* --------------------------------------------------------- */


/* ------------------------------------------------------------------ */
void init_xsec_class(XtAppContext apcon)
  {

  XtAppAddActions(apcon, actions, XtNumber(actions));
  }

/* ------------------------------------------------------------------ */

/* Given an already-created GenWidget, and an xsec structure with
   data in it, initializes the rest of the stuff in xsec, and attaches it
   and the widget together, also puts translations into the widget. */

void init_xsec_wij(Widget w, xsec *m, Pixel *colors, Font *fonts)
  {
  XGCValues xgc;

  xgc.function = GXnor;
  xgc.foreground = BlackPixelOfScreen(XtScreen(w));
  if(m == NULL) return;
  m->ggc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		     GCForeground, &xgc);
  /* printf("Initting the GC: %lx\n", m->ggc); */
  m->colors = colors;
  m->fonts = fonts;
  m->wij = w;

  XtVaSetValues(w, XtNdata, m, NULL);
  XtAddCallback(w, XtNredraw, (XtCallbackProc)redraw_xsec, NULL);
  XtAddCallback(w, XtNdestroy, (XtCallbackProc)destroy_xsec, NULL);
  }

/* --------------------------------------------------------- */

void make_xsec_window(Widget top, xsec *xs, Pixel *colors, Font *fonts)
  {
  int lx, ly;
  int  bc;
  float hoz_dist, r, z;
  Widget xp, box, menu, gen, pane, xs_shell;

  hoz_dist = sqrt(sqr(xs->line.x1 - xs->line.x2)
		  + sqr(xs->line.y1 - xs->line.y2));

  r = sqrt(sqr(xs->line.x1 - xs->line.x2)
	   + sqr(xs->line.y1 - xs->line.y2)) * xs->xscale;
  z = (float)xs->xdepth * xs->xscale;

  lx = r + 200;
  ly = z + 200;
  if(ly > 800) ly = 800;
  if(lx > 1200) lx = 1200;

  pane = XtVaCreateManagedWidget("pane", panedWidgetClass, top,
				 XtNwidth, lx,XtNheight, ly,
				 XtNallowHoriz, FALSE, XtNallowVert, FALSE,
				 NULL);

  box = XtVaCreateManagedWidget("control", boxWidgetClass, pane, NULL);

  xp = XtVaCreateManagedWidget("viewport", viewportWidgetClass, pane, NULL);

  gen = XtVaCreateManagedWidget("core", genWidgetClass, xp,
				XtNtranslations,
				XtParseTranslationTable(defaultTranslations),
				XtNdata, xs, NULL);

  init_xsec_wij(gen, xs, colors, fonts);
  xs->shell = top;

  /* File menu */

  xp = XtVaCreateManagedWidget("File", menuButtonWidgetClass, box, NULL);

  XtVaGetValues(xp, XtNbackground, &bc, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp,
			      XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Destroy Window", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)quit_window, xs);


 xp = XtVaCreateManagedWidget("Refresh", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)XRefresh, xs);

  xp = XtVaCreateManagedWidget("Restore", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)XRestore, xs);

  xp = XtVaCreateManagedWidget("Postscript", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_PS, xs);

  xp = XtVaCreateManagedWidget("Save Xsec", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)SaveXparams, xs);

  xp = XtVaCreateManagedWidget("Quit", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)quit, xs);

  /* Special menu */

  xp = XtVaCreateManagedWidget("Special", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp, XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Dip", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_dip, xs);

  xp = XtVaCreateManagedWidget("Depth", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_depth, xs);

  /* xp = XtVaCreateManagedWidget("PLOT SRC", smeBSBObjectClass, menu, NULL);
     XtAddCallback(xp, XtNcallback, (XtCallbackProc)PLOT_selXsource, xs); */

  xp = XtVaCreateManagedWidget("STA-EL", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)switch_sta_el, xs);

  xp = XtVaCreateManagedWidget("Label", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_Label, xs);

  xp = XtVaCreateManagedWidget("Apparent Dip", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)switch_dip, xs);

  xp = XtVaCreateManagedWidget("Geology", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)X_Geology, xs);

  xp = XtVaCreateManagedWidget("Image Above", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Plot_Topo_Field2, xs);


  xp = XtVaCreateManagedWidget("SDR", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)X_SDR, xs);


  xp = XtVaCreateManagedWidget("Sel Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Xsel_Points, xs);


  xp = XtVaCreateManagedWidget("Distance", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)XGet_Dist, xs);


  xp = XtVaCreateManagedWidget("Polygon", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)X_Poly_Start, xs);

  xp = XtVaCreateManagedWidget("Replot Polygon", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)X_Replot_Poly_Points, xs);
  xp = XtVaCreateManagedWidget("DUMP Polygon", smeBSBObjectClass, menu,
			       NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)DUMP_X_POLY, xs);

 /* Misc menu */

  xp = XtVaCreateManagedWidget("Misc", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp, XtNbackground, bc, NULL);


  xp = XtVaCreateManagedWidget("Dump Xsec Image", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)XDump_Image_Field, xs);


  xp = XtVaCreateManagedWidget("Dump Points", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)XDump_Point_Info, xs);

 xp = XtVaCreateManagedWidget("Postscript", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_PS, xs);


 /* Source menu */

  xp = XtVaCreateManagedWidget("Source", menuButtonWidgetClass, box, NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp, XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Save Source", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)SAVE_selXsource, xs);

  xp = XtVaCreateManagedWidget("Append Source", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)APPEND_selXsource, xs);

  xp = XtVaCreateManagedWidget("Poly SRC", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Do_selXpoly, xs);

  xp = XtVaCreateManagedWidget("SAVE FILE", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Popup_src_dump, xs);



 /* Contour Field menu */


  xp = XtVaCreateManagedWidget("Map Field", menuButtonWidgetClass, box,
			       NULL);
  menu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, xp, XtNbackground, bc, NULL);

  xp = XtVaCreateManagedWidget("Above", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)X_Field_Above, xs);

  xp = XtVaCreateManagedWidget("In Model", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)X_Field_InMod, xs);


  xp = XtVaCreateManagedWidget("Dump", smeBSBObjectClass, menu, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)Dump_Field, xs);

  

  xs->xs_shell = xs_shell = XtVaCreatePopupShell("xs_shell",
					       transientShellWidgetClass, top,
						 NULL);
  xs->dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, xs_shell,
				       NULL);
  /* XdialogDone */

  xs->dialogdone = XtVaCreateManagedWidget("OK", commandWidgetClass,
					   xs->dialog, XtNwidth, 60, NULL);
  DialogDone_xsec = xs;
          
  xp = XtVaCreateManagedWidget("Cancel", commandWidgetClass, xs->dialog, NULL);
  XtAddCallback(xp, XtNcallback, (XtCallbackProc)XDialogQuit, xs);



 xs->labshell= 
    XtVaCreateManagedWidget("dislabel", labelWidgetClass, box,
			    XtNborderWidth, 0, XtNlabel, 
			    "Click Info                                                             ", 
			    XtNfromVert, 0,
			    XtNleft, XtChainLeft, NULL);





  /* Done making widgets, let's see them. */

  XtRealizeWidget(top);
  }

/* --------------------------------------------------------- */
