AmpRespCompare<-function(KLIST)
    {

      
      
        apal = c("black", "darkmagenta", "forestgreen", "blueviolet", 
        "tan3", "lightseagreen", "deeppink", "cyan3", "bisque3", 
        "magenta1", "lightsalmon3", "darkcyan", "darkslateblue", 
        "chocolate4", "goldenrod4", "mediumseagreen")

        klog = c(-4, -3,-2,-1,0, 1, 2, 3)
        EFF = DECON::getfreax(klog=klog)
        
        magicaxis::magplot(range(EFF), c(3000, 0.01) , minorn=10,
                           type='n' , log='xy' ,ylab='Amplitude, Db',
                           xlab='log(Hz)',
                           main=paste('Transfer Function Amplitude')    )

        LTY = 1:length(KLIST)
        for(i in 1:length(KLIST) )
            {
                paz = KLIST[[i]]
                Ktest = DECON::checkNORM(paz, EFF = 1)

                TF = DECON::paz2transfer(paz, EFF=EFF )

                ##  g = paz$Knorm * paz$Sense *TF$H
                g = Ktest * paz$Sense *TF$H


                M0 = Mod(g)
                lines(EFF, M0, col=apal[i], lty=LTY[i])
                
            }




        legend(x=c(2.197804), y=c( 2.51253453), 
               legend = names(KLIST),
               col=apal[1:length(KLIST)] , lty=LTY )



    }
