GETirisWIG<-function(h, i.record, starttime, endtime, iris  )
    {
##########   extract from IRIS a specific time series wiggle

#########  first:  IRISSeismic::getStation to find the stations in a radius
        #### for each slected station find availability
######## then  h is the output of IRISSeismic::getAvailability
#####   the out put of that is a detailed spread sheet of information on
### stations and channels in the record at IRIS
#### this function pulls out one station per call.

### return NA if something went wrong.
        
        
        Achan = h$channel[i.record]
        net =   h$network[i.record]
        sta = h$station[i.record]
        scale = h$scale[i.record]
        lat = h$latitude[i.record]
        lon = h$longitude[i.record]
        elev = h$elevationv[i.record]
        location = h$location[i.record]
        units = h$scaleunits[i.record]
        samplerate = h$samplerate[i.record]
        dt = 1/samplerate
        
        wig.mseed  <- try( IRISSeismic::getDataselect(iris, net,sta,location,Achan,starttime, endtime, 
                                         inclusiveEnd=FALSE,ignoreEpoch=TRUE) )

        if( attr(wig.mseed, 'class') == "try-error" ) return(NA)
        
        ###############  NOTE:  I am scaling the trace here, so units are changed
        H1 = DECON::stream2GHnosens(wig.mseed, DEST='.', 
            STREAM=TRUE, sensitivity = 1, scalefactor = 1/scale, gain = 1 )

        H1$units = units
        H1$coords = list(lat=lat, lon=lon, z=elev/1000)
        
        attr(H1,'channel')<-h[i.record,]

        return(H1)
        
    }

