
GetRespFile<-function(fn)
{
    ###   /Users/lees/Vignettes/Filter/data/IRIS/sensors/guralp/RESP.XX.NS041..BHZ.CMG40T.30.800
h1 = scan(file=fn, what='' , sep='\n' )
g1 = grep('Number of zeroes:', h1)
h1[g1]
nz1 = unlist( strsplit(h1[g1], split='') )
nz = as.numeric(nz1[length(nz1)] )

g1 = grep('Complex zeroes', h1)
g1 = g1+1
hzeros = h1[(g1+1):(g1+nz) ]

zeros = vector(mode='complex', length=nz) 
for(i in 1:nz)
    {
    hz1 = unlist( strsplit(hzeros[i], split=' ') )

     hz2 = hz1[hz1!=""]
     zeros[i] = complex(real=as.numeric(hz2[3]), imaginary=as.numeric(hz2[4]))
     
    }


g1 = grep('Number of poles:', h1)
h1[g1]

np1 = unlist( strsplit(h1[g1], split='') )

np = as.numeric(np1[length(np1)] )

g1 = grep('Complex poles', h1)
g1 = g1+1

hpoles = h1[(g1+1):(g1+np) ]


poles = vector(mode='complex', length=np) 
for(i in 1:np)
    {
     #### cat(hpoles[i], sep='\n')
     hz1 = unlist( strsplit(hpoles[i], split=' ') )
     hz2 = hz1[hz1!=""]
     poles[i] = complex(real=as.numeric(hz2[3]), imaginary=as.numeric(hz2[4]))
     
 }



k1 = grep('A0 normalization factor', h1)
kz1 = unlist( strsplit(h1[k1], split=' ') )
knorm = as.numeric(  kz1[length(kz1) ] )

k1 = grep('Sensitivity:', h1)
kz1 = unlist( strsplit(h1[k1], split=' ') )
ksense = as.numeric(  kz1[length(kz1) ] )

k1 = grep('Normalization frequency:', h1)
kz1 = unlist( strsplit(h1[k1], split=' ') )
fnorm = as.numeric(  kz1[length(kz1) ] )


    
PAZ = list(nz=nz, zeros=zeros, np=np, poles=poles, Knorm=knorm, Sense=ksense, Fnorm=fnorm) 
return(PAZ)

}


if(FALSE)
{
source("~/Vignettes/Filter/CODE/GetRespFile.R")
source("~/Vignettes/Filter/CODE/AmpRespCompare.R")

    library(DECON)
    
    source()
    
    fn = '/Users/lees/Vignettes/Filter/data/IRIS/sensors/guralp/RESP.XX.NS041..BHZ.CMG40T.30.800'
    PAZ = GetRespFile(fn)

    klog = c(-4, -3,-2,-1,0, 1, 2, 3)
 EFF = getfreax(klog=klog)
TF = paz2transfer(PAZ, EFF=EFF)

TFplot(TF, tit='CMG40T' )

  LS.RESP =   list.files(path="/Users/lees/Vignettes/Filter/data/IRIS/sensors", pattern='RESP', recursive=TRUE )


    
}
