
MiniSeedSplitter<-function(mseedfiles, DEST,  TWIN)
{
####  DEST = destimation directory
#### TWIN = time-window for splitting
### mseedfiles = vector of mini-seed files (full path)

#######  these will have to be supplied later
    sensitivity = 1;
    scalefactor = 1;
    gain = 1;
    
    for(IMS in 1:length(mseedfiles) )
    {

        IRISinput = readMiniseedFile(mseedfiles[IMS])
        A = DECON::stream2GHnosens(IRISinput,
                                   DEST = ".",
                                   STREAM = TRUE,
                                   sensitivity = sensitivity,
                                   scalefactor = scalefactor,
                                   gain = gain,
                                   coords =NULL,
                                   orient = NULL,
                                   notes=NA,
                                   suffix='RDS')

        dt = A$dt
        NWIN = TWIN/dt

        Istart = seq(from=1, to=A$N, by=NWIN)
        Inum = length(Istart)
        
        Iend = Istart+NWIN-1
        if(Iend[Inum] > A$N) { Iend[Inum] = A$N }
        
        for(i in 1:length(Istart) )
        {
            Iamp = A$amp[Istart[i]:Iend[i] ]
            IDATTIM = A$DATTIM
            
            IDATTIM$sec = A$DATTIM$sec + (Istart[i]-1)*dt
            IDATTIM =     recdatel(IDATTIM)
            gmd  = getmoday(  IDATTIM$jd, IDATTIM$yr  )
            IDATTIM$mo = gmd$mo
            IDATTIM$dom = gmd$dom
            IDATTIM$msec = 0
            IDATTIM$off = 0
            IDATTIM$t1 = 0
            IDATTIM$dt = dt
            
            B = A
            B$DATTIM = IDATTIM
            B$amp = Iamp
            B$N = length(Iamp)
            
            zd1 = Zdate(IDATTIM)
            FN1 = paste(zd1, B$sta, B$comp,'RDS',  sep='.')
            FN = paste(DEST, FN1, sep='/')
            
            
            saveRDS(file=FN, B)
            
        }
    }

}
