TFplot <-
function(TF,  f0=1, band=c(1/120, 80) ,  tit='' )
    {
     ####   require(signal)
   requireNamespace('signal', quietly = TRUE) 
####  TF is the complex transfer function already calculated
####           EFF = getfreax(klog=klog)
####           colt.TF = paz2transfer(paz, EFF=EFF )

####   f.lo=120 seconds, f.hi=80   Hz
        eff = TF$EFF
        M1 = Mod(TF$H)
###  
        A.raw  = Arg(TF$H)

        A.tf  = (signal::unwrap(A.raw))
        
#### convert to DBdown

        i.f0 = findInterval(f0, eff)
        ##### used to be M.reference = max(M1)
        M.reference = M1[i.f0]
        
        M2 = 20*log10( (M1/M.reference) ) 

        GX.lines = getfreax(klog = c(-4, -3,-2,-1,0, 1, 2), len=10)
        GY.lines = pretty(c(-50, 10))
        old.par <- par(no.readonly = TRUE)
        on.exit(par(old.par))
        par(mfrow=c(2,1) )
        
        plot(c(10e-4, 110), c(-50, 10) ,    type='n' , log='x' ,ylab='Amplitude, Db',
                xlab='log f Hz',
                main=paste(tit,'Transfer Function Amplitude'), axes=FALSE   )
        abline(v=GX.lines, h=GY.lines, col=grey(.8), lty=2)
        if(!is.na(band[1]) | !is.null(band[1]) ) abline(v=band, col='darkgreen' , lty=3)

        abline(v=c(f0), col='red' , lwd=1.2)
        mtext(expression(f[0]), at=f0,  side = 3, line = 0, col='red' )
        
        box()
        magaxis(side = 1)
        magaxis(side = 2, las=2)

        lines(eff, M2)

     ##    magaxis(side = 1,majorn=10,  minorn=10)
        GY2.ax = pretty(c(-180, 180)  )
        
        
        ## points(eff, M2)
        
        plot( range(eff), c(-180, 180) ,
           type='n' , log='x' ,ylab='Phase(deg)',
                xlab='log f Hz',
                main=paste(tit,'Transfer Function Phase') , axes=FALSE )
        abline(v=GX.lines, col=grey(.8), lty=2 )
         abline(h=GY2.ax, col=grey(.8), lty=2 )
         box()
        magaxis(side = 1)
        ydegs = seq(from=-180, to=180, by=45)
        
        axis(side = 2, at=ydegs,  las=2)
   
        lines(eff, (A.tf)*180/pi  )



        invisible(list(eff=eff, AMPDB=M2, PHASE=(A.tf)*180/pi) )

        
    }
