get1mseed<-function(THE.MSEED, NCFcolts, COUNTS.conversion = 1.90735e-06 )
    {
        a.chans = c( 'Z', 'N', 'E', 'F' )

        bn = basename(THE.MSEED)
        jtrace = IRISSeismic::readMiniseedFile(THE.MSEED)
        tr1 <- jtrace@traces[[1]]
        sensitivityValue = attr(tr1, 'InstrumentSensitivity')
        
        aunits = attr(tr1, 'InputUnits')
        
        trINFO = attr(tr1, 'stats')
        ATS = attributes(trINFO) 
        sta = ATS$station
        chan = ATS$channel
        ##### take the last char of the channel
        comp = substr(chan, 3, 3 )
        
        jtrace@traces[[1]]<-tr1
        w.sta = which(sta == NCFcolts$Station )
        
        sn = NCFcolts$Sensor.S.N[w.sta]
        das = NCFcolts$DAS[w.sta]

        w.inst = which( sn==NCFcolts$Sensor.S.N )

        inst.type = NCFcolts$Sensor.type[w.inst]
###     m = match( sn , COLT.SENSE$SN )

        
        w.chan = which(comp==a.chans)
        if(w.chan>0) { rseis.chan =a.chans[w.chan] } else { rseis.chan = 'unknown' }
        
        sensitivityValue =1
        
        gain = NCFcolts$Gain[w.sta ]
        wig  = stream2GHnosens(jtrace, DEST='.', STREAM=TRUE,  sensitivity=1, scalefactor=COUNTS.conversion/gain  )
#######  units are now volts
        
        wig$gain = gain
        wig$units = 'volts'
        wig$instrument = inst.type 
        wig$sense = sensitivityValue
        
        wig$notes = 'GAIN APPLIED'
        wig$HEAD$units = 'volts'
        wig$HEAD$sense = sensitivityValue
        wig$HEAD$process='Counts to VOLTS and GAIN APPLIED'
        wig$sn = sn
        wig$das = das
        wig$rseis.chan = rseis.chan
        
        return(wig)
    }
