paz.decon<-function( data, dt = 0.008, paz, waterlevel = 1e-08, sense=TRUE)
    {

        n = length(data)
        nn = next2(n)
        f = makefreq(nn, dt)
        ###### zero pad wiggle to next power of  two 
        why = c(data, rep(0, nn - n))
        DATA = fft(why)

        ####   if no poles or zeros just return the data/sensitivity

        if(paz$np==0 & paz$nz == 0 & paz$Sense != 0)
            {
                d = data/paz$Sense
                return(d)
            }
        instold = pazINSTresponse(paz,  f )
        
         temp1 = Re(instold$transfer * Conj(instold$transfer))
      ### 
        
        gamma = max(temp1) * waterlevel
        temp =  Conj(instold$transfer)/(temp1 + gamma)
        tempdata = Re(fft(DATA * temp, inverse = TRUE)/nn)
        da = tempdata[1:n]

        if(sense)
        {
            #######  divide by sensitivity
                meandsold = paz$Sense
                d = da/meandsold
            }
        else
            {
                d = da
            }
     
        
        return(d)

}
