paz2transfer <-
function(paz, EFF=1 )
    {
####        require signal
##########  calculate the transfer function of sensor given the poles and zeros
####  this is useful for seismometers, mainly
        #### EFF = frequency in Hz, could use EFF = getfreax(klog=klog)
      ###   require(signal)
requireNamespace('signal', quietly = TRUE) 
###  the return H here does not have a normalization constant or a sensitivity
####  in it.
        
        
        if(missing(EFF)) {
            klog = c(-4, -3,-2,-1,0, 1, 2)
            EFF = getfreax(klog=klog)
        }
        
        NUM.poly  = signal::poly(paz$zeros)
        DEN.poly = signal::poly(paz$poles)

        w = EFF*(2*pi)
        
        ess = complex(real=0, imaginary=w)
        H.DEN = signal::polyval(DEN.poly, ess) 
        H.NUM = signal::polyval(NUM.poly, ess) 
        HA_Z = H.NUM/H.DEN
       
        return(list(H=HA_Z, EFF=EFF, H.DEN=H.DEN, H.NUM=H.NUM, paz=paz ) )

    }
