pazINSTresponse<-function (Calib, ff ) 
{
    verb = FALSE
    norm = Calib$Knorm
    gain = Calib$Gain
    meands = Calib$Sense
    npole = Calib$np
    nzero = Calib$nz
    poles = Calib$poles
    zeroes = Calib$zeros
    nam = Calib$name
    
    if (verb) {
        message(paste(sep = " ", "RESPONSE:", nam, npole, nzero, 
            norm, gain))
        message("poles")
        message(poles)
        message("zeros")
        message(zeroes)
    }
    if (is.null(zeroes)) {
        bb = 1
    }
    else {
        bb = RSEIS::gpoly(zeroes)
    }
    aa = RSEIS::gpoly(poles)
    
    if (length(ff) == 2) {
        f = RSEIS::logspace(ff[1], ff[2])
    }
    else {
        f = ff
    }
    
    w = 2 * pi * f
    ##############     this is the transfer function
    transfer = RSEIS::INSTFREQS(bb, aa, w) * norm
    
    return(list(transfer = transfer, aa = aa, bb = bb))
}
