stream2GHnosens<-function(IRISinput, DEST='.', STREAM=FALSE, sensitivity=1, scalefactor=1, gain=1,coords =NULL, orient = NULL,  notes=NA, suffix='RDS' )
{
#####  convert the output of IRISSeismic::getDataselect to GH
####  convert mseed stream to RSEIS (GH) file

    ##### important conversion factors
 ####     sensitivity=1   convert from volts to m/s
####    scalefactor=1  convert from counts to volts

    #####  gain = 1,32...?

####  in some cases the scale factor is already applied - then need to use scalefactor=1

#### for reftek RT-130  scalefactor=1.90735e-06
  
    BIGLONG = FALSE
    Iendian = 1
    
    tr1 <- IRISinput@traces[[1]]
     
    if( is.null(sensitivity) )
        {  sensitivityValue = attr(tr1, 'InstrumentSensitivity')  }
    else
        {
            sensitivityValue = sensitivity
            
        }
    
    aunits = attr(tr1, 'InputUnits')

    trINFO = attr(tr1, 'stats')

    srate = attr(trINFO, 'sampling_rate')
    starttime = attr(trINFO, 'starttime')
    endtime = attr(trINFO, 'endtime')
    chan = attr(trINFO, 'channel')
    dt = attr(trINFO, 'delta')
    npts = attr(trINFO, 'npts')
    sta = attr(trINFO, 'station')
    
    yr = lubridate::year(starttime)
    mo = lubridate::month(starttime)
    dom = lubridate::day(starttime)
    hr = lubridate::hour(starttime)
    mi = lubridate::minute(starttime)
    sec = lubridate::second(starttime)
    jd = RSEIS::getjul(yr, mo, dom)
    trDATA =  attr(tr1, 'data')
####  this is an RSEIS date list:
    BEGdate = list(yr=yr, jd=jd, hr=hr, mi=mi, sec=sec,
        mo=mo, dom=dom, msec=0, off=0, t1=0, dt=dt)
    
    st <- IRISSeismic::multiplyBy(tr1, scalefactor/sensitivityValue/gain )
    dt = 1/trINFO@"sampling_rate"
    v2 = as.vector(st)
    fn1 = paste(sta,  chan,    paste(Zdate(BEGdate), suffix , sep='.'), sep="_")

    ##  cat(fn1, sep='\n' )
    fn2 = paste(DEST, fn1, sep='/')
    HEAD=list(units=aunits, sense=sensitivityValue, process='changed units' )
    GH = list(fn=fn1, sta=sta,  comp=chan, dt=dt, DATTIM=BEGdate, N=length(v2),amp=v2 ,
        units=aunits ,
        coords=coords ,   orient = orient ,  HEAD=HEAD,
        IO=list(kind=0, Iendian=Iendian,  BIGLONG=BIGLONG) , notes=notes)
    if(STREAM==TRUE)
        {
            return(GH)
        }
    else
        {
            #######  save as a single RSEIS object - readRDS to read
            saveRDS(file=fn2, GH)
            return(fn2)
        }
}


