
texINSTRESP<-function(k2)
  {
####  print out a latex table of the instrument response
    
    message("\\begin{table}[ht]")
    message(paste("\\caption{", k2$name, "}", sep=""))

    message("\\centering")
    message("\\begin{tabular}{rrr}")
    message( "\\hline")
    message( paste(k2$np , " & POLES & \\\\ "))
    if(k2$np>0)
      {
    message( "\\hline")
    message( " & real & imaginary \\\\")
    message("\\hline")
    for(i in 1:k2$np)
      {
        r1 = Re(k2$poles[i])
        i1 = Im(k2$poles[i])
        
        message(paste(i, "&" , r1, "&", i1, "\\\\", sep=" ") ,  sep="\n")
      }
  }
    message("\\hline")
    message( paste(k2$nz , "& ZEROES  & \\\\ "))
    if(k2$nz>0)
      {
    
    message( "\\hline")
    for(i in 1:k2$nz)
      {
        r1 = Re(k2$zeros[i])
        i1 = Im(k2$zeros[i])
        
        message(paste(i, "&" , r1, "&", i1, "\\\\", sep=" "))
      }
  }
    message("\\hline")
    pn = paste("Normalization & ", k2$Knorm, "   & \\\\", sep=" ")
    psens = paste("Sensitivity & ", k2$Sense,  " & \\\\", sep=" ")


    message( pn)
    message("\\hline")

    message( psens)

    message("\\hline")

    message("\\end{tabular}")
    message("\\end{table}")

  }

