\name{DECON-package}
\alias{DECON-package}
\alias{DECON}
\docType{package}
\title{
\packageTitle{DECON}
}
\description{
\packageDescription{DECON}
}
\details{

The DESCRIPTION file:
\packageDESCRIPTION{DECON}
\packageIndices{DECON}
Prepare transfer functions for a given set of poles and zeros
for understanding the instrument response of a seismic instrument.
}
\author{
\packageAuthor{DECON}

Maintainer: \packageMaintainer{DECON}
}
\references{
Scherbaum's book
}

\keyword{ package }
\seealso{
RSEIS, signal
}
\examples{

trillium.iris  = c(
'ZEROS 5',
'0.0000E+00 0.0000E+00',
    '0.0000E+00 0.0000E+00',
    '-90.0E+00 0.0000E+00',
    '-160.7E+00 0.0000E+00',
       '-3108E+00 0.0000E+00',
'POLES 7',
    '-0.03852 0.03658',
    '-0.03852 -0.03658',
    '-178  0.0E+00',
    '-135  160E+00',
       '-135  -160E+00',
    '-671  1154E+00',
         '-671  -1154E+00',
'CONSTANT 308000',
    'SENSE 1201')

tril120.paz = RSEIS::ReadSet.Instr(trillium.iris) 
klog = c(-4, -3, -2, -1, 0, 1, 2)
eff = getfreax(klog=klog)

TFtril = paz2transfer(tril120.paz, EFF = eff)


TFplot(TFtril, f0 = 1, band=c(1/120,  20), tit = "TRILLIUM")

}
