\name{GETirisWIG}
\alias{GETirisWIG}
\title{Get IRIS waveform data
}
\description{Extract specific IRIS waveform data.
}
\usage{
GETirisWIG(h, i.record, starttime, endtime, iris)
}
\arguments{
  \item{h}{list from output of getAvailability
}
  \item{i.record}{index to one row of list
}
  \item{starttime}{start time of trace (posix)
}
  \item{endtime}{end time of trace  (posix)
}
  \item{iris}{ set prior to call IrisClient
}
}
\details{If no trace exists for this call,
return NA.
}
\value{Output of DECON::stream2GHnosens, similar to
output of JGET.seis from RSEIS.  The traces are scaled
so that the units are correctly represented as physical units.
The units and the coordinates are added to the list structure.
The row in h  associated with this extraction is also stored as an
attribute for possible later use.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Units are added to the trace structure. For
seismic data units are typically, m/s. For infrasound they are Pa.

}


\seealso{RSEIS::JGET.seis, RSEIS::GET.seis, 
}
\examples{


\dontrun{

### times are in GMT
RDT=list(
min=list(jd=187, hr=3, mi=0, sec=0, yr=2019))
moday = getmoday(RDT$min$jd, RDT$min$yr)
RDT$min$mo = moday$mo
RDT$min$dom = moday$dom
Dstart = ASCIIdate(RDT$min)
starttime <- lubridate::ymd_hms(Dstart )
endtime <-  starttime + 3600


Chapel_Hill=list()
Chapel_Hill$lat=c(35.927613)
Chapel_Hill$lon=c(280.959373)

e = Chapel_Hill

e$latitude = e$lat
e$longitude = e$lon - 360 

e$rad = 4

iris <- new("IrisClient")

channelH <- IRISSeismic::getAvailability(iris,'N4',
'V58A',"*","*",starttime,endtime,
latitude=e$latitude,longitude=e$longitude,
 maxradius=e$rad )
        
iw = which(names(AVAIL) == 'V58A')
iV58 = iw[1]
h =AVAIL[[iV58]]


V58 = vector(mode='list')
iget = c(1,2,3,15)
for(i in 1:length(iget) )
    {
V58[[i]] = GETirisWIG(h, iget[i], starttime, endtime , iris )
}

GH.V58 = RSEIS::prepSEIS(V58)
swig(GH.V58 )



}



}
\keyword{misc}
