\name{GetRespFile}
\alias{GetRespFile}
\title{Read SEED Response File
}
\description{Read SEED Response file, and
extract poles and zeros for plotting and deconvolution.
}
\usage{
GetRespFile(fn)
}
\arguments{
  \item{fn}{character path to file
}
}
\details{
The code parses out the file - it is still not clear
all the sections extracted here are the correct
ones to extract.  
}
\value{PAZ list
}
\references{ SEED manual
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
There are several elements in the SEED files that
are not relevant to correct deconvolution for field
data - this extraction focuses mainly on the instrument response.
To get the other filters, mainly associated with the
digitizers, must read other parts of the RESP file.
}


\seealso{SAC
}
\examples{

\dontrun{
######  e.g. get the path to this file:
path = "/Users/lees/Vignettes/Filter/data/IRIS/sensors/guralp"
hname =paste(path, "RESP.XX.NS455..BHZ.CMG40T.100_50.20000", sep='/')
 jay1 = GetRespFile(hname)


}



}
\keyword{misc}
