\name{MiniSeedSplitter}
\alias{MiniSeedSplitter}
\title{Split Miniseed file into time chuncks
}
\description{
  Miniseed files come in day-long files from rt2ms. This code splits
  the miniseed datastream into chunks of TWIN seconds long.
}
\usage{
MiniSeedSplitter(mseedfiles, DEST, TWIN)
}
\arguments{
  \item{mseedfiles}{vector of files to convert
}
  \item{DEST}{Destination of RSEIS RDS files
}
  \item{TWIN}{Time-window (s) to break down the long trace.
}
}
\details{
  The long signal is broken down into manageable sections
  for later use in RSEIS.
}
\value{Side Effects: RDS Files are created in the DEST path
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  The data amplitude is not converted.
}

\seealso{get1sac
}
\examples{
\dontrun{
mseedfiles = list.files(path="./TESTS/RoomTest/RoomTest31B/BSUTest")
TWIN = 1800  ###  seconds

DEST = '/Users/lees/Site/Fire/TESTS/RoomTest/RSEIS.FILES'

MiniSeedSplitter(mseedfiles, DEST, TWIN)

}


}
\keyword{misc}
