\name{TFplot}
\alias{TFplot}
\title{Plot transfer function
}
\description{
Folloing computation of the trnsfer function, plot the amplitude and phase
of the transfer function.
}
\usage{
TFplot(TF, f0 = 1, band=c(1/120, 80) , tit = "")
}
\arguments{
  \item{TF}{Complex transfer function
}
  \item{f0}{Frequency for determining  normalization constant
}
 \item{band}{ Low and high frequency (Hz) cutoff for nominal pass band of instrument.
 }
  \item{tit}{title for plot
}
}
\details{
The TF should be created prior to plotting.
}
\value{
Side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
Log-Log plots are created.
}


\seealso{getfreax, paz2transfer
}
\examples{


trillium.iris  = c(
'ZEROS 5',
'0.0000E+00 0.0000E+00',
    '0.0000E+00 0.0000E+00',
    '-90.0E+00 0.0000E+00',
    '-160.7E+00 0.0000E+00',
       '-3108E+00 0.0000E+00',
'POLES 7',
    '-0.03852 0.03658',
    '-0.03852 -0.03658',
    '-178  0.0E+00',
    '-135  160E+00',
       '-135  -160E+00',
    '-671  1154E+00',
         '-671  -1154E+00',
'CONSTANT 308000',
    'SENSE 1201')

tril120.paz = RSEIS::ReadSet.Instr(trillium.iris) 
klog = c(-4, -3, -2, -1, 0, 1, 2)
eff = getfreax(klog=klog)

TFtril = paz2transfer(tril120.paz, EFF = eff)


TFplot(TFtril,  f0 = 1, band=c(1/120,  20),  tit = "TRILLIUM")

}
\keyword{misc}
