\name{Yaxis.expo}
\alias{Yaxis.expo}
\title{Y-axis with exponentials
}
\description{Replace the Y-axis with
exponentials.  Plots with mantissa and exponent may be
more attractive.
}
\usage{
Yaxis.expo(yt, yat, cex=0.8,  cex.exp=1, adj=c(1,-1))
}
\arguments{
  \item{yt}{Y values along axis
}
  \item{yat}{y-axis placement of the ticks and labels 
}

  \item{cex}{character expansion for the axis notation
}

  \item{cex.exp}{character expansion for the exponents
}

  \item{adj}{adjustment of the placement of the exponents
}




}
\details{
Replace the y-axis with new numbers that are scaled by the
log10 mantissa/exponent.
Y-axis placement is provided in the event the locations
do not match the actual valuesin te data - this may occur if
the data has been scaled but is plotted on a different scaling.

}
\value{side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{
axis, text, par
}
\examples{

x  = 1:10
y = seq(from=-1*pi*1e-06 , to= 2*pi*1e-06, length=length(x) )

plot(x,y)


yt = pretty(y)
yt = yt[yt>=min(y) & yt<=max(y) ]

plot(x,y, axes=FALSE)
axis(1)

#####  a small adjustment of the x,y-placement of the exponent
#####   might be useful for asthetics
Yaxis.expo(yt, yt, cex=0.8,  cex.exp=1, adj=c(1.1,-.8))
box()

}
\keyword{misc}
