\name{better.decon}
\alias{better.decon}
\title{Detrend and Deconvolve
}
\description{
Deconvolve trace, by removing trend before
and after spectral division.
}
\usage{better.decon(data, dt = dt, paz, waterlevel = 1e-08, pcttap=0.05, sense=TRUE)
}
\arguments{
  \item{data}{signal vector, floating point
}
  \item{dt}{delta t, sample interval
}
  \item{paz}{list of poles and zeros
}
  \item{waterlevel}{regularization factor
}
  \item{pcttap}{Percent taper on front and back of the trace
}
\item{sense}{logical, if TRUE, divide by sensitivity }


}

\details{
This slightly preconditions the trace prior to
filtering.  Highly recommended.
As a precursor to spectral division, the trace is detrended and tapered
before and after the decon is applied.

}
\value{
Deconvolved trace that has the mean and trend removed.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
It is also desirable to apply some kind of band-pass filter
to the trace after decon.  See butfilt_augment for details.
}


\seealso{paz.decon, butfilt_augment
}
\examples{


\dontrun{
###  need and example here.

}

}
\keyword{misc}
