\name{butfilt_augment}
\alias{butfilt_augment}
\title{Augmented Butterworth filter
}
\description{
 Design and apply butterworth low/high/band pass filters with augmented ends to reduce edge effects.
}
\usage{
butfilt_augment(a, fl = 0, fh = 0.5, deltat = 1, type = "BP", proto = "BU",
npoles = 5, chebstop = 30, trbndw = 0.3, RM = FALSE, zp = TRUE, pct = 0.1)
}
\arguments{
  \item{a}{vector signal}
  \item{fl}{low frequency cut-off, default=0 }
  \item{fh}{high frequency cut-off, DEFAULT= (1/2dt) }
  \item{deltat}{sample rate, s, deFAULT=1}
  \item{type}{type of filter, one of c("LP",  "HP","BP" ,"BR" ), DEFAULT="BP" }
  \item{proto}{prototype, c("BU", "BE" , "C1" ,"C2"), DEFAULT="BU"  }
  \item{npoles}{number of poles or order, DEFAULT=5}
  \item{chebstop}{Chebyshev stop band attenuation, DEFAULT=30.0}
  \item{trbndw}{Chebyshev transition bandwidth, DEFAULT=0.3}
  \item{RM}{Remove mean value from trace, default=FALSE}
  \item{zp}{zero phase filter, default=TRUE}
  \item{pct}{ percentage of overlap to reproduce on the ends of the trace
}
}
\details{

The time series vector is augmented by time-reversed
sections at the begining and ending of the trace.
The amount of overlap is given by a percentage of the trace - typically 10 percent.

  Creation of butfilt is a described by the following arguments:
  \describe{
    \item{LP}{low pass  }
    \item{HP}{high pass }
    \item{BP}{band pass }
    \item{BR}{band reject }
    \item{BU}{Butterworth }
    \item{BE}{Bessel }
    \item{C1}{Chebyshev type 1 }
    \item{C2}{Chebyshev type 2 }
  }

  Arguments chebstop , trbndw  are ignored for non-chebyshev filters.
  LP and HP filters are seet by specifying fl for HP filters and fh for
  LP filters, the other argumentin each case is ignored.

  Mean values should be removed prior to calling this function, and then set RM=FALSE.
  This is true especially if tapering is applied prior to filtering.

  Zero phase filter is achived by running filter back and forth.  Otherwise
  a single pass is returned.  This should be equivalent to package signal filtfilt (from MATLAB).


}
\value{
Filtered time series. 

}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\note{Returned trace should be same length as input trace.
}


\seealso{RSEIS::butfilt
}

\examples{
\dontrun{
####  need an example here.
}
}
\keyword{misc}
