\name{checkNORM}
\alias{checkNORM}
\title{Check the normalization factor
}
\description{
Check the normalization factor for a given instrument response.
}
\usage{
checkNORM(paz, EFF = 1)
}
\arguments{
  \item{paz}{Poles and zeros
}
  \item{EFF}{normalization frequency 
}
}
\details{
This is used to check the normalization factor provided by IRIS
or other agency.  Or can be used to create a new norm.
}
\value{
Single value that insures that the TF is
unity at the frequency given.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{paz2transfer
}
\examples{

trillium.iris  = c(
'ZEROS 5',
'0.0000E+00 0.0000E+00',
    '0.0000E+00 0.0000E+00',
    '-90.0E+00 0.0000E+00',
    '-160.7E+00 0.0000E+00',
       '-3108E+00 0.0000E+00',
'POLES 7',
    '-0.03852 0.03658',
    '-0.03852 -0.03658',
    '-178  0.0E+00',
    '-135  160E+00',
       '-135  -160E+00',
    '-671  1154E+00',
         '-671  -1154E+00',
'CONSTANT 308000',
    'SENSE 1201')

tril120.paz = RSEIS::ReadSet.Instr(trillium.iris) 

K = checkNORM(tril120.paz, EFF = 1)


##### compare these two
print(paste(K, tril120.paz$Knorm))

}
\keyword{misc}
