\name{kplot.TF}
\alias{kplot.TF}
\title{Plot Transfer function
}
\description{
Plot the amplitude and phase response of a transfer function.
}
\usage{
kplot.TF(TF, f.lo = 1/120, f.hi = 80, f0 = 1, tit = "")
}
\arguments{
  \item{TF}{Transfer function (with frequencies)
}
  \item{f.lo}{Low frequency 
}
  \item{f.hi}{High frequency 
}
  \item{f0}{Normalization frequency
}
  \item{tit}{title
}
}

\value{Side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{TFplot

}
\examples{

   trillium.iris  = c(
     'ZEROS 5',
     '0.0000E+00 0.0000E+00',
         '0.0000E+00 0.0000E+00',
         '-90.0E+00 0.0000E+00',
         '-160.7E+00 0.0000E+00',
            '-3108E+00 0.0000E+00',
     'POLES 7',
         '-0.03852 0.03658',
         '-0.03852 -0.03658',
         '-178  0.0E+00',
         '-135  160E+00',
            '-135  -160E+00',
         '-671  1154E+00',
              '-671  -1154E+00',
     'CONSTANT 308000',
         'SENSE 1201')
     
     tril120.paz = RSEIS::ReadSet.Instr(trillium.iris) 
     klog = c(-4, -3, -2, -1, 0, 1, 2)
     eff = getfreax(klog=klog)
     
     TFtril = paz2transfer(tril120.paz, EFF = eff)
     
     
     kplot.TF(TFtril,  f0 = 1, f.lo=1/120,  f.hi=20,  tit = "TRILLIUM")
     


}
\keyword{misc}
