\name{paz.decon}
\alias{paz.decon}
\title{Frequency Domain Deconvolution
}
\description{Deconvolve an instrument response from a seismic trace.
}
\usage{
paz.decon(data, dt = 0.008, paz, waterlevel = 1e-08, sense=TRUE)
}
\arguments{
  \item{data}{signal vector, floating point
}
  \item{dt}{delta t, sample interval
}
  \item{paz}{list of poles and zeros
}
  \item{waterlevel}{regularization factor
}
 \item{sense}{logical, if TRUE, divide by sensitivity }
}
\details{
The paz is converted to the
frequency domain representation of the transfer function
(complex vector), divided out in the frequency domain of the trace,
and returned as the inverse fourier transform.
The frequencies are selected as the next power of two greater
than the length of the trace.
No other filtering is applied.
}
\value{
real valued vector
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
There is a question on whther to apply the sensitivity.
In this case, by default, the sensitivity is applied at the last line of the code.

}


\seealso{RSEIS::deconinst	
}


\examples{


\dontrun{
### need a good example here.

}
}
\keyword{misc}
