\name{paz2transfer}
\alias{paz2transfer}
\title{Poles and Zeros to TF
}
\description{
Poles and zeros are converted to a complex transfer function.
}
\usage{
paz2transfer(paz, EFF = 1)
}
\arguments{
  \item{paz}{list that has components poles and zeros
}
  \item{EFF}{vector of frequencies (Hz) where TF is calcualted.
}
}
\details{
The TF is calculated only where the frequencies are provided.

}
\value{
Complex values vector representing the transfer function.
}


\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
This function does not apply the normalization.
}


\seealso{TFplot, RSEIS::ReadSet.Instr , getfreax, checkNORM
}
\examples{

trillium.iris  = c(
'ZEROS 5',
'0.0000E+00 0.0000E+00',
    '0.0000E+00 0.0000E+00',
    '-90.0E+00 0.0000E+00',
    '-160.7E+00 0.0000E+00',
       '-3108E+00 0.0000E+00',
'POLES 7',
    '-0.03852 0.03658',
    '-0.03852 -0.03658',
    '-178  0.0E+00',
    '-135  160E+00',
       '-135  -160E+00',
    '-671  1154E+00',
         '-671  -1154E+00',
'CONSTANT 308000',
    'SENSE 1201')

tril120.paz = RSEIS::ReadSet.Instr(trillium.iris) 
klog = c(-4, -3, -2, -1, 0, 1, 2)
eff = getfreax(klog=klog)

TFtril = paz2transfer(tril120.paz, EFF = eff)

##plot with TFplot(TFtril)


}
\keyword{misc}
