\name{pazINSTresponse}
\alias{pazINSTresponse}
\title{Poles and Zeros Response Function
}
\description{
Convert a set of poles and zeros to the frequency domain
representation of the transfer function.
}
\usage{
pazINSTresponse(Calib, ff)
}
\arguments{
  \item{Calib}{List with elements named poles and zeros
}
  \item{ff}{
  frequency vector (Hz) where transfer function should be evaluated.
}
}
\details{
The Calib list typically includes np, poles, nz, zeros, norm, gain and sensitivity.
}
\value{
List Transfer function:
\item{transfer}{complex vector}
\item{aa}{denomenator (poles), polynomial}
\item{bb}{numerator (zeros), polynomial}

}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\examples{

trillium.iris  = c(
'ZEROS 5',
'0.0000E+00 0.0000E+00',
    '0.0000E+00 0.0000E+00',
    '-90.0E+00 0.0000E+00',
    '-160.7E+00 0.0000E+00',
       '-3108E+00 0.0000E+00',
'POLES 7',
    '-0.03852 0.03658',
    '-0.03852 -0.03658',
    '-178  0.0E+00',
    '-135  160E+00',
       '-135  -160E+00',
    '-671  1154E+00',
         '-671  -1154E+00',
'CONSTANT 308000',
    'SENSE 1201')

tril120.paz = RSEIS::ReadSet.Instr(trillium.iris) 


klog = c(-4, -3, -2, -1, 0, 1, 2)
eff = getfreax(klog=klog)
TF = pazINSTresponse(tril120.paz, eff)

}
\keyword{misc}
