\name{setEvent}
\alias{setEvent}
\title{Extract parameters from IRIS or ANSS event file.
}
\description{
  Extract and fill data.frame of events extracted from
  IRIS or ANSS data-bases.
}
\usage{
setEvent(events, k = NA)
}
\arguments{
  \item{events}{dataframe, including:
    eventId,time,latitude,longitude,depth,author,
    cCatalog,contributor,contributorId,magType,
    magnitude,magAuthor,eventLocationName
}
  \item{k}{integer index, which event to pull out
}
}
\details{
  Reformat the dataframe output of function IRISSeismic::getEvent.
  Function converts the dates to usable RSEIS style dates.
}
\value{
  List with event information:
  yr, mo, dom, jd, hr, mi, sec, lat, lon, LON, mag, z, depth, LocInfo
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\seealso{IRISSeismic::getEvent
}
\examples{

\dontrun{

Btime = "2011-03-11 05:46:00 GMT"
Atime <- as.POSIXct(Btime, "GMT" )

startwin = Atime
endwin <-startwin + 150*60
starttime = Atime - 3600
endtime=starttime+2*3600

events1 <- IRISSeismic::getEvent(iris, starttime, endtime, minmag=6.0, maxmag=10, 
                        mindepth=5, maxdepth=100 )

TOHOKU.main = data.frame(events1)[1, ]

event1 = setEvent(TOHOKU.main, k=1)

event2 = setEvent(events, k=5)

}




}
\keyword{misc}
