\name{stream2GHnosens}
\alias{stream2GHnosens}
\title{
Mseed Stream to RSEIS
}
\description{
Convert an Mseed data stream to RSEIS list.
}
\usage{
stream2GHnosens(IRISinput, DEST = ".", STREAM = FALSE, sensitivity = 1,
scalefactor = 1, gain = 1,coords =NULL, orient = NULL, notes=NA, suffix='RDS')
}
\arguments{
  \item{IRISinput}{Output of mseed stream from package IRISSeismic
}
  \item{DEST}{ destination path to store outpout
}
  \item{STREAM}{ logical, whether to stream or write to disk
}
  \item{sensitivity}{
  sensor sensitivity, converts volts to m/s
}
  \item{scalefactor}{
  sensor DAS conversion factor (converts counts to volts)
}
  \item{gain}{
  gain factor (multiplicitive factor determined during recording)
}
  \item{coords}{
  coordinates (lat, lon, z)
}
  \item{orient}{
  Orientation (azmuths for rotation, degrees, e.g. 0, 90, 0)
}
  \item{notes}{
  Other information relavent related to this trace (location, orientation, etc)
}
 \item{suffix}{
Suffix to add to the end of the file name, default is ".RDS"
}
}
\details{
Converts an mseed stream to mini GH format. 

}
\value{
RSEIS compatable single tracelist list.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\note{
One has to be careful
about the conversions - whether they have been applied or not.

Starting on January 27, 2020 data is stored using saveRDS.  Any seismic data stored with this
code will have to use readRDS to read in.  In RSEIS this can be achieved by using
JGET.seis with kind = -1.

}


\seealso{RSEIS::JSAC.seis, RSEIS::read1segy 
}
\examples{
\dontrun{
##### here need example data to illustrate.
        H1 = DECON::stream2GHnosens(V58.1, DEST='.', 
                            STREAM=FALSE, sensitivity = 1, scalefactor = 1/scale, gain = 1)

GH = readRDS(H2)
plot(ts(GH$amp, deltat=GH$dt) )	



}


}
\keyword{misc}
