\name{ETOPO2}
\alias{ETOPO2}

\docType{data}
\title{Etopo2 topographic data}
\description{
Etopo2 topographic data: 2-Minute Gridded Global Relief Data (ETOPO2v2)
}
\usage{data(ETOPO2)}
\format{
 matrix of world elevation from 0-360 degrees long
}
\details{
  See web site:
  http://www.ngdc.noaa.gov/mgg/fliers/01mgg04.html

}

\references{
  The \emph{Smith and Sandwell} database is a worldwide set of 2-minute gridded
  ocean bathymetry derived from 1978 satellite radar altimetry of the
  sea surface. The version contained in ETOPO2v2 is 8.2. For a detailed
  technical discussion of their methodology.


  The 'Global Land One-kilometer Base Elevation' (GLOBE) database is
  made up of data sets from more than eight US and foreign agencies.
  It covers all of the world's land masses at a resolution of 0.5 minute
  (30'') of latitude and longitude, which is approximately
  one kilometer at the equator. GLOBE data were sampled to 2' cell averages for all land areas.


  The International Bathymetric Chart of the Arctic Ocean (IBCAO)
  initiative developed a digital database that contains all available
  bathymetric data north of 64 degrees North. The version contained in
  ETOPO2v2 is 1.0, sampled to 2' cell averages.

  The Coastal Relief Model (CRM) is used for US waters from the
  coastline to as far offshore as the NOS
  hydrographic data will support a continuous view of the seafloor. Data
  were sampled to 2'
  cell averages for areas adjacent to all 48 conterminous states,
  Hawaii, and Puerto Rico.

  
}
\examples{
data(ETOPO2)
##
\dontrun{
d = dim(ETOPO2)
####  need to flip the image to plot with function image
elat = attr(ETOPO2, 'lat')
elon = attr(ETOPO2, 'lon')

elon = seq(from=0, to=360-1/d[1] , length=d[1])

image(x=elon , y=elat, z=ETOPO2[, d[2]:1 ] )

}


}
\keyword{datasets}
