\name{interpETOPO}
\alias{interpETOPO}
\title{Interpolate ETOPO to XY Grid
}
\description{Interpolate ETOPO to XY Grid
}
\usage{
interpETOPO(b5, PROJ, nx = 500, ny = 500, nb = 4, mb = 4, hb = 8)
}
\arguments{
  \item{b5}{ETOPO grid with lat lon attributes
}
  \item{PROJ}{Projection from setPROJ
}
  \item{nx}{integer, number of X output grid points
}
  \item{ny}{integer, number of Y output grid points
}
  \item{nb}{initial size of the spline space in the hierarchical
          construction along the x axis. If the rectangular domain is a
          square, n = m = 1 is recommended. If the x axis is k times
          the length of the y axis, n = 1, m = k is recommended. The
          default is n = 1. (SEE mba.surf)
}
  \item{mb}{initial size of the spline space in the hierarchical
          construction along the y axis. If the y axis is k times the
          length of the x axis, m = 1, n = k is recommended. The
          default is m = 1.(SEE mba.surf)
}
  \item{hb}{Number of levels in the hierarchical construction. If, e.g.,
          n = m = 1 and h = 8, the resulting spline surface has a
          coefficient grid of size 2^h + 3 = 259 in each direction of
          the spline surface. See references for additional
          information.(SEE mba.surf)
}
}

\value{Interpolated grid with X-Y projected values
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{(MBA::mba.surf)
}
\examples{
\dontrun{
glat =c(45.4, 49)
glon = c(235, 243) 

PROJ = GEOmap::setPROJ(2, LAT0 = mean(glat), LON0 = mean(glon))

data(ETOPO2)
b2 = ETOPO::getetopo(ETOPO2, glat, glon)

IZOD = interpETOPO(b2, PROJ, nx=200, ny=200, nb = 4, mb = 4, hb = 8 )
calcol=GEOmap::settopocol()
MYCOLL = GEOmap::TOPOCOL(IZOD$z, calcol$calcol)
Dcol = attr(  MYCOLL , "Dcol")
persp(IZOD$x, IZOD$y, IZOD$z/1000, theta = 0, phi = 90,
                col = MYCOLL[1:(Dcol[1]-1), 1:(Dcol[2]-1)], scale = FALSE,
                ltheta = -120, shade = 0.75, border = NA,  box = FALSE)
     
           


}


}
\keyword{misc}
