
ADDpix<-function(AA, PLOTPARMS)
  {

    HEADER=PLOTPARMS$HEADER
    HTMfile=PLOTPARMS$HTMfile
  
    HTMfile=PLOTPARMS$HTMfile
    Title1=PLOTPARMS$Title1
    mapbar=PLOTPARMS$mapbar
    DPX = PLOTPARMS$DP[1]
    DPY = PLOTPARMS$DP[2]


    if( is.list(PLOTPARMS$LOCALES) )
      {
        LOCALES=PLOTPARMS$LOCALES
        mylocales = LOCALES
        mylocales$LON=RPMG::fmod(mylocales$lon, 360)

      }
    else
      {

        if(file.exists(PLOTPARMS$LOCALES))
          {
            mylocales = scan(file=LOCALES, list(lon=0, lat=0, name="", txt="",  img="", URL="" ))
            mylocales$LON=RPMG::fmod(mylocales$lon, 360)

          }
        else
          {
            return(0)

          }


      }

    
    
   
    THElocations = data.frame(mylocales)
    
    Xoff = AA$plt[1]*AA$PIXX
    Yoff = AA$plt[3]*AA$PIXY

    
    
    Mx = seq(from=0, to=AA$PIXX , by=DPX)
    My =   seq(from=0, to=AA$PIXY , by=DPY)

    MM =  RPMG::meshgrid(Mx, My)

    nx =   length( Mx)
    ny =    length( My)
    
    MM$LL=list(x=MM$x[1:(ny-1), 1:(nx-1) ],y=MM$y[1:(ny-1), 1:(nx-1)])
    MM$UR=list(x=MM$x[2:(ny), 2:(nx) ],    y=MM$y[2:(ny), 2:(nx)])
    
    
    peetees = GEOmap::GLOB.XY( THElocations$lat,   THElocations$lon, AA$PROJ)

    tem = trans3d(peetees$x, peetees$y, rep(0, length(peetees$y)),
      AA$PMAT$PMAT)

    pixmx = Xoff+  (AA$PIXX-Xoff)* (tem$x-AA$USR[1])/(AA$USR[2]-AA$USR[1])
    pixmy = AA$PIXY  -  (Yoff+  (AA$PIXY-Yoff)* (tem$y-AA$USR[3])/(AA$USR[4]-AA$USR[3]))

    PIX = list(x=pixmx, y=pixmy)

    midX =  (MM$LL$x+MM$UR$x)/2
    midY =  (MM$LL$y+MM$UR$y)/2
    
    mybins = rep(NA, length=length(PIX$x))

    
    for(i in 1:length(PIX$x))
      {
        w1 = which(PIX$x[i]>MM$LL$x & PIX$x[i]<=MM$UR$x &
          PIX$y[i]>MM$LL$y & PIX$y[i]<=MM$UR$y )

        if(length(w1)<1) next
        if(w1 %in% mybins) {
###  get 10 nearest bins, 
          r = (PIX$x[i]-midX)^2 + (PIX$y[i]-midY)^2 
          or = order(r)
          Rind = 1:length(r)
          wRIND = Rind[or][2:10]
          wDIS =  r[or][2:10]
          ww = which( !(wRIND %in% mybins) )
          w1 =wRIND[ww[1]]

        }
        mybins[i] = w1
      }
#################################

    Mw = which(!is.na(mybins) )


    MYPIX = list(PIXX=AA$PIXX, PIXY=AA$PIXY,  LLx=MM$LL$x[mybins], LLy=MM$LL$y[mybins], URx=MM$UR$x[mybins],  URy=MM$UR$y[mybins])


    RET  = makeHTMLmap(THElocations, HEADER, AA$psname,   HTMfile, Title1, mapbar ,  MYPIX  )

    if(RET==0) { return(0)  }

    
    hotxLL = (AA$USR[2]-AA$USR[1])*(MM$LL$x[mybins[Mw]]-Xoff)/(AA$PIXX-Xoff)+AA$USR[1]
    hotxUR = (AA$USR[2]-AA$USR[1])*(MM$UR$x[mybins[Mw]]-Xoff)/(AA$PIXX-Xoff)+AA$USR[1]
    pixmy =MM$LL$y[mybins[Mw]]
    hotyLL=   ((-(pixmy-AA$PIXY+Yoff))*(AA$USR[4]-AA$USR[3])/(AA$PIXY-Yoff))+AA$USR[3]
    pixmy =MM$UR$y[mybins[Mw]]
    hotyUR=   ((-(pixmy-AA$PIXY+Yoff))*(AA$USR[4]-AA$USR[3])/(AA$PIXY-Yoff))+AA$USR[3]


    
    HOT = cbind(hotxLL, hotyLL,hotxUR,  hotyUR  )
    invisible(HOT)

  }
